/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.utils;

import java.util.concurrent.ThreadFactory;
import org.apache.kafka.common.utils.ThreadUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ThreadUtilsTest {
    private static final Runnable EMPTY_RUNNABLE = () -> {};
    private static final String THREAD_NAME = "ThreadName";
    private static final String THREAD_NAME_WITH_NUMBER = "ThreadName%d";

    @Test
    public void testThreadNameWithoutNumberNoDemon() {
        Assertions.assertEquals((Object)THREAD_NAME, (Object)ThreadUtils.createThreadFactory((String)THREAD_NAME, (boolean)false).newThread(EMPTY_RUNNABLE).getName());
    }

    @Test
    public void testThreadNameWithoutNumberDemon() {
        Thread daemonThread = ThreadUtils.createThreadFactory((String)THREAD_NAME, (boolean)true).newThread(EMPTY_RUNNABLE);
        try {
            Assertions.assertEquals((Object)THREAD_NAME, (Object)daemonThread.getName());
            Assertions.assertTrue((boolean)daemonThread.isDaemon());
        }
        finally {
            try {
                daemonThread.join();
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    @Test
    public void testThreadNameWithNumberNoDemon() {
        ThreadFactory localThreadFactory = ThreadUtils.createThreadFactory((String)THREAD_NAME_WITH_NUMBER, (boolean)false);
        Assertions.assertEquals((Object)"ThreadName1", (Object)localThreadFactory.newThread(EMPTY_RUNNABLE).getName());
        Assertions.assertEquals((Object)"ThreadName2", (Object)localThreadFactory.newThread(EMPTY_RUNNABLE).getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testThreadNameWithNumberDemon() {
        ThreadFactory localThreadFactory = ThreadUtils.createThreadFactory((String)THREAD_NAME_WITH_NUMBER, (boolean)true);
        Thread daemonThread1 = localThreadFactory.newThread(EMPTY_RUNNABLE);
        Thread daemonThread2 = localThreadFactory.newThread(EMPTY_RUNNABLE);
        try {
            Assertions.assertEquals((Object)"ThreadName1", (Object)daemonThread1.getName());
            Assertions.assertTrue((boolean)daemonThread1.isDaemon());
        }
        finally {
            try {
                daemonThread1.join();
            }
            catch (InterruptedException interruptedException) {}
        }
        try {
            Assertions.assertEquals((Object)"ThreadName2", (Object)daemonThread2.getName());
            Assertions.assertTrue((boolean)daemonThread2.isDaemon());
        }
        finally {
            try {
                daemonThread2.join();
            }
            catch (InterruptedException interruptedException) {}
        }
    }
}

