/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.kafka.clients.AddressChangeHostResolver;
import org.apache.kafka.clients.ClientUtils;
import org.apache.kafka.clients.ClusterConnectionStates;
import org.apache.kafka.clients.ConnectionState;
import org.apache.kafka.clients.DefaultHostResolver;
import org.apache.kafka.clients.HostResolver;
import org.apache.kafka.common.errors.AuthenticationException;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.MockTime;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class ClusterConnectionStatesTest {
    private static ArrayList<InetAddress> initialAddresses;
    private static ArrayList<InetAddress> newAddresses;
    private final MockTime time = new MockTime();
    private final long reconnectBackoffMs = 10000L;
    private final long reconnectBackoffMax = 60000L;
    private final long connectionSetupTimeoutMs = 10000L;
    private final long connectionSetupTimeoutMaxMs = 127000L;
    private final int reconnectBackoffExpBase = 2;
    private final double reconnectBackoffJitter = 0.2;
    private final int connectionSetupTimeoutExpBase = 2;
    private final double connectionSetupTimeoutJitter = 0.2;
    private final String nodeId1 = "1001";
    private final String nodeId2 = "2002";
    private final String nodeId3 = "3003";
    private final String hostTwoIps = "multiple.ip.address";
    private ClusterConnectionStates connectionStates;
    private DefaultHostResolver singleIPHostResolver = new DefaultHostResolver();
    private AddressChangeHostResolver multipleIPHostResolver = new AddressChangeHostResolver(initialAddresses.toArray(new InetAddress[0]), newAddresses.toArray(new InetAddress[0]));

    @BeforeEach
    public void setup() {
        this.connectionStates = new ClusterConnectionStates(10000L, 60000L, 10000L, 127000L, new LogContext(), (HostResolver)this.singleIPHostResolver);
    }

    @Test
    public void testClusterConnectionStateChanges() {
        Assertions.assertTrue((boolean)this.connectionStates.canConnect("1001", this.time.milliseconds()));
        Assertions.assertEquals((long)0L, (long)this.connectionStates.connectionDelay("1001", this.time.milliseconds()));
        this.connectionStates.connecting("1001", this.time.milliseconds(), "localhost");
        Assertions.assertEquals((Object)ConnectionState.CONNECTING, (Object)this.connectionStates.connectionState("1001"));
        Assertions.assertTrue((boolean)this.connectionStates.isConnecting("1001"));
        Assertions.assertFalse((boolean)this.connectionStates.isReady("1001", this.time.milliseconds()));
        Assertions.assertFalse((boolean)this.connectionStates.isBlackedOut("1001", this.time.milliseconds()));
        Assertions.assertFalse((boolean)this.connectionStates.hasReadyNodes(this.time.milliseconds()));
        long connectionDelay = this.connectionStates.connectionDelay("1001", this.time.milliseconds());
        double connectionDelayDelta = 2000.0;
        Assertions.assertEquals((double)10000.0, (double)connectionDelay, (double)connectionDelayDelta);
        this.time.sleep(100L);
        this.connectionStates.ready("1001");
        Assertions.assertEquals((Object)ConnectionState.READY, (Object)this.connectionStates.connectionState("1001"));
        Assertions.assertTrue((boolean)this.connectionStates.isReady("1001", this.time.milliseconds()));
        Assertions.assertTrue((boolean)this.connectionStates.hasReadyNodes(this.time.milliseconds()));
        Assertions.assertFalse((boolean)this.connectionStates.isConnecting("1001"));
        Assertions.assertFalse((boolean)this.connectionStates.isBlackedOut("1001", this.time.milliseconds()));
        Assertions.assertEquals((long)Long.MAX_VALUE, (long)this.connectionStates.connectionDelay("1001", this.time.milliseconds()));
        this.time.sleep(15000L);
        this.connectionStates.disconnected("1001", this.time.milliseconds());
        Assertions.assertEquals((Object)ConnectionState.DISCONNECTED, (Object)this.connectionStates.connectionState("1001"));
        Assertions.assertTrue((boolean)this.connectionStates.isDisconnected("1001"));
        Assertions.assertTrue((boolean)this.connectionStates.isBlackedOut("1001", this.time.milliseconds()));
        Assertions.assertFalse((boolean)this.connectionStates.isConnecting("1001"));
        Assertions.assertFalse((boolean)this.connectionStates.hasReadyNodes(this.time.milliseconds()));
        Assertions.assertFalse((boolean)this.connectionStates.canConnect("1001", this.time.milliseconds()));
        double backoffTolerance = 2000.0;
        long currentBackoff = this.connectionStates.connectionDelay("1001", this.time.milliseconds());
        Assertions.assertEquals((double)10000.0, (double)currentBackoff, (double)backoffTolerance);
        this.time.sleep(currentBackoff + 1L);
        Assertions.assertTrue((boolean)this.connectionStates.canConnect("1001", this.time.milliseconds()));
    }

    @Test
    public void testMultipleNodeConnectionStates() {
        Assertions.assertTrue((boolean)this.connectionStates.canConnect("1001", this.time.milliseconds()));
        Assertions.assertTrue((boolean)this.connectionStates.canConnect("2002", this.time.milliseconds()));
        Assertions.assertFalse((boolean)this.connectionStates.hasReadyNodes(this.time.milliseconds()));
        this.connectionStates.connecting("2002", this.time.milliseconds(), "localhost");
        Assertions.assertFalse((boolean)this.connectionStates.hasReadyNodes(this.time.milliseconds()));
        this.time.sleep(1000L);
        this.connectionStates.ready("2002");
        Assertions.assertTrue((boolean)this.connectionStates.hasReadyNodes(this.time.milliseconds()));
        this.connectionStates.connecting("1001", this.time.milliseconds(), "localhost");
        Assertions.assertTrue((boolean)this.connectionStates.hasReadyNodes(this.time.milliseconds()));
        this.time.sleep(1000L);
        this.connectionStates.ready("1001");
        Assertions.assertTrue((boolean)this.connectionStates.hasReadyNodes(this.time.milliseconds()));
        this.time.sleep(12000L);
        this.connectionStates.disconnected("2002", this.time.milliseconds());
        Assertions.assertTrue((boolean)this.connectionStates.hasReadyNodes(this.time.milliseconds()));
        Assertions.assertTrue((boolean)this.connectionStates.isBlackedOut("2002", this.time.milliseconds()));
        Assertions.assertFalse((boolean)this.connectionStates.isBlackedOut("1001", this.time.milliseconds()));
        this.time.sleep(this.connectionStates.connectionDelay("2002", this.time.milliseconds()));
        this.connectionStates.disconnected("1001", this.time.milliseconds() + 1L);
        Assertions.assertTrue((boolean)this.connectionStates.isBlackedOut("1001", this.time.milliseconds()));
        Assertions.assertFalse((boolean)this.connectionStates.isBlackedOut("2002", this.time.milliseconds()));
        Assertions.assertFalse((boolean)this.connectionStates.hasReadyNodes(this.time.milliseconds()));
    }

    @Test
    public void testAuthorizationFailed() {
        this.connectionStates.connecting("1001", this.time.milliseconds(), "localhost");
        this.time.sleep(100L);
        this.connectionStates.authenticationFailed("1001", this.time.milliseconds(), new AuthenticationException("No path to CA for certificate!"));
        this.time.sleep(1000L);
        Assertions.assertEquals((Object)this.connectionStates.connectionState("1001"), (Object)ConnectionState.AUTHENTICATION_FAILED);
        Assertions.assertNotNull((Object)((Object)this.connectionStates.authenticationException("1001")));
        Assertions.assertFalse((boolean)this.connectionStates.hasReadyNodes(this.time.milliseconds()));
        Assertions.assertFalse((boolean)this.connectionStates.canConnect("1001", this.time.milliseconds()));
        this.time.sleep(this.connectionStates.connectionDelay("1001", this.time.milliseconds()) + 1L);
        Assertions.assertTrue((boolean)this.connectionStates.canConnect("1001", this.time.milliseconds()));
        this.connectionStates.ready("1001");
        Assertions.assertNull((Object)((Object)this.connectionStates.authenticationException("1001")));
    }

    @Test
    public void testRemoveNode() {
        this.connectionStates.connecting("1001", this.time.milliseconds(), "localhost");
        this.time.sleep(1000L);
        this.connectionStates.ready("1001");
        this.time.sleep(10000L);
        this.connectionStates.disconnected("1001", this.time.milliseconds());
        this.connectionStates.remove("1001");
        Assertions.assertTrue((boolean)this.connectionStates.canConnect("1001", this.time.milliseconds()));
        Assertions.assertFalse((boolean)this.connectionStates.isBlackedOut("1001", this.time.milliseconds()));
        Assertions.assertEquals((long)this.connectionStates.connectionDelay("1001", this.time.milliseconds()), (long)0L);
    }

    @Test
    public void testMaxReconnectBackoff() {
        long effectiveMaxReconnectBackoff = Math.round(72000.0);
        this.connectionStates.connecting("1001", this.time.milliseconds(), "localhost");
        this.time.sleep(1000L);
        this.connectionStates.disconnected("1001", this.time.milliseconds());
        for (int i = 0; i < 100; ++i) {
            long reconnectBackoff = this.connectionStates.connectionDelay("1001", this.time.milliseconds());
            Assertions.assertTrue((reconnectBackoff <= effectiveMaxReconnectBackoff ? 1 : 0) != 0);
            Assertions.assertFalse((boolean)this.connectionStates.canConnect("1001", this.time.milliseconds()));
            this.time.sleep(reconnectBackoff + 1L);
            Assertions.assertTrue((boolean)this.connectionStates.canConnect("1001", this.time.milliseconds()));
            this.connectionStates.connecting("1001", this.time.milliseconds(), "localhost");
            this.time.sleep(10L);
            this.connectionStates.disconnected("1001", this.time.milliseconds());
        }
    }

    @Test
    public void testExponentialReconnectBackoff() {
        this.verifyReconnectExponentialBackoff(false);
        this.verifyReconnectExponentialBackoff(true);
    }

    @Test
    public void testThrottled() {
        this.connectionStates.connecting("1001", this.time.milliseconds(), "localhost");
        this.time.sleep(1000L);
        this.connectionStates.ready("1001");
        this.time.sleep(10000L);
        Assertions.assertEquals((long)0L, (long)this.connectionStates.throttleDelayMs("1001", this.time.milliseconds()));
        this.connectionStates.throttle("1001", this.time.milliseconds() + 100L);
        Assertions.assertEquals((long)100L, (long)this.connectionStates.throttleDelayMs("1001", this.time.milliseconds()));
        this.time.sleep(50L);
        Assertions.assertEquals((long)50L, (long)this.connectionStates.throttleDelayMs("1001", this.time.milliseconds()));
        Assertions.assertEquals((long)50L, (long)this.connectionStates.pollDelayMs("1001", this.time.milliseconds()));
        this.time.sleep(50L);
        Assertions.assertEquals((long)0L, (long)this.connectionStates.throttleDelayMs("1001", this.time.milliseconds()));
        Assertions.assertEquals((long)this.connectionStates.connectionDelay("1001", this.time.milliseconds()), (long)this.connectionStates.pollDelayMs("1001", this.time.milliseconds()));
    }

    @Test
    public void testSingleIP() throws UnknownHostException {
        Assertions.assertEquals((int)1, (int)ClientUtils.resolve((String)"localhost", (HostResolver)this.singleIPHostResolver).size());
        this.connectionStates.connecting("1001", this.time.milliseconds(), "localhost");
        InetAddress currAddress = this.connectionStates.currentAddress("1001");
        this.connectionStates.connecting("1001", this.time.milliseconds(), "localhost");
        Assertions.assertSame((Object)currAddress, (Object)this.connectionStates.currentAddress("1001"));
    }

    @Test
    public void testMultipleIPs() throws UnknownHostException {
        this.setupMultipleIPs();
        Assertions.assertTrue((ClientUtils.resolve((String)"multiple.ip.address", (HostResolver)this.multipleIPHostResolver).size() > 1 ? 1 : 0) != 0);
        this.connectionStates.connecting("1001", this.time.milliseconds(), "multiple.ip.address");
        InetAddress addr1 = this.connectionStates.currentAddress("1001");
        this.connectionStates.connecting("1001", this.time.milliseconds(), "multiple.ip.address");
        InetAddress addr2 = this.connectionStates.currentAddress("1001");
        Assertions.assertNotSame((Object)addr1, (Object)addr2);
        this.connectionStates.connecting("1001", this.time.milliseconds(), "multiple.ip.address");
        InetAddress addr3 = this.connectionStates.currentAddress("1001");
        Assertions.assertNotSame((Object)addr1, (Object)addr3);
    }

    @Test
    public void testHostResolveChange() throws UnknownHostException {
        this.setupMultipleIPs();
        Assertions.assertTrue((ClientUtils.resolve((String)"multiple.ip.address", (HostResolver)this.multipleIPHostResolver).size() > 1 ? 1 : 0) != 0);
        this.connectionStates.connecting("1001", this.time.milliseconds(), "multiple.ip.address");
        InetAddress addr1 = this.connectionStates.currentAddress("1001");
        this.multipleIPHostResolver.changeAddresses();
        this.connectionStates.connecting("1001", this.time.milliseconds(), "localhost");
        InetAddress addr2 = this.connectionStates.currentAddress("1001");
        Assertions.assertNotSame((Object)addr1, (Object)addr2);
    }

    @Test
    public void testNodeWithNewHostname() throws UnknownHostException {
        this.setupMultipleIPs();
        this.connectionStates.connecting("1001", this.time.milliseconds(), "localhost");
        InetAddress addr1 = this.connectionStates.currentAddress("1001");
        this.multipleIPHostResolver.changeAddresses();
        this.connectionStates.connecting("1001", this.time.milliseconds(), "multiple.ip.address");
        InetAddress addr2 = this.connectionStates.currentAddress("1001");
        Assertions.assertNotSame((Object)addr1, (Object)addr2);
    }

    @Test
    public void testIsPreparingConnection() {
        Assertions.assertFalse((boolean)this.connectionStates.isPreparingConnection("1001"));
        this.connectionStates.connecting("1001", this.time.milliseconds(), "localhost");
        Assertions.assertTrue((boolean)this.connectionStates.isPreparingConnection("1001"));
        this.connectionStates.checkingApiVersions("1001");
        Assertions.assertTrue((boolean)this.connectionStates.isPreparingConnection("1001"));
        this.connectionStates.disconnected("1001", this.time.milliseconds());
        Assertions.assertFalse((boolean)this.connectionStates.isPreparingConnection("1001"));
    }

    @Test
    public void testExponentialConnectionSetupTimeout() {
        Assertions.assertTrue((boolean)this.connectionStates.canConnect("1001", this.time.milliseconds()));
        int n = 0;
        while ((double)n <= Math.log(12.7) / Math.log(2.0)) {
            this.connectionStates.connecting("1001", this.time.milliseconds(), "localhost");
            Assertions.assertTrue((boolean)this.connectionStates.connectingNodes().contains("1001"));
            Assertions.assertEquals((double)(10000.0 * Math.pow(2.0, n)), (double)this.connectionStates.connectionSetupTimeoutMs("1001"), (double)(10000.0 * Math.pow(2.0, n) * 0.2));
            this.connectionStates.disconnected("1001", this.time.milliseconds());
            Assertions.assertFalse((boolean)this.connectionStates.connectingNodes().contains("1001"));
            ++n;
        }
        this.connectionStates.connecting("1001", this.time.milliseconds(), "localhost");
        Assertions.assertEquals((double)127000.0, (double)this.connectionStates.connectionSetupTimeoutMs("1001"), (double)25400.0);
        Assertions.assertTrue((boolean)this.connectionStates.connectingNodes().contains("1001"));
        this.connectionStates.ready("1001");
        Assertions.assertEquals((double)10000.0, (double)this.connectionStates.connectionSetupTimeoutMs("1001"), (double)2000.0);
        Assertions.assertFalse((boolean)this.connectionStates.connectingNodes().contains("1001"));
        this.connectionStates.disconnected("1001", this.time.milliseconds());
        this.connectionStates.connecting("1001", this.time.milliseconds(), "localhost");
        Assertions.assertEquals((double)10000.0, (double)this.connectionStates.connectionSetupTimeoutMs("1001"), (double)2000.0);
        Assertions.assertTrue((boolean)this.connectionStates.connectingNodes().contains("1001"));
    }

    @Test
    public void testTimedOutConnections() {
        this.connectionStates.connecting("1001", this.time.milliseconds(), "localhost");
        this.connectionStates.connecting("2002", this.time.milliseconds(), "localhost");
        Assertions.assertEquals((int)0, (int)this.connectionStates.nodesWithConnectionSetupTimeout(this.time.milliseconds()).size());
        this.time.sleep(5000L);
        this.connectionStates.connecting("3003", this.time.milliseconds(), "localhost");
        this.time.sleep(7000L);
        List timedOutConnections = this.connectionStates.nodesWithConnectionSetupTimeout(this.time.milliseconds());
        Assertions.assertEquals((int)2, (int)timedOutConnections.size());
        Assertions.assertTrue((boolean)timedOutConnections.contains("1001"));
        Assertions.assertTrue((boolean)timedOutConnections.contains("2002"));
        this.connectionStates.disconnected("1001", this.time.milliseconds());
        this.connectionStates.disconnected("2002", this.time.milliseconds());
        this.time.sleep(7000L);
        timedOutConnections = this.connectionStates.nodesWithConnectionSetupTimeout(this.time.milliseconds());
        Assertions.assertEquals((int)1, (int)timedOutConnections.size());
        Assertions.assertTrue((boolean)timedOutConnections.contains("3003"));
        this.connectionStates.disconnected("3003", this.time.milliseconds());
        Assertions.assertEquals((int)0, (int)this.connectionStates.nodesWithConnectionSetupTimeout(this.time.milliseconds()).size());
    }

    private void setupMultipleIPs() {
        this.connectionStates = new ClusterConnectionStates(10000L, 60000L, 10000L, 127000L, new LogContext(), (HostResolver)this.multipleIPHostResolver);
    }

    private void verifyReconnectExponentialBackoff(boolean enterCheckingApiVersionState) {
        double reconnectBackoffMaxExp = Math.log(60000.0 / (double)Math.max(10000L, 1L)) / Math.log(2.0);
        this.connectionStates.remove("1001");
        for (int i = 0; i < 10; ++i) {
            this.connectionStates.connecting("1001", this.time.milliseconds(), "localhost");
            if (enterCheckingApiVersionState) {
                this.connectionStates.checkingApiVersions("1001");
            }
            this.connectionStates.disconnected("1001", this.time.milliseconds());
            long expectedBackoff = Math.round(Math.pow(2.0, Math.min((double)i, reconnectBackoffMaxExp)) * 10000.0);
            long currentBackoff = this.connectionStates.connectionDelay("1001", this.time.milliseconds());
            Assertions.assertEquals((double)expectedBackoff, (double)currentBackoff, (double)(0.2 * (double)expectedBackoff));
            this.time.sleep(this.connectionStates.connectionDelay("1001", this.time.milliseconds()) + 1L);
        }
    }

    static {
        try {
            initialAddresses = new ArrayList<InetAddress>(Arrays.asList(InetAddress.getByName("10.200.20.100"), InetAddress.getByName("10.200.20.101"), InetAddress.getByName("10.200.20.102")));
            newAddresses = new ArrayList<InetAddress>(Arrays.asList(InetAddress.getByName("10.200.20.103"), InetAddress.getByName("10.200.20.104"), InetAddress.getByName("10.200.20.105")));
        }
        catch (UnknownHostException e) {
            Assertions.fail((String)"Attempted to create an invalid InetAddress, this should not happen");
        }
    }
}

