/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.consumer;

import java.lang.management.ManagementFactory;
import java.nio.ByteBuffer;
import java.time.Duration;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.Properties;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.kafka.clients.ClientRequest;
import org.apache.kafka.clients.CommonClientConfigs;
import org.apache.kafka.clients.KafkaClient;
import org.apache.kafka.clients.Metadata;
import org.apache.kafka.clients.MockClient;
import org.apache.kafka.clients.NodeApiVersions;
import org.apache.kafka.clients.consumer.ConsumerConfig;
import org.apache.kafka.clients.consumer.ConsumerGroupMetadata;
import org.apache.kafka.clients.consumer.ConsumerInterceptor;
import org.apache.kafka.clients.consumer.ConsumerPartitionAssignor;
import org.apache.kafka.clients.consumer.ConsumerPartitionAssignorTest;
import org.apache.kafka.clients.consumer.ConsumerRebalanceListener;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.apache.kafka.clients.consumer.CooperativeStickyAssignor;
import org.apache.kafka.clients.consumer.GroupProtocol;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.clients.consumer.NoOffsetForPartitionException;
import org.apache.kafka.clients.consumer.OffsetAndMetadata;
import org.apache.kafka.clients.consumer.OffsetResetStrategy;
import org.apache.kafka.clients.consumer.RangeAssignor;
import org.apache.kafka.clients.consumer.RoundRobinAssignor;
import org.apache.kafka.clients.consumer.internals.ConsumerMetadata;
import org.apache.kafka.clients.consumer.internals.ConsumerProtocol;
import org.apache.kafka.clients.consumer.internals.MockRebalanceListener;
import org.apache.kafka.clients.consumer.internals.SubscriptionState;
import org.apache.kafka.common.Cluster;
import org.apache.kafka.common.IsolationLevel;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.Metric;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.TopicIdPartition;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.config.AbstractConfig;
import org.apache.kafka.common.errors.AuthenticationException;
import org.apache.kafka.common.errors.InterruptException;
import org.apache.kafka.common.errors.InvalidConfigurationException;
import org.apache.kafka.common.errors.InvalidGroupIdException;
import org.apache.kafka.common.errors.InvalidTopicException;
import org.apache.kafka.common.errors.RecordDeserializationException;
import org.apache.kafka.common.errors.SerializationException;
import org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.kafka.common.errors.WakeupException;
import org.apache.kafka.common.header.Headers;
import org.apache.kafka.common.internals.ClusterResourceListeners;
import org.apache.kafka.common.message.FetchResponseData;
import org.apache.kafka.common.message.HeartbeatResponseData;
import org.apache.kafka.common.message.JoinGroupRequestData;
import org.apache.kafka.common.message.JoinGroupResponseData;
import org.apache.kafka.common.message.LeaveGroupResponseData;
import org.apache.kafka.common.message.ListOffsetsRequestData;
import org.apache.kafka.common.message.ListOffsetsResponseData;
import org.apache.kafka.common.message.SyncGroupResponseData;
import org.apache.kafka.common.metrics.JmxReporter;
import org.apache.kafka.common.metrics.Measurable;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.common.metrics.stats.Avg;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.record.BaseRecords;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.MemoryRecordsBuilder;
import org.apache.kafka.common.record.TimestampType;
import org.apache.kafka.common.requests.AbstractResponse;
import org.apache.kafka.common.requests.FetchRequest;
import org.apache.kafka.common.requests.FetchResponse;
import org.apache.kafka.common.requests.FindCoordinatorResponse;
import org.apache.kafka.common.requests.HeartbeatResponse;
import org.apache.kafka.common.requests.JoinGroupRequest;
import org.apache.kafka.common.requests.JoinGroupResponse;
import org.apache.kafka.common.requests.LeaveGroupResponse;
import org.apache.kafka.common.requests.ListOffsetsRequest;
import org.apache.kafka.common.requests.ListOffsetsResponse;
import org.apache.kafka.common.requests.MetadataResponse;
import org.apache.kafka.common.requests.OffsetCommitRequest;
import org.apache.kafka.common.requests.OffsetCommitResponse;
import org.apache.kafka.common.requests.OffsetFetchResponse;
import org.apache.kafka.common.requests.RequestTestUtils;
import org.apache.kafka.common.requests.SyncGroupResponse;
import org.apache.kafka.common.serialization.ByteArrayDeserializer;
import org.apache.kafka.common.serialization.Deserializer;
import org.apache.kafka.common.serialization.StringDeserializer;
import org.apache.kafka.common.telemetry.internals.ClientTelemetryReporter;
import org.apache.kafka.common.telemetry.internals.ClientTelemetrySender;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.test.MockConsumerInterceptor;
import org.apache.kafka.test.MockMetricsReporter;
import org.apache.kafka.test.TestUtils;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.EnumSource;
import org.mockito.ArgumentMatchers;
import org.mockito.MockedStatic;
import org.mockito.Mockito;
import org.mockito.internal.stubbing.answers.CallsRealMethods;
import org.mockito.stubbing.Answer;

public class KafkaConsumerTest {
    private final String topic = "test";
    private final Uuid topicId = Uuid.randomUuid();
    private final TopicPartition tp0 = new TopicPartition("test", 0);
    private final TopicPartition tp1 = new TopicPartition("test", 1);
    private final String topic2 = "test2";
    private final Uuid topicId2 = Uuid.randomUuid();
    private final TopicPartition t2p0 = new TopicPartition("test2", 0);
    private final String topic3 = "test3";
    private final Uuid topicId3 = Uuid.randomUuid();
    private final TopicPartition t3p0 = new TopicPartition("test3", 0);
    private final int sessionTimeoutMs = 10000;
    private final int defaultApiTimeoutMs = 60000;
    private final int heartbeatIntervalMs = 1000;
    private final int autoCommitIntervalMs = 500;
    private final String groupId = "mock-group";
    private final String memberId = "memberId";
    private final String leaderId = "leaderId";
    private final Optional<String> groupInstanceId = Optional.of("mock-instance");
    private Map<String, Uuid> topicIds = Stream.of(new AbstractMap.SimpleEntry<String, Uuid>("test", this.topicId), new AbstractMap.SimpleEntry<String, Uuid>("test2", this.topicId2), new AbstractMap.SimpleEntry<String, Uuid>("test3", this.topicId3)).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    private Map<Uuid, String> topicNames = Stream.of(new AbstractMap.SimpleEntry<Uuid, String>(this.topicId, "test"), new AbstractMap.SimpleEntry<Uuid, String>(this.topicId2, "test2"), new AbstractMap.SimpleEntry<Uuid, String>(this.topicId3, "test3")).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    private final String partitionRevoked = "Hit partition revoke ";
    private final String partitionAssigned = "Hit partition assign ";
    private final String partitionLost = "Hit partition lost ";
    private final Collection<TopicPartition> singleTopicPartition = Collections.singleton(new TopicPartition("test", 0));
    private final Time time = new MockTime();
    private final SubscriptionState subscription = new SubscriptionState(new LogContext(), OffsetResetStrategy.EARLIEST);
    private final ConsumerPartitionAssignor assignor = new RoundRobinAssignor();
    private KafkaConsumer<?, ?> consumer;
    private static final List<String> CLIENT_IDS = new ArrayList<String>();

    @AfterEach
    public void cleanup() {
        if (this.consumer != null) {
            this.consumer.close(Duration.ZERO);
        }
    }

    @ParameterizedTest
    @EnumSource(value=GroupProtocol.class)
    public void testMetricsReporterAutoGeneratedClientId(GroupProtocol groupProtocol) {
        Properties props = new Properties();
        props.setProperty("group.protocol", groupProtocol.name());
        props.setProperty("bootstrap.servers", "localhost:9999");
        props.setProperty("metric.reporters", MockMetricsReporter.class.getName());
        this.consumer = this.newConsumer(props, (Deserializer)new StringDeserializer(), (Deserializer)new StringDeserializer());
        Assertions.assertEquals((int)3, (int)this.consumer.metricsRegistry().reporters().size());
        MockMetricsReporter mockMetricsReporter = (MockMetricsReporter)this.consumer.metricsRegistry().reporters().stream().filter(reporter -> reporter instanceof MockMetricsReporter).findFirst().get();
        Assertions.assertEquals((Object)this.consumer.clientId(), (Object)mockMetricsReporter.clientId);
    }

    @ParameterizedTest
    @EnumSource(value=GroupProtocol.class)
    public void testDisableJmxAndClientTelemetryReporter(GroupProtocol groupProtocol) {
        Properties props = new Properties();
        props.setProperty("group.protocol", groupProtocol.name());
        props.setProperty("bootstrap.servers", "localhost:9999");
        props.setProperty("auto.include.jmx.reporter", "false");
        props.setProperty("enable.metrics.push", "false");
        this.consumer = this.newConsumer(props, (Deserializer)new StringDeserializer(), (Deserializer)new StringDeserializer());
        Assertions.assertTrue((boolean)this.consumer.metricsRegistry().reporters().isEmpty());
    }

    @ParameterizedTest
    @EnumSource(value=GroupProtocol.class)
    public void testExplicitlyOnlyEnableJmxReporter(GroupProtocol groupProtocol) {
        Properties props = new Properties();
        props.setProperty("group.protocol", groupProtocol.name());
        props.setProperty("bootstrap.servers", "localhost:9999");
        props.setProperty("metric.reporters", "org.apache.kafka.common.metrics.JmxReporter");
        props.setProperty("enable.metrics.push", "false");
        this.consumer = this.newConsumer(props, (Deserializer)new StringDeserializer(), (Deserializer)new StringDeserializer());
        Assertions.assertEquals((int)1, (int)this.consumer.metricsRegistry().reporters().size());
        Assertions.assertTrue((boolean)(this.consumer.metricsRegistry().reporters().get(0) instanceof JmxReporter));
    }

    @ParameterizedTest
    @EnumSource(value=GroupProtocol.class)
    public void testExplicitlyOnlyEnableClientTelemetryReporter(GroupProtocol groupProtocol) {
        Properties props = new Properties();
        props.setProperty("group.protocol", groupProtocol.name());
        props.setProperty("bootstrap.servers", "localhost:9999");
        props.setProperty("auto.include.jmx.reporter", "false");
        this.consumer = this.newConsumer(props, (Deserializer)new StringDeserializer(), (Deserializer)new StringDeserializer());
        Assertions.assertEquals((int)1, (int)this.consumer.metricsRegistry().reporters().size());
        Assertions.assertTrue((boolean)(this.consumer.metricsRegistry().reporters().get(0) instanceof ClientTelemetryReporter));
    }

    @ParameterizedTest
    @EnumSource(value=GroupProtocol.class, names={"CLASSIC"})
    public void testPollReturnsRecords(GroupProtocol groupProtocol) {
        this.consumer = this.setUpConsumerWithRecordsToPoll(groupProtocol, this.tp0, 5);
        ConsumerRecords records = this.consumer.poll(Duration.ZERO);
        Assertions.assertEquals((int)records.count(), (int)5);
        Assertions.assertEquals((Object)records.partitions(), Collections.singleton(this.tp0));
        Assertions.assertEquals((int)records.records(this.tp0).size(), (int)5);
    }

    @ParameterizedTest
    @EnumSource(value=GroupProtocol.class, names={"CLASSIC"})
    public void testSecondPollWithDeserializationErrorThrowsRecordDeserializationException(GroupProtocol groupProtocol) {
        int invalidRecordNumber = 4;
        int invalidRecordOffset = 3;
        StringDeserializer deserializer = this.mockErrorDeserializer(invalidRecordNumber);
        this.consumer = this.setUpConsumerWithRecordsToPoll(groupProtocol, this.tp0, 5, (Deserializer<String>)deserializer);
        ConsumerRecords records = this.consumer.poll(Duration.ZERO);
        Assertions.assertEquals((int)(invalidRecordNumber - 1), (int)records.count());
        Assertions.assertEquals(Collections.singleton(this.tp0), (Object)records.partitions());
        Assertions.assertEquals((int)(invalidRecordNumber - 1), (int)records.records(this.tp0).size());
        long lastOffset = ((ConsumerRecord)records.records(this.tp0).get(records.records(this.tp0).size() - 1)).offset();
        Assertions.assertEquals((long)(invalidRecordNumber - 2), (long)lastOffset);
        RecordDeserializationException rde = (RecordDeserializationException)Assertions.assertThrows(RecordDeserializationException.class, () -> this.consumer.poll(Duration.ZERO));
        Assertions.assertEquals((long)invalidRecordOffset, (long)rde.offset());
        Assertions.assertEquals((Object)this.tp0, (Object)rde.topicPartition());
        Assertions.assertEquals((long)rde.offset(), (long)this.consumer.position(this.tp0));
    }

    private StringDeserializer mockErrorDeserializer(int recordNumber) {
        final int recordIndex = recordNumber - 1;
        return new StringDeserializer(){
            int i = 0;

            public String deserialize(String topic, byte[] data) {
                if (this.i == recordIndex) {
                    throw new SerializationException();
                }
                ++this.i;
                return super.deserialize(topic, data);
            }

            public String deserialize(String topic, Headers headers, ByteBuffer data) {
                if (this.i == recordIndex) {
                    throw new SerializationException();
                }
                ++this.i;
                return super.deserialize(topic, headers, data);
            }
        };
    }

    private KafkaConsumer<?, ?> setUpConsumerWithRecordsToPoll(GroupProtocol groupProtocol, TopicPartition tp, int recordCount) {
        return this.setUpConsumerWithRecordsToPoll(groupProtocol, tp, recordCount, (Deserializer<String>)new StringDeserializer());
    }

    private KafkaConsumer<?, ?> setUpConsumerWithRecordsToPoll(GroupProtocol groupProtocol, TopicPartition tp, int recordCount, Deserializer<String> deserializer) {
        Cluster cluster = TestUtils.singletonCluster(tp.topic(), 1);
        Node node = (Node)cluster.nodes().get(0);
        ConsumerMetadata metadata = this.createMetadata(this.subscription);
        MockClient client = new MockClient(this.time, (Metadata)metadata);
        this.initMetadata(client, Collections.singletonMap("test", 1));
        this.consumer = this.newConsumer(groupProtocol, this.time, client, this.subscription, metadata, this.assignor, true, "mock-group", this.groupInstanceId, Optional.of(deserializer), false);
        this.consumer.subscribe(Collections.singleton("test"), this.getConsumerRebalanceListener(this.consumer));
        this.prepareRebalance(client, node, this.assignor, Collections.singletonList(tp), null);
        this.consumer.updateAssignmentMetadataIfNeeded(this.time.timer(Long.MAX_VALUE));
        client.prepareResponseFrom((AbstractResponse)this.fetchResponse(tp, 0L, recordCount), node);
        return this.consumer;
    }

    @ParameterizedTest
    @EnumSource(value=GroupProtocol.class)
    public void testConstructorClose(GroupProtocol groupProtocol) {
        Properties props = new Properties();
        props.setProperty("group.protocol", groupProtocol.name());
        props.setProperty("client.id", "testConstructorClose");
        props.setProperty("bootstrap.servers", "invalid-23-8409-adsfsdj");
        props.setProperty("metric.reporters", MockMetricsReporter.class.getName());
        int oldInitCount = MockMetricsReporter.INIT_COUNT.get();
        int oldCloseCount = MockMetricsReporter.CLOSE_COUNT.get();
        try {
            this.newConsumer(props, (Deserializer)new ByteArrayDeserializer(), (Deserializer)new ByteArrayDeserializer());
            Assertions.fail((String)"should have caught an exception and returned");
        }
        catch (KafkaException e) {
            Assertions.assertEquals((int)(oldInitCount + 1), (int)MockMetricsReporter.INIT_COUNT.get());
            Assertions.assertEquals((int)(oldCloseCount + 1), (int)MockMetricsReporter.CLOSE_COUNT.get());
            Assertions.assertEquals((Object)"Failed to construct kafka consumer", (Object)e.getMessage());
        }
    }

    @ParameterizedTest
    @EnumSource(value=GroupProtocol.class)
    public void testOsDefaultSocketBufferSizes(GroupProtocol groupProtocol) {
        HashMap<String, Object> config = new HashMap<String, Object>();
        config.put("group.protocol", groupProtocol.name());
        config.put("bootstrap.servers", "localhost:9999");
        config.put("send.buffer.bytes", -1);
        config.put("receive.buffer.bytes", -1);
        this.consumer = this.newConsumer((Map<String, Object>)config, (Deserializer)new ByteArrayDeserializer(), (Deserializer)new ByteArrayDeserializer());
    }

    @ParameterizedTest
    @EnumSource(value=GroupProtocol.class)
    public void testInvalidSocketSendBufferSize(GroupProtocol groupProtocol) {
        HashMap<String, Object> config = new HashMap<String, Object>();
        config.put("group.protocol", groupProtocol.name());
        config.put("bootstrap.servers", "localhost:9999");
        config.put("send.buffer.bytes", -2);
        Assertions.assertThrows(KafkaException.class, () -> this.newConsumer(config, (Deserializer)new ByteArrayDeserializer(), (Deserializer)new ByteArrayDeserializer()));
    }

    @ParameterizedTest
    @EnumSource(value=GroupProtocol.class)
    public void testInvalidSocketReceiveBufferSize(GroupProtocol groupProtocol) {
        HashMap<String, Object> config = new HashMap<String, Object>();
        config.put("group.protocol", groupProtocol.name());
        config.put("bootstrap.servers", "localhost:9999");
        config.put("receive.buffer.bytes", -2);
        Assertions.assertThrows(KafkaException.class, () -> this.newConsumer(config, (Deserializer)new ByteArrayDeserializer(), (Deserializer)new ByteArrayDeserializer()));
    }

    @ParameterizedTest
    @EnumSource(value=GroupProtocol.class)
    public void shouldIgnoreGroupInstanceIdForEmptyGroupId(GroupProtocol groupProtocol) {
        HashMap<String, Object> config = new HashMap<String, Object>();
        config.put("group.protocol", groupProtocol.name());
        config.put("bootstrap.servers", "localhost:9999");
        config.put("group.instance.id", "instance_id");
        this.consumer = this.newConsumer((Map<String, Object>)config, (Deserializer)new ByteArrayDeserializer(), (Deserializer)new ByteArrayDeserializer());
    }

    @ParameterizedTest
    @EnumSource(value=GroupProtocol.class)
    public void testSubscription(GroupProtocol groupProtocol) {
        this.consumer = this.newConsumer(groupProtocol, "mock-group");
        this.consumer.subscribe(Collections.singletonList("test"));
        Assertions.assertEquals(Collections.singleton("test"), (Object)this.consumer.subscription());
        Assertions.assertTrue((boolean)this.consumer.assignment().isEmpty());
        this.consumer.subscribe(Collections.emptyList());
        Assertions.assertTrue((boolean)this.consumer.subscription().isEmpty());
        Assertions.assertTrue((boolean)this.consumer.assignment().isEmpty());
        this.consumer.assign(Collections.singletonList(this.tp0));
        Assertions.assertTrue((boolean)this.consumer.subscription().isEmpty());
        Assertions.assertEquals(Collections.singleton(this.tp0), (Object)this.consumer.assignment());
        this.consumer.unsubscribe();
        Assertions.assertTrue((boolean)this.consumer.subscription().isEmpty());
        Assertions.assertTrue((boolean)this.consumer.assignment().isEmpty());
    }

    @ParameterizedTest
    @EnumSource(value=GroupProtocol.class)
    public void testSubscriptionOnNullTopicCollection(GroupProtocol groupProtocol) {
        this.consumer = this.newConsumer(groupProtocol, "mock-group");
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.consumer.subscribe((Collection)null));
    }

    @ParameterizedTest
    @EnumSource(value=GroupProtocol.class)
    public void testSubscriptionOnNullTopic(GroupProtocol groupProtocol) {
        this.consumer = this.newConsumer(groupProtocol, "mock-group");
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.consumer.subscribe(Collections.singletonList(null)));
    }

    @ParameterizedTest
    @EnumSource(value=GroupProtocol.class)
    public void testSubscriptionOnEmptyTopic(GroupProtocol groupProtocol) {
        this.consumer = this.newConsumer(groupProtocol, "mock-group");
        String emptyTopic = "  ";
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.consumer.subscribe(Collections.singletonList(emptyTopic)));
    }

    @ParameterizedTest
    @EnumSource(value=GroupProtocol.class)
    public void testSubscriptionOnNullPattern(GroupProtocol groupProtocol) {
        this.consumer = this.newConsumer(groupProtocol, "mock-group");
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.consumer.subscribe((Pattern)null));
    }

    @ParameterizedTest
    @EnumSource(value=GroupProtocol.class)
    public void testSubscriptionOnEmptyPattern(GroupProtocol groupProtocol) {
        this.consumer = this.newConsumer(groupProtocol, "mock-group");
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.consumer.subscribe(Pattern.compile("")));
    }

    @ParameterizedTest
    @EnumSource(value=GroupProtocol.class)
    public void testSubscriptionWithEmptyPartitionAssignment(GroupProtocol groupProtocol) {
        Properties props = new Properties();
        props.setProperty("group.protocol", groupProtocol.name());
        props.setProperty("bootstrap.servers", "localhost:9999");
        props.setProperty("partition.assignment.strategy", "");
        props.setProperty("group.id", "mock-group");
        this.consumer = this.newConsumer(props, (Deserializer)new ByteArrayDeserializer(), (Deserializer)new ByteArrayDeserializer());
        Assertions.assertThrows(IllegalStateException.class, () -> this.consumer.subscribe(Collections.singletonList("test")));
    }

    @ParameterizedTest
    @EnumSource(value=GroupProtocol.class)
    public void testSeekNegative(GroupProtocol groupProtocol) {
        this.consumer = this.newConsumer(groupProtocol, null);
        this.consumer.assign(Collections.singleton(new TopicPartition("nonExistTopic", 0)));
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.consumer.seek(new TopicPartition("nonExistTopic", 0), -1L));
    }

    @ParameterizedTest
    @EnumSource(value=GroupProtocol.class)
    public void testAssignOnNullTopicPartition(GroupProtocol groupProtocol) {
        this.consumer = this.newConsumer(groupProtocol, null);
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.consumer.assign(null));
    }

    @ParameterizedTest
    @EnumSource(value=GroupProtocol.class)
    public void testAssignOnEmptyTopicPartition(GroupProtocol groupProtocol) {
        this.consumer = this.newConsumer(groupProtocol, "mock-group");
        this.consumer.assign(Collections.emptyList());
        Assertions.assertTrue((boolean)this.consumer.subscription().isEmpty());
        Assertions.assertTrue((boolean)this.consumer.assignment().isEmpty());
    }

    @ParameterizedTest
    @EnumSource(value=GroupProtocol.class)
    public void testAssignOnNullTopicInPartition(GroupProtocol groupProtocol) {
        this.consumer = this.newConsumer(groupProtocol, null);
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.consumer.assign(Collections.singleton(new TopicPartition(null, 0))));
    }

    @ParameterizedTest
    @EnumSource(value=GroupProtocol.class)
    public void testAssignOnEmptyTopicInPartition(GroupProtocol groupProtocol) {
        this.consumer = this.newConsumer(groupProtocol, null);
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.consumer.assign(Collections.singleton(new TopicPartition("  ", 0))));
    }

    @ParameterizedTest
    @EnumSource(value=GroupProtocol.class)
    public void testInterceptorConstructorClose(GroupProtocol groupProtocol) {
        try {
            Properties props = new Properties();
            props.setProperty("group.protocol", groupProtocol.name());
            props.setProperty("bootstrap.servers", "localhost:9999");
            props.setProperty("interceptor.classes", MockConsumerInterceptor.class.getName());
            this.consumer = this.newConsumer(props, (Deserializer)new StringDeserializer(), (Deserializer)new StringDeserializer());
            Assertions.assertEquals((int)1, (int)MockConsumerInterceptor.INIT_COUNT.get());
            Assertions.assertEquals((int)0, (int)MockConsumerInterceptor.CLOSE_COUNT.get());
            this.consumer.close(Duration.ZERO);
            Assertions.assertEquals((int)1, (int)MockConsumerInterceptor.INIT_COUNT.get());
            Assertions.assertEquals((int)1, (int)MockConsumerInterceptor.CLOSE_COUNT.get());
            Assertions.assertNull((Object)MockConsumerInterceptor.CLUSTER_META.get());
        }
        finally {
            MockConsumerInterceptor.resetCounters();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ParameterizedTest
    @EnumSource(value=GroupProtocol.class)
    public void testInterceptorConstructorConfigurationWithExceptionShouldCloseRemainingInstances(GroupProtocol groupProtocol) {
        int targetInterceptor = 3;
        try {
            Properties props = new Properties();
            props.setProperty("group.protocol", groupProtocol.name());
            props.setProperty("bootstrap.servers", "localhost:9999");
            props.setProperty("interceptor.classes", MockConsumerInterceptor.class.getName() + ", " + MockConsumerInterceptor.class.getName() + ", " + MockConsumerInterceptor.class.getName());
            MockConsumerInterceptor.setThrowOnConfigExceptionThreshold(3);
            Assertions.assertThrows(KafkaException.class, () -> this.newConsumer(props, (Deserializer)new StringDeserializer(), (Deserializer)new StringDeserializer()));
            Assertions.assertEquals((int)3, (int)MockConsumerInterceptor.CONFIG_COUNT.get());
            Assertions.assertEquals((int)3, (int)MockConsumerInterceptor.CLOSE_COUNT.get());
        }
        finally {
            MockConsumerInterceptor.resetCounters();
        }
    }

    @ParameterizedTest
    @EnumSource(value=GroupProtocol.class)
    public void testPause(GroupProtocol groupProtocol) {
        this.consumer = this.newConsumer(groupProtocol, "mock-group");
        this.consumer.assign(Collections.singletonList(this.tp0));
        Assertions.assertEquals(Collections.singleton(this.tp0), (Object)this.consumer.assignment());
        Assertions.assertTrue((boolean)this.consumer.paused().isEmpty());
        this.consumer.pause(Collections.singleton(this.tp0));
        Assertions.assertEquals(Collections.singleton(this.tp0), (Object)this.consumer.paused());
        this.consumer.resume(Collections.singleton(this.tp0));
        Assertions.assertTrue((boolean)this.consumer.paused().isEmpty());
        this.consumer.unsubscribe();
        Assertions.assertTrue((boolean)this.consumer.paused().isEmpty());
    }

    @ParameterizedTest
    @EnumSource(value=GroupProtocol.class)
    public void testConsumerJmxPrefix(GroupProtocol groupProtocol) throws Exception {
        HashMap<String, Object> config = new HashMap<String, Object>();
        config.put("group.protocol", groupProtocol.name());
        config.put("bootstrap.servers", "localhost:9999");
        config.put("send.buffer.bytes", -1);
        config.put("receive.buffer.bytes", -1);
        config.put("client.id", "client-1");
        this.consumer = this.newConsumer((Map<String, Object>)config, (Deserializer)new ByteArrayDeserializer(), (Deserializer)new ByteArrayDeserializer());
        MBeanServer server = ManagementFactory.getPlatformMBeanServer();
        MetricName testMetricName = this.consumer.metricsRegistry().metricName("test-metric", "grp1", "test metric");
        this.consumer.metricsRegistry().addMetric(testMetricName, (Measurable)new Avg());
        Assertions.assertNotNull((Object)server.getObjectInstance(new ObjectName("kafka.consumer:type=grp1,client-id=client-1")));
    }

    private KafkaConsumer<byte[], byte[]> newConsumer(GroupProtocol groupProtocol, String groupId) {
        return this.newConsumer(groupProtocol, groupId, Optional.empty());
    }

    private KafkaConsumer<byte[], byte[]> newConsumer(GroupProtocol groupProtocol, String groupId, Optional<Boolean> enableAutoCommit) {
        Properties props = new Properties();
        props.setProperty("group.protocol", groupProtocol.name());
        props.setProperty("client.id", "my.consumer");
        props.setProperty("bootstrap.servers", "localhost:9999");
        props.setProperty("metric.reporters", MockMetricsReporter.class.getName());
        if (groupId != null) {
            props.setProperty("group.id", groupId);
        }
        enableAutoCommit.ifPresent(autoCommit -> props.setProperty("enable.auto.commit", autoCommit.toString()));
        return this.newConsumer(props, (Deserializer)new ByteArrayDeserializer(), (Deserializer)new ByteArrayDeserializer());
    }

    private <K, V> KafkaConsumer<K, V> newConsumer(Properties props) {
        return this.newConsumer(props, (Deserializer<K>)null, (Deserializer<V>)null);
    }

    private <K, V> KafkaConsumer<K, V> newConsumer(Map<String, Object> configs, Deserializer<K> keyDeserializer, Deserializer<V> valueDeserializer) {
        return new KafkaConsumer(new ConsumerConfig(ConsumerConfig.appendDeserializerToConfig(configs, keyDeserializer, valueDeserializer)), keyDeserializer, valueDeserializer);
    }

    private <K, V> KafkaConsumer<K, V> newConsumer(Properties props, Deserializer<K> keyDeserializer, Deserializer<V> valueDeserializer) {
        return this.newConsumer(Utils.propsToMap((Properties)props), keyDeserializer, valueDeserializer);
    }

    @ParameterizedTest
    @EnumSource(value=GroupProtocol.class, names={"CLASSIC"})
    public void verifyHeartbeatSent(GroupProtocol groupProtocol) throws Exception {
        ConsumerMetadata metadata = this.createMetadata(this.subscription);
        MockClient client = new MockClient(this.time, (Metadata)metadata);
        this.initMetadata(client, Collections.singletonMap("test", 1));
        Node node = (Node)metadata.fetch().nodes().get(0);
        this.consumer = this.newConsumer(groupProtocol, this.time, client, this.subscription, metadata, this.assignor, true, this.groupInstanceId);
        this.consumer.subscribe(Collections.singleton("test"), this.getConsumerRebalanceListener(this.consumer));
        Node coordinator = this.prepareRebalance(client, node, this.assignor, Collections.singletonList(this.tp0), null);
        client.prepareResponseFrom((AbstractResponse)this.fetchResponse(this.tp0, 0L, 0), node);
        this.consumer.updateAssignmentMetadataIfNeeded(this.time.timer(Long.MAX_VALUE));
        Assertions.assertEquals(Collections.singleton(this.tp0), (Object)this.consumer.assignment());
        AtomicBoolean heartbeatReceived = this.prepareHeartbeatResponse(client, coordinator, Errors.NONE);
        this.time.sleep(1000L);
        Thread.sleep(1000L);
        this.consumer.updateAssignmentMetadataIfNeeded(this.time.timer(Long.MAX_VALUE));
        Assertions.assertTrue((boolean)heartbeatReceived.get());
    }

    @ParameterizedTest
    @EnumSource(value=GroupProtocol.class, names={"CLASSIC"})
    public void verifyHeartbeatSentWhenFetchedDataReady(GroupProtocol groupProtocol) throws Exception {
        ConsumerMetadata metadata = this.createMetadata(this.subscription);
        MockClient client = new MockClient(this.time, (Metadata)metadata);
        this.initMetadata(client, Collections.singletonMap("test", 1));
        Node node = (Node)metadata.fetch().nodes().get(0);
        this.consumer = this.newConsumer(groupProtocol, this.time, client, this.subscription, metadata, this.assignor, true, this.groupInstanceId);
        this.consumer.subscribe(Collections.singleton("test"), this.getConsumerRebalanceListener(this.consumer));
        Node coordinator = this.prepareRebalance(client, node, this.assignor, Collections.singletonList(this.tp0), null);
        this.consumer.updateAssignmentMetadataIfNeeded(this.time.timer(Long.MAX_VALUE));
        this.consumer.poll(Duration.ZERO);
        client.respondFrom((AbstractResponse)this.fetchResponse(this.tp0, 0L, 5), node);
        client.poll(0L, this.time.milliseconds());
        client.prepareResponseFrom((AbstractResponse)this.fetchResponse(this.tp0, 5L, 0), node);
        AtomicBoolean heartbeatReceived = this.prepareHeartbeatResponse(client, coordinator, Errors.NONE);
        this.time.sleep(1000L);
        Thread.sleep(1000L);
        this.consumer.poll(Duration.ZERO);
        Assertions.assertTrue((boolean)heartbeatReceived.get());
    }

    @ParameterizedTest
    @EnumSource(value=GroupProtocol.class, names={"CLASSIC"})
    public void verifyPollTimesOutDuringMetadataUpdate(GroupProtocol groupProtocol) {
        ConsumerMetadata metadata = this.createMetadata(this.subscription);
        MockClient client = new MockClient(this.time, (Metadata)metadata);
        this.initMetadata(client, Collections.singletonMap("test", 1));
        Node node = (Node)metadata.fetch().nodes().get(0);
        this.consumer = this.newConsumer(groupProtocol, this.time, client, this.subscription, metadata, this.assignor, true, this.groupInstanceId);
        this.consumer.subscribe(Collections.singleton("test"), this.getConsumerRebalanceListener(this.consumer));
        client.prepareResponseFrom((AbstractResponse)FindCoordinatorResponse.prepareResponse((Errors)Errors.NONE, (String)"mock-group", (Node)node), node);
        Node coordinator = new Node(Integer.MAX_VALUE - node.id(), node.host(), node.port());
        client.prepareResponseFrom((AbstractResponse)this.joinGroupFollowerResponse(this.assignor, 1, "memberId", "leaderId", Errors.NONE), coordinator);
        this.consumer.poll(Duration.ZERO);
        Queue<ClientRequest> requests = client.requests();
        Assertions.assertEquals((long)0L, (long)requests.stream().filter(request -> request.apiKey().equals((Object)ApiKeys.FETCH)).count());
    }

    @ParameterizedTest
    @EnumSource(value=GroupProtocol.class, names={"CLASSIC"})
    public void verifyDeprecatedPollDoesNotTimeOutDuringMetadataUpdate(GroupProtocol groupProtocol) {
        ConsumerMetadata metadata = this.createMetadata(this.subscription);
        MockClient client = new MockClient(this.time, (Metadata)metadata);
        this.initMetadata(client, Collections.singletonMap("test", 1));
        Node node = (Node)metadata.fetch().nodes().get(0);
        this.consumer = this.newConsumer(groupProtocol, this.time, client, this.subscription, metadata, this.assignor, true, this.groupInstanceId);
        this.consumer.subscribe(Collections.singleton("test"), this.getConsumerRebalanceListener(this.consumer));
        this.prepareRebalance(client, node, this.assignor, Collections.singletonList(this.tp0), null);
        this.consumer.poll(0L);
        Queue<ClientRequest> requests = client.requests();
        Assertions.assertEquals((int)1, (int)requests.size());
        Class<?> aClass = requests.peek().requestBuilder().getClass();
        Assertions.assertEquals(FetchRequest.Builder.class, aClass);
    }

    @ParameterizedTest
    @EnumSource(value=GroupProtocol.class)
    public void verifyNoCoordinatorLookupForManualAssignmentWithSeek(GroupProtocol groupProtocol) {
        ConsumerMetadata metadata = this.createMetadata(this.subscription);
        MockClient client = new MockClient(this.time, (Metadata)metadata);
        this.initMetadata(client, Collections.singletonMap("test", 1));
        this.consumer = this.newConsumer(groupProtocol, this.time, client, this.subscription, metadata, this.assignor, false, null, this.groupInstanceId, false);
        this.consumer.assign(Collections.singleton(this.tp0));
        this.consumer.seekToBeginning(Collections.singleton(this.tp0));
        client.prepareResponse((AbstractResponse)this.listOffsetsResponse(Collections.singletonMap(this.tp0, 50L)));
        client.prepareResponse((AbstractResponse)this.fetchResponse(this.tp0, 50L, 5));
        ConsumerRecords records = this.consumer.poll(Duration.ofMillis(1L));
        Assertions.assertEquals((int)5, (int)records.count());
        Assertions.assertEquals((long)55L, (long)this.consumer.position(this.tp0));
    }

    @ParameterizedTest
    @EnumSource(value=GroupProtocol.class, names={"CLASSIC"})
    public void verifyNoCoordinatorLookupForManualAssignmentWithOffsetCommit(GroupProtocol groupProtocol) {
        ConsumerMetadata metadata = this.createMetadata(this.subscription);
        MockClient client = new MockClient(this.time, (Metadata)metadata);
        this.initMetadata(client, Collections.singletonMap("test", 1));
        Node node = (Node)metadata.fetch().nodes().get(0);
        this.consumer = this.newConsumer(groupProtocol, this.time, client, this.subscription, metadata, this.assignor, true, this.groupInstanceId);
        this.consumer.assign(Collections.singleton(this.tp0));
        client.prepareResponseFrom((AbstractResponse)FindCoordinatorResponse.prepareResponse((Errors)Errors.COORDINATOR_NOT_AVAILABLE, (String)"mock-group", (Node)node), node);
        this.consumer.poll(Duration.ofMillis(0L));
        client.prepareResponseFrom((AbstractResponse)FindCoordinatorResponse.prepareResponse((Errors)Errors.NONE, (String)"mock-group", (Node)node), node);
        client.prepareResponse((AbstractResponse)this.offsetResponse(Collections.singletonMap(this.tp0, 50L), Errors.NONE));
        client.prepareResponse((AbstractResponse)this.fetchResponse(this.tp0, 50L, 5));
        ConsumerRecords records = this.consumer.poll(Duration.ofMillis(0L));
        Assertions.assertEquals((int)5, (int)records.count());
        Assertions.assertEquals((long)55L, (long)this.consumer.position(this.tp0));
        client.prepareResponse((AbstractResponse)this.offsetCommitResponse(Collections.singletonMap(this.tp0, Errors.NONE)));
        this.consumer.commitSync(Collections.singletonMap(this.tp0, new OffsetAndMetadata(55L)));
        client.prepareResponse((AbstractResponse)this.offsetResponse(Collections.singletonMap(this.tp0, 55L), Errors.NONE));
        Assertions.assertEquals((long)55L, (long)((OffsetAndMetadata)this.consumer.committed(Collections.singleton(this.tp0), Duration.ZERO).get(this.tp0)).offset());
    }

    @ParameterizedTest
    @EnumSource(value=GroupProtocol.class, names={"CLASSIC"})
    public void testFetchProgressWithMissingPartitionPosition(GroupProtocol groupProtocol) {
        ConsumerMetadata metadata = this.createMetadata(this.subscription);
        MockClient client = new MockClient(this.time, (Metadata)metadata);
        this.initMetadata(client, Collections.singletonMap("test", 2));
        Node node = (Node)metadata.fetch().nodes().get(0);
        this.consumer = this.newConsumerNoAutoCommit(groupProtocol, this.time, client, this.subscription, metadata);
        this.consumer.assign(Arrays.asList(this.tp0, this.tp1));
        this.consumer.seekToEnd(Collections.singleton(this.tp0));
        this.consumer.seekToBeginning(Collections.singleton(this.tp1));
        client.prepareResponse(body -> {
            ListOffsetsRequest request = (ListOffsetsRequest)body;
            List partitions = request.topics().stream().flatMap(t -> {
                if (t.name().equals("test")) {
                    return Stream.of(t.partitions());
                }
                return Stream.empty();
            }).flatMap(Collection::stream).collect(Collectors.toList());
            ListOffsetsRequestData.ListOffsetsPartition expectedTp0 = new ListOffsetsRequestData.ListOffsetsPartition().setPartitionIndex(this.tp0.partition()).setTimestamp(-1L);
            ListOffsetsRequestData.ListOffsetsPartition expectedTp1 = new ListOffsetsRequestData.ListOffsetsPartition().setPartitionIndex(this.tp1.partition()).setTimestamp(-2L);
            return partitions.contains(expectedTp0) && partitions.contains(expectedTp1);
        }, (AbstractResponse)this.listOffsetsResponse(Collections.singletonMap(this.tp0, 50L), Collections.singletonMap(this.tp1, Errors.NOT_LEADER_OR_FOLLOWER)));
        client.prepareResponse(body -> {
            FetchRequest request = (FetchRequest)body;
            Map fetchData = request.fetchData(this.topicNames);
            TopicIdPartition tidp0 = new TopicIdPartition(this.topicIds.get(this.tp0.topic()), this.tp0);
            return fetchData.keySet().equals(Collections.singleton(tidp0)) && ((FetchRequest.PartitionData)fetchData.get((Object)tidp0)).fetchOffset == 50L;
        }, (AbstractResponse)this.fetchResponse(this.tp0, 50L, 5));
        ConsumerRecords records = this.consumer.poll(Duration.ofMillis(1L));
        Assertions.assertEquals((int)5, (int)records.count());
        Assertions.assertEquals(Collections.singleton(this.tp0), (Object)records.partitions());
    }

    private void initMetadata(MockClient mockClient, Map<String, Integer> partitionCounts) {
        HashMap<String, Uuid> metadataIds = new HashMap<String, Uuid>();
        for (String name : partitionCounts.keySet()) {
            metadataIds.put(name, this.topicIds.get(name));
        }
        MetadataResponse initialMetadata = RequestTestUtils.metadataUpdateWithIds(1, partitionCounts, metadataIds);
        mockClient.updateMetadata(initialMetadata);
    }

    @ParameterizedTest
    @EnumSource(value=GroupProtocol.class, names={"CLASSIC"})
    public void testMissingOffsetNoResetPolicy(GroupProtocol groupProtocol) {
        SubscriptionState subscription = new SubscriptionState(new LogContext(), OffsetResetStrategy.NONE);
        ConsumerMetadata metadata = this.createMetadata(subscription);
        MockClient client = new MockClient(this.time, (Metadata)metadata);
        this.initMetadata(client, Collections.singletonMap("test", 1));
        Node node = (Node)metadata.fetch().nodes().get(0);
        this.consumer = this.newConsumer(groupProtocol, this.time, client, subscription, metadata, this.assignor, true, "mock-group", this.groupInstanceId, false);
        this.consumer.assign(Collections.singletonList(this.tp0));
        client.prepareResponseFrom((AbstractResponse)FindCoordinatorResponse.prepareResponse((Errors)Errors.NONE, (String)"mock-group", (Node)node), node);
        Node coordinator = new Node(Integer.MAX_VALUE - node.id(), node.host(), node.port());
        client.prepareResponseFrom((AbstractResponse)this.offsetResponse(Collections.singletonMap(this.tp0, -1L), Errors.NONE), coordinator);
        Assertions.assertThrows(NoOffsetForPartitionException.class, () -> this.consumer.poll(Duration.ZERO));
    }

    @ParameterizedTest
    @EnumSource(value=GroupProtocol.class, names={"CLASSIC"})
    public void testResetToCommittedOffset(GroupProtocol groupProtocol) {
        SubscriptionState subscription = new SubscriptionState(new LogContext(), OffsetResetStrategy.NONE);
        ConsumerMetadata metadata = this.createMetadata(subscription);
        MockClient client = new MockClient(this.time, (Metadata)metadata);
        this.initMetadata(client, Collections.singletonMap("test", 1));
        Node node = (Node)metadata.fetch().nodes().get(0);
        KafkaConsumer<String, String> consumer = this.newConsumer(groupProtocol, this.time, client, subscription, metadata, this.assignor, true, "mock-group", this.groupInstanceId, false);
        consumer.assign(Collections.singletonList(this.tp0));
        client.prepareResponseFrom((AbstractResponse)FindCoordinatorResponse.prepareResponse((Errors)Errors.NONE, (String)"mock-group", (Node)node), node);
        Node coordinator = new Node(Integer.MAX_VALUE - node.id(), node.host(), node.port());
        client.prepareResponseFrom((AbstractResponse)this.offsetResponse(Collections.singletonMap(this.tp0, 539L), Errors.NONE), coordinator);
        consumer.poll(Duration.ZERO);
        Assertions.assertEquals((long)539L, (long)consumer.position(this.tp0));
    }

    @ParameterizedTest
    @EnumSource(value=GroupProtocol.class, names={"CLASSIC"})
    public void testResetUsingAutoResetPolicy(GroupProtocol groupProtocol) {
        SubscriptionState subscription = new SubscriptionState(new LogContext(), OffsetResetStrategy.LATEST);
        ConsumerMetadata metadata = this.createMetadata(subscription);
        MockClient client = new MockClient(this.time, (Metadata)metadata);
        this.initMetadata(client, Collections.singletonMap("test", 1));
        Node node = (Node)metadata.fetch().nodes().get(0);
        this.consumer = this.newConsumer(groupProtocol, this.time, client, subscription, metadata, this.assignor, true, "mock-group", this.groupInstanceId, false);
        this.consumer.assign(Collections.singletonList(this.tp0));
        client.prepareResponseFrom((AbstractResponse)FindCoordinatorResponse.prepareResponse((Errors)Errors.NONE, (String)"mock-group", (Node)node), node);
        Node coordinator = new Node(Integer.MAX_VALUE - node.id(), node.host(), node.port());
        client.prepareResponseFrom((AbstractResponse)this.offsetResponse(Collections.singletonMap(this.tp0, -1L), Errors.NONE), coordinator);
        client.prepareResponse((AbstractResponse)this.listOffsetsResponse(Collections.singletonMap(this.tp0, 50L)));
        this.consumer.poll(Duration.ZERO);
        Assertions.assertEquals((long)50L, (long)this.consumer.position(this.tp0));
    }

    @ParameterizedTest
    @EnumSource(value=GroupProtocol.class)
    public void testOffsetIsValidAfterSeek(GroupProtocol groupProtocol) {
        SubscriptionState subscription = new SubscriptionState(new LogContext(), OffsetResetStrategy.LATEST);
        ConsumerMetadata metadata = this.createMetadata(subscription);
        MockClient client = new MockClient(this.time, (Metadata)metadata);
        this.initMetadata(client, Collections.singletonMap("test", 1));
        this.consumer = this.newConsumer(groupProtocol, this.time, client, subscription, metadata, this.assignor, true, "mock-group", Optional.empty(), false);
        this.consumer.assign(Collections.singletonList(this.tp0));
        this.consumer.seek(this.tp0, 20L);
        this.consumer.poll(Duration.ZERO);
        Assertions.assertEquals((long)subscription.validPosition((TopicPartition)this.tp0).offset, (long)20L);
    }

    @ParameterizedTest
    @EnumSource(value=GroupProtocol.class, names={"CLASSIC"})
    public void testCommitsFetchedDuringAssign(GroupProtocol groupProtocol) {
        long offset1 = 10000L;
        long offset2 = 20000L;
        ConsumerMetadata metadata = this.createMetadata(this.subscription);
        MockClient client = new MockClient(this.time, (Metadata)metadata);
        this.initMetadata(client, Collections.singletonMap("test", 2));
        Node node = (Node)metadata.fetch().nodes().get(0);
        this.consumer = this.newConsumer(groupProtocol, this.time, client, this.subscription, metadata, this.assignor, true, this.groupInstanceId);
        this.consumer.assign(Collections.singletonList(this.tp0));
        client.prepareResponseFrom((AbstractResponse)FindCoordinatorResponse.prepareResponse((Errors)Errors.NONE, (String)"mock-group", (Node)node), node);
        Node coordinator = new Node(Integer.MAX_VALUE - node.id(), node.host(), node.port());
        client.prepareResponseFrom((AbstractResponse)this.offsetResponse(Collections.singletonMap(this.tp0, offset1), Errors.NONE), coordinator);
        Assertions.assertEquals((long)offset1, (long)((OffsetAndMetadata)this.consumer.committed(Collections.singleton(this.tp0)).get(this.tp0)).offset());
        this.consumer.assign(Arrays.asList(this.tp0, this.tp1));
        HashMap<TopicPartition, Long> offsets = new HashMap<TopicPartition, Long>();
        offsets.put(this.tp0, offset1);
        client.prepareResponseFrom((AbstractResponse)this.offsetResponse(offsets, Errors.NONE), coordinator);
        Assertions.assertEquals((long)offset1, (long)((OffsetAndMetadata)this.consumer.committed(Collections.singleton(this.tp0)).get(this.tp0)).offset());
        offsets.remove(this.tp0);
        offsets.put(this.tp1, offset2);
        client.prepareResponseFrom((AbstractResponse)this.offsetResponse(offsets, Errors.NONE), coordinator);
        Assertions.assertEquals((long)offset2, (long)((OffsetAndMetadata)this.consumer.committed(Collections.singleton(this.tp1)).get(this.tp1)).offset());
    }

    @ParameterizedTest
    @EnumSource(value=GroupProtocol.class, names={"CLASSIC"})
    public void testFetchStableOffsetThrowInCommitted(GroupProtocol groupProtocol) {
        Assertions.assertThrows(UnsupportedVersionException.class, () -> this.setupThrowableConsumer(groupProtocol).committed(Collections.singleton(this.tp0)));
    }

    @ParameterizedTest
    @EnumSource(value=GroupProtocol.class, names={"CLASSIC"})
    public void testFetchStableOffsetThrowInPoll(GroupProtocol groupProtocol) {
        Assertions.assertThrows(UnsupportedVersionException.class, () -> this.setupThrowableConsumer(groupProtocol).poll(Duration.ZERO));
    }

    @ParameterizedTest
    @EnumSource(value=GroupProtocol.class, names={"CLASSIC"})
    public void testFetchStableOffsetThrowInPosition(GroupProtocol groupProtocol) {
        Assertions.assertThrows(UnsupportedVersionException.class, () -> this.setupThrowableConsumer(groupProtocol).position(this.tp0));
    }

    private KafkaConsumer<?, ?> setupThrowableConsumer(GroupProtocol groupProtocol) {
        long offset1 = 10000L;
        ConsumerMetadata metadata = this.createMetadata(this.subscription);
        MockClient client = new MockClient(this.time, (Metadata)metadata);
        this.initMetadata(client, Collections.singletonMap("test", 2));
        client.setNodeApiVersions(NodeApiVersions.create((short)ApiKeys.OFFSET_FETCH.id, (short)0, (short)6));
        Node node = (Node)metadata.fetch().nodes().get(0);
        this.consumer = this.newConsumer(groupProtocol, this.time, client, this.subscription, metadata, this.assignor, true, "mock-group", this.groupInstanceId, true);
        this.consumer.assign(Collections.singletonList(this.tp0));
        client.prepareResponseFrom((AbstractResponse)FindCoordinatorResponse.prepareResponse((Errors)Errors.NONE, (String)"mock-group", (Node)node), node);
        Node coordinator = new Node(Integer.MAX_VALUE - node.id(), node.host(), node.port());
        client.prepareResponseFrom((AbstractResponse)this.offsetResponse(Collections.singletonMap(this.tp0, offset1), Errors.NONE), coordinator);
        return this.consumer;
    }

    @ParameterizedTest
    @EnumSource(value=GroupProtocol.class, names={"CLASSIC"})
    public void testNoCommittedOffsets(GroupProtocol groupProtocol) {
        long offset1 = 10000L;
        ConsumerMetadata metadata = this.createMetadata(this.subscription);
        MockClient client = new MockClient(this.time, (Metadata)metadata);
        this.initMetadata(client, Collections.singletonMap("test", 2));
        Node node = (Node)metadata.fetch().nodes().get(0);
        this.consumer = this.newConsumer(groupProtocol, this.time, client, this.subscription, metadata, this.assignor, true, this.groupInstanceId);
        this.consumer.assign(Arrays.asList(this.tp0, this.tp1));
        client.prepareResponseFrom((AbstractResponse)FindCoordinatorResponse.prepareResponse((Errors)Errors.NONE, (String)"mock-group", (Node)node), node);
        Node coordinator = new Node(Integer.MAX_VALUE - node.id(), node.host(), node.port());
        client.prepareResponseFrom((AbstractResponse)this.offsetResponse(Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)this.tp0, (Object)offset1), Utils.mkEntry((Object)this.tp1, (Object)-1L)}), Errors.NONE), coordinator);
        Map committed = this.consumer.committed(Utils.mkSet((Object[])new TopicPartition[]{this.tp0, this.tp1}));
        Assertions.assertEquals((int)2, (int)committed.size());
        Assertions.assertEquals((long)offset1, (long)((OffsetAndMetadata)committed.get(this.tp0)).offset());
        Assertions.assertNull(committed.get(this.tp1));
    }

    @ParameterizedTest
    @EnumSource(value=GroupProtocol.class, names={"CLASSIC"})
    public void testAutoCommitSentBeforePositionUpdate(GroupProtocol groupProtocol) {
        ConsumerMetadata metadata = this.createMetadata(this.subscription);
        MockClient client = new MockClient(this.time, (Metadata)metadata);
        this.initMetadata(client, Collections.singletonMap("test", 1));
        Node node = (Node)metadata.fetch().nodes().get(0);
        this.consumer = this.newConsumer(groupProtocol, this.time, client, this.subscription, metadata, this.assignor, true, this.groupInstanceId);
        this.consumer.subscribe(Collections.singleton("test"), this.getConsumerRebalanceListener(this.consumer));
        Node coordinator = this.prepareRebalance(client, node, this.assignor, Collections.singletonList(this.tp0), null);
        this.consumer.updateAssignmentMetadataIfNeeded(this.time.timer(Long.MAX_VALUE));
        this.consumer.poll(Duration.ZERO);
        client.respondFrom((AbstractResponse)this.fetchResponse(this.tp0, 0L, 5), node);
        client.poll(0L, this.time.milliseconds());
        this.time.sleep(500L);
        client.prepareResponseFrom((AbstractResponse)this.fetchResponse(this.tp0, 5L, 0), node);
        AtomicBoolean commitReceived = this.prepareOffsetCommitResponse(client, coordinator, this.tp0, 0L);
        this.consumer.poll(Duration.ZERO);
        Assertions.assertTrue((boolean)commitReceived.get());
    }

    @ParameterizedTest
    @EnumSource(value=GroupProtocol.class, names={"CLASSIC"})
    public void testRegexSubscription(GroupProtocol groupProtocol) {
        String unmatchedTopic = "unmatched";
        ConsumerMetadata metadata = this.createMetadata(this.subscription);
        MockClient client = new MockClient(this.time, (Metadata)metadata);
        HashMap<String, Integer> partitionCounts = new HashMap<String, Integer>();
        partitionCounts.put("test", 1);
        partitionCounts.put(unmatchedTopic, 1);
        this.topicIds.put(unmatchedTopic, Uuid.randomUuid());
        this.initMetadata(client, partitionCounts);
        Node node = (Node)metadata.fetch().nodes().get(0);
        this.consumer = this.newConsumer(groupProtocol, this.time, client, this.subscription, metadata, this.assignor, true, this.groupInstanceId);
        this.prepareRebalance(client, node, Collections.singleton("test"), this.assignor, Collections.singletonList(this.tp0), null);
        this.consumer.subscribe(Pattern.compile("test"), this.getConsumerRebalanceListener(this.consumer));
        client.prepareMetadataUpdate(RequestTestUtils.metadataUpdateWithIds(1, partitionCounts, this.topicIds));
        this.consumer.updateAssignmentMetadataIfNeeded(this.time.timer(Long.MAX_VALUE));
        Assertions.assertEquals(Collections.singleton("test"), (Object)this.consumer.subscription());
        Assertions.assertEquals(Collections.singleton(this.tp0), (Object)this.consumer.assignment());
    }

    @ParameterizedTest
    @EnumSource(value=GroupProtocol.class, names={"CLASSIC"})
    public void testChangingRegexSubscription(GroupProtocol groupProtocol) {
        String otherTopic = "other";
        TopicPartition otherTopicPartition = new TopicPartition(otherTopic, 0);
        ConsumerMetadata metadata = this.createMetadata(this.subscription);
        MockClient client = new MockClient(this.time, (Metadata)metadata);
        HashMap<String, Integer> partitionCounts = new HashMap<String, Integer>();
        partitionCounts.put("test", 1);
        partitionCounts.put(otherTopic, 1);
        this.topicIds.put(otherTopic, Uuid.randomUuid());
        this.initMetadata(client, partitionCounts);
        Node node = (Node)metadata.fetch().nodes().get(0);
        this.consumer = this.newConsumer(groupProtocol, this.time, client, this.subscription, metadata, this.assignor, false, this.groupInstanceId);
        Node coordinator = this.prepareRebalance(client, node, Collections.singleton("test"), this.assignor, Collections.singletonList(this.tp0), null);
        this.consumer.subscribe(Pattern.compile("test"), this.getConsumerRebalanceListener(this.consumer));
        this.consumer.updateAssignmentMetadataIfNeeded(this.time.timer(Long.MAX_VALUE));
        this.consumer.poll(Duration.ZERO);
        Assertions.assertEquals(Collections.singleton("test"), (Object)this.consumer.subscription());
        this.consumer.subscribe(Pattern.compile(otherTopic), this.getConsumerRebalanceListener(this.consumer));
        client.prepareMetadataUpdate(RequestTestUtils.metadataUpdateWithIds(1, partitionCounts, this.topicIds));
        this.prepareRebalance(client, node, Collections.singleton(otherTopic), this.assignor, Collections.singletonList(otherTopicPartition), coordinator);
        this.consumer.poll(Duration.ZERO);
        Assertions.assertEquals(Collections.singleton(otherTopic), (Object)this.consumer.subscription());
    }

    @ParameterizedTest
    @EnumSource(value=GroupProtocol.class, names={"CLASSIC"})
    public void testWakeupWithFetchDataAvailable(GroupProtocol groupProtocol) throws Exception {
        ConsumerMetadata metadata = this.createMetadata(this.subscription);
        MockClient client = new MockClient(this.time, (Metadata)metadata);
        this.initMetadata(client, Collections.singletonMap("test", 1));
        Node node = (Node)metadata.fetch().nodes().get(0);
        this.consumer = this.newConsumer(groupProtocol, this.time, client, this.subscription, metadata, this.assignor, true, this.groupInstanceId);
        this.consumer.subscribe(Collections.singleton("test"), this.getConsumerRebalanceListener(this.consumer));
        this.prepareRebalance(client, node, this.assignor, Collections.singletonList(this.tp0), null);
        this.consumer.updateAssignmentMetadataIfNeeded(this.time.timer(Long.MAX_VALUE));
        this.consumer.poll(Duration.ZERO);
        client.respondFrom((AbstractResponse)this.fetchResponse(this.tp0, 0L, 5), node);
        client.poll(0L, this.time.milliseconds());
        this.consumer.wakeup();
        Assertions.assertThrows(WakeupException.class, () -> this.consumer.poll(Duration.ZERO));
        Assertions.assertEquals((long)0L, (long)this.consumer.position(this.tp0));
        ConsumerRecords records = this.consumer.poll(Duration.ZERO);
        Assertions.assertEquals((int)5, (int)records.count());
        ScheduledExecutorService exec = Executors.newSingleThreadScheduledExecutor();
        exec.scheduleAtFixedRate(() -> this.time.sleep(10000L), 0L, 10L, TimeUnit.MILLISECONDS);
        this.consumer.close();
        exec.shutdownNow();
        exec.awaitTermination(5L, TimeUnit.SECONDS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ParameterizedTest
    @EnumSource(value=GroupProtocol.class, names={"CLASSIC"})
    public void testPollThrowsInterruptExceptionIfInterrupted(GroupProtocol groupProtocol) {
        ConsumerMetadata metadata = this.createMetadata(this.subscription);
        MockClient client = new MockClient(this.time, (Metadata)metadata);
        this.initMetadata(client, Collections.singletonMap("test", 1));
        Node node = (Node)metadata.fetch().nodes().get(0);
        this.consumer = this.newConsumer(groupProtocol, this.time, client, this.subscription, metadata, this.assignor, false, this.groupInstanceId);
        this.consumer.subscribe(Collections.singleton("test"), this.getConsumerRebalanceListener(this.consumer));
        this.prepareRebalance(client, node, this.assignor, Collections.singletonList(this.tp0), null);
        this.consumer.updateAssignmentMetadataIfNeeded(this.time.timer(Long.MAX_VALUE));
        this.consumer.poll(Duration.ZERO);
        try {
            Thread.currentThread().interrupt();
            Assertions.assertThrows(InterruptException.class, () -> this.consumer.poll(Duration.ZERO));
        }
        finally {
            Thread.interrupted();
        }
    }

    @ParameterizedTest
    @EnumSource(value=GroupProtocol.class, names={"CLASSIC"})
    public void fetchResponseWithUnexpectedPartitionIsIgnored(GroupProtocol groupProtocol) {
        ConsumerMetadata metadata = this.createMetadata(this.subscription);
        MockClient client = new MockClient(this.time, (Metadata)metadata);
        this.initMetadata(client, Collections.singletonMap("test", 1));
        Node node = (Node)metadata.fetch().nodes().get(0);
        this.consumer = this.newConsumer(groupProtocol, this.time, client, this.subscription, metadata, this.assignor, true, this.groupInstanceId);
        this.consumer.subscribe(Collections.singletonList("test"), this.getConsumerRebalanceListener(this.consumer));
        this.prepareRebalance(client, node, this.assignor, Collections.singletonList(this.tp0), null);
        HashMap<TopicPartition, FetchInfo> fetches1 = new HashMap<TopicPartition, FetchInfo>();
        fetches1.put(this.tp0, new FetchInfo(0L, 1));
        fetches1.put(this.t2p0, new FetchInfo(0L, 10));
        client.prepareResponseFrom((AbstractResponse)this.fetchResponse(fetches1), node);
        this.consumer.updateAssignmentMetadataIfNeeded(this.time.timer(Long.MAX_VALUE));
        ConsumerRecords records = this.consumer.poll(Duration.ZERO);
        Assertions.assertEquals((int)0, (int)records.count());
    }

    @ParameterizedTest
    @EnumSource(value=GroupProtocol.class, names={"CLASSIC"})
    public void testSubscriptionChangesWithAutoCommitEnabled(GroupProtocol groupProtocol) {
        ConsumerMetadata metadata = this.createMetadata(this.subscription);
        MockClient client = new MockClient(this.time, (Metadata)metadata);
        HashMap<String, Integer> tpCounts = new HashMap<String, Integer>();
        tpCounts.put("test", 1);
        tpCounts.put("test2", 1);
        tpCounts.put("test3", 1);
        this.initMetadata(client, tpCounts);
        Node node = (Node)metadata.fetch().nodes().get(0);
        RangeAssignor assignor = new RangeAssignor();
        this.consumer = this.newConsumer(groupProtocol, this.time, client, this.subscription, metadata, (ConsumerPartitionAssignor)assignor, true, this.groupInstanceId);
        this.consumer.subscribe(Arrays.asList("test", "test2"), this.getConsumerRebalanceListener(this.consumer));
        Assertions.assertEquals((int)2, (int)this.consumer.subscription().size());
        Assertions.assertTrue((this.consumer.subscription().contains("test") && this.consumer.subscription().contains("test2") ? 1 : 0) != 0);
        Assertions.assertTrue((boolean)this.consumer.assignment().isEmpty());
        Node coordinator = this.prepareRebalance(client, node, (ConsumerPartitionAssignor)assignor, Arrays.asList(this.tp0, this.t2p0), null);
        this.consumer.updateAssignmentMetadataIfNeeded(this.time.timer(Long.MAX_VALUE));
        this.consumer.poll(Duration.ZERO);
        Assertions.assertEquals((int)2, (int)this.consumer.subscription().size());
        Assertions.assertTrue((this.consumer.subscription().contains("test") && this.consumer.subscription().contains("test2") ? 1 : 0) != 0);
        Assertions.assertEquals((int)2, (int)this.consumer.assignment().size());
        Assertions.assertTrue((this.consumer.assignment().contains(this.tp0) && this.consumer.assignment().contains(this.t2p0) ? 1 : 0) != 0);
        HashMap<TopicPartition, FetchInfo> fetches1 = new HashMap<TopicPartition, FetchInfo>();
        fetches1.put(this.tp0, new FetchInfo(0L, 1));
        fetches1.put(this.t2p0, new FetchInfo(0L, 10));
        client.respondFrom((AbstractResponse)this.fetchResponse(fetches1), node);
        client.poll(0L, this.time.milliseconds());
        ConsumerRecords records = this.consumer.poll(Duration.ofMillis(1L));
        fetches1.put(this.tp0, new FetchInfo(1L, 0));
        fetches1.put(this.t2p0, new FetchInfo(10L, 0));
        client.respondFrom((AbstractResponse)this.fetchResponse(fetches1), node);
        client.poll(0L, this.time.milliseconds());
        Assertions.assertEquals((int)11, (int)records.count());
        Assertions.assertEquals((long)1L, (long)this.consumer.position(this.tp0));
        Assertions.assertEquals((long)10L, (long)this.consumer.position(this.t2p0));
        this.consumer.subscribe(Arrays.asList("test", "test3"), this.getConsumerRebalanceListener(this.consumer));
        Assertions.assertEquals((int)2, (int)this.consumer.subscription().size());
        Assertions.assertTrue((this.consumer.subscription().contains("test") && this.consumer.subscription().contains("test3") ? 1 : 0) != 0);
        Assertions.assertEquals((int)2, (int)this.consumer.assignment().size());
        Assertions.assertTrue((this.consumer.assignment().contains(this.tp0) && this.consumer.assignment().contains(this.t2p0) ? 1 : 0) != 0);
        HashMap<TopicPartition, Long> partitionOffsets1 = new HashMap<TopicPartition, Long>();
        partitionOffsets1.put(this.tp0, 1L);
        partitionOffsets1.put(this.t2p0, 10L);
        AtomicBoolean commitReceived = this.prepareOffsetCommitResponse(client, coordinator, partitionOffsets1);
        this.prepareRebalance(client, node, (ConsumerPartitionAssignor)assignor, Arrays.asList(this.tp0, this.t3p0), coordinator);
        HashMap<TopicPartition, FetchInfo> fetches2 = new HashMap<TopicPartition, FetchInfo>();
        fetches2.put(this.tp0, new FetchInfo(1L, 1));
        fetches2.put(this.t3p0, new FetchInfo(0L, 100));
        client.prepareResponse((AbstractResponse)this.fetchResponse(fetches2));
        records = this.consumer.poll(Duration.ofMillis(1L));
        Assertions.assertEquals((int)101, (int)records.count());
        Assertions.assertEquals((long)2L, (long)this.consumer.position(this.tp0));
        Assertions.assertEquals((long)100L, (long)this.consumer.position(this.t3p0));
        Assertions.assertTrue((boolean)commitReceived.get());
        Assertions.assertEquals((int)2, (int)this.consumer.subscription().size());
        Assertions.assertTrue((this.consumer.subscription().contains("test") && this.consumer.subscription().contains("test3") ? 1 : 0) != 0);
        Assertions.assertEquals((int)2, (int)this.consumer.assignment().size());
        Assertions.assertTrue((this.consumer.assignment().contains(this.tp0) && this.consumer.assignment().contains(this.t3p0) ? 1 : 0) != 0);
        this.consumer.unsubscribe();
        Assertions.assertTrue((boolean)this.consumer.subscription().isEmpty());
        Assertions.assertTrue((boolean)this.consumer.assignment().isEmpty());
        client.requests().clear();
    }

    @ParameterizedTest
    @EnumSource(value=GroupProtocol.class, names={"CLASSIC"})
    public void testSubscriptionChangesWithAutoCommitDisabled(GroupProtocol groupProtocol) {
        ConsumerMetadata metadata = this.createMetadata(this.subscription);
        MockClient client = new MockClient(this.time, (Metadata)metadata);
        HashMap<String, Integer> tpCounts = new HashMap<String, Integer>();
        tpCounts.put("test", 1);
        tpCounts.put("test2", 1);
        this.initMetadata(client, tpCounts);
        Node node = (Node)metadata.fetch().nodes().get(0);
        RangeAssignor assignor = new RangeAssignor();
        this.consumer = this.newConsumer(groupProtocol, this.time, client, this.subscription, metadata, (ConsumerPartitionAssignor)assignor, false, this.groupInstanceId);
        this.initializeSubscriptionWithSingleTopic(this.consumer, this.getConsumerRebalanceListener(this.consumer));
        this.prepareRebalance(client, node, (ConsumerPartitionAssignor)assignor, Collections.singletonList(this.tp0), null);
        this.consumer.updateAssignmentMetadataIfNeeded(this.time.timer(Long.MAX_VALUE));
        this.consumer.poll(Duration.ZERO);
        Assertions.assertEquals(Collections.singleton("test"), (Object)this.consumer.subscription());
        Assertions.assertEquals(Collections.singleton(this.tp0), (Object)this.consumer.assignment());
        this.consumer.poll(Duration.ZERO);
        this.consumer.subscribe(Collections.singleton("test2"), this.getConsumerRebalanceListener(this.consumer));
        Assertions.assertEquals(Collections.singleton("test2"), (Object)this.consumer.subscription());
        Assertions.assertEquals(Collections.singleton(this.tp0), (Object)this.consumer.assignment());
        for (ClientRequest req : client.requests()) {
            Assertions.assertNotSame((Object)ApiKeys.OFFSET_COMMIT, (Object)req.requestBuilder().apiKey());
        }
        this.consumer.unsubscribe();
        Assertions.assertEquals(Collections.emptySet(), (Object)this.consumer.subscription());
        Assertions.assertEquals(Collections.emptySet(), (Object)this.consumer.assignment());
        for (ClientRequest req : client.requests()) {
            Assertions.assertNotSame((Object)ApiKeys.OFFSET_COMMIT, (Object)req.requestBuilder().apiKey());
        }
        client.requests().clear();
    }

    @ParameterizedTest
    @EnumSource(value=GroupProtocol.class, names={"CLASSIC"})
    public void testUnsubscribeShouldTriggerPartitionsRevokedWithValidGeneration(GroupProtocol groupProtocol) {
        ConsumerMetadata metadata = this.createMetadata(this.subscription);
        MockClient client = new MockClient(this.time, (Metadata)metadata);
        this.initMetadata(client, Collections.singletonMap("test", 1));
        Node node = (Node)metadata.fetch().nodes().get(0);
        CooperativeStickyAssignor assignor = new CooperativeStickyAssignor();
        this.consumer = this.newConsumer(groupProtocol, this.time, client, this.subscription, metadata, (ConsumerPartitionAssignor)assignor, false, this.groupInstanceId);
        this.initializeSubscriptionWithSingleTopic(this.consumer, this.getExceptionConsumerRebalanceListener());
        this.prepareRebalance(client, node, (ConsumerPartitionAssignor)assignor, Collections.singletonList(this.tp0), null);
        RuntimeException assignmentException = (RuntimeException)Assertions.assertThrows(RuntimeException.class, () -> this.consumer.updateAssignmentMetadataIfNeeded(this.time.timer(Long.MAX_VALUE)));
        Assertions.assertEquals((Object)("Hit partition assign " + this.singleTopicPartition), (Object)assignmentException.getCause().getMessage());
        RuntimeException unsubscribeException = (RuntimeException)Assertions.assertThrows(RuntimeException.class, () -> this.consumer.unsubscribe());
        Assertions.assertEquals((Object)("Hit partition revoke " + this.singleTopicPartition), (Object)unsubscribeException.getCause().getMessage());
    }

    @ParameterizedTest
    @EnumSource(value=GroupProtocol.class, names={"CLASSIC"})
    public void testUnsubscribeShouldTriggerPartitionsLostWithNoGeneration(GroupProtocol groupProtocol) throws Exception {
        ConsumerMetadata metadata = this.createMetadata(this.subscription);
        MockClient client = new MockClient(this.time, (Metadata)metadata);
        this.initMetadata(client, Collections.singletonMap("test", 1));
        Node node = (Node)metadata.fetch().nodes().get(0);
        CooperativeStickyAssignor assignor = new CooperativeStickyAssignor();
        this.consumer = this.newConsumer(groupProtocol, this.time, client, this.subscription, metadata, (ConsumerPartitionAssignor)assignor, false, this.groupInstanceId);
        this.initializeSubscriptionWithSingleTopic(this.consumer, this.getExceptionConsumerRebalanceListener());
        Node coordinator = this.prepareRebalance(client, node, (ConsumerPartitionAssignor)assignor, Collections.singletonList(this.tp0), null);
        RuntimeException assignException = (RuntimeException)Assertions.assertThrows(RuntimeException.class, () -> this.consumer.updateAssignmentMetadataIfNeeded(this.time.timer(Long.MAX_VALUE)));
        Assertions.assertEquals((Object)("Hit partition assign " + this.singleTopicPartition), (Object)assignException.getCause().getMessage());
        AtomicBoolean heartbeatReceived = this.prepareHeartbeatResponse(client, coordinator, Errors.UNKNOWN_MEMBER_ID);
        this.time.sleep(1000L);
        TestUtils.waitForCondition(heartbeatReceived::get, "Heartbeat response did not occur within timeout.");
        RuntimeException unsubscribeException = (RuntimeException)Assertions.assertThrows(RuntimeException.class, () -> this.consumer.unsubscribe());
        Assertions.assertEquals((Object)("Hit partition lost " + this.singleTopicPartition), (Object)unsubscribeException.getCause().getMessage());
    }

    private void initializeSubscriptionWithSingleTopic(KafkaConsumer<?, ?> consumer, ConsumerRebalanceListener consumerRebalanceListener) {
        consumer.subscribe(Collections.singleton("test"), consumerRebalanceListener);
        Assertions.assertEquals(Collections.singleton("test"), (Object)consumer.subscription());
        Assertions.assertEquals(Collections.emptySet(), (Object)consumer.assignment());
    }

    @ParameterizedTest
    @EnumSource(value=GroupProtocol.class, names={"CLASSIC"})
    public void testManualAssignmentChangeWithAutoCommitEnabled(GroupProtocol groupProtocol) {
        ConsumerMetadata metadata = this.createMetadata(this.subscription);
        MockClient client = new MockClient(this.time, (Metadata)metadata);
        HashMap<String, Integer> tpCounts = new HashMap<String, Integer>();
        tpCounts.put("test", 1);
        tpCounts.put("test2", 1);
        this.initMetadata(client, tpCounts);
        Node node = (Node)metadata.fetch().nodes().get(0);
        RangeAssignor assignor = new RangeAssignor();
        this.consumer = this.newConsumer(groupProtocol, this.time, client, this.subscription, metadata, (ConsumerPartitionAssignor)assignor, true, this.groupInstanceId);
        client.prepareResponseFrom((AbstractResponse)FindCoordinatorResponse.prepareResponse((Errors)Errors.NONE, (String)"mock-group", (Node)node), node);
        Node coordinator = new Node(Integer.MAX_VALUE - node.id(), node.host(), node.port());
        this.consumer.assign(Collections.singleton(this.tp0));
        this.consumer.seekToBeginning(Collections.singleton(this.tp0));
        client.prepareResponseFrom((AbstractResponse)this.offsetResponse(Collections.singletonMap(this.tp0, 0L), Errors.NONE), coordinator);
        Assertions.assertEquals((long)0L, (long)((OffsetAndMetadata)this.consumer.committed(Collections.singleton(this.tp0)).get(this.tp0)).offset());
        Assertions.assertEquals((Object)this.consumer.assignment(), Collections.singleton(this.tp0));
        client.prepareResponse((AbstractResponse)this.listOffsetsResponse(Collections.singletonMap(this.tp0, 10L)));
        client.prepareResponse((AbstractResponse)this.fetchResponse(this.tp0, 10L, 1));
        ConsumerRecords records = this.consumer.poll(Duration.ofMillis(100L));
        Assertions.assertEquals((int)1, (int)records.count());
        Assertions.assertEquals((long)11L, (long)this.consumer.position(this.tp0));
        AtomicBoolean commitReceived = this.prepareOffsetCommitResponse(client, coordinator, this.tp0, 11L);
        this.consumer.assign(Collections.singleton(this.t2p0));
        Assertions.assertEquals((Object)this.consumer.assignment(), Collections.singleton(this.t2p0));
        Assertions.assertTrue((boolean)commitReceived.get());
        client.requests().clear();
    }

    @ParameterizedTest
    @EnumSource(value=GroupProtocol.class, names={"CLASSIC"})
    public void testManualAssignmentChangeWithAutoCommitDisabled(GroupProtocol groupProtocol) {
        ConsumerMetadata metadata = this.createMetadata(this.subscription);
        MockClient client = new MockClient(this.time, (Metadata)metadata);
        HashMap<String, Integer> tpCounts = new HashMap<String, Integer>();
        tpCounts.put("test", 1);
        tpCounts.put("test2", 1);
        this.initMetadata(client, tpCounts);
        Node node = (Node)metadata.fetch().nodes().get(0);
        RangeAssignor assignor = new RangeAssignor();
        this.consumer = this.newConsumer(groupProtocol, this.time, client, this.subscription, metadata, (ConsumerPartitionAssignor)assignor, false, this.groupInstanceId);
        client.prepareResponseFrom((AbstractResponse)FindCoordinatorResponse.prepareResponse((Errors)Errors.NONE, (String)"mock-group", (Node)node), node);
        Node coordinator = new Node(Integer.MAX_VALUE - node.id(), node.host(), node.port());
        this.consumer.assign(Collections.singleton(this.tp0));
        this.consumer.seekToBeginning(Collections.singleton(this.tp0));
        client.prepareResponseFrom((AbstractResponse)this.offsetResponse(Collections.singletonMap(this.tp0, 0L), Errors.NONE), coordinator);
        Assertions.assertEquals((long)0L, (long)((OffsetAndMetadata)this.consumer.committed(Collections.singleton(this.tp0)).get(this.tp0)).offset());
        Assertions.assertEquals((Object)this.consumer.assignment(), Collections.singleton(this.tp0));
        client.prepareResponse((AbstractResponse)this.listOffsetsResponse(Collections.singletonMap(this.tp0, 10L)));
        client.prepareResponse((AbstractResponse)this.fetchResponse(this.tp0, 10L, 1));
        ConsumerRecords records = this.consumer.poll(Duration.ofMillis(1L));
        Assertions.assertEquals((int)1, (int)records.count());
        Assertions.assertEquals((long)11L, (long)this.consumer.position(this.tp0));
        this.consumer.assign(Collections.singleton(this.t2p0));
        Assertions.assertEquals((Object)this.consumer.assignment(), Collections.singleton(this.t2p0));
        for (ClientRequest req : client.requests()) {
            Assertions.assertNotSame((Object)req.requestBuilder().apiKey(), (Object)ApiKeys.OFFSET_COMMIT);
        }
        client.requests().clear();
    }

    @ParameterizedTest
    @EnumSource(value=GroupProtocol.class, names={"CLASSIC"})
    public void testOffsetOfPausedPartitions(GroupProtocol groupProtocol) {
        ConsumerMetadata metadata = this.createMetadata(this.subscription);
        MockClient client = new MockClient(this.time, (Metadata)metadata);
        this.initMetadata(client, Collections.singletonMap("test", 2));
        Node node = (Node)metadata.fetch().nodes().get(0);
        RangeAssignor assignor = new RangeAssignor();
        this.consumer = this.newConsumer(groupProtocol, this.time, client, this.subscription, metadata, (ConsumerPartitionAssignor)assignor, true, this.groupInstanceId);
        client.prepareResponseFrom((AbstractResponse)FindCoordinatorResponse.prepareResponse((Errors)Errors.NONE, (String)"mock-group", (Node)node), node);
        Node coordinator = new Node(Integer.MAX_VALUE - node.id(), node.host(), node.port());
        Set partitions = Utils.mkSet((Object[])new TopicPartition[]{this.tp0, this.tp1});
        this.consumer.assign((Collection)partitions);
        Assertions.assertEquals((Object)partitions, (Object)this.consumer.assignment());
        this.consumer.pause((Collection)partitions);
        this.consumer.seekToEnd((Collection)partitions);
        HashMap<TopicPartition, Long> offsets = new HashMap<TopicPartition, Long>();
        offsets.put(this.tp0, 0L);
        offsets.put(this.tp1, 0L);
        client.prepareResponseFrom((AbstractResponse)this.offsetResponse(offsets, Errors.NONE), coordinator);
        Assertions.assertEquals((long)0L, (long)((OffsetAndMetadata)this.consumer.committed(Collections.singleton(this.tp0)).get(this.tp0)).offset());
        offsets.remove(this.tp0);
        offsets.put(this.tp1, 0L);
        client.prepareResponseFrom((AbstractResponse)this.offsetResponse(offsets, Errors.NONE), coordinator);
        Assertions.assertEquals((long)0L, (long)((OffsetAndMetadata)this.consumer.committed(Collections.singleton(this.tp1)).get(this.tp1)).offset());
        HashMap<TopicPartition, Long> offsetResponse = new HashMap<TopicPartition, Long>();
        offsetResponse.put(this.tp0, 3L);
        offsetResponse.put(this.tp1, 3L);
        client.prepareResponse((AbstractResponse)this.listOffsetsResponse(offsetResponse));
        Assertions.assertEquals((long)3L, (long)this.consumer.position(this.tp0));
        Assertions.assertEquals((long)3L, (long)this.consumer.position(this.tp1));
        client.requests().clear();
        this.consumer.unsubscribe();
    }

    @ParameterizedTest
    @EnumSource(value=GroupProtocol.class)
    public void testPollWithNoSubscription(GroupProtocol groupProtocol) {
        this.consumer = this.newConsumer(groupProtocol, null);
        Assertions.assertThrows(IllegalStateException.class, () -> this.consumer.poll(Duration.ZERO));
    }

    @ParameterizedTest
    @EnumSource(value=GroupProtocol.class)
    public void testPollWithEmptySubscription(GroupProtocol groupProtocol) {
        this.consumer = this.newConsumer(groupProtocol, "mock-group");
        this.consumer.subscribe(Collections.emptyList());
        Assertions.assertThrows(IllegalStateException.class, () -> this.consumer.poll(Duration.ZERO));
    }

    @ParameterizedTest
    @EnumSource(value=GroupProtocol.class)
    public void testPollWithEmptyUserAssignment(GroupProtocol groupProtocol) {
        this.consumer = this.newConsumer(groupProtocol, "mock-group");
        this.consumer.assign(Collections.emptySet());
        Assertions.assertThrows(IllegalStateException.class, () -> this.consumer.poll(Duration.ZERO));
    }

    @ParameterizedTest
    @EnumSource(value=GroupProtocol.class, names={"CLASSIC"})
    public void testGracefulClose(GroupProtocol groupProtocol) throws Exception {
        HashMap<TopicPartition, Errors> response = new HashMap<TopicPartition, Errors>();
        response.put(this.tp0, Errors.NONE);
        OffsetCommitResponse commitResponse = this.offsetCommitResponse(response);
        LeaveGroupResponse leaveGroupResponse = new LeaveGroupResponse(new LeaveGroupResponseData().setErrorCode(Errors.NONE.code()));
        FetchResponse closeResponse = FetchResponse.of((Errors)Errors.NONE, (int)0, (int)0, new LinkedHashMap());
        this.consumerCloseTest(groupProtocol, 5000L, Arrays.asList(commitResponse, leaveGroupResponse, closeResponse), 0L, false);
    }

    @ParameterizedTest
    @EnumSource(value=GroupProtocol.class, names={"CLASSIC"})
    public void testCloseTimeoutDueToNoResponseForCloseFetchRequest(GroupProtocol groupProtocol) throws Exception {
        HashMap<TopicPartition, Errors> response = new HashMap<TopicPartition, Errors>();
        response.put(this.tp0, Errors.NONE);
        OffsetCommitResponse commitResponse = this.offsetCommitResponse(response);
        LeaveGroupResponse leaveGroupResponse = new LeaveGroupResponse(new LeaveGroupResponseData().setErrorCode(Errors.NONE.code()));
        List<AbstractResponse> serverResponsesWithoutCloseResponse = Arrays.asList(commitResponse, leaveGroupResponse);
        int closeTimeoutMs = 5000;
        int waitForCloseCompletionMs = 6000;
        this.consumerCloseTest(groupProtocol, 5000L, serverResponsesWithoutCloseResponse, 6000L, false);
    }

    @ParameterizedTest
    @EnumSource(value=GroupProtocol.class, names={"CLASSIC"})
    public void testCloseTimeout(GroupProtocol groupProtocol) throws Exception {
        this.consumerCloseTest(groupProtocol, 5000L, Collections.emptyList(), 5000L, false);
    }

    @ParameterizedTest
    @EnumSource(value=GroupProtocol.class, names={"CLASSIC"})
    public void testLeaveGroupTimeout(GroupProtocol groupProtocol) throws Exception {
        HashMap<TopicPartition, Errors> response = new HashMap<TopicPartition, Errors>();
        response.put(this.tp0, Errors.NONE);
        OffsetCommitResponse commitResponse = this.offsetCommitResponse(response);
        this.consumerCloseTest(groupProtocol, 5000L, Collections.singletonList(commitResponse), 5000L, false);
    }

    @ParameterizedTest
    @EnumSource(value=GroupProtocol.class, names={"CLASSIC"})
    public void testCloseNoWait(GroupProtocol groupProtocol) throws Exception {
        this.consumerCloseTest(groupProtocol, 0L, Collections.emptyList(), 0L, false);
    }

    @ParameterizedTest
    @EnumSource(value=GroupProtocol.class, names={"CLASSIC"})
    public void testCloseInterrupt(GroupProtocol groupProtocol) throws Exception {
        this.consumerCloseTest(groupProtocol, Long.MAX_VALUE, Collections.emptyList(), 0L, true);
    }

    @ParameterizedTest
    @EnumSource(value=GroupProtocol.class, names={"CLASSIC"})
    public void testCloseShouldBeIdempotent(GroupProtocol groupProtocol) {
        ConsumerMetadata metadata = this.createMetadata(this.subscription);
        MockClient client = (MockClient)Mockito.spy((Object)new MockClient(this.time, (Metadata)metadata));
        this.initMetadata(client, Collections.singletonMap("test", 1));
        this.consumer = this.newConsumer(groupProtocol, this.time, client, this.subscription, metadata, this.assignor, false, this.groupInstanceId);
        this.consumer.close(Duration.ZERO);
        this.consumer.close(Duration.ZERO);
        ((MockClient)Mockito.verify((Object)client)).close();
    }

    @ParameterizedTest
    @EnumSource(value=GroupProtocol.class)
    public void testOperationsBySubscribingConsumerWithDefaultGroupId(GroupProtocol groupProtocol) {
        Throwable throwable;
        KafkaConsumer<byte[], byte[]> consumer2;
        try {
            consumer2 = this.newConsumer(groupProtocol, null, Optional.of(Boolean.TRUE));
            throwable = null;
            try {
                Assertions.fail((String)"Expected an InvalidConfigurationException");
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (consumer2 != null) {
                    if (throwable != null) {
                        try {
                            consumer2.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    } else {
                        consumer2.close();
                    }
                }
            }
        }
        catch (InvalidConfigurationException consumer2) {
            // empty catch block
        }
        try {
            consumer2 = this.newConsumer(groupProtocol, null);
            throwable = null;
            try {
                consumer2.subscribe(Collections.singleton("test"));
                Assertions.fail((String)"Expected an InvalidGroupIdException");
            }
            catch (Throwable throwable4) {
                throwable = throwable4;
                throw throwable4;
            }
            finally {
                if (consumer2 != null) {
                    if (throwable != null) {
                        try {
                            consumer2.close();
                        }
                        catch (Throwable throwable5) {
                            throwable.addSuppressed(throwable5);
                        }
                    } else {
                        consumer2.close();
                    }
                }
            }
        }
        catch (InvalidGroupIdException consumer3) {
            // empty catch block
        }
        try {
            consumer2 = this.newConsumer(groupProtocol, null);
            throwable = null;
            try {
                consumer2.committed(Collections.singleton(this.tp0)).get(this.tp0);
                Assertions.fail((String)"Expected an InvalidGroupIdException");
            }
            catch (Throwable throwable6) {
                throwable = throwable6;
                throw throwable6;
            }
            finally {
                if (consumer2 != null) {
                    if (throwable != null) {
                        try {
                            consumer2.close();
                        }
                        catch (Throwable throwable7) {
                            throwable.addSuppressed(throwable7);
                        }
                    } else {
                        consumer2.close();
                    }
                }
            }
        }
        catch (InvalidGroupIdException consumer4) {
            // empty catch block
        }
        try {
            consumer2 = this.newConsumer(groupProtocol, null);
            throwable = null;
            try {
                consumer2.commitAsync();
                Assertions.fail((String)"Expected an InvalidGroupIdException");
            }
            catch (Throwable throwable8) {
                throwable = throwable8;
                throw throwable8;
            }
            finally {
                if (consumer2 != null) {
                    if (throwable != null) {
                        try {
                            consumer2.close();
                        }
                        catch (Throwable throwable9) {
                            throwable.addSuppressed(throwable9);
                        }
                    } else {
                        consumer2.close();
                    }
                }
            }
        }
        catch (InvalidGroupIdException consumer5) {
            // empty catch block
        }
        try {
            consumer2 = this.newConsumer(groupProtocol, null);
            throwable = null;
            try {
                consumer2.commitSync();
                Assertions.fail((String)"Expected an InvalidGroupIdException");
            }
            catch (Throwable throwable10) {
                throwable = throwable10;
                throw throwable10;
            }
            finally {
                if (consumer2 != null) {
                    if (throwable != null) {
                        try {
                            consumer2.close();
                        }
                        catch (Throwable throwable11) {
                            throwable.addSuppressed(throwable11);
                        }
                    } else {
                        consumer2.close();
                    }
                }
            }
        }
        catch (InvalidGroupIdException invalidGroupIdException) {
            // empty catch block
        }
    }

    @ParameterizedTest
    @EnumSource(value=GroupProtocol.class)
    public void testOperationsByAssigningConsumerWithDefaultGroupId(GroupProtocol groupProtocol) {
        KafkaConsumer<byte[], byte[]> consumer = this.newConsumer(groupProtocol, null);
        consumer.assign(Collections.singleton(this.tp0));
        try {
            consumer.committed(Collections.singleton(this.tp0)).get(this.tp0);
            Assertions.fail((String)"Expected an InvalidGroupIdException");
        }
        catch (InvalidGroupIdException invalidGroupIdException) {
            // empty catch block
        }
        try {
            consumer.commitAsync();
            Assertions.fail((String)"Expected an InvalidGroupIdException");
        }
        catch (InvalidGroupIdException invalidGroupIdException) {
            // empty catch block
        }
        try {
            consumer.commitSync();
            Assertions.fail((String)"Expected an InvalidGroupIdException");
        }
        catch (InvalidGroupIdException invalidGroupIdException) {
            // empty catch block
        }
        consumer.close();
    }

    @ParameterizedTest
    @EnumSource(value=GroupProtocol.class)
    public void testMetricConfigRecordingLevelInfo(GroupProtocol groupProtocol) {
        Properties props = new Properties();
        props.put("group.protocol", groupProtocol.name());
        props.put("bootstrap.servers", "localhost:9000");
        KafkaConsumer consumer = this.newConsumer(props, (Deserializer)new ByteArrayDeserializer(), (Deserializer)new ByteArrayDeserializer());
        Assertions.assertEquals((Object)Sensor.RecordingLevel.INFO, (Object)consumer.metricsRegistry().config().recordLevel());
        consumer.close(Duration.ZERO);
        props.put("metrics.recording.level", "DEBUG");
        KafkaConsumer consumer2 = this.newConsumer(props, (Deserializer)new ByteArrayDeserializer(), (Deserializer)new ByteArrayDeserializer());
        Assertions.assertEquals((Object)Sensor.RecordingLevel.DEBUG, (Object)consumer2.metricsRegistry().config().recordLevel());
        consumer2.close(Duration.ZERO);
    }

    @ParameterizedTest
    @EnumSource(value=GroupProtocol.class, names={"CLASSIC"})
    public void testShouldAttemptToRejoinGroupAfterSyncGroupFailed(GroupProtocol groupProtocol) throws Exception {
        ConsumerMetadata metadata = this.createMetadata(this.subscription);
        MockClient client = new MockClient(this.time, (Metadata)metadata);
        this.initMetadata(client, Collections.singletonMap("test", 1));
        Node node = (Node)metadata.fetch().nodes().get(0);
        this.consumer = this.newConsumer(groupProtocol, this.time, client, this.subscription, metadata, this.assignor, false, this.groupInstanceId);
        this.consumer.subscribe(Collections.singleton("test"), this.getConsumerRebalanceListener(this.consumer));
        client.prepareResponseFrom((AbstractResponse)FindCoordinatorResponse.prepareResponse((Errors)Errors.NONE, (String)"mock-group", (Node)node), node);
        Node coordinator = new Node(Integer.MAX_VALUE - node.id(), node.host(), node.port());
        client.prepareResponseFrom((AbstractResponse)this.joinGroupFollowerResponse(this.assignor, 1, "memberId", "leaderId", Errors.NONE), coordinator);
        client.prepareResponseFrom((AbstractResponse)this.syncGroupResponse(Collections.singletonList(this.tp0), Errors.NONE), coordinator);
        client.prepareResponseFrom((AbstractResponse)this.fetchResponse(this.tp0, 0L, 1), node);
        client.prepareResponseFrom((AbstractResponse)this.fetchResponse(this.tp0, 1L, 0), node);
        this.consumer.updateAssignmentMetadataIfNeeded(this.time.timer(Long.MAX_VALUE));
        this.consumer.poll(Duration.ZERO);
        client.prepareResponseFrom(body -> true, (AbstractResponse)new HeartbeatResponse(new HeartbeatResponseData().setErrorCode(Errors.REBALANCE_IN_PROGRESS.code())), coordinator);
        ByteBuffer byteBuffer = ConsumerProtocol.serializeSubscription((ConsumerPartitionAssignor.Subscription)new ConsumerPartitionAssignor.Subscription(Collections.singletonList("test")));
        JoinGroupResponse leaderResponse = new JoinGroupResponse(new JoinGroupResponseData().setErrorCode(Errors.NONE.code()).setGenerationId(1).setProtocolName(this.assignor.name()).setLeader("memberId").setMemberId("memberId").setMembers(Collections.singletonList(new JoinGroupResponseData.JoinGroupResponseMember().setMemberId("memberId").setMetadata(byteBuffer.array()))), ApiKeys.JOIN_GROUP.latestVersion());
        client.prepareResponseFrom((AbstractResponse)leaderResponse, coordinator);
        client.prepareResponseFrom((AbstractResponse)this.syncGroupResponse(Collections.singletonList(this.tp0), Errors.NONE), coordinator, true);
        client.prepareResponseFrom((AbstractResponse)FindCoordinatorResponse.prepareResponse((Errors)Errors.NONE, (String)"mock-group", (Node)node), node);
        client.prepareResponseFrom((AbstractResponse)this.joinGroupFollowerResponse(this.assignor, 1, "memberId", "leaderId", Errors.NONE), coordinator);
        client.prepareResponseFrom((AbstractResponse)this.syncGroupResponse(Collections.singletonList(this.tp0), Errors.NONE), coordinator);
        client.prepareResponseFrom(body -> body instanceof FetchRequest && ((FetchRequest)body).fetchData(this.topicNames).containsKey(new TopicIdPartition(this.topicId, this.tp0)), (AbstractResponse)this.fetchResponse(this.tp0, 1L, 1), node);
        this.time.sleep(1000L);
        Thread.sleep(1000L);
        this.consumer.updateAssignmentMetadataIfNeeded(this.time.timer(Long.MAX_VALUE));
        ConsumerRecords records = this.consumer.poll(Duration.ZERO);
        Assertions.assertFalse((boolean)records.isEmpty());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void consumerCloseTest(GroupProtocol groupProtocol, long closeTimeoutMs, List<? extends AbstractResponse> responses, long waitMs, boolean interrupt) throws Exception {
        ConsumerMetadata metadata = this.createMetadata(this.subscription);
        MockClient client = new MockClient(this.time, (Metadata)metadata);
        this.initMetadata(client, Collections.singletonMap("test", 1));
        Node node = (Node)metadata.fetch().nodes().get(0);
        KafkaConsumer<String, String> consumer = this.newConsumer(groupProtocol, this.time, client, this.subscription, metadata, this.assignor, false, Optional.empty());
        consumer.subscribe(Collections.singleton("test"), this.getConsumerRebalanceListener(consumer));
        Node coordinator = this.prepareRebalance(client, node, this.assignor, Collections.singletonList(this.tp0), null);
        client.prepareMetadataUpdate(RequestTestUtils.metadataUpdateWithIds(1, Collections.singletonMap("test", 1), this.topicIds));
        consumer.updateAssignmentMetadataIfNeeded(this.time.timer(Long.MAX_VALUE));
        client.prepareResponseFrom((AbstractResponse)this.fetchResponse(this.tp0, 0L, 1), node);
        client.prepareResponseFrom((AbstractResponse)this.fetchResponse(this.tp0, 1L, 0), node);
        consumer.poll(Duration.ZERO);
        ExecutorService executor = Executors.newSingleThreadExecutor();
        AtomicReference closeException = new AtomicReference();
        try {
            Future<?> future = executor.submit(() -> {
                consumer.commitAsync();
                try {
                    consumer.close(Duration.ofMillis(closeTimeoutMs));
                }
                catch (Exception e) {
                    closeException.set(e);
                }
            });
            try {
                future.get(100L, TimeUnit.MILLISECONDS);
                if (closeTimeoutMs != 0L) {
                    Assertions.fail((String)"Close completed without waiting for commit or leave response");
                }
            }
            catch (TimeoutException timeoutException) {
                // empty catch block
            }
            client.waitForRequests(2, 1000L);
            int nonCloseRequests = 1;
            for (int i = 0; i < responses.size(); ++i) {
                client.waitForRequests(1, 1000L);
                if (i == responses.size() - 1 && responses.get(i) instanceof FetchResponse) {
                    client.respondFrom(responses.get(i), node);
                } else {
                    client.respondFrom(responses.get(i), coordinator);
                }
                if (i >= nonCloseRequests) continue;
                try {
                    future.get(100L, TimeUnit.MILLISECONDS);
                    Assertions.fail((String)"Close completed without waiting for response");
                    continue;
                }
                catch (TimeoutException timeoutException) {
                    // empty catch block
                }
            }
            if (waitMs > 0L) {
                this.time.sleep(waitMs);
            }
            if (interrupt) {
                Assertions.assertTrue((boolean)future.cancel(true), (String)"Close terminated prematurely");
                TestUtils.waitForCondition(() -> closeException.get() != null, "InterruptException did not occur within timeout.");
                Assertions.assertTrue((boolean)(closeException.get() instanceof InterruptException), (String)("Expected exception not thrown " + closeException));
            } else {
                future.get(closeTimeoutMs, TimeUnit.MILLISECONDS);
                Assertions.assertNull(closeException.get(), (String)"Unexpected exception during close");
            }
        }
        finally {
            executor.shutdownNow();
        }
    }

    @ParameterizedTest
    @EnumSource(value=GroupProtocol.class, names={"CLASSIC"})
    public void testPartitionsForNonExistingTopic(GroupProtocol groupProtocol) {
        ConsumerMetadata metadata = this.createMetadata(this.subscription);
        MockClient client = new MockClient(this.time, (Metadata)metadata);
        this.initMetadata(client, Collections.singletonMap("test", 1));
        Cluster cluster = metadata.fetch();
        MetadataResponse updateResponse = RequestTestUtils.metadataResponse(cluster.nodes(), cluster.clusterResource().clusterId(), cluster.controller().id(), Collections.emptyList());
        client.prepareResponse((AbstractResponse)updateResponse);
        KafkaConsumer<String, String> consumer = this.newConsumer(groupProtocol, this.time, client, this.subscription, metadata, this.assignor, true, this.groupInstanceId);
        Assertions.assertEquals(Collections.emptyList(), (Object)consumer.partitionsFor("non-exist-topic"));
    }

    @ParameterizedTest
    @EnumSource(value=GroupProtocol.class, names={"CLASSIC"})
    public void testPartitionsForAuthenticationFailure(GroupProtocol groupProtocol) {
        KafkaConsumer<String, String> consumer = this.consumerWithPendingAuthenticationError(groupProtocol);
        Assertions.assertThrows(AuthenticationException.class, () -> consumer.partitionsFor("some other topic"));
    }

    @ParameterizedTest
    @EnumSource(value=GroupProtocol.class, names={"CLASSIC"})
    public void testBeginningOffsetsAuthenticationFailure(GroupProtocol groupProtocol) {
        KafkaConsumer<String, String> consumer = this.consumerWithPendingAuthenticationError(groupProtocol);
        Assertions.assertThrows(AuthenticationException.class, () -> consumer.beginningOffsets(Collections.singleton(this.tp0)));
    }

    @ParameterizedTest
    @EnumSource(value=GroupProtocol.class, names={"CLASSIC"})
    public void testEndOffsetsAuthenticationFailure(GroupProtocol groupProtocol) {
        KafkaConsumer<String, String> consumer = this.consumerWithPendingAuthenticationError(groupProtocol);
        Assertions.assertThrows(AuthenticationException.class, () -> consumer.endOffsets(Collections.singleton(this.tp0)));
    }

    @ParameterizedTest
    @EnumSource(value=GroupProtocol.class, names={"CLASSIC"})
    public void testPollAuthenticationFailure(GroupProtocol groupProtocol) {
        KafkaConsumer<String, String> consumer = this.consumerWithPendingAuthenticationError(groupProtocol);
        consumer.subscribe(Collections.singleton("test"));
        Assertions.assertThrows(AuthenticationException.class, () -> consumer.poll(Duration.ZERO));
    }

    @ParameterizedTest
    @EnumSource(value=GroupProtocol.class, names={"CLASSIC"})
    public void testOffsetsForTimesAuthenticationFailure(GroupProtocol groupProtocol) {
        KafkaConsumer<String, String> consumer = this.consumerWithPendingAuthenticationError(groupProtocol);
        Assertions.assertThrows(AuthenticationException.class, () -> consumer.offsetsForTimes(Collections.singletonMap(this.tp0, 0L)));
    }

    @ParameterizedTest
    @EnumSource(value=GroupProtocol.class, names={"CLASSIC"})
    public void testCommitSyncAuthenticationFailure(GroupProtocol groupProtocol) {
        KafkaConsumer<String, String> consumer = this.consumerWithPendingAuthenticationError(groupProtocol);
        HashMap<TopicPartition, OffsetAndMetadata> offsets = new HashMap<TopicPartition, OffsetAndMetadata>();
        offsets.put(this.tp0, new OffsetAndMetadata(10L));
        Assertions.assertThrows(AuthenticationException.class, () -> consumer.commitSync(offsets));
    }

    @ParameterizedTest
    @EnumSource(value=GroupProtocol.class, names={"CLASSIC"})
    public void testCommittedAuthenticationFailure(GroupProtocol groupProtocol) {
        KafkaConsumer<String, String> consumer = this.consumerWithPendingAuthenticationError(groupProtocol);
        Assertions.assertThrows(AuthenticationException.class, () -> {
            OffsetAndMetadata cfr_ignored_0 = (OffsetAndMetadata)consumer.committed(Collections.singleton(this.tp0)).get(this.tp0);
        });
    }

    @ParameterizedTest
    @EnumSource(value=GroupProtocol.class, names={"CLASSIC"})
    public void testMeasureCommitSyncDurationOnFailure(GroupProtocol groupProtocol) {
        KafkaConsumer<String, String> consumer = this.consumerWithPendingError(groupProtocol, new MockTime(Duration.ofSeconds(1L).toMillis()));
        try {
            consumer.commitSync(Collections.singletonMap(this.tp0, new OffsetAndMetadata(10L)));
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        Metric metric = (Metric)consumer.metrics().get(consumer.metricsRegistry().metricName("commit-sync-time-ns-total", "consumer-metrics"));
        Assertions.assertTrue(((Double)metric.metricValue() >= (double)Duration.ofMillis(999L).toNanos() ? 1 : 0) != 0);
    }

    @ParameterizedTest
    @EnumSource(value=GroupProtocol.class, names={"CLASSIC"})
    public void testMeasureCommitSyncDuration(GroupProtocol groupProtocol) {
        MockTime time = new MockTime(Duration.ofSeconds(1L).toMillis());
        SubscriptionState subscription = new SubscriptionState(new LogContext(), OffsetResetStrategy.EARLIEST);
        ConsumerMetadata metadata = this.createMetadata(subscription);
        MockClient client = new MockClient((Time)time, (Metadata)metadata);
        this.initMetadata(client, Collections.singletonMap("test", 2));
        Node node = (Node)metadata.fetch().nodes().get(0);
        KafkaConsumer<String, String> consumer = this.newConsumer(groupProtocol, time, client, subscription, metadata, this.assignor, true, this.groupInstanceId);
        consumer.assign(Collections.singletonList(this.tp0));
        client.prepareResponseFrom((AbstractResponse)FindCoordinatorResponse.prepareResponse((Errors)Errors.NONE, (String)"mock-group", (Node)node), node);
        Node coordinator = new Node(Integer.MAX_VALUE - node.id(), node.host(), node.port());
        client.prepareResponseFrom((AbstractResponse)this.offsetCommitResponse(Collections.singletonMap(this.tp0, Errors.NONE)), coordinator);
        consumer.commitSync(Collections.singletonMap(this.tp0, new OffsetAndMetadata(10L)));
        Metric metric = (Metric)consumer.metrics().get(consumer.metricsRegistry().metricName("commit-sync-time-ns-total", "consumer-metrics"));
        Assertions.assertTrue(((Double)metric.metricValue() >= (double)Duration.ofMillis(999L).toNanos() ? 1 : 0) != 0);
    }

    @ParameterizedTest
    @EnumSource(value=GroupProtocol.class, names={"CLASSIC"})
    public void testMeasureCommittedDurationOnFailure(GroupProtocol groupProtocol) {
        KafkaConsumer<String, String> consumer = this.consumerWithPendingError(groupProtocol, new MockTime(Duration.ofSeconds(1L).toMillis()));
        try {
            consumer.committed(Collections.singleton(this.tp0));
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        Metric metric = (Metric)consumer.metrics().get(consumer.metricsRegistry().metricName("committed-time-ns-total", "consumer-metrics"));
        Assertions.assertTrue(((Double)metric.metricValue() >= (double)Duration.ofMillis(999L).toNanos() ? 1 : 0) != 0);
    }

    @ParameterizedTest
    @EnumSource(value=GroupProtocol.class, names={"CLASSIC"})
    public void testMeasureCommittedDuration(GroupProtocol groupProtocol) {
        long offset1 = 10000L;
        MockTime time = new MockTime(Duration.ofSeconds(1L).toMillis());
        SubscriptionState subscription = new SubscriptionState(new LogContext(), OffsetResetStrategy.EARLIEST);
        ConsumerMetadata metadata = this.createMetadata(subscription);
        MockClient client = new MockClient((Time)time, (Metadata)metadata);
        this.initMetadata(client, Collections.singletonMap("test", 2));
        Node node = (Node)metadata.fetch().nodes().get(0);
        KafkaConsumer<String, String> consumer = this.newConsumer(groupProtocol, time, client, subscription, metadata, this.assignor, true, this.groupInstanceId);
        consumer.assign(Collections.singletonList(this.tp0));
        client.prepareResponseFrom((AbstractResponse)FindCoordinatorResponse.prepareResponse((Errors)Errors.NONE, (String)"mock-group", (Node)node), node);
        Node coordinator = new Node(Integer.MAX_VALUE - node.id(), node.host(), node.port());
        client.prepareResponseFrom((AbstractResponse)this.offsetResponse(Collections.singletonMap(this.tp0, offset1), Errors.NONE), coordinator);
        ((OffsetAndMetadata)consumer.committed(Collections.singleton(this.tp0)).get(this.tp0)).offset();
        Metric metric = (Metric)consumer.metrics().get(consumer.metricsRegistry().metricName("committed-time-ns-total", "consumer-metrics"));
        Assertions.assertTrue(((Double)metric.metricValue() >= (double)Duration.ofMillis(999L).toNanos() ? 1 : 0) != 0);
    }

    @ParameterizedTest
    @EnumSource(value=GroupProtocol.class, names={"CLASSIC"})
    public void testRebalanceException(GroupProtocol groupProtocol) {
        ConsumerMetadata metadata = this.createMetadata(this.subscription);
        MockClient client = new MockClient(this.time, (Metadata)metadata);
        this.initMetadata(client, Collections.singletonMap("test", 1));
        Node node = (Node)metadata.fetch().nodes().get(0);
        KafkaConsumer<String, String> consumer = this.newConsumer(groupProtocol, this.time, client, this.subscription, metadata, this.assignor, true, this.groupInstanceId);
        consumer.subscribe(Collections.singleton("test"), this.getExceptionConsumerRebalanceListener());
        Node coordinator = new Node(Integer.MAX_VALUE - node.id(), node.host(), node.port());
        client.prepareResponseFrom((AbstractResponse)FindCoordinatorResponse.prepareResponse((Errors)Errors.NONE, (String)"mock-group", (Node)node), node);
        client.prepareResponseFrom((AbstractResponse)this.joinGroupFollowerResponse(this.assignor, 1, "memberId", "leaderId", Errors.NONE), coordinator);
        client.prepareResponseFrom((AbstractResponse)this.syncGroupResponse(Collections.singletonList(this.tp0), Errors.NONE), coordinator);
        try {
            consumer.updateAssignmentMetadataIfNeeded(this.time.timer(Long.MAX_VALUE));
            Assertions.fail((String)"Should throw exception");
        }
        catch (Throwable e) {
            Assertions.assertEquals((Object)("Hit partition assign " + this.singleTopicPartition), (Object)e.getCause().getMessage());
        }
        Assertions.assertEquals(Collections.singleton(this.tp0), (Object)this.subscription.assignedPartitions());
        try {
            consumer.close(Duration.ofMillis(0L));
            Assertions.fail((String)"Should throw exception");
        }
        catch (Throwable e) {
            Assertions.assertEquals((Object)("Hit partition revoke " + this.singleTopicPartition), (Object)e.getCause().getCause().getMessage());
        }
        consumer.close(Duration.ofMillis(0L));
        Assertions.assertTrue((boolean)this.subscription.assignedPartitions().isEmpty());
    }

    @ParameterizedTest
    @EnumSource(value=GroupProtocol.class, names={"CLASSIC"})
    public void testReturnRecordsDuringRebalance(GroupProtocol groupProtocol) throws InterruptedException {
        MockTime time = new MockTime(1L);
        ConsumerMetadata metadata = this.createMetadata(this.subscription);
        MockClient client = new MockClient((Time)time, (Metadata)metadata);
        CooperativeStickyAssignor assignor = new CooperativeStickyAssignor();
        KafkaConsumer<String, String> consumer = this.newConsumer(groupProtocol, time, client, this.subscription, metadata, (ConsumerPartitionAssignor)assignor, true, this.groupInstanceId);
        this.initMetadata(client, Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)"test", (Object)1), Utils.mkEntry((Object)"test2", (Object)1), Utils.mkEntry((Object)"test3", (Object)1)}));
        consumer.subscribe(Arrays.asList("test", "test2"), this.getConsumerRebalanceListener(consumer));
        Node node = (Node)metadata.fetch().nodes().get(0);
        Node coordinator = this.prepareRebalance(client, node, (ConsumerPartitionAssignor)assignor, Arrays.asList(this.tp0, this.t2p0), null);
        TestUtils.waitForCondition(() -> {
            consumer.poll(Duration.ofMillis(100L));
            return consumer.assignment().equals(Utils.mkSet((Object[])new TopicPartition[]{this.tp0, this.t2p0}));
        }, "Does not complete rebalance in time");
        Assertions.assertEquals((Object)Utils.mkSet((Object[])new String[]{"test", "test2"}), (Object)consumer.subscription());
        Assertions.assertEquals((Object)Utils.mkSet((Object[])new TopicPartition[]{this.tp0, this.t2p0}), (Object)consumer.assignment());
        HashMap<TopicPartition, FetchInfo> fetches1 = new HashMap<TopicPartition, FetchInfo>();
        fetches1.put(this.tp0, new FetchInfo(0L, 1));
        fetches1.put(this.t2p0, new FetchInfo(0L, 10));
        client.respondFrom((AbstractResponse)this.fetchResponse(fetches1), node);
        ConsumerRecords records = consumer.poll(Duration.ZERO);
        Assertions.assertEquals((int)11, (int)records.count());
        Assertions.assertEquals((long)1L, (long)consumer.position(this.tp0));
        Assertions.assertEquals((long)10L, (long)consumer.position(this.t2p0));
        fetches1.clear();
        fetches1.put(this.tp0, new FetchInfo(1L, 1));
        fetches1.put(this.t2p0, new FetchInfo(10L, 20));
        client.respondFrom((AbstractResponse)this.fetchResponse(fetches1), node);
        consumer.subscribe(Arrays.asList("test", "test3"), this.getConsumerRebalanceListener(consumer));
        Assertions.assertEquals((Object)Utils.mkSet((Object[])new String[]{"test", "test3"}), (Object)consumer.subscription());
        Assertions.assertEquals((Object)Utils.mkSet((Object[])new TopicPartition[]{this.tp0, this.t2p0}), (Object)consumer.assignment());
        HashMap<TopicPartition, Long> partitionOffsets1 = new HashMap<TopicPartition, Long>();
        partitionOffsets1.put(this.t2p0, 10L);
        AtomicBoolean commitReceived = this.prepareOffsetCommitResponse(client, coordinator, partitionOffsets1);
        records = consumer.poll(Duration.ZERO);
        fetches1.clear();
        fetches1.put(this.tp0, new FetchInfo(2L, 1));
        client.respondFrom((AbstractResponse)this.fetchResponse(fetches1), node);
        Assertions.assertEquals((Object)Utils.mkSet((Object[])new String[]{"test", "test3"}), (Object)consumer.subscription());
        Assertions.assertEquals(Collections.singleton(this.tp0), (Object)consumer.assignment());
        Assertions.assertEquals((int)1, (int)records.count());
        Assertions.assertEquals((long)2L, (long)consumer.position(this.tp0));
        Assertions.assertTrue((boolean)commitReceived.get());
        client.respondFrom((AbstractResponse)this.joinGroupFollowerResponse((ConsumerPartitionAssignor)assignor, 2, "memberId", "leaderId", Errors.NONE), coordinator);
        records = consumer.poll(Duration.ZERO);
        Assertions.assertEquals((Object)Utils.mkSet((Object[])new String[]{"test", "test3"}), (Object)consumer.subscription());
        Assertions.assertEquals(Collections.singleton(this.tp0), (Object)consumer.assignment());
        Assertions.assertEquals((int)1, (int)records.count());
        Assertions.assertEquals((long)3L, (long)consumer.position(this.tp0));
        fetches1.clear();
        fetches1.put(this.tp0, new FetchInfo(3L, 1));
        client.respondFrom((AbstractResponse)this.fetchResponse(fetches1), node);
        client.respondFrom((AbstractResponse)this.syncGroupResponse(Arrays.asList(this.tp0, this.t3p0), Errors.NONE), coordinator);
        AtomicInteger count = new AtomicInteger(0);
        TestUtils.waitForCondition(() -> {
            ConsumerRecords recs = consumer.poll(Duration.ofMillis(100L));
            return consumer.assignment().equals(Utils.mkSet((Object[])new TopicPartition[]{this.tp0, this.t3p0})) && count.addAndGet(recs.count()) == 1;
        }, "Does not complete rebalance in time");
        Assertions.assertEquals((Object)Utils.mkSet((Object[])new String[]{"test", "test3"}), (Object)consumer.subscription());
        Assertions.assertEquals((Object)Utils.mkSet((Object[])new TopicPartition[]{this.tp0, this.t3p0}), (Object)consumer.assignment());
        Assertions.assertEquals((long)4L, (long)consumer.position(this.tp0));
        Assertions.assertEquals((long)0L, (long)consumer.position(this.t3p0));
        fetches1.clear();
        fetches1.put(this.tp0, new FetchInfo(4L, 1));
        fetches1.put(this.t3p0, new FetchInfo(0L, 100));
        client.respondFrom((AbstractResponse)this.fetchResponse(fetches1), node);
        count.set(0);
        TestUtils.waitForCondition(() -> {
            ConsumerRecords recs = consumer.poll(Duration.ofMillis(100L));
            return count.addAndGet(recs.count()) == 101;
        }, "Does not complete rebalance in time");
        Assertions.assertEquals((long)5L, (long)consumer.position(this.tp0));
        Assertions.assertEquals((long)100L, (long)consumer.position(this.t3p0));
        client.requests().clear();
        consumer.unsubscribe();
        consumer.close(Duration.ZERO);
    }

    @ParameterizedTest
    @EnumSource(value=GroupProtocol.class, names={"CLASSIC"})
    public void testGetGroupMetadata(GroupProtocol groupProtocol) {
        ConsumerMetadata metadata = this.createMetadata(this.subscription);
        MockClient client = new MockClient(this.time, (Metadata)metadata);
        this.initMetadata(client, Collections.singletonMap("test", 1));
        Node node = (Node)metadata.fetch().nodes().get(0);
        KafkaConsumer<String, String> consumer = this.newConsumer(groupProtocol, this.time, client, this.subscription, metadata, this.assignor, true, this.groupInstanceId);
        ConsumerGroupMetadata groupMetadataOnStart = consumer.groupMetadata();
        Assertions.assertEquals((Object)"mock-group", (Object)groupMetadataOnStart.groupId());
        Assertions.assertEquals((Object)"", (Object)groupMetadataOnStart.memberId());
        Assertions.assertEquals((int)-1, (int)groupMetadataOnStart.generationId());
        Assertions.assertEquals(this.groupInstanceId, (Object)groupMetadataOnStart.groupInstanceId());
        consumer.subscribe(Collections.singleton("test"), this.getConsumerRebalanceListener(consumer));
        this.prepareRebalance(client, node, this.assignor, Collections.singletonList(this.tp0), null);
        client.prepareResponseFrom((AbstractResponse)this.fetchResponse(this.tp0, 0L, 0), node);
        consumer.updateAssignmentMetadataIfNeeded(this.time.timer(Long.MAX_VALUE));
        ConsumerGroupMetadata groupMetadataAfterPoll = consumer.groupMetadata();
        Assertions.assertEquals((Object)"mock-group", (Object)groupMetadataAfterPoll.groupId());
        Assertions.assertEquals((Object)"memberId", (Object)groupMetadataAfterPoll.memberId());
        Assertions.assertEquals((int)1, (int)groupMetadataAfterPoll.generationId());
        Assertions.assertEquals(this.groupInstanceId, (Object)groupMetadataAfterPoll.groupInstanceId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ParameterizedTest
    @EnumSource(value=GroupProtocol.class, names={"CLASSIC"})
    public void testInvalidGroupMetadata(GroupProtocol groupProtocol) throws InterruptedException {
        ConsumerMetadata metadata = this.createMetadata(this.subscription);
        MockClient client = new MockClient(this.time, (Metadata)metadata);
        this.initMetadata(client, Collections.singletonMap("test", 1));
        KafkaConsumer<String, String> consumer = this.newConsumer(groupProtocol, this.time, client, this.subscription, metadata, (ConsumerPartitionAssignor)new RoundRobinAssignor(), true, this.groupInstanceId);
        consumer.subscribe(Collections.singletonList("test"));
        client.enableBlockingUntilWakeup(1);
        ExecutorService service = Executors.newSingleThreadExecutor();
        service.execute(() -> consumer.poll(Duration.ofSeconds(5L)));
        try {
            TimeUnit.SECONDS.sleep(1L);
            Assertions.assertThrows(ConcurrentModificationException.class, () -> consumer.groupMetadata());
            client.wakeup();
            consumer.wakeup();
        }
        finally {
            service.shutdown();
            Assertions.assertTrue((boolean)service.awaitTermination(10L, TimeUnit.SECONDS));
        }
        consumer.close(Duration.ZERO);
        Assertions.assertThrows(IllegalStateException.class, () -> consumer.groupMetadata());
    }

    @ParameterizedTest
    @EnumSource(value=GroupProtocol.class, names={"CLASSIC"})
    public void testCurrentLag(GroupProtocol groupProtocol) {
        ConsumerMetadata metadata = this.createMetadata(this.subscription);
        MockClient client = new MockClient(this.time, (Metadata)metadata);
        this.initMetadata(client, Collections.singletonMap("test", 1));
        this.consumer = this.newConsumer(groupProtocol, this.time, client, this.subscription, metadata, this.assignor, true, this.groupInstanceId);
        Assertions.assertThrows(IllegalStateException.class, () -> this.consumer.currentLag(this.tp0));
        this.consumer.assign(Collections.singleton(this.tp0));
        this.consumer.poll(Duration.ofMillis(0L));
        client.respond((AbstractResponse)FindCoordinatorResponse.prepareResponse((Errors)Errors.NONE, (String)"mock-group", (Node)((Node)metadata.fetch().nodes().get(0))));
        Assertions.assertEquals((Object)OptionalLong.empty(), (Object)this.consumer.currentLag(this.tp0));
        Assertions.assertEquals((int)0, (int)client.inFlightRequestCount());
        this.consumer.seek(this.tp0, 50L);
        this.consumer.poll(Duration.ofMillis(0L));
        Assertions.assertEquals((int)2, (int)client.inFlightRequestCount());
        Assertions.assertEquals((Object)OptionalLong.empty(), (Object)this.consumer.currentLag(this.tp0));
        client.respond((AbstractResponse)this.listOffsetsResponse(Collections.singletonMap(this.tp0, 90L)));
        this.consumer.poll(Duration.ofMillis(0L));
        Assertions.assertEquals((Object)OptionalLong.of(40L), (Object)this.consumer.currentLag(this.tp0));
        Assertions.assertEquals((int)1, (int)client.inFlightRequestCount());
        FetchInfo fetchInfo = new FetchInfo(1L, 99L, 50L, 5);
        client.respond((AbstractResponse)this.fetchResponse(Collections.singletonMap(this.tp0, fetchInfo)));
        ConsumerRecords records = this.consumer.poll(Duration.ofMillis(1L));
        Assertions.assertEquals((int)5, (int)records.count());
        Assertions.assertEquals((long)55L, (long)this.consumer.position(this.tp0));
        Assertions.assertEquals((Object)OptionalLong.of(45L), (Object)this.consumer.currentLag(this.tp0));
    }

    @ParameterizedTest
    @EnumSource(value=GroupProtocol.class, names={"CLASSIC"})
    public void testListOffsetShouldUpdateSubscriptions(GroupProtocol groupProtocol) {
        ConsumerMetadata metadata = this.createMetadata(this.subscription);
        MockClient client = new MockClient(this.time, (Metadata)metadata);
        this.initMetadata(client, Collections.singletonMap("test", 1));
        this.consumer = this.newConsumer(groupProtocol, this.time, client, this.subscription, metadata, this.assignor, true, this.groupInstanceId);
        this.consumer.assign(Collections.singleton(this.tp0));
        this.consumer.poll(Duration.ofMillis(0L));
        client.respond((AbstractResponse)FindCoordinatorResponse.prepareResponse((Errors)Errors.NONE, (String)"mock-group", (Node)((Node)metadata.fetch().nodes().get(0))));
        this.consumer.seek(this.tp0, 50L);
        client.prepareResponse((AbstractResponse)this.listOffsetsResponse(Collections.singletonMap(this.tp0, 90L)));
        Assertions.assertEquals(Collections.singletonMap(this.tp0, 90L), (Object)this.consumer.endOffsets(Collections.singleton(this.tp0)));
        Assertions.assertEquals((Object)OptionalLong.of(40L), (Object)this.consumer.currentLag(this.tp0));
    }

    private KafkaConsumer<String, String> consumerWithPendingAuthenticationError(GroupProtocol groupProtocol, Time time) {
        ConsumerMetadata metadata = this.createMetadata(this.subscription);
        MockClient client = new MockClient(time, (Metadata)metadata);
        this.initMetadata(client, Collections.singletonMap("test", 1));
        Node node = (Node)metadata.fetch().nodes().get(0);
        RangeAssignor assignor = new RangeAssignor();
        client.createPendingAuthenticationError(node, 0L);
        return this.newConsumer(groupProtocol, time, client, this.subscription, metadata, (ConsumerPartitionAssignor)assignor, false, this.groupInstanceId);
    }

    private KafkaConsumer<String, String> consumerWithPendingAuthenticationError(GroupProtocol groupProtocol) {
        return this.consumerWithPendingAuthenticationError(groupProtocol, new MockTime());
    }

    private KafkaConsumer<String, String> consumerWithPendingError(GroupProtocol groupProtocol, Time time) {
        return this.consumerWithPendingAuthenticationError(groupProtocol, time);
    }

    private ConsumerRebalanceListener getConsumerRebalanceListener(final KafkaConsumer<?, ?> consumer) {
        return new ConsumerRebalanceListener(){

            public void onPartitionsRevoked(Collection<TopicPartition> partitions) {
            }

            public void onPartitionsAssigned(Collection<TopicPartition> partitions) {
                for (TopicPartition partition : partitions) {
                    consumer.seek(partition, 0L);
                }
            }
        };
    }

    private ConsumerRebalanceListener getExceptionConsumerRebalanceListener() {
        return new ConsumerRebalanceListener(){

            public void onPartitionsRevoked(Collection<TopicPartition> partitions) {
                throw new RuntimeException("Hit partition revoke " + partitions);
            }

            public void onPartitionsAssigned(Collection<TopicPartition> partitions) {
                throw new RuntimeException("Hit partition assign " + partitions);
            }

            public void onPartitionsLost(Collection<TopicPartition> partitions) {
                throw new RuntimeException("Hit partition lost " + partitions);
            }
        };
    }

    private ConsumerMetadata createMetadata(SubscriptionState subscription) {
        return new ConsumerMetadata(0L, 0L, Long.MAX_VALUE, false, false, subscription, new LogContext(), new ClusterResourceListeners());
    }

    private Node prepareRebalance(MockClient client, Node node, Set<String> subscribedTopics, ConsumerPartitionAssignor assignor, List<TopicPartition> partitions, Node coordinator) {
        if (coordinator == null) {
            client.prepareResponseFrom((AbstractResponse)FindCoordinatorResponse.prepareResponse((Errors)Errors.NONE, (String)"mock-group", (Node)node), node);
            coordinator = new Node(Integer.MAX_VALUE - node.id(), node.host(), node.port());
        }
        client.prepareResponseFrom(body -> {
            JoinGroupRequest joinGroupRequest = (JoinGroupRequest)body;
            Iterator protocolIterator = joinGroupRequest.data().protocols().iterator();
            Assertions.assertTrue((boolean)protocolIterator.hasNext());
            ByteBuffer protocolMetadata = ByteBuffer.wrap(((JoinGroupRequestData.JoinGroupRequestProtocol)protocolIterator.next()).metadata());
            ConsumerPartitionAssignor.Subscription subscription = ConsumerProtocol.deserializeSubscription((ByteBuffer)protocolMetadata);
            return subscribedTopics.equals(new HashSet(subscription.topics()));
        }, (AbstractResponse)this.joinGroupFollowerResponse(assignor, 1, "memberId", "leaderId", Errors.NONE), coordinator);
        client.prepareResponseFrom((AbstractResponse)this.syncGroupResponse(partitions, Errors.NONE), coordinator);
        return coordinator;
    }

    private Node prepareRebalance(MockClient client, Node node, ConsumerPartitionAssignor assignor, List<TopicPartition> partitions, Node coordinator) {
        if (coordinator == null) {
            client.prepareResponseFrom((AbstractResponse)FindCoordinatorResponse.prepareResponse((Errors)Errors.NONE, (String)"mock-group", (Node)node), node);
            coordinator = new Node(Integer.MAX_VALUE - node.id(), node.host(), node.port());
        }
        client.prepareResponseFrom((AbstractResponse)this.joinGroupFollowerResponse(assignor, 1, "memberId", "leaderId", Errors.NONE), coordinator);
        client.prepareResponseFrom((AbstractResponse)this.syncGroupResponse(partitions, Errors.NONE), coordinator);
        return coordinator;
    }

    private AtomicBoolean prepareHeartbeatResponse(MockClient client, Node coordinator, Errors error) {
        AtomicBoolean heartbeatReceived = new AtomicBoolean(false);
        client.prepareResponseFrom(body -> {
            heartbeatReceived.set(true);
            return true;
        }, (AbstractResponse)new HeartbeatResponse(new HeartbeatResponseData().setErrorCode(error.code())), coordinator);
        return heartbeatReceived;
    }

    private AtomicBoolean prepareOffsetCommitResponse(MockClient client, Node coordinator, Map<TopicPartition, Long> partitionOffsets) {
        AtomicBoolean commitReceived = new AtomicBoolean(true);
        HashMap<TopicPartition, Errors> response = new HashMap<TopicPartition, Errors>();
        for (TopicPartition partition : partitionOffsets.keySet()) {
            response.put(partition, Errors.NONE);
        }
        client.prepareResponseFrom(body -> {
            OffsetCommitRequest commitRequest = (OffsetCommitRequest)body;
            Map commitErrors = commitRequest.offsets();
            for (Map.Entry partitionOffset : partitionOffsets.entrySet()) {
                if (((Long)commitErrors.get(partitionOffset.getKey())).equals(partitionOffset.getValue())) continue;
                commitReceived.set(false);
                return false;
            }
            return true;
        }, (AbstractResponse)this.offsetCommitResponse(response), coordinator);
        return commitReceived;
    }

    private AtomicBoolean prepareOffsetCommitResponse(MockClient client, Node coordinator, TopicPartition partition, long offset) {
        return this.prepareOffsetCommitResponse(client, coordinator, Collections.singletonMap(partition, offset));
    }

    private OffsetCommitResponse offsetCommitResponse(Map<TopicPartition, Errors> responseData) {
        return new OffsetCommitResponse(responseData);
    }

    private JoinGroupResponse joinGroupFollowerResponse(ConsumerPartitionAssignor assignor, int generationId, String memberId, String leaderId, Errors error) {
        return new JoinGroupResponse(new JoinGroupResponseData().setErrorCode(error.code()).setGenerationId(generationId).setProtocolName(assignor.name()).setLeader(leaderId).setMemberId(memberId).setMembers(Collections.emptyList()), ApiKeys.JOIN_GROUP.latestVersion());
    }

    private SyncGroupResponse syncGroupResponse(List<TopicPartition> partitions, Errors error) {
        ByteBuffer buf = ConsumerProtocol.serializeAssignment((ConsumerPartitionAssignor.Assignment)new ConsumerPartitionAssignor.Assignment(partitions));
        return new SyncGroupResponse(new SyncGroupResponseData().setErrorCode(error.code()).setAssignment(Utils.toArray((ByteBuffer)buf)));
    }

    private OffsetFetchResponse offsetResponse(Map<TopicPartition, Long> offsets, Errors error) {
        HashMap<TopicPartition, OffsetFetchResponse.PartitionData> partitionData = new HashMap<TopicPartition, OffsetFetchResponse.PartitionData>();
        for (Map.Entry<TopicPartition, Long> entry : offsets.entrySet()) {
            partitionData.put(entry.getKey(), new OffsetFetchResponse.PartitionData(entry.getValue().longValue(), Optional.empty(), "", error));
        }
        int throttleMs = 10;
        return new OffsetFetchResponse(throttleMs, Collections.singletonMap("mock-group", Errors.NONE), Collections.singletonMap("mock-group", partitionData));
    }

    private ListOffsetsResponse listOffsetsResponse(Map<TopicPartition, Long> offsets) {
        return this.listOffsetsResponse(offsets, Collections.emptyMap());
    }

    private ListOffsetsResponse listOffsetsResponse(Map<TopicPartition, Long> partitionOffsets, Map<TopicPartition, Errors> partitionErrors) {
        ListOffsetsResponseData.ListOffsetsTopicResponse topic;
        TopicPartition tp;
        HashMap<String, ListOffsetsResponseData.ListOffsetsTopicResponse> responses = new HashMap<String, ListOffsetsResponseData.ListOffsetsTopicResponse>();
        for (Map.Entry<TopicPartition, Long> entry : partitionOffsets.entrySet()) {
            tp = entry.getKey();
            topic = responses.computeIfAbsent(tp.topic(), k -> new ListOffsetsResponseData.ListOffsetsTopicResponse().setName(tp.topic()));
            topic.partitions().add(new ListOffsetsResponseData.ListOffsetsPartitionResponse().setPartitionIndex(tp.partition()).setErrorCode(Errors.NONE.code()).setTimestamp(-1L).setOffset(entry.getValue().longValue()));
        }
        for (Map.Entry<TopicPartition, Long> entry : partitionErrors.entrySet()) {
            tp = entry.getKey();
            topic = responses.computeIfAbsent(tp.topic(), k -> new ListOffsetsResponseData.ListOffsetsTopicResponse().setName(tp.topic()));
            topic.partitions().add(new ListOffsetsResponseData.ListOffsetsPartitionResponse().setPartitionIndex(tp.partition()).setErrorCode(((Errors)entry.getValue()).code()).setTimestamp(-1L).setOffset(-1L));
        }
        ListOffsetsResponseData data = new ListOffsetsResponseData().setTopics(new ArrayList(responses.values()));
        return new ListOffsetsResponse(data);
    }

    private FetchResponse fetchResponse(Map<TopicPartition, FetchInfo> fetches) {
        LinkedHashMap<TopicIdPartition, FetchResponseData.PartitionData> tpResponses = new LinkedHashMap<TopicIdPartition, FetchResponseData.PartitionData>();
        for (Map.Entry<TopicPartition, FetchInfo> fetchEntry : fetches.entrySet()) {
            MemoryRecords records;
            TopicPartition partition = fetchEntry.getKey();
            long fetchOffset = fetchEntry.getValue().offset;
            int fetchCount = fetchEntry.getValue().count;
            long highWatermark = fetchEntry.getValue().logLastOffset + 1L;
            long logStartOffset = fetchEntry.getValue().logFirstOffset;
            if (fetchCount == 0) {
                records = MemoryRecords.EMPTY;
            } else {
                try (MemoryRecordsBuilder builder = MemoryRecords.builder((ByteBuffer)ByteBuffer.allocate(1024), (CompressionType)CompressionType.NONE, (TimestampType)TimestampType.CREATE_TIME, (long)fetchOffset);){
                    for (int i = 0; i < fetchCount; ++i) {
                        builder.append(0L, ("key-" + i).getBytes(), ("value-" + i).getBytes());
                    }
                    records = builder.build();
                }
            }
            tpResponses.put(new TopicIdPartition(this.topicIds.get(partition.topic()), partition), new FetchResponseData.PartitionData().setPartitionIndex(partition.partition()).setHighWatermark(highWatermark).setLogStartOffset(logStartOffset).setRecords((BaseRecords)records));
        }
        return FetchResponse.of((Errors)Errors.NONE, (int)0, (int)0, tpResponses);
    }

    private FetchResponse fetchResponse(TopicPartition partition, long fetchOffset, int count) {
        FetchInfo fetchInfo = new FetchInfo(fetchOffset, count);
        return this.fetchResponse(Collections.singletonMap(partition, fetchInfo));
    }

    private KafkaConsumer<String, String> newConsumer(GroupProtocol groupProtocol, Time time, KafkaClient client, SubscriptionState subscription, ConsumerMetadata metadata, ConsumerPartitionAssignor assignor, boolean autoCommitEnabled, Optional<String> groupInstanceId) {
        return this.newConsumer(groupProtocol, time, client, subscription, metadata, assignor, autoCommitEnabled, "mock-group", groupInstanceId, false);
    }

    private KafkaConsumer<String, String> newConsumerNoAutoCommit(GroupProtocol groupProtocol, Time time, KafkaClient client, SubscriptionState subscription, ConsumerMetadata metadata) {
        return this.newConsumer(groupProtocol, time, client, subscription, metadata, (ConsumerPartitionAssignor)new RangeAssignor(), false, "mock-group", this.groupInstanceId, false);
    }

    private KafkaConsumer<String, String> newConsumer(GroupProtocol groupProtocol, Time time, KafkaClient client, SubscriptionState subscription, ConsumerMetadata metadata, ConsumerPartitionAssignor assignor, boolean autoCommitEnabled, String groupId, Optional<String> groupInstanceId, boolean throwOnStableOffsetNotSupported) {
        return this.newConsumer(groupProtocol, time, client, subscription, metadata, assignor, autoCommitEnabled, groupId, groupInstanceId, Optional.of(new StringDeserializer()), throwOnStableOffsetNotSupported);
    }

    private KafkaConsumer<String, String> newConsumer(GroupProtocol groupProtocol, Time time, KafkaClient client, SubscriptionState subscriptions, ConsumerMetadata metadata, ConsumerPartitionAssignor assignor, boolean autoCommitEnabled, String groupId, Optional<String> groupInstanceId, Optional<Deserializer<String>> valueDeserializerOpt, boolean throwOnStableOffsetNotSupported) {
        StringDeserializer keyDeserializer = new StringDeserializer();
        Deserializer<String> valueDeserializer = valueDeserializerOpt.orElse((Deserializer<String>)new StringDeserializer());
        LogContext logContext = new LogContext();
        List<ConsumerPartitionAssignor> assignors = Collections.singletonList(assignor);
        ConsumerConfig config = this.newConsumerConfig(groupProtocol, autoCommitEnabled, groupId, groupInstanceId, valueDeserializer, throwOnStableOffsetNotSupported);
        return new KafkaConsumer(logContext, time, config, (Deserializer)keyDeserializer, valueDeserializer, client, subscriptions, metadata, assignors);
    }

    private ConsumerConfig newConsumerConfig(GroupProtocol groupProtocol, boolean autoCommitEnabled, String groupId, Optional<String> groupInstanceId, Deserializer<String> valueDeserializer, boolean throwOnStableOffsetNotSupported) {
        String clientId = "mock-consumer";
        long retryBackoffMs = 100L;
        long retryBackoffMaxMs = 1000L;
        int minBytes = 1;
        int maxBytes = Integer.MAX_VALUE;
        int maxWaitMs = 500;
        int fetchSize = 0x100000;
        int maxPollRecords = Integer.MAX_VALUE;
        boolean checkCrcs = true;
        int rebalanceTimeoutMs = 60000;
        int requestTimeoutMs = 30000;
        HashMap<String, Object> configs = new HashMap<String, Object>();
        configs.put("auto.commit.interval.ms", 500);
        configs.put("check.crcs", checkCrcs);
        configs.put("client.id", clientId);
        configs.put("client.rack", "");
        configs.put("default.api.timeout.ms", 60000);
        configs.put("enable.auto.commit", autoCommitEnabled);
        configs.put("fetch.max.bytes", maxBytes);
        configs.put("fetch.max.wait.ms", maxWaitMs);
        configs.put("fetch.min.bytes", minBytes);
        configs.put("group.id", groupId);
        configs.put("group.protocol", groupProtocol.name());
        configs.put("heartbeat.interval.ms", 1000);
        configs.put("isolation.level", IsolationLevel.READ_UNCOMMITTED.name().toLowerCase(Locale.ROOT));
        configs.put("key.deserializer", StringDeserializer.class);
        configs.put("max.partition.fetch.bytes", fetchSize);
        configs.put("max.poll.interval.ms", rebalanceTimeoutMs);
        configs.put("max.poll.records", maxPollRecords);
        configs.put("request.timeout.ms", requestTimeoutMs);
        configs.put("retry.backoff.max.ms", retryBackoffMaxMs);
        configs.put("retry.backoff.ms", retryBackoffMs);
        configs.put("session.timeout.ms", 10000);
        configs.put("internal.throw.on.fetch.stable.offset.unsupported", throwOnStableOffsetNotSupported);
        configs.put("value.deserializer", valueDeserializer.getClass());
        groupInstanceId.ifPresent(gi -> configs.put("group.instance.id", gi));
        return new ConsumerConfig(configs);
    }

    @ParameterizedTest
    @EnumSource(value=GroupProtocol.class, names={"CLASSIC"})
    public void testSubscriptionOnInvalidTopic(GroupProtocol groupProtocol) {
        ConsumerMetadata metadata = this.createMetadata(this.subscription);
        MockClient client = new MockClient(this.time, (Metadata)metadata);
        this.initMetadata(client, Collections.singletonMap("test", 1));
        Cluster cluster = metadata.fetch();
        String invalidTopicName = "topic abc";
        ArrayList<MetadataResponse.TopicMetadata> topicMetadata = new ArrayList<MetadataResponse.TopicMetadata>();
        topicMetadata.add(new MetadataResponse.TopicMetadata(Errors.INVALID_TOPIC_EXCEPTION, invalidTopicName, false, Collections.emptyList()));
        MetadataResponse updateResponse = RequestTestUtils.metadataResponse(cluster.nodes(), cluster.clusterResource().clusterId(), cluster.controller().id(), topicMetadata);
        client.prepareMetadataUpdate(updateResponse);
        KafkaConsumer<String, String> consumer = this.newConsumer(groupProtocol, this.time, client, this.subscription, metadata, this.assignor, true, this.groupInstanceId);
        consumer.subscribe(Collections.singleton(invalidTopicName), this.getConsumerRebalanceListener(consumer));
        Assertions.assertThrows(InvalidTopicException.class, () -> consumer.poll(Duration.ZERO));
    }

    @ParameterizedTest
    @EnumSource(value=GroupProtocol.class)
    public void testPollTimeMetrics(GroupProtocol groupProtocol) {
        ConsumerMetadata metadata = this.createMetadata(this.subscription);
        MockClient client = new MockClient(this.time, (Metadata)metadata);
        this.initMetadata(client, Collections.singletonMap("test", 1));
        KafkaConsumer<String, String> consumer = this.newConsumer(groupProtocol, this.time, client, this.subscription, metadata, this.assignor, true, this.groupInstanceId);
        consumer.subscribe(Collections.singletonList("test"));
        Metrics metrics = consumer.metricsRegistry();
        MetricName lastPollSecondsAgoName = metrics.metricName("last-poll-seconds-ago", "consumer-metrics");
        MetricName timeBetweenPollAvgName = metrics.metricName("time-between-poll-avg", "consumer-metrics");
        MetricName timeBetweenPollMaxName = metrics.metricName("time-between-poll-max", "consumer-metrics");
        Assertions.assertEquals((Object)-1.0, (Object)((Metric)consumer.metrics().get(lastPollSecondsAgoName)).metricValue());
        Assertions.assertEquals((Object)Double.NaN, (Object)((Metric)consumer.metrics().get(timeBetweenPollAvgName)).metricValue());
        Assertions.assertEquals((Object)Double.NaN, (Object)((Metric)consumer.metrics().get(timeBetweenPollMaxName)).metricValue());
        consumer.poll(Duration.ZERO);
        Assertions.assertEquals((Object)0.0, (Object)((Metric)consumer.metrics().get(lastPollSecondsAgoName)).metricValue());
        Assertions.assertEquals((Object)0.0, (Object)((Metric)consumer.metrics().get(timeBetweenPollAvgName)).metricValue());
        Assertions.assertEquals((Object)0.0, (Object)((Metric)consumer.metrics().get(timeBetweenPollMaxName)).metricValue());
        this.time.sleep(5000L);
        Assertions.assertEquals((Object)5.0, (Object)((Metric)consumer.metrics().get(lastPollSecondsAgoName)).metricValue());
        consumer.poll(Duration.ZERO);
        Assertions.assertEquals((Object)2500.0, (Object)((Metric)consumer.metrics().get(timeBetweenPollAvgName)).metricValue());
        Assertions.assertEquals((Object)5000.0, (Object)((Metric)consumer.metrics().get(timeBetweenPollMaxName)).metricValue());
        this.time.sleep(10000L);
        Assertions.assertEquals((Object)10.0, (Object)((Metric)consumer.metrics().get(lastPollSecondsAgoName)).metricValue());
        consumer.poll(Duration.ZERO);
        Assertions.assertEquals((Object)5000.0, (Object)((Metric)consumer.metrics().get(timeBetweenPollAvgName)).metricValue());
        Assertions.assertEquals((Object)10000.0, (Object)((Metric)consumer.metrics().get(timeBetweenPollMaxName)).metricValue());
        this.time.sleep(5000L);
        Assertions.assertEquals((Object)5.0, (Object)((Metric)consumer.metrics().get(lastPollSecondsAgoName)).metricValue());
        consumer.poll(Duration.ZERO);
        Assertions.assertEquals((Object)5000.0, (Object)((Metric)consumer.metrics().get(timeBetweenPollAvgName)).metricValue());
        Assertions.assertEquals((Object)10000.0, (Object)((Metric)consumer.metrics().get(timeBetweenPollMaxName)).metricValue());
    }

    @ParameterizedTest
    @EnumSource(value=GroupProtocol.class)
    public void testPollIdleRatio(GroupProtocol groupProtocol) {
        ConsumerMetadata metadata = this.createMetadata(this.subscription);
        MockClient client = new MockClient(this.time, (Metadata)metadata);
        this.initMetadata(client, Collections.singletonMap("test", 1));
        KafkaConsumer<String, String> consumer = this.newConsumer(groupProtocol, this.time, client, this.subscription, metadata, this.assignor, true, this.groupInstanceId);
        Metrics metrics = consumer.metricsRegistry();
        MetricName pollIdleRatio = metrics.metricName("poll-idle-ratio-avg", "consumer-metrics");
        Assertions.assertEquals((Object)Double.NaN, (Object)((Metric)consumer.metrics().get(pollIdleRatio)).metricValue());
        consumer.kafkaConsumerMetrics().recordPollStart(this.time.milliseconds());
        this.time.sleep(50L);
        consumer.kafkaConsumerMetrics().recordPollEnd(this.time.milliseconds());
        Assertions.assertEquals((Object)1.0, (Object)((Metric)consumer.metrics().get(pollIdleRatio)).metricValue());
        this.time.sleep(50L);
        consumer.kafkaConsumerMetrics().recordPollStart(this.time.milliseconds());
        consumer.kafkaConsumerMetrics().recordPollEnd(this.time.milliseconds());
        Assertions.assertEquals((Object)0.5, (Object)((Metric)consumer.metrics().get(pollIdleRatio)).metricValue());
        this.time.sleep(25L);
        consumer.kafkaConsumerMetrics().recordPollStart(this.time.milliseconds());
        this.time.sleep(25L);
        consumer.kafkaConsumerMetrics().recordPollEnd(this.time.milliseconds());
        Assertions.assertEquals((Object)0.5, (Object)((Metric)consumer.metrics().get(pollIdleRatio)).metricValue());
    }

    private static boolean consumerMetricPresent(KafkaConsumer<String, String> consumer, String name) {
        MetricName metricName = new MetricName(name, "consumer-metrics", "", Collections.emptyMap());
        return consumer.metricsRegistry().metrics().containsKey(metricName);
    }

    @ParameterizedTest
    @EnumSource(value=GroupProtocol.class)
    public void testClosingConsumerUnregistersConsumerMetrics(GroupProtocol groupProtocol) {
        MockTime time = new MockTime(1L);
        ConsumerMetadata metadata = this.createMetadata(this.subscription);
        MockClient client = new MockClient((Time)time, (Metadata)metadata);
        this.initMetadata(client, Collections.singletonMap("test", 1));
        KafkaConsumer<String, String> consumer = this.newConsumer(groupProtocol, time, client, this.subscription, metadata, (ConsumerPartitionAssignor)new RoundRobinAssignor(), true, this.groupInstanceId);
        consumer.subscribe(Collections.singletonList("test"));
        Assertions.assertTrue((boolean)KafkaConsumerTest.consumerMetricPresent(consumer, "last-poll-seconds-ago"));
        Assertions.assertTrue((boolean)KafkaConsumerTest.consumerMetricPresent(consumer, "time-between-poll-avg"));
        Assertions.assertTrue((boolean)KafkaConsumerTest.consumerMetricPresent(consumer, "time-between-poll-max"));
        consumer.close();
        Assertions.assertFalse((boolean)KafkaConsumerTest.consumerMetricPresent(consumer, "last-poll-seconds-ago"));
        Assertions.assertFalse((boolean)KafkaConsumerTest.consumerMetricPresent(consumer, "time-between-poll-avg"));
        Assertions.assertFalse((boolean)KafkaConsumerTest.consumerMetricPresent(consumer, "time-between-poll-max"));
    }

    @ParameterizedTest
    @EnumSource(value=GroupProtocol.class, names={"CLASSIC"})
    public void testEnforceRebalanceWithManualAssignment(GroupProtocol groupProtocol) {
        this.consumer = this.newConsumer(groupProtocol, null);
        this.consumer.assign(Collections.singleton(new TopicPartition("topic", 0)));
        Assertions.assertThrows(IllegalStateException.class, () -> this.consumer.enforceRebalance());
    }

    @ParameterizedTest
    @EnumSource(value=GroupProtocol.class, names={"CLASSIC"})
    public void testEnforceRebalanceTriggersRebalanceOnNextPoll(GroupProtocol groupProtocol) {
        MockTime time = new MockTime(1L);
        ConsumerMetadata metadata = this.createMetadata(this.subscription);
        MockClient client = new MockClient((Time)time, (Metadata)metadata);
        KafkaConsumer<String, String> consumer = this.newConsumer(groupProtocol, time, client, this.subscription, metadata, this.assignor, true, this.groupInstanceId);
        MockRebalanceListener countingRebalanceListener = new MockRebalanceListener();
        this.initMetadata(client, Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)"test", (Object)1), Utils.mkEntry((Object)"test2", (Object)1), Utils.mkEntry((Object)"test3", (Object)1)}));
        consumer.subscribe(Arrays.asList("test", "test2"), (ConsumerRebalanceListener)countingRebalanceListener);
        Node node = (Node)metadata.fetch().nodes().get(0);
        this.prepareRebalance(client, node, this.assignor, Arrays.asList(this.tp0, this.t2p0), null);
        consumer.poll(Duration.ZERO);
        consumer.poll(Duration.ZERO);
        Assertions.assertEquals((int)countingRebalanceListener.revokedCount, (int)0);
        Assertions.assertEquals((int)countingRebalanceListener.assignedCount, (int)1);
        consumer.enforceRebalance();
        consumer.poll(Duration.ZERO);
        Assertions.assertEquals((int)countingRebalanceListener.revokedCount, (int)1);
    }

    @ParameterizedTest
    @EnumSource(value=GroupProtocol.class, names={"CLASSIC"})
    public void testEnforceRebalanceReason(GroupProtocol groupProtocol) {
        MockTime time = new MockTime(1L);
        ConsumerMetadata metadata = this.createMetadata(this.subscription);
        MockClient client = new MockClient((Time)time, (Metadata)metadata);
        this.initMetadata(client, Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)"test", (Object)1)}));
        Node node = (Node)metadata.fetch().nodes().get(0);
        this.consumer = this.newConsumer(groupProtocol, time, client, this.subscription, metadata, this.assignor, true, this.groupInstanceId);
        this.consumer.subscribe(Collections.singletonList("test"));
        client.prepareResponseFrom((AbstractResponse)FindCoordinatorResponse.prepareResponse((Errors)Errors.NONE, (String)"mock-group", (Node)node), node);
        this.consumer.poll(Duration.ZERO);
        this.prepareJoinGroupAndVerifyReason(client, node, "");
        this.consumer.poll(Duration.ZERO);
        this.consumer.enforceRebalance(null);
        this.prepareJoinGroupAndVerifyReason(client, node, "rebalance enforced by user");
        this.consumer.poll(Duration.ZERO);
        this.consumer.enforceRebalance("");
        this.prepareJoinGroupAndVerifyReason(client, node, "rebalance enforced by user");
        this.consumer.poll(Duration.ZERO);
        String customReason = "user provided reason";
        this.consumer.enforceRebalance(customReason);
        this.prepareJoinGroupAndVerifyReason(client, node, customReason);
        this.consumer.poll(Duration.ZERO);
    }

    private void prepareJoinGroupAndVerifyReason(MockClient client, Node node, String expectedReason) {
        client.prepareResponseFrom(body -> {
            JoinGroupRequest joinGroupRequest = (JoinGroupRequest)body;
            return expectedReason.equals(joinGroupRequest.data().reason());
        }, (AbstractResponse)this.joinGroupFollowerResponse(this.assignor, 1, "memberId", "leaderId", Errors.NONE), node);
    }

    @ParameterizedTest
    @EnumSource(value=GroupProtocol.class, names={"CLASSIC"})
    public void configurableObjectsShouldSeeGeneratedClientId(GroupProtocol groupProtocol) {
        Properties props = new Properties();
        props.put("group.protocol", groupProtocol.name());
        props.put("bootstrap.servers", "localhost:9999");
        props.put("key.deserializer", DeserializerForClientId.class.getName());
        props.put("value.deserializer", DeserializerForClientId.class.getName());
        props.put("interceptor.classes", ConsumerInterceptorForClientId.class.getName());
        this.consumer = this.newConsumer(props);
        Assertions.assertNotNull((Object)this.consumer.clientId());
        Assertions.assertNotEquals((int)0, (int)this.consumer.clientId().length());
        Assertions.assertEquals((int)3, (int)CLIENT_IDS.size());
        CLIENT_IDS.forEach(id -> Assertions.assertEquals((Object)id, (Object)this.consumer.clientId()));
    }

    @ParameterizedTest
    @EnumSource(value=GroupProtocol.class)
    public void testUnusedConfigs(GroupProtocol groupProtocol) {
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("group.protocol", groupProtocol.name());
        props.put("bootstrap.servers", "localhost:9999");
        props.put("ssl.protocol", "TLS");
        ConsumerConfig config = new ConsumerConfig(ConsumerConfig.appendDeserializerToConfig(props, (Deserializer)new StringDeserializer(), (Deserializer)new StringDeserializer()));
        Assertions.assertTrue((boolean)config.unused().contains("ssl.protocol"));
        this.consumer = new KafkaConsumer(config, null, null);
        Assertions.assertTrue((boolean)config.unused().contains("ssl.protocol"));
    }

    @ParameterizedTest
    @EnumSource(value=GroupProtocol.class)
    public void testAssignorNameConflict(GroupProtocol groupProtocol) {
        HashMap<String, Object> configs = new HashMap<String, Object>();
        configs.put("group.protocol", groupProtocol.name());
        configs.put("bootstrap.servers", "localhost:9999");
        configs.put("partition.assignment.strategy", Arrays.asList(RangeAssignor.class.getName(), ConsumerPartitionAssignorTest.TestConsumerPartitionAssignor.class.getName()));
        Assertions.assertThrows(KafkaException.class, () -> this.newConsumer(configs, (Deserializer)new StringDeserializer(), (Deserializer)new StringDeserializer()));
    }

    @ParameterizedTest
    @EnumSource(value=GroupProtocol.class, names={"CLASSIC"})
    public void testOffsetsForTimesTimeout(GroupProtocol groupProtocol) {
        KafkaConsumer<String, String> consumer = this.consumerForCheckingTimeoutException(groupProtocol);
        Assertions.assertEquals((Object)"Failed to get offsets by times in 60000ms", (Object)((org.apache.kafka.common.errors.TimeoutException)Assertions.assertThrows(org.apache.kafka.common.errors.TimeoutException.class, () -> consumer.offsetsForTimes(Collections.singletonMap(this.tp0, 0L)))).getMessage());
    }

    @ParameterizedTest
    @EnumSource(value=GroupProtocol.class, names={"CLASSIC"})
    public void testBeginningOffsetsTimeout(GroupProtocol groupProtocol) {
        KafkaConsumer<String, String> consumer = this.consumerForCheckingTimeoutException(groupProtocol);
        Assertions.assertEquals((Object)"Failed to get offsets by times in 60000ms", (Object)((org.apache.kafka.common.errors.TimeoutException)Assertions.assertThrows(org.apache.kafka.common.errors.TimeoutException.class, () -> consumer.beginningOffsets(Collections.singletonList(this.tp0)))).getMessage());
    }

    @ParameterizedTest
    @EnumSource(value=GroupProtocol.class, names={"CLASSIC"})
    public void testEndOffsetsTimeout(GroupProtocol groupProtocol) {
        KafkaConsumer<String, String> consumer = this.consumerForCheckingTimeoutException(groupProtocol);
        Assertions.assertEquals((Object)"Failed to get offsets by times in 60000ms", (Object)((org.apache.kafka.common.errors.TimeoutException)Assertions.assertThrows(org.apache.kafka.common.errors.TimeoutException.class, () -> consumer.endOffsets(Collections.singletonList(this.tp0)))).getMessage());
    }

    @ParameterizedTest
    @EnumSource(value=GroupProtocol.class)
    public void testClientInstanceId() {
        Properties props = new Properties();
        props.setProperty("bootstrap.servers", "localhost:9999");
        ClientTelemetryReporter clientTelemetryReporter = (ClientTelemetryReporter)Mockito.mock(ClientTelemetryReporter.class);
        clientTelemetryReporter.configure((Map)ArgumentMatchers.any());
        MockedStatic mockedCommonClientConfigs = Mockito.mockStatic(CommonClientConfigs.class, (Answer)new CallsRealMethods());
        mockedCommonClientConfigs.when(() -> CommonClientConfigs.telemetryReporter((String)ArgumentMatchers.anyString(), (AbstractConfig)((AbstractConfig)ArgumentMatchers.any()))).thenReturn(Optional.of(clientTelemetryReporter));
        ClientTelemetrySender clientTelemetrySender = (ClientTelemetrySender)Mockito.mock(ClientTelemetrySender.class);
        Uuid expectedUuid = Uuid.randomUuid();
        Mockito.when((Object)clientTelemetryReporter.telemetrySender()).thenReturn((Object)clientTelemetrySender);
        Mockito.when((Object)clientTelemetrySender.clientInstanceId((Duration)ArgumentMatchers.any())).thenReturn(Optional.of(expectedUuid));
        this.consumer = this.newConsumer(props, (Deserializer)new StringDeserializer(), (Deserializer)new StringDeserializer());
        Uuid uuid = this.consumer.clientInstanceId(Duration.ofMillis(0L));
        Assertions.assertEquals((Object)expectedUuid, (Object)uuid);
        mockedCommonClientConfigs.close();
    }

    @ParameterizedTest
    @EnumSource(value=GroupProtocol.class)
    public void testClientInstanceIdInvalidTimeout() {
        Properties props = new Properties();
        props.setProperty("bootstrap.servers", "localhost:9999");
        this.consumer = this.newConsumer(props, (Deserializer)new StringDeserializer(), (Deserializer)new StringDeserializer());
        Exception exception = (Exception)Assertions.assertThrows(IllegalArgumentException.class, () -> this.consumer.clientInstanceId(Duration.ofMillis(-1L)));
        Assertions.assertEquals((Object)"The timeout cannot be negative.", (Object)exception.getMessage());
    }

    @ParameterizedTest
    @EnumSource(value=GroupProtocol.class)
    public void testClientInstanceIdNoTelemetryReporterRegistered() {
        Properties props = new Properties();
        props.setProperty("bootstrap.servers", "localhost:9999");
        props.setProperty("enable.metrics.push", "false");
        this.consumer = this.newConsumer(props, (Deserializer)new StringDeserializer(), (Deserializer)new StringDeserializer());
        Exception exception = (Exception)Assertions.assertThrows(IllegalStateException.class, () -> this.consumer.clientInstanceId(Duration.ofMillis(0L)));
        Assertions.assertEquals((Object)"Telemetry is not enabled. Set config `enable.metrics.push` to `true`.", (Object)exception.getMessage());
    }

    private KafkaConsumer<String, String> consumerForCheckingTimeoutException(GroupProtocol groupProtocol) {
        ConsumerMetadata metadata = this.createMetadata(this.subscription);
        MockClient client = new MockClient(this.time, (Metadata)metadata);
        this.initMetadata(client, Collections.singletonMap("test", 1));
        RangeAssignor assignor = new RangeAssignor();
        KafkaConsumer<String, String> consumer = this.newConsumer(groupProtocol, this.time, client, this.subscription, metadata, (ConsumerPartitionAssignor)assignor, false, this.groupInstanceId);
        for (int i = 0; i < 10; ++i) {
            client.prepareResponse(request -> {
                this.time.sleep(6000L);
                return request instanceof ListOffsetsRequest;
            }, (AbstractResponse)this.listOffsetsResponse(Collections.emptyMap(), Collections.singletonMap(this.tp0, Errors.UNKNOWN_TOPIC_OR_PARTITION)));
        }
        return consumer;
    }

    @ParameterizedTest
    @EnumSource(value=GroupProtocol.class)
    public void testCommittedThrowsTimeoutExceptionForNoResponse(GroupProtocol groupProtocol) {
        MockTime time = new MockTime(Duration.ofSeconds(1L).toMillis());
        ConsumerMetadata metadata = this.createMetadata(this.subscription);
        MockClient client = new MockClient((Time)time, (Metadata)metadata);
        this.initMetadata(client, Collections.singletonMap("test", 2));
        Node node = (Node)metadata.fetch().nodes().get(0);
        this.consumer = this.newConsumer(groupProtocol, time, client, this.subscription, metadata, this.assignor, true, this.groupInstanceId);
        this.consumer.assign(Collections.singletonList(this.tp0));
        client.prepareResponseFrom((AbstractResponse)FindCoordinatorResponse.prepareResponse((Errors)Errors.NONE, (String)"mock-group", (Node)node), node);
        Node coordinator = new Node(Integer.MAX_VALUE - node.id(), node.host(), node.port());
        client.prepareResponseFrom((AbstractResponse)this.offsetResponse(Collections.singletonMap(this.tp0, 0L), Errors.NONE), coordinator, true);
        org.apache.kafka.common.errors.TimeoutException timeoutException = (org.apache.kafka.common.errors.TimeoutException)Assertions.assertThrows(org.apache.kafka.common.errors.TimeoutException.class, () -> this.consumer.committed(Collections.singleton(this.tp0), Duration.ofMillis(1000L)));
        Assertions.assertEquals((Object)"Timeout of 1000ms expired before the last committed offset for partitions [test-0] could be determined. Try tuning default.api.timeout.ms larger to relax the threshold.", (Object)timeoutException.getMessage());
    }

    public static class ConsumerInterceptorForClientId
    implements ConsumerInterceptor<byte[], byte[]> {
        public ConsumerRecords<byte[], byte[]> onConsume(ConsumerRecords<byte[], byte[]> records) {
            return records;
        }

        public void onCommit(Map<TopicPartition, OffsetAndMetadata> offsets) {
        }

        public void close() {
        }

        public void configure(Map<String, ?> configs) {
            CLIENT_IDS.add(configs.get("client.id").toString());
        }
    }

    public static class DeserializerForClientId
    implements Deserializer<byte[]> {
        public void configure(Map<String, ?> configs, boolean isKey) {
            CLIENT_IDS.add(configs.get("client.id").toString());
        }

        public byte[] deserialize(String topic, byte[] data) {
            return data;
        }
    }

    private static class FetchInfo {
        long logFirstOffset;
        long logLastOffset;
        long offset;
        int count;

        FetchInfo(long offset, int count) {
            this(0L, offset + (long)count, offset, count);
        }

        FetchInfo(long logFirstOffset, long logLastOffset, long offset, int count) {
            this.logFirstOffset = logFirstOffset;
            this.logLastOffset = logLastOffset;
            this.offset = offset;
            this.count = count;
        }
    }
}

