/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.consumer.internals;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import org.apache.kafka.clients.consumer.internals.FetchBuffer;
import org.apache.kafka.clients.consumer.internals.WakeupTrigger;
import org.apache.kafka.common.errors.WakeupException;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoSettings;
import org.mockito.quality.Strictness;

@MockitoSettings(strictness=Strictness.STRICT_STUBS)
public class WakeupTriggerTest {
    private static final long DEFAULT_TIMEOUT_MS = 1000L;
    private WakeupTrigger wakeupTrigger;

    @BeforeEach
    public void setup() {
        this.wakeupTrigger = new WakeupTrigger();
    }

    @Test
    public void testEnsureActiveFutureCanBeWakeUp() {
        CompletableFuture task = new CompletableFuture();
        this.wakeupTrigger.setActiveTask(task);
        this.wakeupTrigger.wakeup();
        this.assertWakeupExceptionIsThrown(task);
        Assertions.assertNull((Object)this.wakeupTrigger.getPendingTask());
    }

    @Test
    public void testSettingActiveFutureAfterWakeupShouldThrow() {
        this.wakeupTrigger.wakeup();
        CompletableFuture task = new CompletableFuture();
        this.wakeupTrigger.setActiveTask(task);
        this.assertWakeupExceptionIsThrown(task);
        Assertions.assertNull((Object)this.wakeupTrigger.getPendingTask());
    }

    @Test
    public void testUnsetActiveFuture() {
        CompletableFuture task = new CompletableFuture();
        this.wakeupTrigger.setActiveTask(task);
        this.wakeupTrigger.clearTask();
        Assertions.assertNull((Object)this.wakeupTrigger.getPendingTask());
    }

    @Test
    public void testSettingFetchAction() {
        try (FetchBuffer fetchBuffer = (FetchBuffer)Mockito.mock(FetchBuffer.class);){
            this.wakeupTrigger.setFetchAction(fetchBuffer);
            WakeupTrigger.Wakeupable wakeupable = this.wakeupTrigger.getPendingTask();
            Assertions.assertInstanceOf(WakeupTrigger.FetchAction.class, (Object)wakeupable);
            Assertions.assertEquals((Object)fetchBuffer, (Object)((WakeupTrigger.FetchAction)wakeupable).fetchBuffer());
        }
    }

    @Test
    public void testUnsetFetchAction() {
        try (FetchBuffer fetchBuffer = (FetchBuffer)Mockito.mock(FetchBuffer.class);){
            this.wakeupTrigger.setFetchAction(fetchBuffer);
            this.wakeupTrigger.clearTask();
            Assertions.assertNull((Object)this.wakeupTrigger.getPendingTask());
        }
    }

    @Test
    public void testWakeupFromFetchAction() {
        try (FetchBuffer fetchBuffer = (FetchBuffer)Mockito.mock(FetchBuffer.class);){
            this.wakeupTrigger.setFetchAction(fetchBuffer);
            this.wakeupTrigger.wakeup();
            ((FetchBuffer)Mockito.verify((Object)fetchBuffer)).wakeup();
            WakeupTrigger.Wakeupable wakeupable = this.wakeupTrigger.getPendingTask();
            Assertions.assertInstanceOf(WakeupTrigger.WakeupFuture.class, (Object)wakeupable);
        }
    }

    @Test
    public void testManualTriggerWhenWakeupCalled() {
        this.wakeupTrigger.wakeup();
        Assertions.assertThrows(WakeupException.class, () -> this.wakeupTrigger.maybeTriggerWakeup());
    }

    @Test
    public void testManualTriggerWhenWakeupNotCalled() {
        Assertions.assertDoesNotThrow(() -> this.wakeupTrigger.maybeTriggerWakeup());
    }

    @Test
    public void testManualTriggerWhenWakeupCalledAndActiveTaskSet() {
        CompletableFuture future = new CompletableFuture();
        this.wakeupTrigger.setActiveTask(future);
        Assertions.assertDoesNotThrow(() -> this.wakeupTrigger.maybeTriggerWakeup());
    }

    @Test
    public void testManualTriggerWhenWakeupCalledAndFetchActionSet() {
        try (FetchBuffer fetchBuffer = (FetchBuffer)Mockito.mock(FetchBuffer.class);){
            this.wakeupTrigger.setFetchAction(fetchBuffer);
            Assertions.assertDoesNotThrow(() -> this.wakeupTrigger.maybeTriggerWakeup());
        }
    }

    private void assertWakeupExceptionIsThrown(CompletableFuture<?> future) {
        Assertions.assertTrue((boolean)future.isCompletedExceptionally());
        try {
            future.get(1000L, TimeUnit.MILLISECONDS);
        }
        catch (ExecutionException e) {
            Assertions.assertTrue((boolean)(e.getCause() instanceof WakeupException));
            return;
        }
        catch (Exception e) {
            Assertions.fail((String)("The task should throw an ExecutionException but got:" + e));
        }
        Assertions.fail((String)"The task should throw an ExecutionException");
    }
}

