/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.consumer.internals;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import org.apache.kafka.clients.consumer.internals.AsyncKafkaConsumer;
import org.apache.kafka.clients.consumer.internals.CommitRequestManager;
import org.apache.kafka.clients.consumer.internals.ConsumerCoordinatorMetrics;
import org.apache.kafka.clients.consumer.internals.ConsumerMetadata;
import org.apache.kafka.clients.consumer.internals.ConsumerRebalanceListenerInvoker;
import org.apache.kafka.clients.consumer.internals.ConsumerRebalanceListenerMethodName;
import org.apache.kafka.clients.consumer.internals.ConsumerTestBuilder;
import org.apache.kafka.clients.consumer.internals.CounterConsumerRebalanceListener;
import org.apache.kafka.clients.consumer.internals.MemberState;
import org.apache.kafka.clients.consumer.internals.MemberStateListener;
import org.apache.kafka.clients.consumer.internals.MembershipManager;
import org.apache.kafka.clients.consumer.internals.MembershipManagerImpl;
import org.apache.kafka.clients.consumer.internals.MockRebalanceListener;
import org.apache.kafka.clients.consumer.internals.SubscriptionState;
import org.apache.kafka.clients.consumer.internals.Utils;
import org.apache.kafka.clients.consumer.internals.events.BackgroundEvent;
import org.apache.kafka.clients.consumer.internals.events.BackgroundEventHandler;
import org.apache.kafka.clients.consumer.internals.events.ConsumerRebalanceListenerCallbackCompletedEvent;
import org.apache.kafka.clients.consumer.internals.events.ConsumerRebalanceListenerCallbackNeededEvent;
import org.apache.kafka.common.ClusterResourceListener;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.TopicIdPartition;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.message.ConsumerGroupHeartbeatResponseData;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.ConsumerGroupHeartbeatResponse;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.common.utils.Time;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class MembershipManagerImplTest {
    private static final String GROUP_ID = "test-group";
    private static final String MEMBER_ID = "test-member-1";
    private static final int REBALANCE_TIMEOUT = 100;
    private static final int MEMBER_EPOCH = 1;
    private final LogContext logContext = new LogContext();
    private SubscriptionState subscriptionState;
    private ConsumerMetadata metadata;
    private CommitRequestManager commitRequestManager;
    private ConsumerTestBuilder testBuilder;
    private BlockingQueue<BackgroundEvent> backgroundEventQueue;
    private BackgroundEventHandler backgroundEventHandler;
    private Time time;

    @BeforeEach
    public void setup() {
        this.testBuilder = new ConsumerTestBuilder(ConsumerTestBuilder.createDefaultGroupInformation());
        this.metadata = this.testBuilder.metadata;
        this.subscriptionState = this.testBuilder.subscriptions;
        this.commitRequestManager = this.testBuilder.commitRequestManager.orElseThrow(IllegalStateException::new);
        this.backgroundEventQueue = this.testBuilder.backgroundEventQueue;
        this.backgroundEventHandler = this.testBuilder.backgroundEventHandler;
        this.time = this.testBuilder.time;
    }

    @AfterEach
    public void tearDown() {
        if (this.testBuilder != null) {
            this.testBuilder.close();
        }
    }

    private MembershipManagerImpl createMembershipManagerJoiningGroup() {
        MembershipManagerImpl manager = (MembershipManagerImpl)Mockito.spy((Object)new MembershipManagerImpl(GROUP_ID, Optional.empty(), 100, Optional.empty(), this.subscriptionState, this.commitRequestManager, this.metadata, this.logContext, Optional.empty(), this.backgroundEventHandler, this.time));
        manager.transitionToJoining();
        return manager;
    }

    private MembershipManagerImpl createMembershipManagerJoiningGroup(String groupInstanceId) {
        MembershipManagerImpl manager = (MembershipManagerImpl)Mockito.spy((Object)new MembershipManagerImpl(GROUP_ID, Optional.ofNullable(groupInstanceId), 100, Optional.empty(), this.subscriptionState, this.commitRequestManager, this.metadata, this.logContext, Optional.empty(), this.backgroundEventHandler, this.time));
        manager.transitionToJoining();
        return manager;
    }

    private MembershipManagerImpl createMembershipManagerJoiningGroup(String groupInstanceId, String serverAssignor) {
        MembershipManagerImpl manager = new MembershipManagerImpl(GROUP_ID, Optional.ofNullable(groupInstanceId), 100, Optional.ofNullable(serverAssignor), this.subscriptionState, this.commitRequestManager, this.metadata, this.logContext, Optional.empty(), this.backgroundEventHandler, this.time);
        manager.transitionToJoining();
        return manager;
    }

    @Test
    public void testMembershipManagerServerAssignor() {
        MembershipManagerImpl membershipManager = this.createMembershipManagerJoiningGroup();
        Assertions.assertEquals(Optional.empty(), (Object)membershipManager.serverAssignor());
        membershipManager = this.createMembershipManagerJoiningGroup("instance1", "Uniform");
        Assertions.assertEquals(Optional.of("Uniform"), (Object)membershipManager.serverAssignor());
    }

    @Test
    public void testMembershipManagerInitSupportsEmptyGroupInstanceId() {
        this.createMembershipManagerJoiningGroup();
        this.createMembershipManagerJoiningGroup(null, null);
    }

    @Test
    public void testMembershipManagerRegistersForClusterMetadataUpdatesOnFirstJoin() {
        MembershipManagerImpl manager = new MembershipManagerImpl(GROUP_ID, Optional.empty(), 100, Optional.empty(), this.subscriptionState, this.commitRequestManager, this.metadata, this.logContext, Optional.empty(), this.backgroundEventHandler, this.time);
        manager.transitionToJoining();
        ((ConsumerMetadata)Mockito.verify((Object)this.metadata)).addClusterUpdateListener((ClusterResourceListener)manager);
        Mockito.clearInvocations((Object[])new ConsumerMetadata[]{this.metadata});
        this.receiveEmptyAssignment((MembershipManager)manager);
        this.mockLeaveGroup();
        manager.leaveGroup();
        Assertions.assertEquals((Object)MemberState.LEAVING, (Object)manager.state());
        manager.onHeartbeatRequestSent();
        Assertions.assertEquals((Object)MemberState.UNSUBSCRIBED, (Object)manager.state());
        manager.transitionToJoining();
        ((ConsumerMetadata)Mockito.verify((Object)this.metadata, (VerificationMode)Mockito.never())).addClusterUpdateListener((ClusterResourceListener)manager);
    }

    @Test
    public void testReconcilingWhenReceivingAssignmentFoundInMetadata() {
        MembershipManagerImpl membershipManager = this.mockJoinAndReceiveAssignment(true);
        Assertions.assertEquals((Object)MemberState.ACKNOWLEDGING, (Object)membershipManager.state());
        membershipManager.onHeartbeatRequestSent();
        Assertions.assertEquals((Object)MemberState.STABLE, (Object)membershipManager.state());
    }

    @Test
    public void testTransitionToReconcilingOnlyIfAssignmentReceived() {
        MembershipManagerImpl membershipManager = this.createMembershipManagerJoiningGroup();
        Assertions.assertEquals((Object)MemberState.JOINING, (Object)membershipManager.state());
        ConsumerGroupHeartbeatResponse responseWithoutAssignment = this.createConsumerGroupHeartbeatResponse(null);
        membershipManager.onHeartbeatResponseReceived(responseWithoutAssignment.data());
        Assertions.assertNotEquals((Object)MemberState.RECONCILING, (Object)membershipManager.state());
        ConsumerGroupHeartbeatResponse responseWithAssignment = this.createConsumerGroupHeartbeatResponse(this.createAssignment(true));
        membershipManager.onHeartbeatResponseReceived(responseWithAssignment.data());
        Assertions.assertEquals((Object)MemberState.RECONCILING, (Object)membershipManager.state());
    }

    @Test
    public void testMemberIdAndEpochResetOnFencedMembers() {
        MembershipManagerImpl membershipManager = this.createMembershipManagerJoiningGroup();
        ConsumerGroupHeartbeatResponse heartbeatResponse = this.createConsumerGroupHeartbeatResponse(null);
        membershipManager.onHeartbeatResponseReceived(heartbeatResponse.data());
        Assertions.assertEquals((Object)MemberState.STABLE, (Object)membershipManager.state());
        Assertions.assertEquals((Object)MEMBER_ID, (Object)membershipManager.memberId());
        Assertions.assertEquals((int)1, (int)membershipManager.memberEpoch());
        this.mockMemberHasAutoAssignedPartition();
        membershipManager.transitionToFenced();
        Assertions.assertEquals((Object)MEMBER_ID, (Object)membershipManager.memberId());
        Assertions.assertEquals((int)0, (int)membershipManager.memberEpoch());
    }

    @Test
    public void testTransitionToFatal() {
        MembershipManagerImpl membershipManager = this.createMembershipManagerJoiningGroup();
        ConsumerGroupHeartbeatResponse heartbeatResponse = this.createConsumerGroupHeartbeatResponse(null);
        membershipManager.onHeartbeatResponseReceived(heartbeatResponse.data());
        Assertions.assertEquals((Object)MemberState.STABLE, (Object)membershipManager.state());
        Assertions.assertEquals((Object)MEMBER_ID, (Object)membershipManager.memberId());
        Assertions.assertEquals((int)1, (int)membershipManager.memberEpoch());
        Mockito.when((Object)this.subscriptionState.hasAutoAssignedPartitions()).thenReturn((Object)true);
        membershipManager.transitionToFatal();
        Assertions.assertEquals((Object)MemberState.FATAL, (Object)membershipManager.state());
        ((SubscriptionState)Mockito.verify((Object)this.subscriptionState)).assignFromSubscribed(Collections.emptySet());
    }

    @Test
    public void testTransitionToFailedWhenTryingToJoin() {
        MembershipManagerImpl membershipManager = new MembershipManagerImpl(GROUP_ID, Optional.empty(), 100, Optional.empty(), this.subscriptionState, this.commitRequestManager, this.metadata, this.logContext, Optional.empty(), this.backgroundEventHandler, this.time);
        Assertions.assertEquals((Object)MemberState.UNSUBSCRIBED, (Object)membershipManager.state());
        membershipManager.transitionToJoining();
        Mockito.when((Object)this.subscriptionState.hasAutoAssignedPartitions()).thenReturn((Object)true);
        membershipManager.transitionToFatal();
        Assertions.assertEquals((Object)MemberState.FATAL, (Object)membershipManager.state());
    }

    @Test
    public void testFencingWhenStateIsStable() {
        MembershipManagerImpl membershipManager = this.createMemberInStableState();
        this.testFencedMemberReleasesAssignmentAndTransitionsToJoining((MembershipManager)membershipManager);
        ((SubscriptionState)Mockito.verify((Object)this.subscriptionState)).assignFromSubscribed(Collections.emptySet());
    }

    @Test
    public void testListenersGetNotifiedOnTransitionsToFatal() {
        MembershipManagerImpl membershipManager = this.createMembershipManagerJoiningGroup();
        MemberStateListener listener = (MemberStateListener)Mockito.mock(MemberStateListener.class);
        membershipManager.registerStateListener(listener);
        this.mockStableMember(membershipManager);
        ((MemberStateListener)Mockito.verify((Object)listener)).onMemberEpochUpdated(Optional.of(1), Optional.of(MEMBER_ID));
        Mockito.clearInvocations((Object[])new MemberStateListener[]{listener});
        membershipManager.transitionToFatal();
        Assertions.assertEquals((Object)MemberState.FATAL, (Object)membershipManager.state());
        ((MemberStateListener)Mockito.verify((Object)listener)).onMemberEpochUpdated(Optional.empty(), Optional.empty());
    }

    @Test
    public void testListenersGetNotifiedOnTransitionsToLeavingGroup() {
        MembershipManagerImpl membershipManager = this.createMembershipManagerJoiningGroup();
        MemberStateListener listener = (MemberStateListener)Mockito.mock(MemberStateListener.class);
        membershipManager.registerStateListener(listener);
        this.mockStableMember(membershipManager);
        ((MemberStateListener)Mockito.verify((Object)listener)).onMemberEpochUpdated(Optional.of(1), Optional.of(MEMBER_ID));
        Mockito.clearInvocations((Object[])new MemberStateListener[]{listener});
        this.mockLeaveGroup();
        membershipManager.leaveGroup();
        Assertions.assertEquals((Object)MemberState.LEAVING, (Object)membershipManager.state());
        ((MemberStateListener)Mockito.verify((Object)listener)).onMemberEpochUpdated(Optional.empty(), Optional.empty());
    }

    @Test
    public void testListenersGetNotifiedOfMemberEpochUpdatesOnlyIfItChanges() {
        MembershipManagerImpl membershipManager = this.createMembershipManagerJoiningGroup();
        MemberStateListener listener = (MemberStateListener)Mockito.mock(MemberStateListener.class);
        membershipManager.registerStateListener(listener);
        int epoch = 5;
        membershipManager.onHeartbeatResponseReceived(new ConsumerGroupHeartbeatResponseData().setErrorCode(Errors.NONE.code()).setMemberId(MEMBER_ID).setMemberEpoch(epoch));
        ((MemberStateListener)Mockito.verify((Object)listener)).onMemberEpochUpdated(Optional.of(epoch), Optional.of(MEMBER_ID));
        Mockito.clearInvocations((Object[])new MemberStateListener[]{listener});
        membershipManager.onHeartbeatResponseReceived(new ConsumerGroupHeartbeatResponseData().setErrorCode(Errors.NONE.code()).setMemberId(MEMBER_ID).setMemberEpoch(epoch));
        ((MemberStateListener)Mockito.verify((Object)listener, (VerificationMode)Mockito.never())).onMemberEpochUpdated((Optional)ArgumentMatchers.any(), (Optional)ArgumentMatchers.any());
    }

    private void mockStableMember(MembershipManagerImpl membershipManager) {
        ConsumerGroupHeartbeatResponse heartbeatResponse = this.createConsumerGroupHeartbeatResponse(null);
        membershipManager.onHeartbeatResponseReceived(heartbeatResponse.data());
        Assertions.assertEquals((Object)MemberState.STABLE, (Object)membershipManager.state());
        Assertions.assertEquals((Object)MEMBER_ID, (Object)membershipManager.memberId());
        Assertions.assertEquals((int)1, (int)membershipManager.memberEpoch());
    }

    @Test
    public void testFencingWhenStateIsReconciling() {
        MembershipManagerImpl membershipManager = this.mockJoinAndReceiveAssignment(false);
        Assertions.assertEquals((Object)MemberState.RECONCILING, (Object)membershipManager.state());
        this.testFencedMemberReleasesAssignmentAndTransitionsToJoining((MembershipManager)membershipManager);
        ((SubscriptionState)Mockito.verify((Object)this.subscriptionState)).assignFromSubscribed(Collections.emptySet());
    }

    @Test
    public void testFencingWhenStateIsPrepareLeaving() {
        MembershipManagerImpl membershipManager = this.createMemberInStableState();
        ConsumerRebalanceListenerInvoker invoker = this.consumerRebalanceListenerInvoker();
        ConsumerRebalanceListenerCallbackCompletedEvent callbackEvent = this.mockPrepareLeavingStuckOnUserCallback(membershipManager, invoker);
        Assertions.assertEquals((Object)MemberState.PREPARE_LEAVING, (Object)membershipManager.state());
        Mockito.clearInvocations((Object[])new SubscriptionState[]{this.subscriptionState});
        membershipManager.transitionToFenced();
        this.testFenceIsNoOp(membershipManager);
        Assertions.assertEquals((Object)MemberState.UNSUBSCRIBED, (Object)membershipManager.state());
        this.completeCallback(callbackEvent, membershipManager);
        Assertions.assertEquals((Object)MemberState.UNSUBSCRIBED, (Object)membershipManager.state());
        Assertions.assertTrue((boolean)membershipManager.shouldSkipHeartbeat());
    }

    @Test
    public void testNewAssignmentIgnoredWhenStateIsPrepareLeaving() {
        MembershipManagerImpl membershipManager = this.createMemberInStableState();
        ConsumerRebalanceListenerInvoker invoker = this.consumerRebalanceListenerInvoker();
        ConsumerRebalanceListenerCallbackCompletedEvent callbackEvent = this.mockPrepareLeavingStuckOnUserCallback(membershipManager, invoker);
        Assertions.assertEquals((Object)MemberState.PREPARE_LEAVING, (Object)membershipManager.state());
        Uuid topicId = Uuid.randomUuid();
        this.mockOwnedPartitionAndAssignmentReceived(membershipManager, topicId, "topic1", Collections.emptyList());
        this.receiveAssignment(topicId, Arrays.asList(0, 1), (MembershipManager)membershipManager);
        Assertions.assertEquals((Object)MemberState.PREPARE_LEAVING, (Object)membershipManager.state());
        Assertions.assertTrue((boolean)membershipManager.assignmentReadyToReconcile().isEmpty());
        Assertions.assertTrue((boolean)membershipManager.topicsWaitingForMetadata().isEmpty());
        ((MembershipManagerImpl)Mockito.verify((Object)membershipManager, (VerificationMode)Mockito.never())).markReconciliationInProgress();
        this.completeCallback(callbackEvent, membershipManager);
        Assertions.assertEquals((Object)MemberState.LEAVING, (Object)membershipManager.state());
    }

    @Test
    public void testFencingWhenStateIsLeaving() {
        MembershipManagerImpl membershipManager = this.createMemberInStableState();
        this.mockLeaveGroup();
        membershipManager.leaveGroup();
        Assertions.assertEquals((Object)MemberState.LEAVING, (Object)membershipManager.state());
        Mockito.clearInvocations((Object[])new SubscriptionState[]{this.subscriptionState});
        membershipManager.transitionToFenced();
        this.testFenceIsNoOp(membershipManager);
        Assertions.assertEquals((Object)MemberState.LEAVING, (Object)membershipManager.state());
        membershipManager.onHeartbeatRequestSent();
        Assertions.assertEquals((Object)MemberState.UNSUBSCRIBED, (Object)membershipManager.state());
        Mockito.clearInvocations((Object[])new SubscriptionState[]{this.subscriptionState});
        membershipManager.transitionToFenced();
        this.testFenceIsNoOp(membershipManager);
        Assertions.assertEquals((Object)MemberState.UNSUBSCRIBED, (Object)membershipManager.state());
    }

    @Test
    public void testLeaveGroupEpoch() {
        MembershipManagerImpl membershipManager = this.createMemberInStableState("instance1");
        this.mockLeaveGroup();
        membershipManager.leaveGroup();
        Assertions.assertEquals((Object)MemberState.LEAVING, (Object)membershipManager.state());
        Assertions.assertEquals((int)-2, (int)membershipManager.memberEpoch());
        membershipManager = this.createMemberInStableState(null);
        this.mockLeaveGroup();
        membershipManager.leaveGroup();
        Assertions.assertEquals((Object)MemberState.LEAVING, (Object)membershipManager.state());
        Assertions.assertEquals((int)-1, (int)membershipManager.memberEpoch());
    }

    @Test
    public void testDelayedReconciliationResultDiscardedIfMemberNotInReconcilingStateAnymore() {
        MembershipManagerImpl membershipManager = this.createMemberInStableState();
        Uuid topicId1 = Uuid.randomUuid();
        String topic1 = "topic1";
        List<TopicIdPartition> owned = Collections.singletonList(new TopicIdPartition(topicId1, new TopicPartition(topic1, 0)));
        this.mockOwnedPartitionAndAssignmentReceived(membershipManager, topicId1, topic1, owned);
        CompletableFuture<Void> commitResult = this.mockEmptyAssignmentAndRevocationStuckOnCommit(membershipManager);
        Mockito.when((Object)this.subscriptionState.hasAutoAssignedPartitions()).thenReturn((Object)true);
        membershipManager.transitionToFatal();
        ((SubscriptionState)Mockito.verify((Object)this.subscriptionState)).assignFromSubscribed(Collections.emptySet());
        Mockito.clearInvocations((Object[])new SubscriptionState[]{this.subscriptionState});
        commitResult.complete(null);
        ((SubscriptionState)Mockito.verify((Object)this.subscriptionState, (VerificationMode)Mockito.never())).assignFromSubscribed((Collection)ArgumentMatchers.anySet());
        Assertions.assertNotEquals((Object)MemberState.ACKNOWLEDGING, (Object)membershipManager.state());
    }

    @Test
    public void testDelayedReconciliationResultDiscardedIfMemberRejoins() {
        MembershipManagerImpl membershipManager = this.createMemberInStableState();
        Uuid topicId1 = Uuid.randomUuid();
        String topic1 = "topic1";
        List<TopicIdPartition> owned = Collections.singletonList(new TopicIdPartition(topicId1, new TopicPartition(topic1, 0)));
        this.mockOwnedPartitionAndAssignmentReceived(membershipManager, topicId1, topic1, owned);
        CompletableFuture<Void> commitResult = this.mockNewAssignmentAndRevocationStuckOnCommit(membershipManager, topicId1, topic1, Arrays.asList(1, 2), true);
        SortedSet<TopicIdPartition> assignment1 = this.topicIdPartitionsSet(topicId1, topic1, 1, 2);
        Assertions.assertEquals(assignment1, (Object)membershipManager.assignmentReadyToReconcile());
        this.testFencedMemberReleasesAssignmentAndTransitionsToJoining((MembershipManager)membershipManager);
        Mockito.clearInvocations((Object[])new SubscriptionState[]{this.subscriptionState});
        Uuid topicId3 = Uuid.randomUuid();
        this.mockOwnedPartitionAndAssignmentReceived(membershipManager, topicId3, "topic3", owned);
        this.receiveAssignmentAfterRejoin(topicId3, Collections.singletonList(5), (MembershipManager)membershipManager);
        this.verifyReconciliationNotTriggered(membershipManager);
        SortedSet<TopicIdPartition> assignmentAfterRejoin = this.topicIdPartitionsSet(topicId3, "topic3", 5);
        Assertions.assertEquals(assignmentAfterRejoin, (Object)membershipManager.assignmentReadyToReconcile());
        commitResult.complete(null);
        ((SubscriptionState)Mockito.verify((Object)this.subscriptionState, (VerificationMode)Mockito.never())).assignFromSubscribed(ArgumentMatchers.anyCollection());
        Assertions.assertNotEquals((Object)MemberState.ACKNOWLEDGING, (Object)membershipManager.state());
        Assertions.assertEquals(assignmentAfterRejoin, (Object)membershipManager.assignmentReadyToReconcile());
    }

    @Test
    public void testDelayedReconciliationResultAppliedWhenTargetChangedWithMetadataUpdate() {
        Uuid topicId1 = Uuid.randomUuid();
        String topic1 = "topic1";
        MembershipManagerImpl membershipManager = this.mockMemberSuccessfullyReceivesAndAcksAssignment(topicId1, topic1, Collections.singletonList(0));
        membershipManager.onHeartbeatRequestSent();
        Assertions.assertEquals((Object)MemberState.STABLE, (Object)membershipManager.state());
        Mockito.clearInvocations((Object[])new Object[]{membershipManager, this.subscriptionState});
        Mockito.when((Object)this.subscriptionState.assignedPartitions()).thenReturn(Collections.singleton(new TopicPartition(topic1, 0)));
        Uuid topicId2 = Uuid.randomUuid();
        String topic2 = "topic2";
        CompletableFuture<Void> commitResult = this.mockNewAssignmentAndRevocationStuckOnCommit(membershipManager, topicId2, topic2, Arrays.asList(1, 2), false);
        ((ConsumerMetadata)Mockito.verify((Object)this.metadata)).requestUpdate(ArgumentMatchers.anyBoolean());
        Assertions.assertEquals(Collections.singleton(topicId2), (Object)membershipManager.topicsWaitingForMetadata());
        this.mockTopicNameInMetadataCache(Collections.singletonMap(topicId2, topic2), true);
        membershipManager.onUpdate(null);
        Assertions.assertEquals(Collections.emptySet(), (Object)membershipManager.topicsWaitingForMetadata());
        this.verifyReconciliationNotTriggered(membershipManager);
        commitResult.complete(null);
        ((SubscriptionState)Mockito.verify((Object)this.subscriptionState)).assignFromSubscribed(Collections.emptySet());
        Assertions.assertEquals((Object)MemberState.ACKNOWLEDGING, (Object)membershipManager.state());
        SortedSet<TopicIdPartition> topic2Assignment = this.topicIdPartitionsSet(topicId2, topic2, 1, 2);
        Assertions.assertEquals(topic2Assignment, (Object)membershipManager.assignmentReadyToReconcile());
    }

    @Test
    public void testLeaveGroupWhenStateIsStable() {
        MembershipManagerImpl membershipManager = this.createMemberInStableState();
        this.testLeaveGroupReleasesAssignmentAndResetsEpochToSendLeaveGroup((MembershipManager)membershipManager);
        ((SubscriptionState)Mockito.verify((Object)this.subscriptionState)).assignFromSubscribed(Collections.emptySet());
    }

    @Test
    public void testLeaveGroupWhenStateIsReconciling() {
        MembershipManagerImpl membershipManager = this.mockJoinAndReceiveAssignment(false);
        Assertions.assertEquals((Object)MemberState.RECONCILING, (Object)membershipManager.state());
        this.testLeaveGroupReleasesAssignmentAndResetsEpochToSendLeaveGroup((MembershipManager)membershipManager);
    }

    @Test
    public void testLeaveGroupWhenMemberOwnsAssignment() {
        Uuid topicId = Uuid.randomUuid();
        String topicName = "topic1";
        MembershipManagerImpl membershipManager = this.createMembershipManagerJoiningGroup();
        this.mockOwnedPartitionAndAssignmentReceived(membershipManager, topicId, topicName, Collections.emptyList());
        this.receiveAssignment(topicId, Arrays.asList(0, 1), (MembershipManager)membershipManager);
        List<TopicIdPartition> assignedPartitions = Arrays.asList(new TopicIdPartition(topicId, new TopicPartition(topicName, 0)), new TopicIdPartition(topicId, new TopicPartition(topicName, 1)));
        this.verifyReconciliationTriggeredAndCompleted(membershipManager, assignedPartitions);
        Assertions.assertEquals((int)1, (int)membershipManager.currentAssignment().size());
        this.testLeaveGroupReleasesAssignmentAndResetsEpochToSendLeaveGroup((MembershipManager)membershipManager);
    }

    @Test
    public void testLeaveGroupWhenMemberAlreadyLeaving() {
        MembershipManagerImpl membershipManager = this.createMemberInStableState();
        this.mockLeaveGroup();
        CompletableFuture leaveResult1 = membershipManager.leaveGroup();
        Assertions.assertFalse((boolean)leaveResult1.isDone());
        Assertions.assertEquals((Object)MemberState.LEAVING, (Object)membershipManager.state());
        ((SubscriptionState)Mockito.verify((Object)this.subscriptionState)).assignFromSubscribed(Collections.emptySet());
        Mockito.clearInvocations((Object[])new SubscriptionState[]{this.subscriptionState});
        this.mockLeaveGroup();
        CompletableFuture leaveResult2 = membershipManager.leaveGroup();
        ((SubscriptionState)Mockito.verify((Object)this.subscriptionState, (VerificationMode)Mockito.never())).rebalanceListener();
        Assertions.assertFalse((boolean)leaveResult2.isDone());
        membershipManager.onHeartbeatRequestSent();
        Assertions.assertTrue((boolean)leaveResult1.isDone());
        Assertions.assertFalse((boolean)leaveResult1.isCompletedExceptionally());
        Assertions.assertTrue((boolean)leaveResult2.isDone());
        Assertions.assertFalse((boolean)leaveResult2.isCompletedExceptionally());
        ((SubscriptionState)Mockito.verify((Object)this.subscriptionState, (VerificationMode)Mockito.never())).assignFromSubscribed(Collections.emptySet());
    }

    @Test
    public void testLeaveGroupWhenMemberAlreadyLeft() {
        MembershipManagerImpl membershipManager = this.createMemberInStableState();
        this.mockLeaveGroup();
        CompletableFuture leaveResult1 = membershipManager.leaveGroup();
        Assertions.assertEquals((Object)MemberState.LEAVING, (Object)membershipManager.state());
        membershipManager.onHeartbeatRequestSent();
        Assertions.assertEquals((Object)MemberState.UNSUBSCRIBED, (Object)membershipManager.state());
        Assertions.assertTrue((boolean)leaveResult1.isDone());
        Assertions.assertFalse((boolean)leaveResult1.isCompletedExceptionally());
        ((SubscriptionState)Mockito.verify((Object)this.subscriptionState)).assignFromSubscribed(Collections.emptySet());
        Mockito.clearInvocations((Object[])new SubscriptionState[]{this.subscriptionState});
        this.mockLeaveGroup();
        CompletableFuture leaveResult2 = membershipManager.leaveGroup();
        Assertions.assertTrue((boolean)leaveResult2.isDone());
        Assertions.assertFalse((boolean)leaveResult2.isCompletedExceptionally());
        Assertions.assertEquals((Object)MemberState.UNSUBSCRIBED, (Object)membershipManager.state());
        ((SubscriptionState)Mockito.verify((Object)this.subscriptionState, (VerificationMode)Mockito.never())).rebalanceListener();
        ((SubscriptionState)Mockito.verify((Object)this.subscriptionState, (VerificationMode)Mockito.never())).assignFromSubscribed(Collections.emptySet());
    }

    @Test
    public void testFatalFailureWhenStateIsUnjoined() {
        MembershipManagerImpl membershipManager = this.createMembershipManagerJoiningGroup();
        Assertions.assertEquals((Object)MemberState.JOINING, (Object)membershipManager.state());
        this.testStateUpdateOnFatalFailure(membershipManager);
    }

    @Test
    public void testFatalFailureWhenStateIsStable() {
        MembershipManagerImpl membershipManager = this.createMembershipManagerJoiningGroup();
        ConsumerGroupHeartbeatResponse heartbeatResponse = this.createConsumerGroupHeartbeatResponse(null);
        membershipManager.onHeartbeatResponseReceived(heartbeatResponse.data());
        Assertions.assertEquals((Object)MemberState.STABLE, (Object)membershipManager.state());
        this.testStateUpdateOnFatalFailure(membershipManager);
    }

    @Test
    public void testFatalFailureWhenStateIsPrepareLeaving() {
        MembershipManagerImpl membershipManager = this.createMemberInStableState();
        ConsumerRebalanceListenerInvoker invoker = this.consumerRebalanceListenerInvoker();
        ConsumerRebalanceListenerCallbackCompletedEvent callbackEvent = this.mockPrepareLeavingStuckOnUserCallback(membershipManager, invoker);
        Assertions.assertEquals((Object)MemberState.PREPARE_LEAVING, (Object)membershipManager.state());
        this.testStateUpdateOnFatalFailure(membershipManager);
        this.completeCallback(callbackEvent, membershipManager);
        Assertions.assertEquals((Object)MemberState.FATAL, (Object)membershipManager.state());
    }

    @Test
    public void testFatalFailureWhenStateIsLeaving() {
        MembershipManagerImpl membershipManager = this.createMemberInStableState();
        this.mockLeaveGroup();
        membershipManager.leaveGroup();
        Assertions.assertEquals((Object)MemberState.LEAVING, (Object)membershipManager.state());
        this.testStateUpdateOnFatalFailure(membershipManager);
        Assertions.assertEquals((Object)MemberState.FATAL, (Object)membershipManager.state());
        membershipManager.onHeartbeatRequestSent();
        Assertions.assertEquals((Object)MemberState.FATAL, (Object)membershipManager.state());
    }

    @Test
    public void testFatalFailureWhenMemberAlreadyLeft() {
        MembershipManagerImpl membershipManager = this.createMemberInStableState();
        this.mockLeaveGroup();
        membershipManager.leaveGroup();
        Assertions.assertEquals((Object)MemberState.LEAVING, (Object)membershipManager.state());
        membershipManager.onHeartbeatRequestSent();
        Assertions.assertEquals((Object)MemberState.UNSUBSCRIBED, (Object)membershipManager.state());
        MockRebalanceListener rebalanceListener = new MockRebalanceListener();
        Mockito.when((Object)this.subscriptionState.rebalanceListener()).thenReturn(Optional.of(rebalanceListener));
        membershipManager.transitionToFatal();
        Assertions.assertEquals((int)0, (int)rebalanceListener.lostCount);
        Assertions.assertEquals((Object)MemberState.FATAL, (Object)membershipManager.state());
    }

    @Test
    public void testUpdateStateFailsOnResponsesWithErrors() {
        MembershipManagerImpl membershipManager = this.createMembershipManagerJoiningGroup();
        ConsumerGroupHeartbeatResponse unknownMemberResponse = this.createConsumerGroupHeartbeatResponseWithError();
        Assertions.assertThrows(IllegalArgumentException.class, () -> membershipManager.onHeartbeatResponseReceived(unknownMemberResponse.data()));
    }

    @Test
    public void testNewAssignmentReplacesPreviousOneWaitingOnMetadata() {
        MembershipManagerImpl membershipManager = this.mockJoinAndReceiveAssignment(false);
        Assertions.assertEquals((Object)MemberState.RECONCILING, (Object)membershipManager.state());
        Assertions.assertFalse((boolean)membershipManager.topicsWaitingForMetadata().isEmpty());
        membershipManager.onHeartbeatRequestSent();
        Assertions.assertEquals((Object)MemberState.RECONCILING, (Object)membershipManager.state());
        Assertions.assertFalse((boolean)membershipManager.topicsWaitingForMetadata().isEmpty());
        Uuid topicId = Uuid.randomUuid();
        String topicName = "topic1";
        Mockito.when((Object)this.metadata.topicNames()).thenReturn(Collections.singletonMap(topicId, topicName));
        this.receiveAssignment(topicId, Collections.singletonList(0), (MembershipManager)membershipManager);
        Set<TopicPartition> expectedAssignment = Collections.singleton(new TopicPartition(topicName, 0));
        Assertions.assertEquals((Object)MemberState.ACKNOWLEDGING, (Object)membershipManager.state());
        ((SubscriptionState)Mockito.verify((Object)this.subscriptionState)).assignFromSubscribed(expectedAssignment);
        membershipManager.onHeartbeatRequestSent();
        Assertions.assertEquals((Object)MemberState.STABLE, (Object)membershipManager.state());
        Assertions.assertTrue((boolean)membershipManager.topicsWaitingForMetadata().isEmpty());
    }

    @Test
    public void testNewEmptyAssignmentReplacesPreviousOneWaitingOnMetadata() {
        MembershipManagerImpl membershipManager = this.mockJoinAndReceiveAssignment(false);
        Assertions.assertEquals((Object)MemberState.RECONCILING, (Object)membershipManager.state());
        Assertions.assertFalse((boolean)membershipManager.topicsWaitingForMetadata().isEmpty());
        membershipManager.onHeartbeatRequestSent();
        Assertions.assertEquals((Object)MemberState.RECONCILING, (Object)membershipManager.state());
        Assertions.assertFalse((boolean)membershipManager.topicsWaitingForMetadata().isEmpty());
        Uuid topicId = Uuid.randomUuid();
        String topicName = "topic1";
        Mockito.when((Object)this.metadata.topicNames()).thenReturn(Collections.singletonMap(topicId, topicName));
        this.receiveEmptyAssignment((MembershipManager)membershipManager);
        Assertions.assertEquals((Object)MemberState.STABLE, (Object)membershipManager.state());
        ((SubscriptionState)Mockito.verify((Object)this.subscriptionState, (VerificationMode)Mockito.never())).assignFromSubscribed((Collection)ArgumentMatchers.any());
    }

    @Test
    public void testNewAssignmentNotInMetadataReplacesPreviousOneWaitingOnMetadata() {
        MembershipManagerImpl membershipManager = this.mockJoinAndReceiveAssignment(false);
        Assertions.assertEquals((Object)MemberState.RECONCILING, (Object)membershipManager.state());
        Assertions.assertFalse((boolean)membershipManager.topicsWaitingForMetadata().isEmpty());
        Uuid topicId = Uuid.randomUuid();
        Mockito.when((Object)this.metadata.topicNames()).thenReturn(Collections.emptyMap());
        this.receiveAssignment(topicId, Collections.singletonList(0), (MembershipManager)membershipManager);
        Assertions.assertEquals((Object)MemberState.RECONCILING, (Object)membershipManager.state());
        Assertions.assertFalse((boolean)membershipManager.topicsWaitingForMetadata().isEmpty());
        Assertions.assertEquals((Object)topicId, membershipManager.topicsWaitingForMetadata().iterator().next());
    }

    @Test
    public void testUnresolvedTargetAssignmentIsReconciledWhenMetadataReceived() {
        MembershipManagerImpl membershipManager = this.createMemberInStableState();
        Uuid topicId = Uuid.randomUuid();
        this.receiveAssignment(topicId, Collections.singletonList(1), (MembershipManager)membershipManager);
        Assertions.assertEquals((Object)MemberState.RECONCILING, (Object)membershipManager.state());
        Assertions.assertFalse((boolean)membershipManager.topicsWaitingForMetadata().isEmpty());
        String topicName = "topic1";
        Mockito.when((Object)this.metadata.topicNames()).thenReturn(Collections.singletonMap(topicId, topicName));
        Mockito.when((Object)this.subscriptionState.hasAutoAssignedPartitions()).thenReturn((Object)true);
        Mockito.when((Object)this.subscriptionState.rebalanceListener()).thenReturn(Optional.empty());
        membershipManager.onUpdate(null);
        Set<TopicPartition> expectedAssignment = Collections.singleton(new TopicPartition(topicName, 1));
        ((SubscriptionState)Mockito.verify((Object)this.subscriptionState)).assignFromSubscribed(expectedAssignment);
        Assertions.assertEquals((Object)MemberState.ACKNOWLEDGING, (Object)membershipManager.state());
        Assertions.assertTrue((boolean)membershipManager.topicsWaitingForMetadata().isEmpty());
    }

    @Test
    public void testMemberKeepsUnresolvedAssignmentWaitingForMetadataUntilResolved() {
        Uuid topic1 = Uuid.randomUuid();
        String topic1Name = "topic1";
        Uuid topic2 = Uuid.randomUuid();
        ConsumerGroupHeartbeatResponseData.Assignment assignment = new ConsumerGroupHeartbeatResponseData.Assignment().setTopicPartitions(Arrays.asList(new ConsumerGroupHeartbeatResponseData.TopicPartitions().setTopicId(topic1).setPartitions(Collections.singletonList(0)), new ConsumerGroupHeartbeatResponseData.TopicPartitions().setTopicId(topic2).setPartitions(Arrays.asList(1, 3))));
        Mockito.when((Object)this.metadata.topicNames()).thenReturn(Collections.singletonMap(topic1, topic1Name));
        MembershipManagerImpl membershipManager = this.mockJoinAndReceiveAssignment(true, assignment);
        Assertions.assertEquals((Object)MemberState.ACKNOWLEDGING, (Object)membershipManager.state());
        ((ConsumerMetadata)Mockito.verify((Object)this.metadata)).requestUpdate(ArgumentMatchers.anyBoolean());
        Assertions.assertEquals(Collections.singleton(topic2), (Object)membershipManager.topicsWaitingForMetadata());
        membershipManager.onHeartbeatRequestSent();
        Assertions.assertEquals((Object)MemberState.RECONCILING, (Object)membershipManager.state());
        Mockito.clearInvocations((Object[])new SubscriptionState[]{this.subscriptionState});
        membershipManager.onHeartbeatResponseReceived(this.createConsumerGroupHeartbeatResponse(assignment).data());
        Assertions.assertEquals((Object)MemberState.RECONCILING, (Object)membershipManager.state());
        Assertions.assertEquals(Collections.singleton(topic2), (Object)membershipManager.topicsWaitingForMetadata());
        ((SubscriptionState)Mockito.verify((Object)this.subscriptionState, (VerificationMode)Mockito.never())).assignFromSubscribed(ArgumentMatchers.anyCollection());
    }

    @Test
    public void testReconcileNewPartitionsAssignedWhenNoPartitionOwned() {
        Uuid topicId = Uuid.randomUuid();
        String topicName = "topic1";
        MembershipManagerImpl membershipManager = this.createMembershipManagerJoiningGroup();
        this.mockOwnedPartitionAndAssignmentReceived(membershipManager, topicId, topicName, Collections.emptyList());
        this.receiveAssignment(topicId, Arrays.asList(0, 1), (MembershipManager)membershipManager);
        List<TopicIdPartition> assignedPartitions = this.topicIdPartitions(topicId, topicName, 0, 1);
        this.verifyReconciliationTriggeredAndCompleted(membershipManager, assignedPartitions);
    }

    @Test
    public void testReconcileNewPartitionsAssignedWhenOtherPartitionsOwned() {
        Uuid topicId = Uuid.randomUuid();
        String topicName = "topic1";
        TopicIdPartition ownedPartition = new TopicIdPartition(topicId, new TopicPartition(topicName, 0));
        MembershipManagerImpl membershipManager = this.createMemberInStableState();
        this.mockOwnedPartitionAndAssignmentReceived(membershipManager, topicId, topicName, Collections.singletonList(ownedPartition));
        this.receiveAssignment(topicId, Arrays.asList(0, 1, 2), (MembershipManager)membershipManager);
        ArrayList<TopicIdPartition> assignedPartitions = new ArrayList<TopicIdPartition>();
        assignedPartitions.add(ownedPartition);
        assignedPartitions.addAll(this.topicIdPartitions(topicId, topicName, 1, 2));
        this.verifyReconciliationTriggeredAndCompleted(membershipManager, assignedPartitions);
    }

    @Test
    public void testReconciliationSkippedWhenSameAssignmentReceived() {
        MembershipManagerImpl membershipManager = this.createMembershipManagerJoiningGroup();
        Uuid topicId = Uuid.randomUuid();
        String topicName = "topic1";
        this.mockOwnedPartitionAndAssignmentReceived(membershipManager, topicId, topicName, Collections.emptyList());
        List<TopicIdPartition> expectedAssignmentReconciled = this.topicIdPartitions(topicId, topicName, 0, 1);
        this.receiveAssignment(topicId, Arrays.asList(0, 1), (MembershipManager)membershipManager);
        this.verifyReconciliationTriggeredAndCompleted(membershipManager, expectedAssignmentReconciled);
        Assertions.assertEquals((Object)MemberState.ACKNOWLEDGING, (Object)membershipManager.state());
        Mockito.clearInvocations((Object[])new Object[]{this.subscriptionState, membershipManager});
        membershipManager.onHeartbeatRequestSent();
        Assertions.assertEquals((Object)MemberState.STABLE, (Object)membershipManager.state());
        this.mockOwnedPartitionAndAssignmentReceived(membershipManager, topicId, topicName, expectedAssignmentReconciled);
        this.receiveAssignment(topicId, Arrays.asList(0, 1), (MembershipManager)membershipManager);
        ((MembershipManagerImpl)Mockito.verify((Object)membershipManager, (VerificationMode)Mockito.never())).markReconciliationInProgress();
        ((MembershipManagerImpl)Mockito.verify((Object)membershipManager, (VerificationMode)Mockito.never())).markReconciliationCompleted();
        ((SubscriptionState)Mockito.verify((Object)this.subscriptionState, (VerificationMode)Mockito.never())).assignFromSubscribed(ArgumentMatchers.anyCollection());
        Assertions.assertEquals((Object)MemberState.STABLE, (Object)membershipManager.state());
    }

    @Test
    public void testReconcilePartitionsRevokedNoAutoCommitNoCallbacks() {
        MembershipManagerImpl membershipManager = this.createMemberInStableState();
        this.mockOwnedPartition(membershipManager, Uuid.randomUuid(), "topic1");
        this.mockRevocationNoCallbacks(false);
        this.receiveEmptyAssignment((MembershipManager)membershipManager);
        this.testRevocationOfAllPartitionsCompleted(membershipManager);
    }

    @Test
    public void testReconcilePartitionsRevokedWithSuccessfulAutoCommitNoCallbacks() {
        MembershipManagerImpl membershipManager = this.createMemberInStableState();
        this.mockOwnedPartition(membershipManager, Uuid.randomUuid(), "topic1");
        CompletableFuture<Void> commitResult = this.mockRevocationNoCallbacks(true);
        this.receiveEmptyAssignment((MembershipManager)membershipManager);
        Assertions.assertEquals((Object)MemberState.RECONCILING, (Object)membershipManager.state());
        ((SubscriptionState)Mockito.verify((Object)this.subscriptionState, (VerificationMode)Mockito.never())).assignFromSubscribed(ArgumentMatchers.anyCollection());
        commitResult.complete(null);
        this.testRevocationOfAllPartitionsCompleted(membershipManager);
    }

    @Test
    public void testReconcilePartitionsRevokedWithFailedAutoCommitCompletesRevocationAnyway() {
        MembershipManagerImpl membershipManager = this.createMemberInStableState();
        this.mockOwnedPartition(membershipManager, Uuid.randomUuid(), "topic1");
        CompletableFuture<Void> commitResult = this.mockRevocationNoCallbacks(true);
        this.receiveEmptyAssignment((MembershipManager)membershipManager);
        Assertions.assertEquals((Object)MemberState.RECONCILING, (Object)membershipManager.state());
        ((SubscriptionState)Mockito.verify((Object)this.subscriptionState, (VerificationMode)Mockito.never())).assignFromSubscribed(ArgumentMatchers.anyCollection());
        commitResult.completeExceptionally(new KafkaException("Commit request failed with non-retriable error"));
        this.testRevocationOfAllPartitionsCompleted(membershipManager);
    }

    @Test
    public void testReconcileNewPartitionsAssignedAndRevoked() {
        Uuid topicId = Uuid.randomUuid();
        String topicName = "topic1";
        TopicIdPartition ownedPartition = new TopicIdPartition(topicId, new TopicPartition(topicName, 0));
        MembershipManagerImpl membershipManager = this.createMembershipManagerJoiningGroup();
        this.mockOwnedPartitionAndAssignmentReceived(membershipManager, topicId, topicName, Collections.singletonList(ownedPartition));
        this.mockRevocationNoCallbacks(false);
        this.receiveAssignment(topicId, Arrays.asList(1, 2), (MembershipManager)membershipManager);
        Assertions.assertEquals((Object)MemberState.ACKNOWLEDGING, (Object)membershipManager.state());
        Assertions.assertEquals(this.topicIdPartitionsMap(topicId, 1, 2), (Object)membershipManager.currentAssignment());
        Assertions.assertFalse((boolean)membershipManager.reconciliationInProgress());
        ((SubscriptionState)Mockito.verify((Object)this.subscriptionState)).assignFromSubscribed(ArgumentMatchers.anyCollection());
    }

    @Test
    public void testMetadataUpdatesReconcilesUnresolvedAssignments() {
        Uuid topicId = Uuid.randomUuid();
        ConsumerGroupHeartbeatResponseData.Assignment targetAssignment = new ConsumerGroupHeartbeatResponseData.Assignment().setTopicPartitions(Collections.singletonList(new ConsumerGroupHeartbeatResponseData.TopicPartitions().setTopicId(topicId).setPartitions(Arrays.asList(0, 1))));
        MembershipManagerImpl membershipManager = this.mockJoinAndReceiveAssignment(false, targetAssignment);
        Assertions.assertEquals((Object)MemberState.RECONCILING, (Object)membershipManager.state());
        this.verifyReconciliationNotTriggered(membershipManager);
        Assertions.assertEquals(Collections.singleton(topicId), (Object)membershipManager.topicsWaitingForMetadata());
        ((ConsumerMetadata)Mockito.verify((Object)this.metadata)).requestUpdate(ArgumentMatchers.anyBoolean());
        String topicName = "topic1";
        this.mockTopicNameInMetadataCache(Collections.singletonMap(topicId, topicName), true);
        membershipManager.onUpdate(null);
        List<TopicIdPartition> expectedAssignmentReconciled = this.topicIdPartitions(topicId, topicName, 0, 1);
        this.verifyReconciliationTriggeredAndCompleted(membershipManager, expectedAssignmentReconciled);
        Assertions.assertEquals((Object)MemberState.ACKNOWLEDGING, (Object)membershipManager.state());
        Assertions.assertTrue((boolean)membershipManager.topicsWaitingForMetadata().isEmpty());
    }

    @Test
    public void testMetadataUpdatesRequestsAnotherUpdateIfNeeded() {
        Uuid topicId = Uuid.randomUuid();
        ConsumerGroupHeartbeatResponseData.Assignment targetAssignment = new ConsumerGroupHeartbeatResponseData.Assignment().setTopicPartitions(Collections.singletonList(new ConsumerGroupHeartbeatResponseData.TopicPartitions().setTopicId(topicId).setPartitions(Arrays.asList(0, 1))));
        MembershipManagerImpl membershipManager = this.mockJoinAndReceiveAssignment(false, targetAssignment);
        Assertions.assertEquals((Object)MemberState.RECONCILING, (Object)membershipManager.state());
        this.verifyReconciliationNotTriggered(membershipManager);
        Assertions.assertEquals(Collections.singleton(topicId), (Object)membershipManager.topicsWaitingForMetadata());
        ((ConsumerMetadata)Mockito.verify((Object)this.metadata)).requestUpdate(ArgumentMatchers.anyBoolean());
        Mockito.when((Object)this.metadata.topicNames()).thenReturn(Collections.emptyMap());
        membershipManager.onUpdate(null);
        this.verifyReconciliationNotTriggered(membershipManager);
        Assertions.assertEquals(Collections.singleton(topicId), (Object)membershipManager.topicsWaitingForMetadata());
        ((ConsumerMetadata)Mockito.verify((Object)this.metadata, (VerificationMode)Mockito.times((int)2))).requestUpdate(ArgumentMatchers.anyBoolean());
    }

    @Test
    public void testRevokePartitionsUsesTopicNamesLocalCacheWhenMetadataNotAvailable() {
        Uuid topicId = Uuid.randomUuid();
        String topicName = "topic1";
        MembershipManagerImpl membershipManager = this.createMembershipManagerJoiningGroup();
        this.mockOwnedPartitionAndAssignmentReceived(membershipManager, topicId, topicName, Collections.emptyList());
        this.receiveAssignment(topicId, Arrays.asList(0, 1), (MembershipManager)membershipManager);
        Assertions.assertEquals((Object)MemberState.ACKNOWLEDGING, (Object)membershipManager.state());
        List<Integer> partitions = Arrays.asList(0, 1);
        Set assignedPartitions = partitions.stream().map(p -> new TopicPartition(topicName, p.intValue())).collect(Collectors.toSet());
        Map<Uuid, TreeSet<Integer>> assignedTopicIdPartitions = Collections.singletonMap(topicId, new TreeSet<Integer>(partitions));
        Assertions.assertEquals(assignedTopicIdPartitions, (Object)membershipManager.currentAssignment());
        Assertions.assertFalse((boolean)membershipManager.reconciliationInProgress());
        this.mockAckSent(membershipManager);
        Mockito.when((Object)this.subscriptionState.assignedPartitions()).thenReturn(assignedPartitions);
        Mockito.when((Object)this.subscriptionState.hasAutoAssignedPartitions()).thenReturn((Object)true);
        this.mockRevocationNoCallbacks(false);
        this.mockTopicNameInMetadataCache(Collections.singletonMap(topicId, topicName), false);
        this.receiveAssignment(topicId, Collections.singletonList(1), (MembershipManager)membershipManager);
        ((ConsumerMetadata)Mockito.verify((Object)this.metadata, (VerificationMode)Mockito.never())).requestUpdate(ArgumentMatchers.anyBoolean());
        List<TopicIdPartition> remainingAssignment = this.topicIdPartitions(topicId, topicName, 1);
        this.testRevocationCompleted(membershipManager, remainingAssignment);
    }

    @Test
    public void testOnSubscriptionUpdatedTransitionsToJoiningOnlyIfNotInGroup() {
        MembershipManagerImpl membershipManager = this.createMemberInStableState();
        ((MembershipManagerImpl)Mockito.verify((Object)membershipManager)).transitionToJoining();
        Mockito.clearInvocations((Object[])new MembershipManagerImpl[]{membershipManager});
        membershipManager.onSubscriptionUpdated();
        ((MembershipManagerImpl)Mockito.verify((Object)membershipManager, (VerificationMode)Mockito.never())).transitionToJoining();
    }

    @Test
    public void testListenerCallbacksBasic() {
        MembershipManagerImpl membershipManager = this.createMemberInStableState();
        CounterConsumerRebalanceListener listener = new CounterConsumerRebalanceListener();
        ConsumerRebalanceListenerInvoker invoker = this.consumerRebalanceListenerInvoker();
        String topicName = "topic1";
        Uuid topicId = Uuid.randomUuid();
        Mockito.when((Object)this.subscriptionState.assignedPartitions()).thenReturn(Collections.emptySet());
        Mockito.when((Object)this.subscriptionState.hasAutoAssignedPartitions()).thenReturn((Object)true);
        Mockito.when((Object)this.subscriptionState.rebalanceListener()).thenReturn(Optional.of(listener));
        ((SubscriptionState)Mockito.doNothing().when((Object)this.subscriptionState)).markPendingRevocation(ArgumentMatchers.anySet());
        Mockito.when((Object)this.metadata.topicNames()).thenReturn(Collections.singletonMap(topicId, topicName));
        Mockito.when((Object)this.metadata.topicNames()).thenReturn(Collections.singletonMap(topicId, topicName));
        this.receiveAssignment(topicId, Arrays.asList(0, 1), (MembershipManager)membershipManager);
        Assertions.assertEquals((Object)MemberState.RECONCILING, (Object)membershipManager.state());
        Assertions.assertTrue((boolean)membershipManager.reconciliationInProgress());
        Assertions.assertEquals((int)0, (int)listener.revokedCount());
        Assertions.assertEquals((int)0, (int)listener.assignedCount());
        Assertions.assertEquals((int)0, (int)listener.lostCount());
        Assertions.assertTrue((boolean)membershipManager.reconciliationInProgress());
        this.performCallback(membershipManager, invoker, ConsumerRebalanceListenerMethodName.ON_PARTITIONS_ASSIGNED, this.topicPartitions(topicName, 0, 1), true);
        Assertions.assertFalse((boolean)membershipManager.reconciliationInProgress());
        membershipManager.onHeartbeatRequestSent();
        Assertions.assertEquals((Object)MemberState.STABLE, (Object)membershipManager.state());
        Assertions.assertEquals(this.topicIdPartitionsMap(topicId, 0, 1), (Object)membershipManager.currentAssignment());
        Assertions.assertEquals((int)0, (int)listener.revokedCount());
        Assertions.assertEquals((int)1, (int)listener.assignedCount());
        Assertions.assertEquals((int)0, (int)listener.lostCount());
        Mockito.when((Object)this.subscriptionState.assignedPartitions()).thenReturn(this.topicPartitions(topicName, 0, 1));
        this.receiveEmptyAssignment((MembershipManager)membershipManager);
        Assertions.assertEquals((Object)MemberState.RECONCILING, (Object)membershipManager.state());
        Assertions.assertTrue((boolean)membershipManager.reconciliationInProgress());
        this.performCallback(membershipManager, invoker, ConsumerRebalanceListenerMethodName.ON_PARTITIONS_REVOKED, this.topicPartitions(topicName, 0, 1), true);
        Assertions.assertTrue((boolean)membershipManager.reconciliationInProgress());
        this.performCallback(membershipManager, invoker, ConsumerRebalanceListenerMethodName.ON_PARTITIONS_ASSIGNED, Collections.emptySortedSet(), true);
        Assertions.assertFalse((boolean)membershipManager.reconciliationInProgress());
        membershipManager.onHeartbeatRequestSent();
        Assertions.assertEquals((Object)MemberState.STABLE, (Object)membershipManager.state());
        Assertions.assertFalse((boolean)membershipManager.reconciliationInProgress());
        Assertions.assertEquals((int)1, (int)listener.revokedCount());
        Assertions.assertEquals((int)2, (int)listener.assignedCount());
        Assertions.assertEquals((int)0, (int)listener.lostCount());
    }

    @Test
    public void testListenerCallbacksThrowsErrorOnPartitionsRevoked() {
        String topicName = "topic1";
        Uuid topicId = Uuid.randomUuid();
        MembershipManagerImpl membershipManager = this.createMemberInStableState();
        this.mockOwnedPartition(membershipManager, topicId, topicName);
        CounterConsumerRebalanceListener listener = new CounterConsumerRebalanceListener(Optional.of(new IllegalArgumentException("Intentional onPartitionsRevoked() error")), Optional.empty(), Optional.empty());
        ConsumerRebalanceListenerInvoker invoker = this.consumerRebalanceListenerInvoker();
        Mockito.when((Object)this.subscriptionState.rebalanceListener()).thenReturn(Optional.of(listener));
        ((SubscriptionState)Mockito.doNothing().when((Object)this.subscriptionState)).markPendingRevocation(ArgumentMatchers.anySet());
        this.receiveEmptyAssignment((MembershipManager)membershipManager);
        Assertions.assertEquals((Object)MemberState.RECONCILING, (Object)membershipManager.state());
        Assertions.assertEquals(this.topicIdPartitionsMap(topicId, 0), (Object)membershipManager.currentAssignment());
        Assertions.assertTrue((boolean)membershipManager.reconciliationInProgress());
        Assertions.assertEquals((int)0, (int)listener.revokedCount());
        Assertions.assertEquals((int)0, (int)listener.assignedCount());
        Assertions.assertEquals((int)0, (int)listener.lostCount());
        Assertions.assertTrue((boolean)membershipManager.reconciliationInProgress());
        this.performCallback(membershipManager, invoker, ConsumerRebalanceListenerMethodName.ON_PARTITIONS_REVOKED, this.topicPartitions(topicName, 0), true);
        Assertions.assertFalse((boolean)membershipManager.reconciliationInProgress());
        Assertions.assertEquals((Object)MemberState.RECONCILING, (Object)membershipManager.state());
        membershipManager.onHeartbeatRequestSent();
        Assertions.assertEquals((Object)MemberState.RECONCILING, (Object)membershipManager.state());
        Assertions.assertEquals((int)1, (int)listener.revokedCount());
        Assertions.assertEquals((int)0, (int)listener.assignedCount());
        Assertions.assertEquals((int)0, (int)listener.lostCount());
    }

    @Test
    public void testListenerCallbacksThrowsErrorOnPartitionsAssigned() {
        MembershipManagerImpl membershipManager = this.createMemberInStableState();
        String topicName = "topic1";
        Uuid topicId = Uuid.randomUuid();
        this.mockOwnedPartition(membershipManager, topicId, topicName);
        CounterConsumerRebalanceListener listener = new CounterConsumerRebalanceListener(Optional.empty(), Optional.of(new IllegalArgumentException("Intentional onPartitionsAssigned() error")), Optional.empty());
        ConsumerRebalanceListenerInvoker invoker = this.consumerRebalanceListenerInvoker();
        Mockito.when((Object)this.subscriptionState.rebalanceListener()).thenReturn(Optional.of(listener));
        ((SubscriptionState)Mockito.doNothing().when((Object)this.subscriptionState)).markPendingRevocation(ArgumentMatchers.anySet());
        this.receiveEmptyAssignment((MembershipManager)membershipManager);
        Assertions.assertEquals((Object)MemberState.RECONCILING, (Object)membershipManager.state());
        Assertions.assertEquals(this.topicIdPartitionsMap(topicId, 0), (Object)membershipManager.currentAssignment());
        Assertions.assertTrue((boolean)membershipManager.reconciliationInProgress());
        Assertions.assertEquals((int)0, (int)listener.revokedCount());
        Assertions.assertEquals((int)0, (int)listener.assignedCount());
        Assertions.assertEquals((int)0, (int)listener.lostCount());
        Assertions.assertTrue((boolean)membershipManager.reconciliationInProgress());
        this.performCallback(membershipManager, invoker, ConsumerRebalanceListenerMethodName.ON_PARTITIONS_REVOKED, this.topicPartitions("topic1", 0), true);
        Assertions.assertTrue((boolean)membershipManager.reconciliationInProgress());
        this.performCallback(membershipManager, invoker, ConsumerRebalanceListenerMethodName.ON_PARTITIONS_ASSIGNED, Collections.emptySortedSet(), true);
        Assertions.assertFalse((boolean)membershipManager.reconciliationInProgress());
        Assertions.assertEquals((Object)MemberState.RECONCILING, (Object)membershipManager.state());
        membershipManager.onHeartbeatRequestSent();
        Assertions.assertEquals((Object)MemberState.RECONCILING, (Object)membershipManager.state());
        Assertions.assertEquals((int)1, (int)listener.revokedCount());
        Assertions.assertEquals((int)1, (int)listener.assignedCount());
        Assertions.assertEquals((int)0, (int)listener.lostCount());
    }

    @Test
    public void testOnPartitionsLostNoError() {
        MembershipManagerImpl membershipManager = this.createMemberInStableState();
        String topicName = "topic1";
        Uuid topicId = Uuid.randomUuid();
        this.mockOwnedPartition(membershipManager, topicId, topicName);
        this.testOnPartitionsLost(Optional.empty());
    }

    @Test
    public void testOnPartitionsLostError() {
        MembershipManagerImpl membershipManager = this.createMemberInStableState();
        String topicName = "topic1";
        Uuid topicId = Uuid.randomUuid();
        this.mockOwnedPartition(membershipManager, topicId, topicName);
        this.testOnPartitionsLost(Optional.of(new KafkaException("Intentional error for test")));
    }

    private void testOnPartitionsLost(Optional<RuntimeException> lostError) {
        MembershipManagerImpl membershipManager = this.createMemberInStableState();
        CounterConsumerRebalanceListener listener = new CounterConsumerRebalanceListener(Optional.empty(), Optional.empty(), lostError);
        ConsumerRebalanceListenerInvoker invoker = this.consumerRebalanceListenerInvoker();
        Mockito.when((Object)this.subscriptionState.rebalanceListener()).thenReturn(Optional.of(listener));
        ((SubscriptionState)Mockito.doNothing().when((Object)this.subscriptionState)).markPendingRevocation(ArgumentMatchers.anySet());
        membershipManager.transitionToFenced();
        Assertions.assertEquals((Object)MemberState.FENCED, (Object)membershipManager.state());
        Assertions.assertEquals(Collections.emptyMap(), (Object)membershipManager.currentAssignment());
        Assertions.assertEquals((int)0, (int)listener.revokedCount());
        Assertions.assertEquals((int)0, (int)listener.assignedCount());
        Assertions.assertEquals((int)0, (int)listener.lostCount());
        this.performCallback(membershipManager, invoker, ConsumerRebalanceListenerMethodName.ON_PARTITIONS_LOST, this.topicPartitions("topic1", 0), true);
        membershipManager.onHeartbeatRequestSent();
        Assertions.assertEquals((Object)MemberState.JOINING, (Object)membershipManager.state());
        Assertions.assertEquals((int)0, (int)listener.revokedCount());
        Assertions.assertEquals((int)0, (int)listener.assignedCount());
        Assertions.assertEquals((int)1, (int)listener.lostCount());
    }

    private ConsumerRebalanceListenerInvoker consumerRebalanceListenerInvoker() {
        ConsumerCoordinatorMetrics coordinatorMetrics = new ConsumerCoordinatorMetrics(this.subscriptionState, new Metrics(), "test-");
        return new ConsumerRebalanceListenerInvoker(new LogContext(), this.subscriptionState, (Time)new MockTime(1L), coordinatorMetrics);
    }

    private SortedSet<TopicPartition> topicPartitions(String topicName, int ... partitions) {
        TreeSet<TopicPartition> topicPartitions = new TreeSet<TopicPartition>((Comparator<TopicPartition>)new Utils.TopicPartitionComparator());
        for (int partition : partitions) {
            topicPartitions.add(new TopicPartition(topicName, partition));
        }
        return topicPartitions;
    }

    private SortedSet<TopicIdPartition> topicIdPartitionsSet(Uuid topicId, String topicName, int ... partitions) {
        TreeSet<TopicIdPartition> topicIdPartitions = new TreeSet<TopicIdPartition>((Comparator<TopicIdPartition>)new Utils.TopicIdPartitionComparator());
        for (int partition : partitions) {
            topicIdPartitions.add(new TopicIdPartition(topicId, new TopicPartition(topicName, partition)));
        }
        return topicIdPartitions;
    }

    private List<TopicIdPartition> topicIdPartitions(Uuid topicId, String topicName, int ... partitions) {
        return new ArrayList<TopicIdPartition>(this.topicIdPartitionsSet(topicId, topicName, partitions));
    }

    private Map<Uuid, SortedSet<Integer>> topicIdPartitionsMap(Uuid topicId, int ... partitions) {
        TreeSet<Integer> topicIdPartitions = new TreeSet<Integer>();
        for (int partition : partitions) {
            topicIdPartitions.add(partition);
        }
        return Collections.singletonMap(topicId, topicIdPartitions);
    }

    private ConsumerRebalanceListenerCallbackCompletedEvent performCallback(MembershipManagerImpl membershipManager, ConsumerRebalanceListenerInvoker invoker, ConsumerRebalanceListenerMethodName expectedMethodName, SortedSet<TopicPartition> expectedPartitions, boolean complete) {
        Assertions.assertEquals((int)1, (int)this.backgroundEventQueue.size());
        Assertions.assertNotNull(this.backgroundEventQueue.peek());
        Assertions.assertInstanceOf(ConsumerRebalanceListenerCallbackNeededEvent.class, this.backgroundEventQueue.peek());
        ConsumerRebalanceListenerCallbackNeededEvent neededEvent = (ConsumerRebalanceListenerCallbackNeededEvent)this.backgroundEventQueue.poll();
        Assertions.assertNotNull((Object)neededEvent);
        Assertions.assertEquals((Object)expectedMethodName, (Object)neededEvent.methodName());
        Assertions.assertEquals(expectedPartitions, (Object)neededEvent.partitions());
        ConsumerRebalanceListenerCallbackCompletedEvent invokedEvent = AsyncKafkaConsumer.invokeRebalanceCallbacks((ConsumerRebalanceListenerInvoker)invoker, (ConsumerRebalanceListenerMethodName)neededEvent.methodName(), (SortedSet)neededEvent.partitions(), (CompletableFuture)neededEvent.future());
        if (complete) {
            this.completeCallback(invokedEvent, membershipManager);
        }
        return invokedEvent;
    }

    private void completeCallback(ConsumerRebalanceListenerCallbackCompletedEvent callbackCompletedEvent, MembershipManagerImpl membershipManager) {
        membershipManager.consumerRebalanceListenerCallbackCompleted(callbackCompletedEvent);
    }

    private void testFenceIsNoOp(MembershipManagerImpl membershipManager) {
        Assertions.assertNotEquals((int)0, (int)membershipManager.memberEpoch());
        ((SubscriptionState)Mockito.verify((Object)this.subscriptionState, (VerificationMode)Mockito.never())).rebalanceListener();
    }

    @Test
    public void testTransitionToStaled() {
        MembershipManager membershipManager = this.memberJoinWithAssignment("topic", Uuid.randomUuid());
        membershipManager.transitionToStale();
        Assertions.assertEquals((int)-1, (int)membershipManager.memberEpoch());
    }

    @Test
    public void testHeartbeatSentOnStaledMember() {
        MembershipManagerImpl membershipManager = this.createMemberInStableState();
        this.subscriptionState.subscribe(Collections.singleton("topic"), Optional.empty());
        this.subscriptionState.assignFromSubscribed(Collections.singleton(new TopicPartition("topic", 0)));
        membershipManager.transitionToStale();
        membershipManager.onHeartbeatRequestSent();
        Assertions.assertEquals((Object)MemberState.JOINING, (Object)membershipManager.state());
        Assertions.assertTrue((boolean)membershipManager.currentAssignment().isEmpty());
        Assertions.assertTrue((boolean)this.subscriptionState.assignedPartitions().isEmpty());
    }

    private void dropAssignedPartitions() {
        TreeSet droppedPartitions = new TreeSet(MembershipManagerImpl.TOPIC_PARTITION_COMPARATOR);
        droppedPartitions.addAll(this.subscriptionState.assignedPartitions());
        this.subscriptionState.assignFromSubscribed(Collections.emptySet());
    }

    @Test
    public void testMemberJoiningTransitionsToStableWhenReceivingEmptyAssignment() {
        MembershipManagerImpl membershipManager = this.createMembershipManagerJoiningGroup(null);
        Assertions.assertEquals((Object)MemberState.JOINING, (Object)membershipManager.state());
        this.receiveEmptyAssignment((MembershipManager)membershipManager);
        Assertions.assertEquals((Object)MemberState.STABLE, (Object)membershipManager.state());
    }

    private MembershipManagerImpl mockMemberSuccessfullyReceivesAndAcksAssignment(Uuid topicId, String topicName, List<Integer> partitions) {
        MembershipManagerImpl membershipManager = this.createMembershipManagerJoiningGroup();
        this.mockOwnedPartitionAndAssignmentReceived(membershipManager, topicId, topicName, Collections.emptyList());
        this.receiveAssignment(topicId, partitions, (MembershipManager)membershipManager);
        List<TopicIdPartition> assignedPartitions = partitions.stream().map(tp -> new TopicIdPartition(topicId, new TopicPartition(topicName, tp.intValue()))).collect(Collectors.toList());
        this.verifyReconciliationTriggeredAndCompleted(membershipManager, assignedPartitions);
        return membershipManager;
    }

    private CompletableFuture<Void> mockEmptyAssignmentAndRevocationStuckOnCommit(MembershipManagerImpl membershipManager) {
        CompletableFuture<Void> commitResult = this.mockRevocationNoCallbacks(true);
        this.receiveEmptyAssignment((MembershipManager)membershipManager);
        this.verifyReconciliationTriggered(membershipManager);
        Mockito.clearInvocations((Object[])new MembershipManagerImpl[]{membershipManager});
        Assertions.assertEquals((Object)MemberState.RECONCILING, (Object)membershipManager.state());
        return commitResult;
    }

    private CompletableFuture<Void> mockNewAssignmentAndRevocationStuckOnCommit(MembershipManagerImpl membershipManager, Uuid topicId, String topicName, List<Integer> partitions, boolean mockMetadata) {
        CompletableFuture<Void> commitResult = this.mockRevocationNoCallbacks(true);
        if (mockMetadata) {
            Mockito.when((Object)this.metadata.topicNames()).thenReturn(Collections.singletonMap(topicId, topicName));
        }
        this.receiveAssignment(topicId, partitions, (MembershipManager)membershipManager);
        this.verifyReconciliationTriggered(membershipManager);
        Mockito.clearInvocations((Object[])new MembershipManagerImpl[]{membershipManager});
        Assertions.assertEquals((Object)MemberState.RECONCILING, (Object)membershipManager.state());
        return commitResult;
    }

    private void verifyReconciliationTriggered(MembershipManagerImpl membershipManager) {
        ((MembershipManagerImpl)Mockito.verify((Object)membershipManager)).markReconciliationInProgress();
        Assertions.assertEquals((Object)MemberState.RECONCILING, (Object)membershipManager.state());
    }

    private void verifyReconciliationNotTriggered(MembershipManagerImpl membershipManager) {
        ((MembershipManagerImpl)Mockito.verify((Object)membershipManager, (VerificationMode)Mockito.never())).markReconciliationInProgress();
        ((MembershipManagerImpl)Mockito.verify((Object)membershipManager, (VerificationMode)Mockito.never())).markReconciliationCompleted();
    }

    private void verifyReconciliationTriggeredAndCompleted(MembershipManagerImpl membershipManager, List<TopicIdPartition> expectedAssignment) {
        Assertions.assertEquals((Object)MemberState.ACKNOWLEDGING, (Object)membershipManager.state());
        ((MembershipManagerImpl)Mockito.verify((Object)membershipManager)).markReconciliationInProgress();
        ((MembershipManagerImpl)Mockito.verify((Object)membershipManager)).markReconciliationCompleted();
        Assertions.assertFalse((boolean)membershipManager.reconciliationInProgress());
        List<TopicPartition> expectedTopicPartitions = this.buildTopicPartitions(expectedAssignment);
        ((SubscriptionState)Mockito.verify((Object)this.subscriptionState)).assignFromSubscribed(new HashSet<TopicPartition>(expectedTopicPartitions));
        Map<Uuid, SortedSet<Integer>> assignmentByTopicId = this.assignmentByTopicId(expectedAssignment);
        Assertions.assertEquals(assignmentByTopicId, (Object)membershipManager.currentAssignment());
        ((CommitRequestManager)Mockito.verify((Object)this.commitRequestManager)).resetAutoCommitTimer();
    }

    private List<TopicPartition> buildTopicPartitions(List<TopicIdPartition> topicIdPartitions) {
        return topicIdPartitions.stream().map(TopicIdPartition::topicPartition).collect(Collectors.toList());
    }

    private void mockAckSent(MembershipManagerImpl membershipManager) {
        membershipManager.onHeartbeatRequestSent();
    }

    private void mockTopicNameInMetadataCache(Map<Uuid, String> topicNames, boolean isPresent) {
        if (isPresent) {
            Mockito.when((Object)this.metadata.topicNames()).thenReturn(topicNames);
        } else {
            Mockito.when((Object)this.metadata.topicNames()).thenReturn(Collections.emptyMap());
        }
    }

    private CompletableFuture<Void> mockRevocationNoCallbacks(boolean withAutoCommit) {
        ((SubscriptionState)Mockito.doNothing().when((Object)this.subscriptionState)).markPendingRevocation(ArgumentMatchers.anySet());
        Mockito.when((Object)this.subscriptionState.rebalanceListener()).thenReturn(Optional.empty()).thenReturn(Optional.empty());
        if (withAutoCommit) {
            Mockito.when((Object)this.commitRequestManager.autoCommitEnabled()).thenReturn((Object)true);
            CompletableFuture<Void> commitResult = new CompletableFuture<Void>();
            Mockito.when((Object)this.commitRequestManager.maybeAutoCommitAllConsumedNow((Optional)ArgumentMatchers.any(), ArgumentMatchers.anyBoolean())).thenReturn(commitResult);
            return commitResult;
        }
        return CompletableFuture.completedFuture(null);
    }

    private void mockMemberHasAutoAssignedPartition() {
        String topicName = "topic1";
        TopicPartition ownedPartition = new TopicPartition(topicName, 0);
        Mockito.when((Object)this.subscriptionState.assignedPartitions()).thenReturn(Collections.singleton(ownedPartition));
        Mockito.when((Object)this.subscriptionState.hasAutoAssignedPartitions()).thenReturn((Object)true);
        Mockito.when((Object)this.subscriptionState.rebalanceListener()).thenReturn(Optional.empty()).thenReturn(Optional.empty());
    }

    private void testRevocationOfAllPartitionsCompleted(MembershipManagerImpl membershipManager) {
        this.testRevocationCompleted(membershipManager, Collections.emptyList());
    }

    private void testRevocationCompleted(MembershipManagerImpl membershipManager, List<TopicIdPartition> expectedCurrentAssignment) {
        Assertions.assertEquals((Object)MemberState.ACKNOWLEDGING, (Object)membershipManager.state());
        Map<Uuid, SortedSet<Integer>> assignmentByTopicId = this.assignmentByTopicId(expectedCurrentAssignment);
        Assertions.assertEquals(assignmentByTopicId, (Object)membershipManager.currentAssignment());
        Assertions.assertFalse((boolean)membershipManager.reconciliationInProgress());
        ((SubscriptionState)Mockito.verify((Object)this.subscriptionState)).markPendingRevocation(ArgumentMatchers.anySet());
        List<TopicPartition> expectedTopicPartitionAssignment = this.buildTopicPartitions(expectedCurrentAssignment);
        ((SubscriptionState)Mockito.verify((Object)this.subscriptionState)).assignFromSubscribed(new HashSet<TopicPartition>(expectedTopicPartitionAssignment));
    }

    private Map<Uuid, SortedSet<Integer>> assignmentByTopicId(List<TopicIdPartition> topicIdPartitions) {
        HashMap<Uuid, SortedSet<Integer>> assignmentByTopicId = new HashMap<Uuid, SortedSet<Integer>>();
        topicIdPartitions.forEach(topicIdPartition -> {
            Uuid topicId = topicIdPartition.topicId();
            assignmentByTopicId.computeIfAbsent(topicId, k -> new TreeSet()).add(topicIdPartition.partition());
        });
        return assignmentByTopicId;
    }

    private void mockOwnedPartitionAndAssignmentReceived(MembershipManagerImpl membershipManager, Uuid topicId, String topicName, List<TopicIdPartition> previouslyOwned) {
        Mockito.when((Object)this.subscriptionState.assignedPartitions()).thenReturn(this.getTopicPartitions(previouslyOwned));
        membershipManager.updateCurrentAssignment(new HashSet<TopicIdPartition>(previouslyOwned));
        Mockito.when((Object)this.metadata.topicNames()).thenReturn(Collections.singletonMap(topicId, topicName));
        Mockito.when((Object)this.subscriptionState.hasAutoAssignedPartitions()).thenReturn((Object)true);
        Mockito.when((Object)this.subscriptionState.rebalanceListener()).thenReturn(Optional.empty()).thenReturn(Optional.empty());
    }

    private Set<TopicPartition> getTopicPartitions(List<TopicIdPartition> topicIdPartitions) {
        return topicIdPartitions.stream().map(topicIdPartition -> new TopicPartition(topicIdPartition.topic(), topicIdPartition.partition())).collect(Collectors.toSet());
    }

    private void mockOwnedPartition(MembershipManagerImpl membershipManager, Uuid topicId, String topic) {
        int partition = 0;
        TopicPartition previouslyOwned = new TopicPartition(topic, partition);
        membershipManager.updateCurrentAssignment(Collections.singleton(new TopicIdPartition(topicId, new TopicPartition(topic, partition))));
        Mockito.when((Object)this.subscriptionState.assignedPartitions()).thenReturn(Collections.singleton(previouslyOwned));
        Mockito.when((Object)this.subscriptionState.hasAutoAssignedPartitions()).thenReturn((Object)true);
    }

    private MembershipManagerImpl mockJoinAndReceiveAssignment(boolean expectSubscriptionUpdated) {
        return this.mockJoinAndReceiveAssignment(expectSubscriptionUpdated, this.createAssignment(expectSubscriptionUpdated));
    }

    private MembershipManagerImpl mockJoinAndReceiveAssignment(boolean expectSubscriptionUpdated, ConsumerGroupHeartbeatResponseData.Assignment assignment) {
        MembershipManagerImpl membershipManager = this.createMembershipManagerJoiningGroup();
        ConsumerGroupHeartbeatResponse heartbeatResponse = this.createConsumerGroupHeartbeatResponse(assignment);
        Mockito.when((Object)this.subscriptionState.hasAutoAssignedPartitions()).thenReturn((Object)true);
        Mockito.when((Object)this.subscriptionState.rebalanceListener()).thenReturn(Optional.empty()).thenReturn(Optional.empty());
        membershipManager.onHeartbeatResponseReceived(heartbeatResponse.data());
        if (expectSubscriptionUpdated) {
            ((SubscriptionState)Mockito.verify((Object)this.subscriptionState)).assignFromSubscribed(ArgumentMatchers.anyCollection());
        } else {
            ((SubscriptionState)Mockito.verify((Object)this.subscriptionState, (VerificationMode)Mockito.never())).assignFromSubscribed(ArgumentMatchers.anyCollection());
        }
        return membershipManager;
    }

    private MembershipManagerImpl createMemberInStableState() {
        return this.createMemberInStableState(null);
    }

    private MembershipManagerImpl createMemberInStableState(String groupInstanceId) {
        MembershipManagerImpl membershipManager = this.createMembershipManagerJoiningGroup(groupInstanceId);
        ConsumerGroupHeartbeatResponse heartbeatResponse = this.createConsumerGroupHeartbeatResponse(null);
        membershipManager.onHeartbeatResponseReceived(heartbeatResponse.data());
        Assertions.assertEquals((Object)MemberState.STABLE, (Object)membershipManager.state());
        return membershipManager;
    }

    private void receiveAssignment(Uuid topicId, List<Integer> partitions, MembershipManager membershipManager) {
        ConsumerGroupHeartbeatResponseData.Assignment targetAssignment = new ConsumerGroupHeartbeatResponseData.Assignment().setTopicPartitions(Collections.singletonList(new ConsumerGroupHeartbeatResponseData.TopicPartitions().setTopicId(topicId).setPartitions(partitions)));
        ConsumerGroupHeartbeatResponse heartbeatResponse = this.createConsumerGroupHeartbeatResponse(targetAssignment);
        membershipManager.onHeartbeatResponseReceived(heartbeatResponse.data());
    }

    private void receiveAssignmentAfterRejoin(Uuid topicId, List<Integer> partitions, MembershipManager membershipManager) {
        ConsumerGroupHeartbeatResponseData.Assignment targetAssignment = new ConsumerGroupHeartbeatResponseData.Assignment().setTopicPartitions(Collections.singletonList(new ConsumerGroupHeartbeatResponseData.TopicPartitions().setTopicId(topicId).setPartitions(partitions)));
        ConsumerGroupHeartbeatResponse heartbeatResponse = this.createConsumerGroupHeartbeatResponseWithBumpedEpoch(targetAssignment);
        membershipManager.onHeartbeatResponseReceived(heartbeatResponse.data());
    }

    private void receiveEmptyAssignment(MembershipManager membershipManager) {
        ConsumerGroupHeartbeatResponseData.Assignment targetAssignment = new ConsumerGroupHeartbeatResponseData.Assignment().setTopicPartitions(Collections.emptyList());
        ConsumerGroupHeartbeatResponse heartbeatResponse = this.createConsumerGroupHeartbeatResponse(targetAssignment);
        membershipManager.onHeartbeatResponseReceived(heartbeatResponse.data());
    }

    private void testFencedMemberReleasesAssignmentAndTransitionsToJoining(MembershipManager membershipManager) {
        this.mockMemberHasAutoAssignedPartition();
        membershipManager.transitionToFenced();
        Assertions.assertEquals((Object)MEMBER_ID, (Object)membershipManager.memberId());
        Assertions.assertEquals((int)0, (int)membershipManager.memberEpoch());
        Assertions.assertEquals((Object)MemberState.JOINING, (Object)membershipManager.state());
    }

    private void testLeaveGroupReleasesAssignmentAndResetsEpochToSendLeaveGroup(MembershipManager membershipManager) {
        this.mockLeaveGroup();
        CompletableFuture leaveResult = membershipManager.leaveGroup();
        Assertions.assertEquals((Object)MemberState.LEAVING, (Object)membershipManager.state());
        Assertions.assertFalse((boolean)leaveResult.isDone(), (String)"Leave group result should not complete until the heartbeat request to leave is sent out.");
        membershipManager.onHeartbeatRequestSent();
        Assertions.assertEquals((Object)MemberState.UNSUBSCRIBED, (Object)membershipManager.state());
        Assertions.assertTrue((boolean)leaveResult.isDone());
        Assertions.assertFalse((boolean)leaveResult.isCompletedExceptionally());
        Assertions.assertEquals((Object)MEMBER_ID, (Object)membershipManager.memberId());
        Assertions.assertEquals((int)-1, (int)membershipManager.memberEpoch());
        Assertions.assertTrue((boolean)membershipManager.currentAssignment().isEmpty());
        ((SubscriptionState)Mockito.verify((Object)this.subscriptionState)).assignFromSubscribed(Collections.emptySet());
    }

    private void mockLeaveGroup() {
        this.mockMemberHasAutoAssignedPartition();
        ((SubscriptionState)Mockito.doNothing().when((Object)this.subscriptionState)).markPendingRevocation(ArgumentMatchers.anySet());
    }

    private ConsumerRebalanceListenerCallbackCompletedEvent mockPrepareLeavingStuckOnUserCallback(MembershipManagerImpl membershipManager, ConsumerRebalanceListenerInvoker invoker) {
        String topicName = "topic1";
        TopicPartition ownedPartition = new TopicPartition(topicName, 0);
        CounterConsumerRebalanceListener listener = new CounterConsumerRebalanceListener();
        Mockito.when((Object)this.subscriptionState.assignedPartitions()).thenReturn(Collections.singleton(ownedPartition));
        Mockito.when((Object)this.subscriptionState.hasAutoAssignedPartitions()).thenReturn((Object)true);
        Mockito.when((Object)this.subscriptionState.rebalanceListener()).thenReturn(Optional.of(listener));
        ((SubscriptionState)Mockito.doNothing().when((Object)this.subscriptionState)).markPendingRevocation(ArgumentMatchers.anySet());
        Mockito.when((Object)this.commitRequestManager.autoCommitEnabled()).thenReturn((Object)false);
        membershipManager.leaveGroup();
        return this.performCallback(membershipManager, invoker, ConsumerRebalanceListenerMethodName.ON_PARTITIONS_REVOKED, this.topicPartitions(ownedPartition.topic(), ownedPartition.partition()), false);
    }

    private void testStateUpdateOnFatalFailure(MembershipManagerImpl membershipManager) {
        String memberId = membershipManager.memberId();
        int lastEpoch = membershipManager.memberEpoch();
        Mockito.when((Object)this.subscriptionState.hasAutoAssignedPartitions()).thenReturn((Object)true);
        membershipManager.transitionToFatal();
        Assertions.assertEquals((Object)MemberState.FATAL, (Object)membershipManager.state());
        Assertions.assertEquals((Object)memberId, (Object)membershipManager.memberId());
        Assertions.assertEquals((int)lastEpoch, (int)membershipManager.memberEpoch());
    }

    private ConsumerGroupHeartbeatResponse createConsumerGroupHeartbeatResponse(ConsumerGroupHeartbeatResponseData.Assignment assignment) {
        return new ConsumerGroupHeartbeatResponse(new ConsumerGroupHeartbeatResponseData().setErrorCode(Errors.NONE.code()).setMemberId(MEMBER_ID).setMemberEpoch(1).setAssignment(assignment));
    }

    private ConsumerGroupHeartbeatResponse createConsumerGroupHeartbeatResponseWithBumpedEpoch(ConsumerGroupHeartbeatResponseData.Assignment assignment) {
        return new ConsumerGroupHeartbeatResponse(new ConsumerGroupHeartbeatResponseData().setErrorCode(Errors.NONE.code()).setMemberId(MEMBER_ID).setMemberEpoch(2).setAssignment(assignment));
    }

    private ConsumerGroupHeartbeatResponse createConsumerGroupHeartbeatResponseWithError() {
        return new ConsumerGroupHeartbeatResponse(new ConsumerGroupHeartbeatResponseData().setErrorCode(Errors.UNKNOWN_MEMBER_ID.code()).setMemberId(MEMBER_ID).setMemberEpoch(5));
    }

    private ConsumerGroupHeartbeatResponseData.Assignment createAssignment(boolean mockMetadata) {
        Uuid topic1 = Uuid.randomUuid();
        Uuid topic2 = Uuid.randomUuid();
        if (mockMetadata) {
            HashMap<Uuid, String> topicNames = new HashMap<Uuid, String>();
            topicNames.put(topic1, "topic1");
            topicNames.put(topic2, "topic2");
            Mockito.when((Object)this.metadata.topicNames()).thenReturn(topicNames);
        }
        return new ConsumerGroupHeartbeatResponseData.Assignment().setTopicPartitions(Arrays.asList(new ConsumerGroupHeartbeatResponseData.TopicPartitions().setTopicId(topic1).setPartitions(Arrays.asList(0, 1, 2)), new ConsumerGroupHeartbeatResponseData.TopicPartitions().setTopicId(topic2).setPartitions(Arrays.asList(3, 4, 5))));
    }

    private MembershipManager memberJoinWithAssignment(String topicName, Uuid topicId) {
        MembershipManagerImpl membershipManager = this.mockJoinAndReceiveAssignment(true);
        membershipManager.onHeartbeatRequestSent();
        Mockito.when((Object)this.metadata.topicNames()).thenReturn(Collections.singletonMap(topicId, topicName));
        this.receiveAssignment(topicId, Collections.singletonList(0), (MembershipManager)membershipManager);
        membershipManager.onHeartbeatRequestSent();
        Assertions.assertFalse((boolean)membershipManager.currentAssignment().isEmpty());
        return membershipManager;
    }
}

