/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.network;

import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;

public class SslSender
extends Thread {
    private final String tlsProtocol;
    private final InetSocketAddress serverAddress;
    private final byte[] payload;
    private final CountDownLatch handshaked = new CountDownLatch(1);

    public SslSender(String tlsProtocol, InetSocketAddress serverAddress, byte[] payload) {
        this.tlsProtocol = tlsProtocol;
        this.serverAddress = serverAddress;
        this.payload = payload;
        this.setDaemon(true);
        this.setName("SslSender - " + payload.length + " bytes @ " + serverAddress);
    }

    @Override
    public void run() {
        try {
            SSLContext sc = SSLContext.getInstance(this.tlsProtocol);
            sc.init(null, new TrustManager[]{new NaiveTrustManager()}, new SecureRandom());
            try (SSLSocket connection = (SSLSocket)sc.getSocketFactory().createSocket(this.serverAddress.getAddress(), this.serverAddress.getPort());){
                OutputStream os = connection.getOutputStream();
                connection.startHandshake();
                this.handshaked.countDown();
                os.write(this.payload);
                os.flush();
            }
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
        }
    }

    public boolean waitForHandshake(long timeoutMillis) throws InterruptedException {
        return this.handshaked.await(timeoutMillis, TimeUnit.MILLISECONDS);
    }

    private static class NaiveTrustManager
    implements X509TrustManager {
        private NaiveTrustManager() {
        }

        @Override
        public void checkClientTrusted(X509Certificate[] x509Certificates, String s) {
        }

        @Override
        public void checkServerTrusted(X509Certificate[] x509Certificates, String s) {
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return new X509Certificate[0];
        }
    }
}

