/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.consumer.internals;

import org.apache.kafka.clients.consumer.internals.TimedRequestState;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Timer;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TimedRequestStateTest {
    private static final long DEFAULT_TIMEOUT_MS = 30000L;
    private final Time time = new MockTime();

    @Test
    public void testIsExpired() {
        TimedRequestState state = new TimedRequestState(new LogContext(), this.getClass().getSimpleName(), 100L, 1000L, this.time.timer(30000L));
        Assertions.assertFalse((boolean)state.isExpired());
        this.time.sleep(30000L);
        Assertions.assertTrue((boolean)state.isExpired());
    }

    @Test
    public void testRemainingMs() {
        TimedRequestState state = new TimedRequestState(new LogContext(), this.getClass().getSimpleName(), 100L, 1000L, this.time.timer(30000L));
        Assertions.assertEquals((long)30000L, (long)state.remainingMs());
        this.time.sleep(30000L);
        Assertions.assertEquals((long)0L, (long)state.remainingMs());
    }

    @Test
    public void testDeadlineTimer() {
        long deadlineMs = this.time.milliseconds() + 30000L;
        Timer timer = TimedRequestState.deadlineTimer((Time)this.time, (long)deadlineMs);
        Assertions.assertEquals((long)30000L, (long)timer.remainingMs());
        timer.sleep(30000L);
        Assertions.assertEquals((long)0L, (long)timer.remainingMs());
    }

    @Test
    public void testAllowOverdueDeadlineTimer() {
        long deadlineMs = this.time.milliseconds() - 30000L;
        Timer timer = TimedRequestState.deadlineTimer((Time)this.time, (long)deadlineMs);
        Assertions.assertEquals((long)0L, (long)timer.remainingMs());
    }

    @Test
    public void testToStringUpdatesTimer() {
        TimedRequestState state = new TimedRequestState(new LogContext(), this.getClass().getSimpleName(), 100L, 1000L, this.time.timer(30000L));
        this.assertToString(state, 30000L);
        this.time.sleep(30000L);
        this.assertToString(state, 0L);
    }

    private void assertToString(TimedRequestState state, long timerMs) {
        Assertions.assertTrue((boolean)state.toString().contains("remainingMs=" + timerMs + "}"));
    }
}

