/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.consumer.internals;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.CompletableFuture;
import org.apache.kafka.clients.ClientResponse;
import org.apache.kafka.clients.RequestCompletionHandler;
import org.apache.kafka.clients.consumer.ConsumerConfig;
import org.apache.kafka.clients.consumer.internals.NetworkClientDelegate;
import org.apache.kafka.clients.consumer.internals.TopicMetadataRequestManager;
import org.apache.kafka.common.Cluster;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.errors.NetworkException;
import org.apache.kafka.common.errors.RetriableException;
import org.apache.kafka.common.errors.TimeoutException;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.AbstractResponse;
import org.apache.kafka.common.requests.MetadataRequest;
import org.apache.kafka.common.requests.MetadataResponse;
import org.apache.kafka.common.requests.RequestHeader;
import org.apache.kafka.common.requests.RequestTestUtils;
import org.apache.kafka.common.serialization.StringDeserializer;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.common.utils.Time;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;
import org.mockito.Mockito;

public class TopicMetadataRequestManagerTest {
    private MockTime time;
    private TopicMetadataRequestManager topicMetadataRequestManager;

    @BeforeEach
    public void setup() {
        this.time = new MockTime();
        Properties props = new Properties();
        props.put("retry.backoff.ms", (Object)100);
        props.put("allow.auto.create.topics", (Object)false);
        props.put("key.deserializer", StringDeserializer.class);
        props.put("value.deserializer", StringDeserializer.class);
        this.topicMetadataRequestManager = (TopicMetadataRequestManager)Mockito.spy((Object)new TopicMetadataRequestManager(new LogContext(), (Time)this.time, new ConsumerConfig(props)));
    }

    @Test
    public void testPoll_SuccessfulRequestTopicMetadata() {
        String topic = "hello";
        this.topicMetadataRequestManager.requestTopicMetadata(topic, Long.MAX_VALUE);
        this.time.sleep(100L);
        NetworkClientDelegate.PollResult res = this.topicMetadataRequestManager.poll(this.time.milliseconds());
        Assertions.assertEquals((int)1, (int)res.unsentRequests.size());
    }

    @Test
    public void testPoll_SuccessfulRequestAllTopicsMetadata() {
        this.topicMetadataRequestManager.requestAllTopicsMetadata(Long.MAX_VALUE);
        this.time.sleep(100L);
        NetworkClientDelegate.PollResult res = this.topicMetadataRequestManager.poll(this.time.milliseconds());
        Assertions.assertEquals((int)1, (int)res.unsentRequests.size());
    }

    @ParameterizedTest
    @MethodSource(value={"exceptionProvider"})
    public void testTopicExceptionAndInflightRequests(Errors error, boolean shouldRetry) {
        String topic = "hello";
        this.topicMetadataRequestManager.requestTopicMetadata(topic, Long.MAX_VALUE);
        this.time.sleep(100L);
        NetworkClientDelegate.PollResult res = this.topicMetadataRequestManager.poll(this.time.milliseconds());
        ((NetworkClientDelegate.UnsentRequest)res.unsentRequests.get(0)).future().complete(this.buildTopicMetadataClientResponse((NetworkClientDelegate.UnsentRequest)res.unsentRequests.get(0), topic, error));
        List inflights = this.topicMetadataRequestManager.inflightRequests();
        if (shouldRetry) {
            Assertions.assertEquals((int)1, (int)inflights.size());
            Assertions.assertEquals((Object)topic, (Object)((TopicMetadataRequestManager.TopicMetadataRequestState)inflights.get(0)).topic());
        } else {
            Assertions.assertEquals((int)0, (int)inflights.size());
        }
    }

    @ParameterizedTest
    @MethodSource(value={"exceptionProvider"})
    public void testAllTopicsExceptionAndInflightRequests(Errors error, boolean shouldRetry) {
        this.topicMetadataRequestManager.requestAllTopicsMetadata(Long.MAX_VALUE);
        this.time.sleep(100L);
        NetworkClientDelegate.PollResult res = this.topicMetadataRequestManager.poll(this.time.milliseconds());
        ((NetworkClientDelegate.UnsentRequest)res.unsentRequests.get(0)).future().complete(this.buildAllTopicsMetadataClientResponse((NetworkClientDelegate.UnsentRequest)res.unsentRequests.get(0), error));
        List inflights = this.topicMetadataRequestManager.inflightRequests();
        if (shouldRetry) {
            Assertions.assertEquals((int)1, (int)inflights.size());
        } else {
            Assertions.assertEquals((int)0, (int)inflights.size());
        }
    }

    @Test
    public void testExpiringRequest() {
        String topic = "hello";
        long now = this.time.milliseconds();
        CompletableFuture future = this.topicMetadataRequestManager.requestTopicMetadata(topic, now + 1000L);
        Assertions.assertEquals((int)1, (int)this.topicMetadataRequestManager.inflightRequests().size());
        NetworkClientDelegate.PollResult res = this.topicMetadataRequestManager.poll(this.time.milliseconds());
        Assertions.assertEquals((int)1, (int)res.unsentRequests.size());
        ((NetworkClientDelegate.UnsentRequest)res.unsentRequests.get(0)).future().complete(this.buildTopicMetadataClientResponse((NetworkClientDelegate.UnsentRequest)res.unsentRequests.get(0), topic, Errors.REQUEST_TIMED_OUT));
        this.time.sleep(500L);
        res = this.topicMetadataRequestManager.poll(this.time.milliseconds());
        Assertions.assertEquals((int)1, (int)res.unsentRequests.size());
        ((NetworkClientDelegate.UnsentRequest)res.unsentRequests.get(0)).future().complete(this.buildTopicMetadataClientResponse((NetworkClientDelegate.UnsentRequest)res.unsentRequests.get(0), topic, Errors.REQUEST_TIMED_OUT));
        this.time.sleep(1000L);
        res = this.topicMetadataRequestManager.poll(this.time.milliseconds());
        Assertions.assertEquals((int)0, (int)res.unsentRequests.size());
        Assertions.assertEquals((int)0, (int)this.topicMetadataRequestManager.inflightRequests().size());
        Assertions.assertTrue((boolean)future.isCompletedExceptionally());
    }

    @ParameterizedTest
    @MethodSource(value={"hardFailureExceptionProvider"})
    public void testHardFailures(Exception exception) {
        String topic = "hello";
        this.topicMetadataRequestManager.requestTopicMetadata(topic, Long.MAX_VALUE);
        NetworkClientDelegate.PollResult res = this.topicMetadataRequestManager.poll(this.time.milliseconds());
        Assertions.assertEquals((int)1, (int)res.unsentRequests.size());
        ((NetworkClientDelegate.UnsentRequest)res.unsentRequests.get(0)).future().completeExceptionally(exception);
        if (exception instanceof RetriableException) {
            Assertions.assertFalse((boolean)this.topicMetadataRequestManager.inflightRequests().isEmpty());
        } else {
            Assertions.assertTrue((boolean)this.topicMetadataRequestManager.inflightRequests().isEmpty());
        }
    }

    @Test
    public void testNetworkTimeout() {
        String topic = "hello";
        this.topicMetadataRequestManager.requestTopicMetadata(topic, Long.MAX_VALUE);
        NetworkClientDelegate.PollResult res = this.topicMetadataRequestManager.poll(this.time.milliseconds());
        Assertions.assertEquals((int)1, (int)res.unsentRequests.size());
        NetworkClientDelegate.PollResult res2 = this.topicMetadataRequestManager.poll(this.time.milliseconds());
        Assertions.assertEquals((int)0, (int)res2.unsentRequests.size());
        ((NetworkClientDelegate.UnsentRequest)res.unsentRequests.get(0)).handler().onFailure(this.time.milliseconds(), (RuntimeException)((Object)new TimeoutException()));
        long backoffMs = ((TopicMetadataRequestManager.TopicMetadataRequestState)this.topicMetadataRequestManager.inflightRequests().get(0)).remainingBackoffMs(this.time.milliseconds());
        this.time.sleep(backoffMs - 1L);
        res2 = this.topicMetadataRequestManager.poll(this.time.milliseconds());
        Assertions.assertEquals((int)0, (int)res2.unsentRequests.size());
        this.time.sleep(1L);
        res2 = this.topicMetadataRequestManager.poll(this.time.milliseconds());
        Assertions.assertEquals((int)1, (int)res2.unsentRequests.size());
        ((NetworkClientDelegate.UnsentRequest)res2.unsentRequests.get(0)).future().complete(this.buildTopicMetadataClientResponse((NetworkClientDelegate.UnsentRequest)res2.unsentRequests.get(0), topic, Errors.NONE));
        Assertions.assertTrue((boolean)this.topicMetadataRequestManager.inflightRequests().isEmpty());
    }

    private ClientResponse buildTopicMetadataClientResponse(NetworkClientDelegate.UnsentRequest request, String topic, Errors error) {
        AbstractRequest abstractRequest = request.requestBuilder().build();
        Assertions.assertInstanceOf(MetadataRequest.class, (Object)abstractRequest);
        MetadataRequest metadataRequest = (MetadataRequest)abstractRequest;
        Cluster cluster = TopicMetadataRequestManagerTest.mockCluster(3, 0);
        ArrayList<MetadataResponse.TopicMetadata> topics = new ArrayList<MetadataResponse.TopicMetadata>();
        topics.add(new MetadataResponse.TopicMetadata(error, topic, false, Collections.emptyList()));
        MetadataResponse metadataResponse = RequestTestUtils.metadataResponse(cluster.nodes(), cluster.clusterResource().clusterId(), cluster.controller().id(), topics);
        return new ClientResponse(new RequestHeader(ApiKeys.METADATA, metadataRequest.version(), "mockClientId", 1), (RequestCompletionHandler)request.handler(), "-1", this.time.milliseconds(), this.time.milliseconds(), false, null, null, (AbstractResponse)metadataResponse);
    }

    private ClientResponse buildAllTopicsMetadataClientResponse(NetworkClientDelegate.UnsentRequest request, Errors error) {
        AbstractRequest abstractRequest = request.requestBuilder().build();
        Assertions.assertInstanceOf(MetadataRequest.class, (Object)abstractRequest);
        MetadataRequest metadataRequest = (MetadataRequest)abstractRequest;
        Cluster cluster = TopicMetadataRequestManagerTest.mockCluster(3, 0);
        ArrayList<MetadataResponse.TopicMetadata> topics = new ArrayList<MetadataResponse.TopicMetadata>();
        topics.add(new MetadataResponse.TopicMetadata(error, "topic1", false, Collections.emptyList()));
        topics.add(new MetadataResponse.TopicMetadata(error, "topic2", false, Collections.emptyList()));
        MetadataResponse metadataResponse = RequestTestUtils.metadataResponse(cluster.nodes(), cluster.clusterResource().clusterId(), cluster.controller().id(), topics);
        return new ClientResponse(new RequestHeader(ApiKeys.METADATA, metadataRequest.version(), "mockClientId", 1), (RequestCompletionHandler)request.handler(), "-1", this.time.milliseconds(), this.time.milliseconds(), false, null, null, (AbstractResponse)metadataResponse);
    }

    private static Cluster mockCluster(int numNodes, int controllerIndex) {
        HashMap<Integer, Node> nodes = new HashMap<Integer, Node>();
        for (int i = 0; i < numNodes; ++i) {
            nodes.put(i, new Node(i, "localhost", 8121 + i));
        }
        return new Cluster("mockClusterId", nodes.values(), Collections.emptySet(), Collections.emptySet(), Collections.emptySet(), (Node)nodes.get(controllerIndex));
    }

    private static Collection<Arguments> exceptionProvider() {
        return Arrays.asList(Arguments.of((Object[])new Object[]{Errors.UNKNOWN_TOPIC_OR_PARTITION, false}), Arguments.of((Object[])new Object[]{Errors.INVALID_TOPIC_EXCEPTION, false}), Arguments.of((Object[])new Object[]{Errors.UNKNOWN_SERVER_ERROR, false}), Arguments.of((Object[])new Object[]{Errors.NETWORK_EXCEPTION, true}), Arguments.of((Object[])new Object[]{Errors.NONE, false}));
    }

    private static Collection<Arguments> hardFailureExceptionProvider() {
        return Arrays.asList(Arguments.of((Object[])new Object[]{new TimeoutException("timeout")}), Arguments.of((Object[])new Object[]{new KafkaException("non-retriable exception")}), Arguments.of((Object[])new Object[]{new NetworkException("retriable-exception")}));
    }
}

