/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.security.oauthbearer.internals.secured;

import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.kafka.common.config.SslConfigs;
import org.apache.kafka.common.security.oauthbearer.internals.secured.JaasOptionsUtils;
import org.apache.kafka.common.security.oauthbearer.internals.secured.OAuthBearerTest;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class JaasOptionsUtilsTest
extends OAuthBearerTest {
    @Test
    public void testSSLClientConfig() {
        HashMap<String, String> options = new HashMap<String, String>();
        String sslKeystore = "test.keystore.jks";
        String sslTruststore = "test.truststore.jks";
        options.put("ssl.keystore.location", sslKeystore);
        options.put("ssl.keystore.password", "$3cr3+");
        options.put("ssl.truststore.location", sslTruststore);
        JaasOptionsUtils jou = new JaasOptionsUtils(options);
        Map sslClientConfig = jou.getSslClientConfig();
        Assertions.assertNotNull((Object)sslClientConfig);
        Assertions.assertEquals((Object)sslKeystore, sslClientConfig.get("ssl.keystore.location"));
        Assertions.assertEquals((Object)sslTruststore, sslClientConfig.get("ssl.truststore.location"));
        Assertions.assertEquals((Object)SslConfigs.DEFAULT_SSL_PROTOCOL, sslClientConfig.get("ssl.protocol"));
    }

    @Test
    public void testShouldUseSslClientConfig() throws Exception {
        JaasOptionsUtils jou = new JaasOptionsUtils(Collections.emptyMap());
        Assertions.assertFalse((boolean)jou.shouldCreateSSLSocketFactory(new URL("http://example.com")));
        Assertions.assertTrue((boolean)jou.shouldCreateSSLSocketFactory(new URL("https://example.com")));
        Assertions.assertFalse((boolean)jou.shouldCreateSSLSocketFactory(new URL("file:///tmp/test.txt")));
    }
}

