/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.utils;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.common.utils.ConfigUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ConfigUtilsTest {
    private static final ConfigDef CONFIG = new ConfigDef().define("myPassword", ConfigDef.Type.PASSWORD, ConfigDef.Importance.HIGH, "").define("myString", ConfigDef.Type.STRING, ConfigDef.Importance.HIGH, "").define("myInt", ConfigDef.Type.INT, ConfigDef.Importance.HIGH, "").define("myString2", ConfigDef.Type.STRING, ConfigDef.Importance.HIGH, "");

    @Test
    public void testTranslateDeprecated() {
        HashMap<String, Object> config = new HashMap<String, Object>();
        config.put("foo.bar", "baz");
        config.put("foo.bar.deprecated", "quux");
        config.put("chicken", "1");
        config.put("rooster", "2");
        config.put("hen", "3");
        config.put("heifer", "moo");
        config.put("blah", "blah");
        config.put("unexpected.non.string.object", 42);
        Map newConfig = ConfigUtils.translateDeprecatedConfigs(config, (String[][])new String[][]{{"foo.bar", "foo.bar.deprecated"}, {"chicken", "rooster", "hen"}, {"cow", "beef", "heifer", "steer"}});
        Assertions.assertEquals((Object)"baz", newConfig.get("foo.bar"));
        Assertions.assertNull(newConfig.get("foobar.deprecated"));
        Assertions.assertEquals((Object)"1", newConfig.get("chicken"));
        Assertions.assertNull(newConfig.get("rooster"));
        Assertions.assertNull(newConfig.get("hen"));
        Assertions.assertEquals((Object)"moo", newConfig.get("cow"));
        Assertions.assertNull(newConfig.get("beef"));
        Assertions.assertNull(newConfig.get("heifer"));
        Assertions.assertNull(newConfig.get("steer"));
        Assertions.assertNull(config.get("cow"));
        Assertions.assertEquals((Object)"blah", config.get("blah"));
        Assertions.assertEquals((Object)"blah", newConfig.get("blah"));
        Assertions.assertEquals((Object)42, newConfig.get("unexpected.non.string.object"));
        Assertions.assertEquals((Object)42, config.get("unexpected.non.string.object"));
    }

    @Test
    public void testAllowsNewKey() {
        HashMap<String, String> config = new HashMap<String, String>();
        config.put("foo.bar", "baz");
        Map newConfig = ConfigUtils.translateDeprecatedConfigs(config, (String[][])new String[][]{{"foo.bar", "foo.bar.deprecated"}, {"chicken", "rooster", "hen"}, {"cow", "beef", "heifer", "steer"}});
        Assertions.assertNotNull((Object)newConfig);
        Assertions.assertEquals((Object)"baz", newConfig.get("foo.bar"));
        Assertions.assertNull(newConfig.get("foo.bar.deprecated"));
    }

    @Test
    public void testAllowDeprecatedNulls() {
        HashMap<String, String> config = new HashMap<String, String>();
        config.put("foo.bar.deprecated", null);
        config.put("foo.bar", "baz");
        Map newConfig = ConfigUtils.translateDeprecatedConfigs(config, (String[][])new String[][]{{"foo.bar", "foo.bar.deprecated"}});
        Assertions.assertNotNull((Object)newConfig);
        Assertions.assertEquals((Object)"baz", newConfig.get("foo.bar"));
        Assertions.assertNull(newConfig.get("foo.bar.deprecated"));
    }

    @Test
    public void testAllowNullOverride() {
        HashMap<String, String> config = new HashMap<String, String>();
        config.put("foo.bar.deprecated", "baz");
        config.put("foo.bar", null);
        Map newConfig = ConfigUtils.translateDeprecatedConfigs(config, (String[][])new String[][]{{"foo.bar", "foo.bar.deprecated"}});
        Assertions.assertNotNull((Object)newConfig);
        Assertions.assertNull(newConfig.get("foo.bar"));
        Assertions.assertNull(newConfig.get("foo.bar.deprecated"));
    }

    @Test
    public void testNullMapEntriesWithoutAliasesDoNotThrowNPE() {
        HashMap<String, Object> config = new HashMap<String, Object>();
        config.put("other", null);
        Map newConfig = ConfigUtils.translateDeprecatedConfigs(config, (String[][])new String[][]{{"foo.bar", "foo.bar.deprecated"}});
        Assertions.assertNotNull((Object)newConfig);
        Assertions.assertNull(newConfig.get("other"));
    }

    @Test
    public void testDuplicateSynonyms() {
        HashMap<String, String> config = new HashMap<String, String>();
        config.put("foo.bar", "baz");
        config.put("foo.bar.deprecated", "derp");
        Map newConfig = ConfigUtils.translateDeprecatedConfigs(config, (String[][])new String[][]{{"foo.bar", "foo.bar.deprecated"}, {"chicken", "foo.bar.deprecated"}});
        Assertions.assertNotNull((Object)newConfig);
        Assertions.assertEquals((Object)"baz", newConfig.get("foo.bar"));
        Assertions.assertEquals((Object)"derp", newConfig.get("chicken"));
        Assertions.assertNull(newConfig.get("foo.bar.deprecated"));
    }

    @Test
    public void testMultipleDeprecations() {
        HashMap<String, String> config = new HashMap<String, String>();
        config.put("foo.bar.deprecated", "derp");
        config.put("foo.bar.even.more.deprecated", "very old configuration");
        Map newConfig = ConfigUtils.translateDeprecatedConfigs(config, (String[][])new String[][]{{"foo.bar", "foo.bar.deprecated", "foo.bar.even.more.deprecated"}});
        Assertions.assertNotNull((Object)newConfig);
        Assertions.assertEquals((Object)"derp", newConfig.get("foo.bar"));
        Assertions.assertNull(newConfig.get("foo.bar.deprecated"));
        Assertions.assertNull(newConfig.get("foo.bar.even.more.deprecated"));
    }

    @Test
    public void testConfigMapToRedactedStringForEmptyMap() {
        Assertions.assertEquals((Object)"{}", (Object)ConfigUtils.configMapToRedactedString(Collections.emptyMap(), (ConfigDef)CONFIG));
    }

    @Test
    public void testConfigMapToRedactedStringWithSecrets() {
        HashMap<String, Object> testMap1 = new HashMap<String, Object>();
        testMap1.put("myString", "whatever");
        testMap1.put("myInt", 123);
        testMap1.put("myPassword", "foosecret");
        testMap1.put("myString2", null);
        testMap1.put("myUnknown", 456);
        Assertions.assertEquals((Object)"{myInt=123, myPassword=(redacted), myString=\"whatever\", myString2=null, myUnknown=(redacted)}", (Object)ConfigUtils.configMapToRedactedString(testMap1, (ConfigDef)CONFIG));
    }

    @Test
    public void testGetBoolean() {
        String key = "test.key";
        boolean defaultValue = true;
        HashMap<String, Object> config = new HashMap<String, Object>();
        config.put("some.other.key", false);
        Assertions.assertEquals((Object)defaultValue, (Object)ConfigUtils.getBoolean(config, (String)key, (boolean)defaultValue));
        config = new HashMap();
        config.put(key, false);
        Assertions.assertFalse((boolean)ConfigUtils.getBoolean(config, (String)key, (boolean)defaultValue));
        config = new HashMap();
        config.put(key, "false");
        Assertions.assertFalse((boolean)ConfigUtils.getBoolean(config, (String)key, (boolean)defaultValue));
        config = new HashMap();
        config.put(key, "not-a-boolean");
        Assertions.assertFalse((boolean)ConfigUtils.getBoolean(config, (String)key, (boolean)defaultValue));
        config = new HashMap();
        config.put(key, 5);
        Assertions.assertEquals((Object)defaultValue, (Object)ConfigUtils.getBoolean(config, (String)key, (boolean)defaultValue));
    }
}

