/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.consumer;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Optional;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.header.Headers;
import org.apache.kafka.common.header.internals.RecordHeaders;
import org.apache.kafka.common.record.TimestampType;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ConsumerRecordsTest {
    @Test
    public void testIterator() {
        String topic = "topic";
        int recordSize = 10;
        int partitionSize = 15;
        int emptyPartitionIndex = 3;
        ConsumerRecords<Integer, String> records = this.buildTopicTestRecords(recordSize, partitionSize, emptyPartitionIndex, Collections.singleton(topic));
        Iterator iterator = records.iterator();
        int recordCount = 0;
        int partitionCount = 0;
        int currentPartition = -1;
        while (iterator.hasNext()) {
            ConsumerRecord record = (ConsumerRecord)iterator.next();
            this.validateEmptyPartition((ConsumerRecord<Integer, String>)record, emptyPartitionIndex);
            if (currentPartition != record.partition()) {
                ++partitionCount;
                currentPartition = record.partition();
            }
            this.validateRecordPayload(topic, (ConsumerRecord<Integer, String>)record, currentPartition, recordCount, recordSize);
            ++recordCount;
        }
        Assertions.assertEquals((int)partitionSize, (int)(partitionCount + 1));
    }

    @Test
    public void testRecordsByPartition() {
        List<String> topics = Arrays.asList("topic1", "topic2");
        int recordSize = 3;
        int partitionSize = 5;
        int emptyPartitionIndex = 2;
        ConsumerRecords<Integer, String> consumerRecords = this.buildTopicTestRecords(recordSize, partitionSize, emptyPartitionIndex, topics);
        for (String topic : topics) {
            for (int partition = 0; partition < partitionSize; ++partition) {
                TopicPartition topicPartition = new TopicPartition(topic, partition);
                List records = consumerRecords.records(topicPartition);
                if (partition == emptyPartitionIndex) {
                    Assertions.assertTrue((boolean)records.isEmpty());
                    continue;
                }
                Assertions.assertEquals((int)recordSize, (int)records.size());
                for (int i = 0; i < records.size(); ++i) {
                    ConsumerRecord record = (ConsumerRecord)records.get(i);
                    this.validateRecordPayload(topic, (ConsumerRecord<Integer, String>)record, partition, i, recordSize);
                }
            }
        }
    }

    @Test
    public void testRecordsByNullTopic() {
        String nullTopic = null;
        ConsumerRecords consumerRecords = ConsumerRecords.empty();
        IllegalArgumentException exception = (IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> consumerRecords.records(nullTopic));
        Assertions.assertEquals((Object)"Topic must be non-null.", (Object)exception.getMessage());
    }

    @Test
    public void testRecordsByTopic() {
        List<String> topics = Arrays.asList("topic1", "topic2", "topic3", "topic4");
        int recordSize = 3;
        int partitionSize = 10;
        int emptyPartitionIndex = 6;
        int expectedTotalRecordSizeOfEachTopic = recordSize * (partitionSize - 1);
        ConsumerRecords<Integer, String> consumerRecords = this.buildTopicTestRecords(recordSize, partitionSize, emptyPartitionIndex, topics);
        for (String topic : topics) {
            Iterable records = consumerRecords.records(topic);
            int recordCount = 0;
            int partitionCount = 0;
            int currentPartition = -1;
            for (ConsumerRecord record : records) {
                this.validateEmptyPartition((ConsumerRecord<Integer, String>)record, emptyPartitionIndex);
                if (currentPartition != record.partition()) {
                    ++partitionCount;
                    currentPartition = record.partition();
                }
                this.validateRecordPayload(topic, (ConsumerRecord<Integer, String>)record, currentPartition, recordCount, recordSize);
                ++recordCount;
            }
            Assertions.assertEquals((int)partitionSize, (int)(partitionCount + 1));
            Assertions.assertEquals((int)expectedTotalRecordSizeOfEachTopic, (int)recordCount);
        }
    }

    @Test
    public void testRecordsAreImmutable() {
        String topic = "topic";
        int recordSize = 3;
        int partitionSize = 6;
        int emptyPartitionIndex = 2;
        TopicPartition topicPartition = new TopicPartition(topic, 0);
        ConsumerRecord newRecord = new ConsumerRecord(topic, 0, 0L, 0L, TimestampType.CREATE_TIME, 0, 0, (Object)0, (Object)"0", (Headers)new RecordHeaders(), Optional.empty());
        ConsumerRecords<Integer, String> records = this.buildTopicTestRecords(recordSize, partitionSize, emptyPartitionIndex, Collections.singleton(topic));
        ConsumerRecords emptyRecords = ConsumerRecords.empty();
        Assertions.assertThrows(UnsupportedOperationException.class, () -> records.records(topicPartition).add(newRecord));
        Assertions.assertThrows(UnsupportedOperationException.class, () -> records.partitions().add(topicPartition));
        Assertions.assertThrows(UnsupportedOperationException.class, () -> records.iterator().remove());
        Assertions.assertThrows(UnsupportedOperationException.class, () -> records.records(topic).iterator().remove());
        Assertions.assertEquals((int)(recordSize * (partitionSize - 1)), (int)records.count());
        Assertions.assertThrows(UnsupportedOperationException.class, () -> emptyRecords.records(topicPartition).add(newRecord));
        Assertions.assertThrows(UnsupportedOperationException.class, () -> emptyRecords.partitions().add(topicPartition));
        Assertions.assertThrows(UnsupportedOperationException.class, () -> emptyRecords.iterator().remove());
        Assertions.assertThrows(UnsupportedOperationException.class, () -> emptyRecords.records(topic).iterator().remove());
        Assertions.assertEquals((int)0, (int)emptyRecords.count());
    }

    private ConsumerRecords<Integer, String> buildTopicTestRecords(int recordSize, int partitionSize, int emptyPartitionIndex, Collection<String> topics) {
        LinkedHashMap partitionToRecords = new LinkedHashMap();
        for (String topic : topics) {
            for (int i = 0; i < partitionSize; ++i) {
                ArrayList<ConsumerRecord> records = new ArrayList<ConsumerRecord>(recordSize);
                if (i != emptyPartitionIndex) {
                    for (int j = 0; j < recordSize; ++j) {
                        records.add(new ConsumerRecord(topic, i, (long)j, 0L, TimestampType.CREATE_TIME, 0, 0, (Object)j, (Object)String.valueOf(j), (Headers)new RecordHeaders(), Optional.empty()));
                    }
                }
                partitionToRecords.put(new TopicPartition(topic, i), records);
            }
        }
        return new ConsumerRecords(partitionToRecords);
    }

    private void validateEmptyPartition(ConsumerRecord<Integer, String> record, int emptyPartitionIndex) {
        Assertions.assertNotEquals((int)emptyPartitionIndex, (int)record.partition(), (String)("Partition " + record.partition() + " is not empty"));
    }

    private void validateRecordPayload(String topic, ConsumerRecord<Integer, String> record, int currentPartition, int recordCount, int recordSize) {
        Assertions.assertEquals((Object)topic, (Object)record.topic());
        Assertions.assertEquals((int)currentPartition, (int)record.partition());
        Assertions.assertEquals((long)(recordCount % recordSize), (long)record.offset());
        Assertions.assertEquals((int)(recordCount % recordSize), (Integer)((Integer)record.key()));
        Assertions.assertEquals((Object)String.valueOf(recordCount % recordSize), (Object)record.value());
    }
}

