/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.security.oauthbearer;

import java.io.IOException;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.CompletionException;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import org.apache.kafka.common.internals.SecurityManagerCompatibility;
import org.apache.kafka.common.security.oauthbearer.OAuthBearerToken;
import org.apache.kafka.common.security.oauthbearer.OAuthBearerTokenCallback;
import org.apache.kafka.common.security.oauthbearer.internals.OAuthBearerSaslClientCallbackHandler;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class OAuthBearerSaslClientCallbackHandlerTest {
    private static OAuthBearerToken createTokenWithLifetimeMillis(final long lifetimeMillis) {
        return new OAuthBearerToken(){

            public String value() {
                return null;
            }

            public Long startTimeMs() {
                return null;
            }

            public Set<String> scope() {
                return null;
            }

            public String principalName() {
                return null;
            }

            public long lifetimeMs() {
                return lifetimeMillis;
            }
        };
    }

    @Test
    public void testWithZeroTokens() {
        OAuthBearerSaslClientCallbackHandler handler = OAuthBearerSaslClientCallbackHandlerTest.createCallbackHandler();
        CompletionException e = (CompletionException)Assertions.assertThrows(CompletionException.class, () -> SecurityManagerCompatibility.get().callAs(new Subject(), () -> {
            OAuthBearerTokenCallback callback = new OAuthBearerTokenCallback();
            handler.handle(new Callback[]{callback});
            return null;
        }));
        Assertions.assertEquals(IOException.class, e.getCause().getClass());
    }

    @Test
    public void testWithPotentiallyMultipleTokens() {
        OAuthBearerSaslClientCallbackHandler handler = OAuthBearerSaslClientCallbackHandlerTest.createCallbackHandler();
        SecurityManagerCompatibility.get().callAs(new Subject(), () -> {
            int maxTokens = 4;
            Set<Object> privateCredentials = SecurityManagerCompatibility.get().current().getPrivateCredentials();
            privateCredentials.clear();
            for (int num = 1; num <= 4; ++num) {
                privateCredentials.add(OAuthBearerSaslClientCallbackHandlerTest.createTokenWithLifetimeMillis(num));
                OAuthBearerTokenCallback callback = new OAuthBearerTokenCallback();
                handler.handle(new Callback[]{callback});
                Assertions.assertEquals((long)num, (long)callback.token().lifetimeMs());
            }
            return null;
        });
    }

    private static OAuthBearerSaslClientCallbackHandler createCallbackHandler() {
        OAuthBearerSaslClientCallbackHandler handler = new OAuthBearerSaslClientCallbackHandler();
        handler.configure(Collections.emptyMap(), "OAUTHBEARER", Collections.emptyList());
        return handler;
    }
}

