/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.consumer;

import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import org.apache.kafka.clients.consumer.ConsumerRebalanceListener;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.apache.kafka.clients.consumer.MockConsumer;
import org.apache.kafka.clients.consumer.OffsetAndMetadata;
import org.apache.kafka.clients.consumer.SubscriptionPattern;
import org.apache.kafka.clients.consumer.internals.AutoOffsetResetStrategy;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.header.Headers;
import org.apache.kafka.common.header.internals.RecordHeaders;
import org.apache.kafka.common.record.TimestampType;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class MockConsumerTest {
    private final MockConsumer<String, String> consumer = new MockConsumer(AutoOffsetResetStrategy.EARLIEST.name());

    @Test
    public void testSimpleMock() {
        this.consumer.subscribe(Collections.singleton("test"));
        Assertions.assertEquals((int)0, (int)this.consumer.poll(Duration.ZERO).count());
        this.consumer.rebalance(Arrays.asList(new TopicPartition("test", 0), new TopicPartition("test", 1)));
        HashMap<TopicPartition, Long> beginningOffsets = new HashMap<TopicPartition, Long>();
        beginningOffsets.put(new TopicPartition("test", 0), 0L);
        beginningOffsets.put(new TopicPartition("test", 1), 0L);
        this.consumer.updateBeginningOffsets(beginningOffsets);
        this.consumer.seek(new TopicPartition("test", 0), 0L);
        ConsumerRecord rec1 = new ConsumerRecord("test", 0, 0L, 0L, TimestampType.CREATE_TIME, 0, 0, (Object)"key1", (Object)"value1", (Headers)new RecordHeaders(), Optional.empty());
        ConsumerRecord rec2 = new ConsumerRecord("test", 0, 1L, 0L, TimestampType.CREATE_TIME, 0, 0, (Object)"key2", (Object)"value2", (Headers)new RecordHeaders(), Optional.empty());
        this.consumer.addRecord(rec1);
        this.consumer.addRecord(rec2);
        ConsumerRecords recs = this.consumer.poll(Duration.ofMillis(1L));
        Iterator iter = recs.iterator();
        Assertions.assertEquals((Object)rec1, iter.next());
        Assertions.assertEquals((Object)rec2, iter.next());
        Assertions.assertFalse((boolean)iter.hasNext());
        TopicPartition tp = new TopicPartition("test", 0);
        Assertions.assertEquals((long)2L, (long)this.consumer.position(tp));
        Assertions.assertEquals((int)1, (int)recs.nextOffsets().size());
        Assertions.assertEquals((Object)new OffsetAndMetadata(2L, Optional.empty(), ""), recs.nextOffsets().get(tp));
        this.consumer.commitSync();
        Assertions.assertEquals((long)2L, (long)((OffsetAndMetadata)this.consumer.committed(Collections.singleton(tp)).get(tp)).offset());
    }

    @Test
    public void testConsumerRecordsIsEmptyWhenReturningNoRecords() {
        TopicPartition partition = new TopicPartition("test", 0);
        this.consumer.assign(Collections.singleton(partition));
        this.consumer.addRecord(new ConsumerRecord("test", 0, 0L, null, null));
        this.consumer.updateEndOffsets(Collections.singletonMap(partition, 1L));
        this.consumer.seekToEnd(Collections.singleton(partition));
        ConsumerRecords records = this.consumer.poll(Duration.ofMillis(1L));
        Assertions.assertEquals((int)0, (int)records.count());
        Assertions.assertTrue((boolean)records.isEmpty());
    }

    @Test
    public void shouldNotClearRecordsForPausedPartitions() {
        TopicPartition partition0 = new TopicPartition("test", 0);
        List<TopicPartition> testPartitionList = Collections.singletonList(partition0);
        this.consumer.assign(testPartitionList);
        this.consumer.addRecord(new ConsumerRecord("test", 0, 0L, null, null));
        this.consumer.updateBeginningOffsets(Collections.singletonMap(partition0, 0L));
        this.consumer.seekToBeginning(testPartitionList);
        this.consumer.pause(testPartitionList);
        this.consumer.poll(Duration.ofMillis(1L));
        this.consumer.resume(testPartitionList);
        ConsumerRecords recordsSecondPoll = this.consumer.poll(Duration.ofMillis(1L));
        Assertions.assertEquals((int)1, (int)recordsSecondPoll.count());
        Assertions.assertEquals((int)1, (int)recordsSecondPoll.nextOffsets().size());
        Assertions.assertEquals((Object)new OffsetAndMetadata(1L, Optional.empty(), ""), recordsSecondPoll.nextOffsets().get(new TopicPartition("test", 0)));
    }

    @Test
    public void endOffsetsShouldBeIdempotent() {
        TopicPartition partition = new TopicPartition("test", 0);
        this.consumer.updateEndOffsets(Collections.singletonMap(partition, 10L));
        Assertions.assertEquals((long)10L, (long)((Long)this.consumer.endOffsets(Collections.singleton(partition)).get(partition)));
        Assertions.assertEquals((long)10L, (long)((Long)this.consumer.endOffsets(Collections.singleton(partition)).get(partition)));
        Assertions.assertEquals((long)10L, (long)((Long)this.consumer.endOffsets(Collections.singleton(partition)).get(partition)));
        this.consumer.updateEndOffsets(Collections.singletonMap(partition, 11L));
        Assertions.assertEquals((long)11L, (long)((Long)this.consumer.endOffsets(Collections.singleton(partition)).get(partition)));
        Assertions.assertEquals((long)11L, (long)((Long)this.consumer.endOffsets(Collections.singleton(partition)).get(partition)));
        Assertions.assertEquals((long)11L, (long)((Long)this.consumer.endOffsets(Collections.singleton(partition)).get(partition)));
    }

    @Test
    public void testDurationBasedOffsetReset() {
        MockConsumer consumer = new MockConsumer("by_duration:PT1H");
        consumer.subscribe(Collections.singleton("test"));
        consumer.rebalance(Arrays.asList(new TopicPartition("test", 0), new TopicPartition("test", 1)));
        HashMap<TopicPartition, Long> durationBasedOffsets = new HashMap<TopicPartition, Long>();
        durationBasedOffsets.put(new TopicPartition("test", 0), 10L);
        durationBasedOffsets.put(new TopicPartition("test", 1), 11L);
        consumer.updateDurationOffsets(durationBasedOffsets);
        ConsumerRecord rec1 = new ConsumerRecord("test", 0, 10L, 0L, TimestampType.CREATE_TIME, 0, 0, (Object)"key1", (Object)"value1", (Headers)new RecordHeaders(), Optional.empty());
        ConsumerRecord rec2 = new ConsumerRecord("test", 0, 11L, 0L, TimestampType.CREATE_TIME, 0, 0, (Object)"key2", (Object)"value2", (Headers)new RecordHeaders(), Optional.empty());
        consumer.addRecord(rec1);
        consumer.addRecord(rec2);
        ConsumerRecords records = consumer.poll(Duration.ofMillis(1L));
        Iterator iter = records.iterator();
        Assertions.assertEquals((Object)rec1, iter.next());
        Assertions.assertEquals((Object)rec2, iter.next());
        Assertions.assertFalse((boolean)iter.hasNext());
    }

    @Test
    public void testRebalanceListener() {
        final ArrayList revoked = new ArrayList();
        final ArrayList assigned = new ArrayList();
        ConsumerRebalanceListener consumerRebalanceListener = new ConsumerRebalanceListener(){

            public void onPartitionsRevoked(Collection<TopicPartition> partitions) {
                revoked.clear();
                revoked.addAll(partitions);
            }

            public void onPartitionsAssigned(Collection<TopicPartition> partitions) {
                if (partitions.isEmpty()) {
                    return;
                }
                assigned.clear();
                assigned.addAll(partitions);
            }
        };
        this.consumer.subscribe(Collections.singleton("test"), consumerRebalanceListener);
        Assertions.assertEquals((int)0, (int)this.consumer.poll(Duration.ZERO).count());
        List<TopicPartition> topicPartitionList = Arrays.asList(new TopicPartition("test", 0), new TopicPartition("test", 1));
        this.consumer.rebalance(topicPartitionList);
        Assertions.assertTrue((boolean)revoked.isEmpty());
        Assertions.assertEquals((int)2, (int)assigned.size());
        Assertions.assertTrue((boolean)assigned.contains(topicPartitionList.get(0)));
        Assertions.assertTrue((boolean)assigned.contains(topicPartitionList.get(1)));
        this.consumer.rebalance(Collections.emptyList());
        Assertions.assertEquals((int)2, (int)assigned.size());
        Assertions.assertTrue((boolean)revoked.contains(topicPartitionList.get(0)));
        Assertions.assertTrue((boolean)revoked.contains(topicPartitionList.get(1)));
        this.consumer.rebalance(Collections.singletonList(topicPartitionList.get(0)));
        Assertions.assertEquals((int)1, (int)assigned.size());
        Assertions.assertTrue((boolean)assigned.contains(topicPartitionList.get(0)));
        this.consumer.rebalance(Collections.singletonList(topicPartitionList.get(1)));
        Assertions.assertEquals((int)1, (int)assigned.size());
        Assertions.assertTrue((boolean)assigned.contains(topicPartitionList.get(1)));
        Assertions.assertEquals((int)1, (int)revoked.size());
        Assertions.assertTrue((boolean)revoked.contains(topicPartitionList.get(0)));
    }

    @Test
    public void testRe2JPatternSubscription() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.consumer.subscribe((SubscriptionPattern)null));
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.consumer.subscribe(new SubscriptionPattern("")));
        SubscriptionPattern pattern = new SubscriptionPattern("t.*");
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.consumer.subscribe(pattern, null));
        this.consumer.subscribe(pattern);
        Assertions.assertTrue((boolean)this.consumer.subscription().isEmpty());
        Assertions.assertThrows(IllegalStateException.class, () -> this.consumer.subscribe(List.of("topic1")));
    }
}

