/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.consumer.internals.metrics;

import org.apache.kafka.clients.consumer.internals.metrics.ShareRebalanceMetricsManager;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.common.utils.Time;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class ShareRebalanceMetricsManagerTest {
    private final Time time = new MockTime();
    private final Metrics metrics = new Metrics(this.time);

    ShareRebalanceMetricsManagerTest() {
    }

    @Test
    public void testRebalanceMetrics() {
        ShareRebalanceMetricsManager shareRebalanceMetricsManager = new ShareRebalanceMetricsManager(this.metrics);
        Assertions.assertNotNull((Object)this.metrics.metric(shareRebalanceMetricsManager.rebalanceTotal));
        Assertions.assertNotNull((Object)this.metrics.metric(shareRebalanceMetricsManager.rebalanceRatePerHour));
        shareRebalanceMetricsManager.recordRebalanceStarted(10L);
        shareRebalanceMetricsManager.recordRebalanceEnded(25L);
        shareRebalanceMetricsManager.recordRebalanceStarted(30L);
        shareRebalanceMetricsManager.recordRebalanceEnded(40L);
        shareRebalanceMetricsManager.recordRebalanceStarted(50L);
        shareRebalanceMetricsManager.recordRebalanceEnded(100L);
        Assertions.assertEquals((Object)3.0, (Object)this.metrics.metric(shareRebalanceMetricsManager.rebalanceTotal).metricValue());
        Assertions.assertEquals((Object)360.0, (Object)this.metrics.metric(shareRebalanceMetricsManager.rebalanceRatePerHour).metricValue());
    }
}

