/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.network;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ScatteringByteChannel;
import java.util.stream.IntStream;
import org.apache.kafka.common.network.NetworkReceive;
import org.apache.kafka.test.TestUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.Mockito;

public class NetworkReceiveTest {
    @Test
    public void testBytesRead() throws IOException {
        NetworkReceive receive = new NetworkReceive(128, "0");
        Assertions.assertEquals((int)0, (int)receive.bytesRead());
        ScatteringByteChannel channel = (ScatteringByteChannel)Mockito.mock(ScatteringByteChannel.class);
        ArgumentCaptor bufferCaptor = ArgumentCaptor.forClass(ByteBuffer.class);
        Mockito.when((Object)channel.read((ByteBuffer)bufferCaptor.capture())).thenAnswer(invocation -> {
            ((ByteBuffer)bufferCaptor.getValue()).putInt(128);
            return 4;
        }).thenReturn((Object)0);
        Assertions.assertEquals((long)4L, (long)receive.readFrom(channel));
        Assertions.assertEquals((int)4, (int)receive.bytesRead());
        Assertions.assertFalse((boolean)receive.complete());
        Mockito.reset((Object[])new ScatteringByteChannel[]{channel});
        Mockito.when((Object)channel.read((ByteBuffer)bufferCaptor.capture())).thenAnswer(invocation -> {
            ((ByteBuffer)bufferCaptor.getValue()).put(TestUtils.randomBytes(64));
            return 64;
        });
        Assertions.assertEquals((long)64L, (long)receive.readFrom(channel));
        Assertions.assertEquals((int)68, (int)receive.bytesRead());
        Assertions.assertFalse((boolean)receive.complete());
        Mockito.reset((Object[])new ScatteringByteChannel[]{channel});
        Mockito.when((Object)channel.read((ByteBuffer)bufferCaptor.capture())).thenAnswer(invocation -> {
            ((ByteBuffer)bufferCaptor.getValue()).put(TestUtils.randomBytes(64));
            return 64;
        });
        Assertions.assertEquals((long)64L, (long)receive.readFrom(channel));
        Assertions.assertEquals((int)132, (int)receive.bytesRead());
        Assertions.assertTrue((boolean)receive.complete());
    }

    @Test
    public void testRequiredMemoryAmountKnownWhenNotSet() {
        NetworkReceive receive = new NetworkReceive("0");
        Assertions.assertFalse((boolean)receive.requiredMemoryAmountKnown(), (String)"Memory amount should not be known before read.");
    }

    @Test
    public void testRequiredMemoryAmountKnownWhenSet() throws IOException {
        NetworkReceive receive = new NetworkReceive(128, "0");
        ScatteringByteChannel channel = (ScatteringByteChannel)Mockito.mock(ScatteringByteChannel.class);
        ArgumentCaptor bufferCaptor = ArgumentCaptor.forClass(ByteBuffer.class);
        Mockito.when((Object)channel.read((ByteBuffer)bufferCaptor.capture())).thenAnswer(invocation -> {
            ((ByteBuffer)bufferCaptor.getValue()).putInt(64);
            return 4;
        });
        receive.readFrom(channel);
        Assertions.assertTrue((boolean)receive.requiredMemoryAmountKnown(), (String)"Memory amount should be known after read.");
    }

    @Test
    public void testSizeWithPredefineBuffer() {
        int payloadSize = 8;
        int expectedTotalSize = 4 + payloadSize;
        ByteBuffer payloadBuffer = ByteBuffer.allocate(payloadSize);
        IntStream.range(0, payloadSize).forEach(i -> payloadBuffer.put((byte)i));
        NetworkReceive networkReceive = new NetworkReceive("0", payloadBuffer);
        Assertions.assertEquals((int)expectedTotalSize, (int)networkReceive.size(), (String)"The total size should be the sum of the size buffer and payload.");
    }

    @Test
    public void testSizeAfterRead() throws IOException {
        int payloadSize = 32;
        int expectedTotalSize = 4 + payloadSize;
        NetworkReceive receive = new NetworkReceive(128, "0");
        ScatteringByteChannel channel = (ScatteringByteChannel)Mockito.mock(ScatteringByteChannel.class);
        ArgumentCaptor bufferCaptor = ArgumentCaptor.forClass(ByteBuffer.class);
        Mockito.when((Object)channel.read((ByteBuffer)bufferCaptor.capture())).thenAnswer(invocation -> {
            ((ByteBuffer)bufferCaptor.getValue()).putInt(payloadSize);
            return 4;
        });
        receive.readFrom(channel);
        Assertions.assertEquals((int)expectedTotalSize, (int)receive.size(), (String)"The total size should be the sum of the size buffer and receive size.");
    }
}

