/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.security.kerberos;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.kafka.common.security.kerberos.KerberosName;
import org.apache.kafka.common.security.kerberos.KerberosShortNamer;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class KerberosNameTest {
    @Test
    public void testParse() throws IOException {
        List<String> rules = Arrays.asList("RULE:[1:$1](App\\..*)s/App\\.(.*)/$1/g", "RULE:[2:$1](App\\..*)s/App\\.(.*)/$1/g", "DEFAULT");
        KerberosShortNamer shortNamer = KerberosShortNamer.fromUnparsedRules((String)"REALM.COM", rules);
        KerberosName name = KerberosName.parse((String)"App.service-name/example.com@REALM.COM");
        Assertions.assertEquals((Object)"App.service-name", (Object)name.serviceName());
        Assertions.assertEquals((Object)"example.com", (Object)name.hostName());
        Assertions.assertEquals((Object)"REALM.COM", (Object)name.realm());
        Assertions.assertEquals((Object)"service-name", (Object)shortNamer.shortName(name));
        name = KerberosName.parse((String)"App.service-name@REALM.COM");
        Assertions.assertEquals((Object)"App.service-name", (Object)name.serviceName());
        Assertions.assertNull((Object)name.hostName());
        Assertions.assertEquals((Object)"REALM.COM", (Object)name.realm());
        Assertions.assertEquals((Object)"service-name", (Object)shortNamer.shortName(name));
        name = KerberosName.parse((String)"user/host@REALM.COM");
        Assertions.assertEquals((Object)"user", (Object)name.serviceName());
        Assertions.assertEquals((Object)"host", (Object)name.hostName());
        Assertions.assertEquals((Object)"REALM.COM", (Object)name.realm());
        Assertions.assertEquals((Object)"user", (Object)shortNamer.shortName(name));
    }

    @Test
    public void testToLowerCase() throws Exception {
        List<String> rules = Arrays.asList("RULE:[1:$1]/L", "RULE:[2:$1](Test.*)s/ABC///L", "RULE:[2:$1](ABC.*)s/ABC/XYZ/g/L", "RULE:[2:$1](App\\..*)s/App\\.(.*)/$1/g/L", "RULE:[2:$1]/L", "DEFAULT");
        KerberosShortNamer shortNamer = KerberosShortNamer.fromUnparsedRules((String)"REALM.COM", rules);
        KerberosName name = KerberosName.parse((String)"User@REALM.COM");
        Assertions.assertEquals((Object)"user", (Object)shortNamer.shortName(name));
        name = KerberosName.parse((String)"TestABC/host@FOO.COM");
        Assertions.assertEquals((Object)"test", (Object)shortNamer.shortName(name));
        name = KerberosName.parse((String)"ABC_User_ABC/host@FOO.COM");
        Assertions.assertEquals((Object)"xyz_user_xyz", (Object)shortNamer.shortName(name));
        name = KerberosName.parse((String)"App.SERVICE-name/example.com@REALM.COM");
        Assertions.assertEquals((Object)"service-name", (Object)shortNamer.shortName(name));
        name = KerberosName.parse((String)"User/root@REALM.COM");
        Assertions.assertEquals((Object)"user", (Object)shortNamer.shortName(name));
    }

    @Test
    public void testToUpperCase() throws Exception {
        List<String> rules = Arrays.asList("RULE:[1:$1]/U", "RULE:[2:$1](Test.*)s/ABC///U", "RULE:[2:$1](ABC.*)s/ABC/XYZ/g/U", "RULE:[2:$1](App\\..*)s/App\\.(.*)/$1/g/U", "RULE:[2:$1]/U", "DEFAULT");
        KerberosShortNamer shortNamer = KerberosShortNamer.fromUnparsedRules((String)"REALM.COM", rules);
        KerberosName name = KerberosName.parse((String)"User@REALM.COM");
        Assertions.assertEquals((Object)"USER", (Object)shortNamer.shortName(name));
        name = KerberosName.parse((String)"TestABC/host@FOO.COM");
        Assertions.assertEquals((Object)"TEST", (Object)shortNamer.shortName(name));
        name = KerberosName.parse((String)"ABC_User_ABC/host@FOO.COM");
        Assertions.assertEquals((Object)"XYZ_USER_XYZ", (Object)shortNamer.shortName(name));
        name = KerberosName.parse((String)"App.SERVICE-name/example.com@REALM.COM");
        Assertions.assertEquals((Object)"SERVICE-NAME", (Object)shortNamer.shortName(name));
        name = KerberosName.parse((String)"User/root@REALM.COM");
        Assertions.assertEquals((Object)"USER", (Object)shortNamer.shortName(name));
    }

    @Test
    public void testInvalidRules() {
        this.testInvalidRule(Collections.singletonList("default"));
        this.testInvalidRule(Collections.singletonList("DEFAUL"));
        this.testInvalidRule(Collections.singletonList("DEFAULT/L"));
        this.testInvalidRule(Collections.singletonList("DEFAULT/g"));
        this.testInvalidRule(Collections.singletonList("rule:[1:$1]"));
        this.testInvalidRule(Collections.singletonList("rule:[1:$1]/L/U"));
        this.testInvalidRule(Collections.singletonList("rule:[1:$1]/U/L"));
        this.testInvalidRule(Collections.singletonList("rule:[1:$1]/LU"));
        this.testInvalidRule(Collections.singletonList("RULE:[1:$1/L"));
        this.testInvalidRule(Collections.singletonList("RULE:[1:$1]/l"));
        this.testInvalidRule(Collections.singletonList("RULE:[2:$1](ABC.*)s/ABC/XYZ/L/g"));
    }

    private void testInvalidRule(List<String> rules) {
        Assertions.assertThrows(IllegalArgumentException.class, () -> KerberosShortNamer.fromUnparsedRules((String)"REALM.COM", (List)rules));
    }
}

