/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.consumer;

import java.time.Duration;
import java.util.Optional;
import org.apache.kafka.clients.consumer.CloseOptions;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class CloseOptionsTest {
    CloseOptionsTest() {
    }

    @Test
    void operationShouldNotBeNull() {
        Assertions.assertThrows(NullPointerException.class, () -> CloseOptions.groupMembershipOperation(null));
        Assertions.assertThrows(NullPointerException.class, () -> CloseOptions.timeout((Duration)Duration.ZERO).withGroupMembershipOperation(null));
    }

    @Test
    void operationShouldHaveDefaultValue() {
        Assertions.assertEquals((Object)CloseOptions.GroupMembershipOperation.DEFAULT, (Object)CloseOptions.timeout((Duration)Duration.ZERO).groupMembershipOperation());
    }

    @Test
    void timeoutCouldBeNull() {
        CloseOptions closeOptions = (CloseOptions)Assertions.assertDoesNotThrow(() -> CloseOptions.timeout(null));
        Assertions.assertEquals(Optional.empty(), (Object)closeOptions.timeout());
    }

    @Test
    void timeoutShouldBeDefaultEmpty() {
        Assertions.assertEquals(Optional.empty(), (Object)CloseOptions.groupMembershipOperation((CloseOptions.GroupMembershipOperation)CloseOptions.GroupMembershipOperation.DEFAULT).timeout());
    }
}

