/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.consumer.internals;

import org.apache.kafka.clients.consumer.internals.HeartbeatRequestState;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.common.utils.Time;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class HeartbeatRequestStateTest {
    private static final LogContext LOG_CONTEXT = new LogContext("test ");
    private static final long HEARTBEAT_INTERVAL_MS = 1000L;
    private static final long RETRY_BACKOFF_MS = 100L;
    private static final long RETRY_BACKOFF_MAX_MS = 500L;
    private static final double JITTER = 0.2;
    private final Time time = new MockTime();

    @Test
    public void testCanSendRequestAndTimeToNextHeartbeatMs() {
        HeartbeatRequestState heartbeatRequestState = new HeartbeatRequestState(LOG_CONTEXT, this.time, 1000L, 100L, 500L, 0.2);
        Assertions.assertFalse((boolean)heartbeatRequestState.canSendRequest(this.time.milliseconds()));
        Assertions.assertEquals((long)1000L, (long)heartbeatRequestState.timeToNextHeartbeatMs(this.time.milliseconds()));
        this.time.sleep(999L);
        Assertions.assertFalse((boolean)heartbeatRequestState.canSendRequest(this.time.milliseconds()));
        Assertions.assertEquals((long)1L, (long)heartbeatRequestState.timeToNextHeartbeatMs(this.time.milliseconds()));
        this.time.sleep(1L);
        Assertions.assertTrue((boolean)heartbeatRequestState.canSendRequest(this.time.milliseconds()));
        Assertions.assertEquals((long)0L, (long)heartbeatRequestState.timeToNextHeartbeatMs(this.time.milliseconds()));
        this.time.sleep(100L);
        Assertions.assertTrue((boolean)heartbeatRequestState.canSendRequest(this.time.milliseconds()));
        Assertions.assertEquals((long)0L, (long)heartbeatRequestState.timeToNextHeartbeatMs(this.time.milliseconds()));
    }

    @Test
    public void testResetTimer() {
        HeartbeatRequestState heartbeatRequestState = new HeartbeatRequestState(LOG_CONTEXT, this.time, 1000L, 100L, 500L, 0.2);
        this.time.sleep(1100L);
        Assertions.assertTrue((boolean)heartbeatRequestState.canSendRequest(this.time.milliseconds()));
        Assertions.assertEquals((long)0L, (long)heartbeatRequestState.timeToNextHeartbeatMs(this.time.milliseconds()));
        heartbeatRequestState.resetTimer();
        Assertions.assertFalse((boolean)heartbeatRequestState.canSendRequest(this.time.milliseconds()));
        Assertions.assertEquals((long)1000L, (long)heartbeatRequestState.timeToNextHeartbeatMs(this.time.milliseconds()));
    }

    @Test
    public void testUpdateHeartbeatIntervalMs() {
        HeartbeatRequestState heartbeatRequestState = new HeartbeatRequestState(LOG_CONTEXT, this.time, 1000L, 100L, 500L, 0.2);
        long updatedHeartbeatIntervalMs = 2000L;
        this.time.sleep(1100L);
        heartbeatRequestState.updateHeartbeatIntervalMs(2000L);
        Assertions.assertFalse((boolean)heartbeatRequestState.canSendRequest(this.time.milliseconds()));
        Assertions.assertEquals((long)2000L, (long)heartbeatRequestState.timeToNextHeartbeatMs(this.time.milliseconds()));
    }

    @Test
    public void testUpdateHeartbeatIntervalMsWithSameInterval() {
        HeartbeatRequestState heartbeatRequestState = new HeartbeatRequestState(LOG_CONTEXT, this.time, 1000L, 100L, 500L, 0.2);
        this.time.sleep(1100L);
        heartbeatRequestState.updateHeartbeatIntervalMs(1000L);
        Assertions.assertEquals((long)1000L, (long)heartbeatRequestState.heartbeatIntervalMs());
        Assertions.assertTrue((boolean)heartbeatRequestState.canSendRequest(this.time.milliseconds()));
    }

    @Test
    public void testOnFailedAttempt() {
        HeartbeatRequestState heartbeatRequestState = new HeartbeatRequestState(LOG_CONTEXT, this.time, 1000L, 100L, 500L, 0.2);
        this.time.sleep(1100L);
        heartbeatRequestState.onFailedAttempt(this.time.milliseconds());
        Assertions.assertFalse((boolean)heartbeatRequestState.canSendRequest(this.time.milliseconds()));
        Assertions.assertTrue((heartbeatRequestState.timeToNextHeartbeatMs(this.time.milliseconds()) > 0L ? 1 : 0) != 0);
    }
}

