/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.message;

import com.fasterxml.jackson.databind.JsonNode;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.function.Supplier;
import org.apache.kafka.common.IsolationLevel;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.kafka.common.message.AddOffsetsToTxnRequestData;
import org.apache.kafka.common.message.AddOffsetsToTxnResponseData;
import org.apache.kafka.common.message.AddPartitionsToTxnRequestData;
import org.apache.kafka.common.message.ApiMessageType;
import org.apache.kafka.common.message.CreateTopicsRequestData;
import org.apache.kafka.common.message.DescribeAclsRequestData;
import org.apache.kafka.common.message.DescribeClusterRequestData;
import org.apache.kafka.common.message.DescribeClusterResponseData;
import org.apache.kafka.common.message.DescribeGroupsRequestData;
import org.apache.kafka.common.message.DescribeGroupsResponseData;
import org.apache.kafka.common.message.FetchRequestData;
import org.apache.kafka.common.message.HeartbeatRequestData;
import org.apache.kafka.common.message.JoinGroupRequestData;
import org.apache.kafka.common.message.JoinGroupResponseData;
import org.apache.kafka.common.message.LeaveGroupResponseData;
import org.apache.kafka.common.message.ListOffsetsRequestData;
import org.apache.kafka.common.message.ListOffsetsResponseData;
import org.apache.kafka.common.message.MetadataRequestData;
import org.apache.kafka.common.message.OffsetCommitRequestData;
import org.apache.kafka.common.message.OffsetCommitResponseData;
import org.apache.kafka.common.message.OffsetFetchRequestData;
import org.apache.kafka.common.message.OffsetFetchResponseData;
import org.apache.kafka.common.message.OffsetForLeaderEpochRequestData;
import org.apache.kafka.common.message.ProduceResponseData;
import org.apache.kafka.common.message.SimpleExampleMessageData;
import org.apache.kafka.common.message.SyncGroupRequestData;
import org.apache.kafka.common.message.TxnOffsetCommitRequestData;
import org.apache.kafka.common.message.TxnOffsetCommitResponseData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.common.protocol.ByteBufferAccessor;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.protocol.Message;
import org.apache.kafka.common.protocol.MessageUtil;
import org.apache.kafka.common.protocol.ObjectSerializationCache;
import org.apache.kafka.common.protocol.Readable;
import org.apache.kafka.common.protocol.Writable;
import org.apache.kafka.common.protocol.types.RawTaggedField;
import org.apache.kafka.common.utils.ImplicitLinkedHashCollection;
import org.apache.kafka.common.utils.annotation.ApiKeyVersionsSource;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;
import org.junit.jupiter.params.ParameterizedTest;

@Timeout(value=120L)
public final class MessageTest {
    private final String memberId = "memberId";
    private final String instanceId = "instanceId";

    @Test
    public void testAddOffsetsToTxnVersions() throws Exception {
        this.testAllMessageRoundTrips((Message)new AddOffsetsToTxnRequestData().setTransactionalId("foobar").setProducerId(52596993799604990L).setProducerEpoch((short)123).setGroupId("baaz"));
        this.testAllMessageRoundTrips((Message)new AddOffsetsToTxnResponseData().setThrottleTimeMs(42).setErrorCode((short)0));
    }

    @Test
    public void testAddPartitionsToTxnVersions() throws Exception {
        AddPartitionsToTxnRequestData v3AndBelowData = new AddPartitionsToTxnRequestData().setV3AndBelowTransactionalId("blah").setV3AndBelowProducerId(52596993799604990L).setV3AndBelowProducerEpoch((short)30000).setV3AndBelowTopics(new AddPartitionsToTxnRequestData.AddPartitionsToTxnTopicCollection(Collections.singletonList(new AddPartitionsToTxnRequestData.AddPartitionsToTxnTopic().setName("Topic").setPartitions(Collections.singletonList(1))).iterator()));
        this.testDuplication((Message)v3AndBelowData);
        this.testAllMessageRoundTripsUntilVersion((short)3, (Message)v3AndBelowData);
        AddPartitionsToTxnRequestData data = new AddPartitionsToTxnRequestData().setTransactions(new AddPartitionsToTxnRequestData.AddPartitionsToTxnTransactionCollection(Collections.singletonList(new AddPartitionsToTxnRequestData.AddPartitionsToTxnTransaction().setTransactionalId("blah").setProducerId(52596993799604990L).setProducerEpoch((short)30000).setTopics(v3AndBelowData.v3AndBelowTopics())).iterator()));
        this.testDuplication((Message)data);
        this.testAllMessageRoundTripsFromVersion((short)4, (Message)data);
    }

    @Test
    public void testCreateTopicsVersions() throws Exception {
        this.testAllMessageRoundTrips((Message)new CreateTopicsRequestData().setTimeoutMs(1000).setTopics(new CreateTopicsRequestData.CreatableTopicCollection()));
    }

    @Test
    public void testDescribeAclsRequest() throws Exception {
        this.testAllMessageRoundTrips((Message)new DescribeAclsRequestData().setResourceTypeFilter((byte)42).setResourceNameFilter(null).setPatternTypeFilter((byte)3).setPrincipalFilter("abc").setHostFilter(null).setOperation((byte)0).setPermissionType((byte)0));
    }

    @Test
    public void testMetadataVersions() throws Exception {
        this.testAllMessageRoundTrips((Message)new MetadataRequestData().setTopics(Arrays.asList(new MetadataRequestData.MetadataRequestTopic().setName("foo"), new MetadataRequestData.MetadataRequestTopic().setName("bar"))));
        this.testAllMessageRoundTripsFromVersion((short)1, (Message)new MetadataRequestData().setTopics(null).setAllowAutoTopicCreation(true).setIncludeClusterAuthorizedOperations(false).setIncludeTopicAuthorizedOperations(false));
        this.testAllMessageRoundTripsFromVersion((short)4, (Message)new MetadataRequestData().setTopics(null).setAllowAutoTopicCreation(false).setIncludeClusterAuthorizedOperations(false).setIncludeTopicAuthorizedOperations(false));
    }

    @Test
    public void testHeartbeatVersions() throws Exception {
        Supplier<HeartbeatRequestData> newRequest = () -> new HeartbeatRequestData().setGroupId("groupId").setMemberId("memberId").setGenerationId(15);
        this.testAllMessageRoundTrips((Message)newRequest.get());
        this.testAllMessageRoundTrips((Message)newRequest.get().setGroupInstanceId(null));
        this.testAllMessageRoundTripsFromVersion((short)3, (Message)newRequest.get().setGroupInstanceId("instanceId"));
    }

    @Test
    public void testJoinGroupRequestVersions() throws Exception {
        Supplier<JoinGroupRequestData> newRequest = () -> new JoinGroupRequestData().setGroupId("groupId").setMemberId("memberId").setProtocolType("consumer").setProtocols(new JoinGroupRequestData.JoinGroupRequestProtocolCollection()).setSessionTimeoutMs(10000);
        this.testAllMessageRoundTrips((Message)newRequest.get());
        this.testAllMessageRoundTripsFromVersion((short)1, (Message)newRequest.get().setRebalanceTimeoutMs(20000));
        this.testAllMessageRoundTrips((Message)newRequest.get().setGroupInstanceId(null));
        this.testAllMessageRoundTripsFromVersion((short)5, (Message)newRequest.get().setGroupInstanceId("instanceId"));
    }

    @Test
    public void testListOffsetsRequestVersions() throws Exception {
        List<ListOffsetsRequestData.ListOffsetsTopic> v = Collections.singletonList(new ListOffsetsRequestData.ListOffsetsTopic().setName("topic").setPartitions(Collections.singletonList(new ListOffsetsRequestData.ListOffsetsPartition().setPartitionIndex(0).setTimestamp(123L))));
        Supplier<ListOffsetsRequestData> newRequest = () -> new ListOffsetsRequestData().setTopics(v).setReplicaId(0);
        this.testAllMessageRoundTrips((Message)newRequest.get());
        this.testAllMessageRoundTripsFromVersion((short)2, (Message)newRequest.get().setIsolationLevel(IsolationLevel.READ_COMMITTED.id()));
    }

    @Test
    public void testListOffsetsResponseVersions() throws Exception {
        ListOffsetsResponseData.ListOffsetsPartitionResponse partition = new ListOffsetsResponseData.ListOffsetsPartitionResponse().setErrorCode(Errors.NONE.code()).setPartitionIndex(0);
        List<ListOffsetsResponseData.ListOffsetsTopicResponse> topics = Collections.singletonList(new ListOffsetsResponseData.ListOffsetsTopicResponse().setName("topic").setPartitions(Collections.singletonList(partition)));
        Supplier<ListOffsetsResponseData> response = () -> new ListOffsetsResponseData().setTopics(topics);
        for (short version = ApiKeys.LIST_OFFSETS.oldestVersion(); version <= ApiKeys.LIST_OFFSETS.latestVersion(); version = (short)(version + 1)) {
            ListOffsetsResponseData responseData = response.get();
            ((ListOffsetsResponseData.ListOffsetsPartitionResponse)((ListOffsetsResponseData.ListOffsetsTopicResponse)responseData.topics().get(0)).partitions().get(0)).setOffset(456L).setTimestamp(123L);
            if (version > 1) {
                responseData.setThrottleTimeMs(1000);
            }
            if (version > 3) {
                partition.setLeaderEpoch(1);
            }
            this.testEquivalentMessageRoundTrip(version, (Message)responseData);
        }
    }

    @Test
    public void testJoinGroupResponseVersions() throws Exception {
        Supplier<JoinGroupResponseData> newResponse = () -> new JoinGroupResponseData().setMemberId("memberId").setLeader("memberId").setGenerationId(1).setMembers(Collections.singletonList(new JoinGroupResponseData.JoinGroupResponseMember().setMemberId("memberId")));
        this.testAllMessageRoundTrips((Message)newResponse.get());
        this.testAllMessageRoundTripsFromVersion((short)2, (Message)newResponse.get().setThrottleTimeMs(1000));
        this.testAllMessageRoundTrips((Message)((JoinGroupResponseData.JoinGroupResponseMember)newResponse.get().members().get(0)).setGroupInstanceId(null));
        this.testAllMessageRoundTripsFromVersion((short)5, (Message)((JoinGroupResponseData.JoinGroupResponseMember)newResponse.get().members().get(0)).setGroupInstanceId("instanceId"));
    }

    @Test
    public void testLeaveGroupResponseVersions() throws Exception {
        Supplier<LeaveGroupResponseData> newResponse = () -> new LeaveGroupResponseData().setErrorCode(Errors.NOT_COORDINATOR.code());
        this.testAllMessageRoundTrips((Message)newResponse.get());
        this.testAllMessageRoundTripsFromVersion((short)1, (Message)newResponse.get().setThrottleTimeMs(1000));
        this.testAllMessageRoundTripsFromVersion((short)3, (Message)newResponse.get().setMembers(Collections.singletonList(new LeaveGroupResponseData.MemberResponse().setMemberId("memberId").setGroupInstanceId("instanceId"))));
    }

    @Test
    public void testSyncGroupDefaultGroupInstanceId() throws Exception {
        Supplier<SyncGroupRequestData> request = () -> new SyncGroupRequestData().setGroupId("groupId").setMemberId("memberId").setGenerationId(15).setAssignments(new ArrayList());
        this.testAllMessageRoundTrips((Message)request.get());
        this.testAllMessageRoundTrips((Message)request.get().setGroupInstanceId(null));
        this.testAllMessageRoundTripsFromVersion((short)3, (Message)request.get().setGroupInstanceId("instanceId"));
    }

    @Test
    public void testOffsetCommitDefaultGroupInstanceId() throws Exception {
        this.testAllMessageRoundTrips((Message)new OffsetCommitRequestData().setTopics(new ArrayList()).setGroupId("groupId"));
        Supplier<OffsetCommitRequestData> request = () -> new OffsetCommitRequestData().setGroupId("groupId").setMemberId("memberId").setTopics(new ArrayList()).setGenerationIdOrMemberEpoch(15);
        this.testAllMessageRoundTripsFromVersion((short)1, (Message)request.get());
        this.testAllMessageRoundTripsFromVersion((short)1, (Message)request.get().setGroupInstanceId(null));
        this.testAllMessageRoundTripsFromVersion((short)7, (Message)request.get().setGroupInstanceId("instanceId"));
    }

    @Test
    public void testDescribeGroupsRequestVersions() throws Exception {
        this.testAllMessageRoundTrips((Message)new DescribeGroupsRequestData().setGroups(Collections.singletonList("group")).setIncludeAuthorizedOperations(false));
    }

    @Test
    public void testDescribeGroupsResponseVersions() throws Exception {
        DescribeGroupsResponseData.DescribedGroupMember baseMember = new DescribeGroupsResponseData.DescribedGroupMember().setMemberId("memberId");
        DescribeGroupsResponseData.DescribedGroup baseGroup = new DescribeGroupsResponseData.DescribedGroup().setGroupId("group").setGroupState("Stable").setErrorCode(Errors.NONE.code()).setMembers(Collections.singletonList(baseMember)).setProtocolType("consumer");
        DescribeGroupsResponseData baseResponse = new DescribeGroupsResponseData().setGroups(Collections.singletonList(baseGroup));
        this.testAllMessageRoundTrips((Message)baseResponse);
        this.testAllMessageRoundTripsFromVersion((short)1, (Message)baseResponse.setThrottleTimeMs(10));
        baseGroup.setAuthorizedOperations(1);
        this.testAllMessageRoundTripsFromVersion((short)3, (Message)baseResponse);
        baseMember.setGroupInstanceId("instanceId");
        this.testAllMessageRoundTripsFromVersion((short)4, (Message)baseResponse);
    }

    @Test
    public void testDescribeClusterRequestVersions() throws Exception {
        this.testAllMessageRoundTrips((Message)new DescribeClusterRequestData().setIncludeClusterAuthorizedOperations(true));
    }

    @Test
    public void testDescribeClusterResponseVersions() throws Exception {
        DescribeClusterResponseData data = new DescribeClusterResponseData().setBrokers(new DescribeClusterResponseData.DescribeClusterBrokerCollection(Collections.singletonList(new DescribeClusterResponseData.DescribeClusterBroker().setBrokerId(1).setHost("localhost").setPort(9092).setRack("rack1")).iterator())).setClusterId("clusterId").setControllerId(1).setClusterAuthorizedOperations(10);
        this.testAllMessageRoundTrips((Message)data);
    }

    @Test
    public void testGroupInstanceIdIgnorableInDescribeGroupsResponse() throws Exception {
        DescribeGroupsResponseData responseWithGroupInstanceId = new DescribeGroupsResponseData().setGroups(Collections.singletonList(new DescribeGroupsResponseData.DescribedGroup().setGroupId("group").setGroupState("Stable").setErrorCode(Errors.NONE.code()).setMembers(Collections.singletonList(new DescribeGroupsResponseData.DescribedGroupMember().setMemberId("memberId").setGroupInstanceId("instanceId"))).setProtocolType("consumer")));
        DescribeGroupsResponseData expectedResponse = responseWithGroupInstanceId.duplicate();
        ((DescribeGroupsResponseData.DescribedGroupMember)((DescribeGroupsResponseData.DescribedGroup)expectedResponse.groups().get(0)).members().get(0)).setGroupInstanceId(null);
        this.testAllMessageRoundTripsBeforeVersion((short)4, (Message)responseWithGroupInstanceId, (Message)expectedResponse);
    }

    @Test
    public void testThrottleTimeIgnorableInDescribeGroupsResponse() throws Exception {
        DescribeGroupsResponseData responseWithGroupInstanceId = new DescribeGroupsResponseData().setGroups(Collections.singletonList(new DescribeGroupsResponseData.DescribedGroup().setGroupId("group").setGroupState("Stable").setErrorCode(Errors.NONE.code()).setMembers(Collections.singletonList(new DescribeGroupsResponseData.DescribedGroupMember().setMemberId("memberId"))).setProtocolType("consumer"))).setThrottleTimeMs(10);
        DescribeGroupsResponseData expectedResponse = responseWithGroupInstanceId.duplicate();
        expectedResponse.setThrottleTimeMs(0);
        this.testAllMessageRoundTripsBeforeVersion((short)1, (Message)responseWithGroupInstanceId, (Message)expectedResponse);
    }

    @Test
    public void testOffsetForLeaderEpochVersions() throws Exception {
        OffsetForLeaderEpochRequestData.OffsetForLeaderPartition partitionDataNoCurrentEpoch = new OffsetForLeaderEpochRequestData.OffsetForLeaderPartition().setPartition(0).setLeaderEpoch(3);
        OffsetForLeaderEpochRequestData.OffsetForLeaderPartition partitionDataWithCurrentEpoch = new OffsetForLeaderEpochRequestData.OffsetForLeaderPartition().setPartition(0).setLeaderEpoch(3).setCurrentLeaderEpoch(5);
        OffsetForLeaderEpochRequestData data = new OffsetForLeaderEpochRequestData();
        data.topics().add((ImplicitLinkedHashCollection.Element)new OffsetForLeaderEpochRequestData.OffsetForLeaderTopic().setTopic("foo").setPartitions(Collections.singletonList(partitionDataNoCurrentEpoch)));
        this.testAllMessageRoundTrips((Message)data);
        short lowestVersion = ApiKeys.OFFSET_FOR_LEADER_EPOCH.oldestVersion();
        this.testAllMessageRoundTripsBetweenVersions(lowestVersion, (short)2, (Message)partitionDataWithCurrentEpoch, (Message)partitionDataNoCurrentEpoch);
        this.testAllMessageRoundTripsFromVersion((short)2, (Message)partitionDataWithCurrentEpoch);
        this.testAllMessageRoundTripsFromVersion((short)3, (Message)new OffsetForLeaderEpochRequestData().setReplicaId(5));
        this.testAllMessageRoundTripsBeforeVersion((short)3, (Message)new OffsetForLeaderEpochRequestData().setReplicaId(5), (Message)new OffsetForLeaderEpochRequestData());
        this.testAllMessageRoundTripsBeforeVersion((short)3, (Message)new OffsetForLeaderEpochRequestData().setReplicaId(5), (Message)new OffsetForLeaderEpochRequestData().setReplicaId(-2));
    }

    @ParameterizedTest
    @ApiKeyVersionsSource(apiKey=ApiKeys.OFFSET_COMMIT)
    public void testOffsetCommitRequestVersions(short version) throws Exception {
        OffsetCommitRequestData request = new OffsetCommitRequestData().setGroupId("groupId").setMemberId("memberId").setGenerationIdOrMemberEpoch(version >= 1 ? 10 : -1).setGroupInstanceId(version >= 7 ? "instanceId" : null).setRetentionTimeMs(version >= 2 && version <= 4 ? 20L : -1L).setTopics(Collections.singletonList(new OffsetCommitRequestData.OffsetCommitRequestTopic().setTopicId(version >= 10 ? Uuid.randomUuid() : Uuid.ZERO_UUID).setName(version < 10 ? "topic" : "").setPartitions(Collections.singletonList(new OffsetCommitRequestData.OffsetCommitRequestPartition().setPartitionIndex(1).setCommittedMetadata("metadata").setCommittedOffset(100L).setCommittedLeaderEpoch(version >= 6 ? 10 : -1)))));
        this.testMessageRoundTrip(version, (Message)request, (Message)request);
    }

    @ParameterizedTest
    @ApiKeyVersionsSource(apiKey=ApiKeys.OFFSET_COMMIT)
    public void testOffsetCommitResponseVersions(short version) throws Exception {
        OffsetCommitResponseData response = new OffsetCommitResponseData().setThrottleTimeMs(version >= 3 ? 20 : 0).setTopics(Collections.singletonList(new OffsetCommitResponseData.OffsetCommitResponseTopic().setTopicId(version >= 10 ? Uuid.randomUuid() : Uuid.ZERO_UUID).setName(version < 10 ? "topic" : "").setPartitions(Collections.singletonList(new OffsetCommitResponseData.OffsetCommitResponsePartition().setPartitionIndex(1).setErrorCode(Errors.UNKNOWN_MEMBER_ID.code())))));
        this.testMessageRoundTrip(version, (Message)response, (Message)response);
    }

    @Test
    public void testTxnOffsetCommitRequestVersions() throws Exception {
        String groupId = "groupId";
        String topicName = "topic";
        String metadata = "metadata";
        String txnId = "transactionalId";
        int producerId = 25;
        short producerEpoch = 10;
        String instanceId = "instance";
        String memberId = "member";
        int generationId = 1;
        int partition = 2;
        int offset = 100;
        this.testAllMessageRoundTrips((Message)new TxnOffsetCommitRequestData().setGroupId(groupId).setTransactionalId(txnId).setProducerId((long)producerId).setProducerEpoch(producerEpoch).setTopics(Collections.singletonList(new TxnOffsetCommitRequestData.TxnOffsetCommitRequestTopic().setName(topicName).setPartitions(Collections.singletonList(new TxnOffsetCommitRequestData.TxnOffsetCommitRequestPartition().setPartitionIndex(partition).setCommittedMetadata(metadata).setCommittedOffset((long)offset))))));
        Supplier<TxnOffsetCommitRequestData> request = () -> new TxnOffsetCommitRequestData().setGroupId(groupId).setTransactionalId(txnId).setProducerId((long)producerId).setProducerEpoch(producerEpoch).setGroupInstanceId(instanceId).setMemberId(memberId).setGenerationId(generationId).setTopics(Collections.singletonList(new TxnOffsetCommitRequestData.TxnOffsetCommitRequestTopic().setName(topicName).setPartitions(Collections.singletonList(new TxnOffsetCommitRequestData.TxnOffsetCommitRequestPartition().setPartitionIndex(partition).setCommittedLeaderEpoch(10).setCommittedMetadata(metadata).setCommittedOffset((long)offset)))));
        Iterator iterator = ApiKeys.TXN_OFFSET_COMMIT.allVersions().iterator();
        while (iterator.hasNext()) {
            short version = (Short)iterator.next();
            TxnOffsetCommitRequestData requestData = request.get();
            if (version < 2) {
                ((TxnOffsetCommitRequestData.TxnOffsetCommitRequestPartition)((TxnOffsetCommitRequestData.TxnOffsetCommitRequestTopic)requestData.topics().get(0)).partitions().get(0)).setCommittedLeaderEpoch(-1);
            }
            if (version < 3) {
                short finalVersion = version;
                Assertions.assertThrows(UnsupportedVersionException.class, () -> this.testEquivalentMessageRoundTrip(finalVersion, (Message)requestData));
                requestData.setGroupInstanceId(null);
                Assertions.assertThrows(UnsupportedVersionException.class, () -> this.testEquivalentMessageRoundTrip(finalVersion, (Message)requestData));
                requestData.setMemberId("");
                Assertions.assertThrows(UnsupportedVersionException.class, () -> this.testEquivalentMessageRoundTrip(finalVersion, (Message)requestData));
                requestData.setGenerationId(-1);
            }
            this.testAllMessageRoundTripsFromVersion(version, (Message)requestData);
        }
    }

    @Test
    public void testTxnOffsetCommitResponseVersions() throws Exception {
        this.testAllMessageRoundTrips((Message)new TxnOffsetCommitResponseData().setTopics(Collections.singletonList(new TxnOffsetCommitResponseData.TxnOffsetCommitResponseTopic().setName("topic").setPartitions(Collections.singletonList(new TxnOffsetCommitResponseData.TxnOffsetCommitResponsePartition().setPartitionIndex(1).setErrorCode(Errors.UNKNOWN_MEMBER_ID.code()))))).setThrottleTimeMs(20));
    }

    @ParameterizedTest
    @ApiKeyVersionsSource(apiKey=ApiKeys.OFFSET_FETCH)
    public void testOffsetFetchRequestVersions(short version) throws Exception {
        OffsetFetchRequestData request = version < 8 ? new OffsetFetchRequestData().setGroupId("groupId").setRequireStable(version == 7).setTopics(List.of(new OffsetFetchRequestData.OffsetFetchRequestTopic().setName("foo").setPartitionIndexes(List.of(Integer.valueOf(0), Integer.valueOf(1), Integer.valueOf(2))))) : new OffsetFetchRequestData().setRequireStable(true).setGroups(List.of(new OffsetFetchRequestData.OffsetFetchRequestGroup().setGroupId("groupId").setMemberId(version >= 9 ? "memberId" : null).setMemberEpoch(version >= 9 ? 10 : -1).setTopics(List.of(new OffsetFetchRequestData.OffsetFetchRequestTopics().setName(version < 10 ? "foo" : "").setTopicId(version >= 10 ? Uuid.randomUuid() : Uuid.ZERO_UUID).setPartitionIndexes(List.of(Integer.valueOf(0), Integer.valueOf(1), Integer.valueOf(2)))))));
        this.testMessageRoundTrip(version, (Message)request, (Message)request);
    }

    @ParameterizedTest
    @ApiKeyVersionsSource(apiKey=ApiKeys.OFFSET_FETCH)
    public void testOffsetFetchResponseVersions(short version) throws Exception {
        OffsetFetchResponseData response = version < 8 ? new OffsetFetchResponseData().setThrottleTimeMs(version >= 3 ? 1000 : 0).setErrorCode(version >= 2 ? Errors.INVALID_GROUP_ID.code() : (short)0).setTopics(List.of(new OffsetFetchResponseData.OffsetFetchResponseTopic().setName("foo").setPartitions(List.of(new OffsetFetchResponseData.OffsetFetchResponsePartition().setPartitionIndex(0).setCommittedOffset(10L).setMetadata("meta").setCommittedLeaderEpoch(version >= 5 ? 20 : -1).setErrorCode(Errors.UNKNOWN_TOPIC_OR_PARTITION.code()))))) : new OffsetFetchResponseData().setThrottleTimeMs(1000).setGroups(List.of(new OffsetFetchResponseData.OffsetFetchResponseGroup().setGroupId("groupId").setErrorCode(Errors.INVALID_GROUP_ID.code()).setTopics(List.of(new OffsetFetchResponseData.OffsetFetchResponseTopics().setName(version < 10 ? "foo" : "").setTopicId(version >= 10 ? Uuid.randomUuid() : Uuid.ZERO_UUID).setPartitions(List.of(new OffsetFetchResponseData.OffsetFetchResponsePartitions().setPartitionIndex(0).setCommittedOffset(10L).setMetadata("meta").setCommittedLeaderEpoch(20).setErrorCode(Errors.UNKNOWN_TOPIC_OR_PARTITION.code())))))));
        this.testMessageRoundTrip(version, (Message)response, (Message)response);
    }

    @Test
    public void testProduceResponseVersions() throws Exception {
        String topicName = "topic";
        Uuid topicId = Uuid.fromString((String)"klZ9sa2rSvig6QpgGXzALT");
        int partitionIndex = 0;
        short errorCode = Errors.INVALID_TOPIC_EXCEPTION.code();
        long baseOffset = 12L;
        int throttleTimeMs = 1234;
        long logAppendTimeMs = 1234L;
        long logStartOffset = 1234L;
        int batchIndex = 0;
        String batchIndexErrorMessage = "error message";
        String errorMessage = "global error message";
        this.testAllMessageRoundTrips((Message)new ProduceResponseData().setResponses(new ProduceResponseData.TopicProduceResponseCollection(Collections.singletonList(new ProduceResponseData.TopicProduceResponse().setPartitionResponses(Collections.singletonList(new ProduceResponseData.PartitionProduceResponse().setIndex(partitionIndex).setErrorCode(errorCode).setBaseOffset(baseOffset)))).iterator())));
        Supplier<ProduceResponseData> response = () -> new ProduceResponseData().setResponses(new ProduceResponseData.TopicProduceResponseCollection(Collections.singletonList(new ProduceResponseData.TopicProduceResponse().setPartitionResponses(Collections.singletonList(new ProduceResponseData.PartitionProduceResponse().setIndex(partitionIndex).setErrorCode(errorCode).setBaseOffset(baseOffset).setLogAppendTimeMs(logAppendTimeMs).setLogStartOffset(logStartOffset).setRecordErrors(Collections.singletonList(new ProduceResponseData.BatchIndexAndErrorMessage().setBatchIndex(batchIndex).setBatchIndexErrorMessage(batchIndexErrorMessage))).setErrorMessage(errorMessage)))).iterator())).setThrottleTimeMs(throttleTimeMs);
        Iterator iterator = ApiKeys.PRODUCE.allVersions().iterator();
        while (iterator.hasNext()) {
            short version = (Short)iterator.next();
            ProduceResponseData responseData = response.get();
            if (version < 8) {
                ((ProduceResponseData.PartitionProduceResponse)((ProduceResponseData.TopicProduceResponse)responseData.responses().iterator().next()).partitionResponses().get(0)).setRecordErrors(Collections.emptyList());
                ((ProduceResponseData.PartitionProduceResponse)((ProduceResponseData.TopicProduceResponse)responseData.responses().iterator().next()).partitionResponses().get(0)).setErrorMessage(null);
            }
            if (version < 5) {
                ((ProduceResponseData.PartitionProduceResponse)((ProduceResponseData.TopicProduceResponse)responseData.responses().iterator().next()).partitionResponses().get(0)).setLogStartOffset(-1L);
            }
            if (version < 2) {
                ((ProduceResponseData.PartitionProduceResponse)((ProduceResponseData.TopicProduceResponse)responseData.responses().iterator().next()).partitionResponses().get(0)).setLogAppendTimeMs(-1L);
            }
            if (version < 1) {
                responseData.setThrottleTimeMs(0);
            }
            if (version >= 13) {
                ((ProduceResponseData.TopicProduceResponse)responseData.responses().iterator().next()).setTopicId(topicId);
            } else {
                ((ProduceResponseData.TopicProduceResponse)responseData.responses().iterator().next()).setName(topicName);
            }
            if (version >= 3 && version <= 4) {
                this.testAllMessageRoundTripsBetweenVersions(version, (short)5, (Message)responseData, (Message)responseData);
                continue;
            }
            if (version >= 6 && version <= 7) {
                this.testAllMessageRoundTripsBetweenVersions(version, (short)8, (Message)responseData, (Message)responseData);
                continue;
            }
            if (version <= 12) {
                this.testAllMessageRoundTripsBetweenVersions(version, (short)12, (Message)responseData, (Message)responseData);
                continue;
            }
            this.testEquivalentMessageRoundTrip(version, (Message)responseData);
        }
    }

    @Test
    public void defaultValueShouldBeWritable() {
        for (short version = 0; version <= 2; version = (short)(version + 1)) {
            MessageUtil.toByteBufferAccessor((Message)new SimpleExampleMessageData(), (short)version).buffer();
        }
    }

    @Test
    public void testSimpleMessage() throws Exception {
        SimpleExampleMessageData message = new SimpleExampleMessageData();
        message.setMyStruct(new SimpleExampleMessageData.MyStruct().setStructId(25).setArrayInStruct(Collections.singletonList(new SimpleExampleMessageData.StructArray().setArrayFieldId(20))));
        message.setMyTaggedStruct(new SimpleExampleMessageData.TaggedStruct().setStructId("abc"));
        message.setProcessId(Uuid.randomUuid());
        message.setMyNullableString("notNull");
        message.setMyInt16((short)3);
        message.setMyString("test string");
        SimpleExampleMessageData duplicate = message.duplicate();
        Assertions.assertEquals((Object)duplicate, (Object)message);
        Assertions.assertEquals((Object)message, (Object)duplicate);
        duplicate.setMyTaggedIntArray(Collections.singletonList(123));
        Assertions.assertNotEquals((Object)duplicate, (Object)message);
        Assertions.assertNotEquals((Object)message, (Object)duplicate);
        this.testAllMessageRoundTripsFromVersion((short)2, (Message)message);
    }

    private void testAllMessageRoundTrips(Message message) throws Exception {
        this.testDuplication(message);
        this.testAllMessageRoundTripsFromVersion(message.lowestSupportedVersion(), message);
    }

    private void testDuplication(Message message) {
        Message duplicate = message.duplicate();
        Assertions.assertEquals((Object)duplicate, (Object)message);
        Assertions.assertEquals((Object)message, (Object)duplicate);
        Assertions.assertEquals((int)duplicate.hashCode(), (int)message.hashCode());
        Assertions.assertEquals((int)message.hashCode(), (int)duplicate.hashCode());
    }

    private void testAllMessageRoundTripsBeforeVersion(short beforeVersion, Message message, Message expected) throws Exception {
        this.testAllMessageRoundTripsBetweenVersions((short)0, beforeVersion, message, expected);
    }

    private void testAllMessageRoundTripsBetweenVersions(short startVersion, short endVersion, Message message, Message expected) throws Exception {
        for (short version = startVersion; version < endVersion; version = (short)(version + 1)) {
            this.testMessageRoundTrip(version, message, expected);
        }
    }

    private void testAllMessageRoundTripsFromVersion(short fromVersion, Message message) throws Exception {
        for (short version = fromVersion; version <= message.highestSupportedVersion(); version = (short)(version + 1)) {
            this.testEquivalentMessageRoundTrip(version, message);
        }
    }

    private void testAllMessageRoundTripsUntilVersion(short untilVersion, Message message) throws Exception {
        for (short version = message.lowestSupportedVersion(); version <= untilVersion; version = (short)(version + 1)) {
            this.testEquivalentMessageRoundTrip(version, message);
        }
    }

    private void testMessageRoundTrip(short version, Message message, Message expected) throws Exception {
        this.testByteBufferRoundTrip(version, message, expected);
    }

    private void testEquivalentMessageRoundTrip(short version, Message message) throws Exception {
        this.testByteBufferRoundTrip(version, message, message);
        this.testJsonRoundTrip(version, message, message);
    }

    private void testByteBufferRoundTrip(short version, Message message, Message expected) throws Exception {
        ObjectSerializationCache cache = new ObjectSerializationCache();
        int size = message.size(cache, version);
        ByteBuffer buf = ByteBuffer.allocate(size);
        ByteBufferAccessor byteBufferAccessor = new ByteBufferAccessor(buf);
        message.write((Writable)byteBufferAccessor, cache, version);
        Assertions.assertEquals((int)size, (int)buf.position(), (String)("The result of the size function does not match the number of bytes written for version " + version));
        Message message2 = (Message)message.getClass().getConstructor(new Class[0]).newInstance(new Object[0]);
        buf.flip();
        message2.read((Readable)byteBufferAccessor, version);
        Assertions.assertEquals((int)size, (int)buf.position(), (String)("The result of the size function does not match the number of bytes read back in for version " + version));
        Assertions.assertEquals((Object)expected, (Object)message2, (String)("The message object created after a round trip did not match for version " + version));
        Assertions.assertEquals((int)expected.hashCode(), (int)message2.hashCode());
        Assertions.assertEquals((Object)expected.toString(), (Object)message2.toString());
    }

    private void testJsonRoundTrip(short version, Message message, Message expected) throws Exception {
        String jsonConverter = MessageTest.jsonConverterTypeName(message.getClass().getTypeName());
        Class<?> converter = Class.forName(jsonConverter);
        Method writeMethod = converter.getMethod("write", message.getClass(), Short.TYPE);
        JsonNode jsonNode = (JsonNode)writeMethod.invoke(null, message, version);
        Method readMethod = converter.getMethod("read", JsonNode.class, Short.TYPE);
        Message message2 = (Message)readMethod.invoke(null, jsonNode, version);
        Assertions.assertEquals((Object)expected, (Object)message2);
        Assertions.assertEquals((int)expected.hashCode(), (int)message2.hashCode());
        Assertions.assertEquals((Object)expected.toString(), (Object)message2.toString());
    }

    private static String jsonConverterTypeName(String source) {
        int outerClassIndex = source.lastIndexOf(36);
        if (outerClassIndex == -1) {
            return source + "JsonConverter";
        }
        return source.substring(0, outerClassIndex) + "JsonConverter$" + source.substring(outerClassIndex + 1) + "JsonConverter";
    }

    @Test
    public void testMessageVersions() {
        for (ApiKeys apiKey : ApiKeys.values()) {
            if (!apiKey.hasValidVersion()) continue;
            ApiMessage message = null;
            try {
                message = ApiMessageType.fromApiKey((short)apiKey.id).newRequest();
            }
            catch (UnsupportedVersionException e) {
                Assertions.fail((String)("No request message spec found for API " + String.valueOf(apiKey)));
            }
            Assertions.assertTrue((apiKey.latestVersion() <= message.highestSupportedVersion() ? 1 : 0) != 0, (String)("Request message spec for " + String.valueOf(apiKey) + " only supports versions up to " + message.highestSupportedVersion()));
            try {
                message = ApiMessageType.fromApiKey((short)apiKey.id).newResponse();
            }
            catch (UnsupportedVersionException e) {
                Assertions.fail((String)("No response message spec found for API " + String.valueOf(apiKey)));
            }
            Assertions.assertTrue((apiKey.latestVersion() <= message.highestSupportedVersion() ? 1 : 0) != 0, (String)("Response message spec for " + String.valueOf(apiKey) + " only supports versions up to " + message.highestSupportedVersion()));
        }
    }

    @Test
    public void testDefaultValues() {
        this.verifyWriteSucceeds((short)2, (Message)new OffsetCommitRequestData().setRetentionTimeMs(123L));
        this.verifyWriteRaisesUve((short)5, "forgotten", (Message)new FetchRequestData().setForgottenTopicsData(Collections.singletonList(new FetchRequestData.ForgottenTopic().setTopic("foo"))));
        this.verifyWriteSucceeds((short)5, (Message)new FetchRequestData());
        this.verifyWriteSucceeds((short)7, (Message)new FetchRequestData().setForgottenTopicsData(Collections.singletonList(new FetchRequestData.ForgottenTopic().setTopic("foo"))));
    }

    @Test
    public void testNonIgnorableFieldWithDefaultNull() {
        this.verifyWriteRaisesUve((short)0, "groupInstanceId", (Message)new HeartbeatRequestData().setGroupId("groupId").setGenerationId(15).setMemberId("memberId").setGroupInstanceId("instanceId"));
        this.verifyWriteSucceeds((short)0, (Message)new HeartbeatRequestData().setGroupId("groupId").setGenerationId(15).setMemberId("memberId").setGroupInstanceId(null));
        this.verifyWriteSucceeds((short)0, (Message)new HeartbeatRequestData().setGroupId("groupId").setGenerationId(15).setMemberId("memberId"));
    }

    @Test
    public void testWriteNullForNonNullableFieldRaisesException() {
        CreateTopicsRequestData createTopics = new CreateTopicsRequestData().setTopics(null);
        Iterator iterator = ApiKeys.CREATE_TOPICS.allVersions().iterator();
        while (iterator.hasNext()) {
            short version = (Short)iterator.next();
            this.verifyWriteRaisesNpe(version, (Message)createTopics);
        }
        MetadataRequestData metadata = new MetadataRequestData().setTopics(null);
        this.verifyWriteRaisesNpe((short)0, (Message)metadata);
    }

    @Test
    public void testUnknownTaggedFields() {
        CreateTopicsRequestData createTopics = new CreateTopicsRequestData();
        this.verifyWriteSucceeds((short)6, (Message)createTopics);
        RawTaggedField field1000 = new RawTaggedField(1000, new byte[]{1, 2, 3});
        createTopics.unknownTaggedFields().add(field1000);
        this.verifyWriteRaisesUve((short)0, "Tagged fields were set", (Message)createTopics);
        this.verifyWriteSucceeds((short)6, (Message)createTopics);
    }

    @Test
    public void testLongTaggedString() {
        char[] chars = new char[1024];
        Arrays.fill(chars, 'a');
        String longString = new String(chars);
        SimpleExampleMessageData message = new SimpleExampleMessageData().setMyString(longString);
        ObjectSerializationCache cache = new ObjectSerializationCache();
        short version = 1;
        int size = message.size(cache, version);
        ByteBuffer buf = ByteBuffer.allocate(size);
        ByteBufferAccessor byteBufferAccessor = new ByteBufferAccessor(buf);
        message.write((Writable)byteBufferAccessor, cache, version);
        Assertions.assertEquals((int)size, (int)buf.position());
    }

    private void verifyWriteRaisesNpe(short version, Message message) {
        ObjectSerializationCache cache = new ObjectSerializationCache();
        Assertions.assertThrows(NullPointerException.class, () -> {
            int size = message.size(cache, version);
            ByteBuffer buf = ByteBuffer.allocate(size);
            ByteBufferAccessor byteBufferAccessor = new ByteBufferAccessor(buf);
            message.write((Writable)byteBufferAccessor, cache, version);
        });
    }

    private void verifyWriteRaisesUve(short version, String problemText, Message message) {
        ObjectSerializationCache cache = new ObjectSerializationCache();
        UnsupportedVersionException e = (UnsupportedVersionException)Assertions.assertThrows(UnsupportedVersionException.class, () -> {
            int size = message.size(cache, version);
            ByteBuffer buf = ByteBuffer.allocate(size);
            ByteBufferAccessor byteBufferAccessor = new ByteBufferAccessor(buf);
            message.write((Writable)byteBufferAccessor, cache, version);
        });
        Assertions.assertTrue((boolean)e.getMessage().contains(problemText), (String)("Expected to get an error message about " + problemText + ", but got: " + e.getMessage()));
    }

    private void verifyWriteSucceeds(short version, Message message) {
        ObjectSerializationCache cache = new ObjectSerializationCache();
        int size = message.size(cache, version);
        ByteBuffer buf = ByteBuffer.allocate(size * 2);
        ByteBufferAccessor byteBufferAccessor = new ByteBufferAccessor(buf);
        message.write((Writable)byteBufferAccessor, cache, version);
        Assertions.assertEquals((int)size, (int)buf.position(), (String)("Expected the serialized size to be " + size + ", but it was " + buf.position()));
    }

    @Test
    public void testCompareWithUnknownTaggedFields() {
        CreateTopicsRequestData createTopics = new CreateTopicsRequestData();
        createTopics.setTimeoutMs(123);
        CreateTopicsRequestData createTopics2 = new CreateTopicsRequestData();
        createTopics2.setTimeoutMs(123);
        Assertions.assertEquals((Object)createTopics, (Object)createTopics2);
        Assertions.assertEquals((Object)createTopics2, (Object)createTopics);
        createTopics.unknownTaggedFields();
        Assertions.assertEquals((Object)createTopics, (Object)createTopics2);
        Assertions.assertEquals((Object)createTopics2, (Object)createTopics);
        createTopics.unknownTaggedFields().add(new RawTaggedField(0, new byte[]{0}));
        Assertions.assertNotEquals((Object)createTopics, (Object)createTopics2);
        Assertions.assertNotEquals((Object)createTopics2, (Object)createTopics);
        createTopics2.unknownTaggedFields().add(new RawTaggedField(0, new byte[]{0}));
        Assertions.assertEquals((Object)createTopics, (Object)createTopics2);
        Assertions.assertEquals((Object)createTopics2, (Object)createTopics);
    }
}

