/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.security.oauthbearer;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.security.auth.callback.Callback;
import javax.security.auth.login.AppConfigurationEntry;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.security.oauthbearer.DefaultJwtValidator;
import org.apache.kafka.common.security.oauthbearer.JwtValidator;
import org.apache.kafka.common.security.oauthbearer.JwtValidatorException;
import org.apache.kafka.common.security.oauthbearer.OAuthBearerToken;
import org.apache.kafka.common.security.oauthbearer.OAuthBearerValidatorCallback;
import org.apache.kafka.common.security.oauthbearer.OAuthBearerValidatorCallbackHandler;
import org.apache.kafka.common.security.oauthbearer.internals.secured.AccessTokenBuilder;
import org.apache.kafka.common.security.oauthbearer.internals.secured.CloseableVerificationKeyResolver;
import org.apache.kafka.common.security.oauthbearer.internals.secured.OAuthBearerTest;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class OAuthBearerValidatorCallbackHandlerTest
extends OAuthBearerTest {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testBasic() throws Exception {
        String expectedAudience = "a";
        List<String> allAudiences = Arrays.asList(expectedAudience, "b", "c");
        AccessTokenBuilder builder = new AccessTokenBuilder().audience(expectedAudience).jwk(this.createRsaJwk()).alg("RS256");
        String accessToken = builder.build();
        Map<String, ?> configs = this.getSaslConfigs("sasl.oauthbearer.expected.audience", allAudiences);
        CloseableVerificationKeyResolver verificationKeyResolver = this.createVerificationKeyResolver(builder);
        JwtValidator jwtValidator = this.createJwtValidator(verificationKeyResolver);
        handler.configure(configs, "OAUTHBEARER", this.getJaasConfigEntries(), verificationKeyResolver, jwtValidator);
        try (OAuthBearerValidatorCallbackHandler handler = new OAuthBearerValidatorCallbackHandler();){
            OAuthBearerValidatorCallback callback = new OAuthBearerValidatorCallback(accessToken);
            handler.handle(new Callback[]{callback});
            Assertions.assertNotNull((Object)callback.token());
            OAuthBearerToken token = callback.token();
            Assertions.assertEquals((Object)accessToken, (Object)token.value());
            Assertions.assertEquals((Object)builder.subject(), (Object)token.principalName());
            Assertions.assertEquals((long)(builder.expirationSeconds() * 1000L), (long)token.lifetimeMs());
            Assertions.assertEquals((long)(builder.issuedAtSeconds() * 1000L), (Long)token.startTimeMs());
        }
    }

    @Test
    public void testInvalidAccessToken() throws Exception {
        String substring = "invalid_token";
        this.assertInvalidAccessTokenFails("this isn't valid", substring);
        this.assertInvalidAccessTokenFails("this.isn't.valid", substring);
        this.assertInvalidAccessTokenFails(this.createJwt("this", "isn't", "valid"), substring);
        this.assertInvalidAccessTokenFails(this.createJwt("{}", "{}", "{}"), substring);
    }

    @Test
    public void testHandlerConfigureThrowsException() throws IOException {
        final KafkaException configureError = new KafkaException("configure() error");
        AccessTokenBuilder builder = new AccessTokenBuilder().alg("RS256");
        CloseableVerificationKeyResolver verificationKeyResolver = this.createVerificationKeyResolver(builder);
        JwtValidator jwtValidator = new JwtValidator(){

            public void configure(Map<String, ?> configs, String saslMechanism, List<AppConfigurationEntry> jaasConfigEntries) {
                throw configureError;
            }

            public OAuthBearerToken validate(String accessToken) throws JwtValidatorException {
                return null;
            }
        };
        OAuthBearerValidatorCallbackHandler handler = new OAuthBearerValidatorCallbackHandler();
        KafkaException error = (KafkaException)Assertions.assertThrows(KafkaException.class, () -> handler.configure(this.getSaslConfigs(), "OAUTHBEARER", this.getJaasConfigEntries(), verificationKeyResolver, jwtValidator));
        Assertions.assertEquals((Object)((Object)configureError), (Object)((Object)error));
    }

    @Test
    public void testHandlerCloseDoesNotThrowException() throws IOException {
        AccessTokenBuilder builder = new AccessTokenBuilder().alg("RS256");
        CloseableVerificationKeyResolver verificationKeyResolver = this.createVerificationKeyResolver(builder);
        JwtValidator jwtValidator = new JwtValidator(){

            public void close() throws IOException {
                throw new IOException("close() error");
            }

            public OAuthBearerToken validate(String accessToken) throws JwtValidatorException {
                return null;
            }
        };
        OAuthBearerValidatorCallbackHandler handler = new OAuthBearerValidatorCallbackHandler();
        handler.configure(this.getSaslConfigs(), "OAUTHBEARER", this.getJaasConfigEntries(), verificationKeyResolver, jwtValidator);
        Assertions.assertDoesNotThrow(() -> ((OAuthBearerValidatorCallbackHandler)handler).close());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void assertInvalidAccessTokenFails(String accessToken, String expectedMessageSubstring) throws Exception {
        AccessTokenBuilder builder = new AccessTokenBuilder().alg("RS256");
        Map<String, ?> configs = this.getSaslConfigs();
        CloseableVerificationKeyResolver verificationKeyResolver = this.createVerificationKeyResolver(builder);
        JwtValidator jwtValidator = this.createJwtValidator(verificationKeyResolver);
        handler.configure(configs, "OAUTHBEARER", this.getJaasConfigEntries(), verificationKeyResolver, jwtValidator);
        try (OAuthBearerValidatorCallbackHandler handler = new OAuthBearerValidatorCallbackHandler();){
            OAuthBearerValidatorCallback callback = new OAuthBearerValidatorCallback(accessToken);
            handler.handle(new Callback[]{callback});
            Assertions.assertNull((Object)callback.token());
            String actualMessage = callback.errorStatus();
            Assertions.assertNotNull((Object)actualMessage);
            Assertions.assertTrue((boolean)actualMessage.contains(expectedMessageSubstring), (String)String.format("The error message \"%s\" didn't contain the expected substring \"%s\"", actualMessage, expectedMessageSubstring));
        }
    }

    private JwtValidator createJwtValidator(CloseableVerificationKeyResolver verificationKeyResolver) {
        return new DefaultJwtValidator(verificationKeyResolver);
    }

    private CloseableVerificationKeyResolver createVerificationKeyResolver(AccessTokenBuilder builder) {
        return (jws, nestingContext) -> builder.jwk().getPublicKey();
    }
}

