/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.security.oauthbearer.internals.secured;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import java.security.Key;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.kafka.common.security.oauthbearer.internals.secured.ClaimValidationUtils;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.common.utils.Time;
import org.jose4j.jwk.PublicJsonWebKey;
import org.jose4j.jws.JsonWebSignature;
import org.jose4j.lang.JoseException;

public class AccessTokenBuilder {
    private final String scopeClaimName = "scope";
    private final Long issuedAtSeconds;
    private final ObjectMapper objectMapper = new ObjectMapper();
    private String alg;
    private String audience;
    private String subject = "jdoe";
    private String subjectClaimName = "sub";
    private Object scope = "engineering";
    private Long expirationSeconds;
    private PublicJsonWebKey jwk;
    private final Map<String, String> customClaims = new HashMap<String, String>();

    public AccessTokenBuilder() {
        this(new MockTime());
    }

    public AccessTokenBuilder(Time time) {
        this.issuedAtSeconds = time.milliseconds() / 1000L;
        this.expirationSeconds = this.issuedAtSeconds + 60L;
    }

    public String alg() {
        return this.alg;
    }

    public AccessTokenBuilder alg(String alg) {
        this.alg = alg;
        return this;
    }

    public AccessTokenBuilder audience(String audience) {
        this.audience = audience;
        return this;
    }

    public String subject() {
        return this.subject;
    }

    public AccessTokenBuilder subject(String subject) {
        this.subject = subject;
        return this;
    }

    public String subjectClaimName() {
        return this.subjectClaimName;
    }

    public AccessTokenBuilder subjectClaimName(String subjectClaimName) {
        this.subjectClaimName = subjectClaimName;
        return this;
    }

    public Object scope() {
        return this.scope;
    }

    public AccessTokenBuilder scope(Object scope) {
        this.scope = scope;
        if (scope instanceof String) {
            return this;
        }
        if (scope instanceof Collection) {
            return this;
        }
        throw new IllegalArgumentException(String.format("%s parameter must be a %s or a %s containing %s", "scope", String.class.getName(), Collection.class.getName(), String.class.getName()));
    }

    public String scopeClaimName() {
        return "scope";
    }

    public Long issuedAtSeconds() {
        return this.issuedAtSeconds;
    }

    public Long expirationSeconds() {
        return this.expirationSeconds;
    }

    public AccessTokenBuilder expirationSeconds(Long expirationSeconds) {
        this.expirationSeconds = expirationSeconds;
        return this;
    }

    public PublicJsonWebKey jwk() {
        return this.jwk;
    }

    public AccessTokenBuilder jwk(PublicJsonWebKey jwk) {
        this.jwk = jwk;
        return this;
    }

    public AccessTokenBuilder addCustomClaim(String name, String value) {
        String validatedName = ClaimValidationUtils.validateClaimNameOverride((String)"claim name", (String)name);
        String validatedValue = ClaimValidationUtils.validateClaimNameOverride((String)validatedName, (String)value);
        this.customClaims.put(validatedName, validatedValue);
        return this;
    }

    public String build() throws JoseException, IOException {
        ObjectNode node = this.objectMapper.createObjectNode();
        if (this.audience != null) {
            node.put("aud", this.audience);
        }
        if (this.subject != null) {
            node.put(this.subjectClaimName, this.subject);
        }
        if (this.scope instanceof String) {
            node.put("scope", (String)this.scope);
        } else if (this.scope instanceof Collection) {
            ArrayNode child = node.putArray("scope");
            ((Collection)this.scope).forEach(arg_0 -> ((ArrayNode)child).add(arg_0));
        } else {
            throw new IllegalArgumentException(String.format("%s claim must be a %s or a %s containing %s", "scope", String.class.getName(), Collection.class.getName(), String.class.getName()));
        }
        if (this.issuedAtSeconds != null) {
            node.put("iat", this.issuedAtSeconds);
        }
        if (this.expirationSeconds != null) {
            node.put("exp", this.expirationSeconds);
        }
        for (Map.Entry entry : this.customClaims.entrySet()) {
            node.put((String)entry.getKey(), (String)entry.getValue());
        }
        String json = this.objectMapper.writeValueAsString((Object)node);
        JsonWebSignature jsonWebSignature = new JsonWebSignature();
        jsonWebSignature.setPayload(json);
        if (this.jwk != null) {
            jsonWebSignature.setKey((Key)this.jwk.getPrivateKey());
            jsonWebSignature.setKeyIdHeaderValue(this.jwk.getKeyId());
        }
        if (this.alg != null) {
            jsonWebSignature.setAlgorithmHeaderValue(this.alg);
        }
        return jsonWebSignature.getCompactSerialization();
    }
}

