/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.telemetry.internals;

import java.util.Collections;
import java.util.HashMap;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.telemetry.internals.MetricKey;
import org.apache.kafka.common.telemetry.internals.MetricNamingStrategy;
import org.apache.kafka.common.telemetry.internals.TelemetryMetricNamingConvention;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class TelemetryMetricNamingConventionTest {
    private MetricNamingStrategy<MetricName> metricNamingStrategy;

    @BeforeEach
    public void setUp() {
        this.metricNamingStrategy = TelemetryMetricNamingConvention.getClientTelemetryMetricNamingStrategy((String)"org.apache.kafka");
    }

    @Test
    public void testMetricKey() {
        MetricName metricName = new MetricName("name", "group", "description", Collections.emptyMap());
        MetricKey metricKey = this.metricNamingStrategy.metricKey((Object)metricName);
        Assertions.assertEquals((Object)"org.apache.kafka.group.name", (Object)metricKey.name());
        Assertions.assertEquals(Collections.emptyMap(), (Object)metricKey.tags());
    }

    @Test
    public void testMetricKeyWithHyphenNameAndNonEmptyTags() {
        HashMap<String, String> tags = new HashMap<String, String>();
        tags.put("tag1", "value1");
        tags.put("tag2", "value2");
        MetricName metricName = new MetricName("test-name", "group-name", "description", tags);
        MetricKey metricKey = this.metricNamingStrategy.metricKey((Object)metricName);
        Assertions.assertEquals((Object)"org.apache.kafka.group.name.test.name", (Object)metricKey.name());
        Assertions.assertEquals(tags, (Object)metricKey.tags());
    }

    @Test
    public void testMetricKeyWithMixedNameAndMixedTags() {
        HashMap<String, String> tags = new HashMap<String, String>();
        tags.put("tag1-Ab-2_(", "value1");
        tags.put("tag2-HELLO.@", "value2");
        MetricName metricName = new MetricName("test-Name-1.$", "grouP-name-AB_&", "description", tags);
        MetricKey metricKey = this.metricNamingStrategy.metricKey((Object)metricName);
        tags.clear();
        tags.put("tag1_ab_2_(", "value1");
        tags.put("tag2_hello.@", "value2");
        Assertions.assertEquals((Object)"org.apache.kafka.group.name.ab_&.test.name.1.$", (Object)metricKey.name());
        Assertions.assertEquals(tags, (Object)metricKey.tags());
    }

    @Test
    public void testMetricKeyWithNullMetricName() {
        Exception e = (Exception)Assertions.assertThrows(NullPointerException.class, () -> this.metricNamingStrategy.metricKey(null));
        Assertions.assertEquals((Object)"metric name cannot be null", (Object)e.getMessage());
    }

    @Test
    public void testMetricKeyWithEmptyName() {
        MetricName metricName = new MetricName("", "group-1A", "description", Collections.emptyMap());
        MetricKey metricKey = this.metricNamingStrategy.metricKey((Object)metricName);
        Assertions.assertEquals((Object)"org.apache.kafka.group.1a.", (Object)metricKey.name());
        Assertions.assertEquals(Collections.emptyMap(), (Object)metricKey.tags());
    }

    @Test
    public void testMetricKeyWithEmptyGroup() {
        MetricName metricName = new MetricName("name", "", "description", Collections.emptyMap());
        MetricKey metricKey = this.metricNamingStrategy.metricKey((Object)metricName);
        Assertions.assertEquals((Object)"org.apache.kafka..name", (Object)metricKey.name());
        Assertions.assertEquals(Collections.emptyMap(), (Object)metricKey.tags());
    }

    @Test
    public void testMetricKeyWithAdditionalMetricsSuffixInGroup() {
        MetricName metricName = new MetricName("name", "group-metrics", "description", Collections.emptyMap());
        MetricKey metricKey = this.metricNamingStrategy.metricKey((Object)metricName);
        Assertions.assertEquals((Object)"org.apache.kafka.group.name", (Object)metricKey.name());
        Assertions.assertEquals(Collections.emptyMap(), (Object)metricKey.tags());
    }

    @Test
    public void testMetricKeyWithMultipleMetricsSuffixInGroup() {
        MetricName metricName = new MetricName("name-metrics", "group-metrics-metrics", "description", Collections.emptyMap());
        MetricKey metricKey = this.metricNamingStrategy.metricKey((Object)metricName);
        Assertions.assertEquals((Object)"org.apache.kafka.group.name.metrics", (Object)metricKey.name());
        Assertions.assertEquals(Collections.emptyMap(), (Object)metricKey.tags());
    }

    @Test
    public void testMetricKeyWithNullTagKey() {
        MetricName metricName = new MetricName("name", "group", "description", Collections.singletonMap(null, "value1"));
        Exception e = (Exception)Assertions.assertThrows(NullPointerException.class, () -> this.metricNamingStrategy.metricKey((Object)metricName));
        Assertions.assertEquals((Object)"metric data cannot be null", (Object)e.getMessage());
    }

    @Test
    public void testMetricKeyWithBlankTagKey() {
        MetricName metricName = new MetricName("name", "group", "description", Collections.singletonMap("", "value1"));
        MetricKey metricKey = this.metricNamingStrategy.metricKey((Object)metricName);
        Assertions.assertEquals((Object)"org.apache.kafka.group.name", (Object)metricKey.name());
        Assertions.assertEquals(Collections.singletonMap("", "value1"), (Object)metricKey.tags());
    }

    @Test
    public void testDerivedMetricKey() {
        MetricName metricName = new MetricName("name", "group", "description", Collections.emptyMap());
        MetricKey metricKey = this.metricNamingStrategy.derivedMetricKey(this.metricNamingStrategy.metricKey((Object)metricName), "delta");
        Assertions.assertEquals((Object)"org.apache.kafka.group.name.delta", (Object)metricKey.name());
        Assertions.assertEquals(Collections.emptyMap(), (Object)metricKey.tags());
    }

    @Test
    public void testDerivedMetricKeyWithTags() {
        MetricName metricName = new MetricName("name", "group", "description", Collections.singletonMap("tag1", "value1"));
        MetricKey metricKey = this.metricNamingStrategy.derivedMetricKey(this.metricNamingStrategy.metricKey((Object)metricName), "delta");
        Assertions.assertEquals((Object)"org.apache.kafka.group.name.delta", (Object)metricKey.name());
        Assertions.assertEquals(Collections.singletonMap("tag1", "value1"), (Object)metricKey.tags());
    }

    @Test
    public void testDerivedMetricKeyWithNullComponent() {
        MetricName metricName = new MetricName("name", "group", "description", Collections.emptyMap());
        Exception e = (Exception)Assertions.assertThrows(NullPointerException.class, () -> this.metricNamingStrategy.derivedMetricKey(this.metricNamingStrategy.metricKey((Object)metricName), null));
        Assertions.assertEquals((Object)"derived component cannot be null", (Object)e.getMessage());
    }

    @Test
    public void testDerivedMetricKeyWithBlankComponent() {
        MetricName metricName = new MetricName("name", "group", "description", Collections.emptyMap());
        MetricKey metricKey = this.metricNamingStrategy.derivedMetricKey(this.metricNamingStrategy.metricKey((Object)metricName), "");
        Assertions.assertEquals((Object)"org.apache.kafka.group.name.", (Object)metricKey.name());
        Assertions.assertEquals(Collections.emptyMap(), (Object)metricKey.tags());
    }

    @Test
    public void testNullPrefix() {
        Exception e = (Exception)Assertions.assertThrows(NullPointerException.class, () -> TelemetryMetricNamingConvention.getClientTelemetryMetricNamingStrategy(null));
        Assertions.assertEquals((Object)"prefix cannot be null", (Object)e.getMessage());
    }

    @Test
    public void testStandardProducerMetrics() {
        Assertions.assertEquals((Object)"org.apache.kafka.producer.connection.creation.rate", (Object)this.metricNamingStrategy.metricKey((Object)new MetricName("connection-creation-rate", "producer-metrics", "description", Collections.emptyMap())).name());
        Assertions.assertEquals((Object)"org.apache.kafka.producer.connection.creation.total", (Object)this.metricNamingStrategy.metricKey((Object)new MetricName("connection-creation-total", "producer-metrics", "description", Collections.emptyMap())).name());
        Assertions.assertEquals((Object)"org.apache.kafka.producer.node.request.latency.avg", (Object)this.metricNamingStrategy.metricKey((Object)new MetricName("request-latency-avg", "producer-node-metrics", "description", Collections.emptyMap())).name());
        Assertions.assertEquals((Object)"org.apache.kafka.producer.node.request.latency.max", (Object)this.metricNamingStrategy.metricKey((Object)new MetricName("request-latency-max", "producer-node-metrics", "description", Collections.emptyMap())).name());
        Assertions.assertEquals((Object)"org.apache.kafka.producer.produce.throttle.time.avg", (Object)this.metricNamingStrategy.metricKey((Object)new MetricName("produce-throttle-time-avg", "producer-metrics", "description", Collections.emptyMap())).name());
        Assertions.assertEquals((Object)"org.apache.kafka.producer.produce.throttle.time.max", (Object)this.metricNamingStrategy.metricKey((Object)new MetricName("produce-throttle-time-max", "producer-metrics", "description", Collections.emptyMap())).name());
        Assertions.assertEquals((Object)"org.apache.kafka.producer.record.queue.time.avg", (Object)this.metricNamingStrategy.metricKey((Object)new MetricName("record-queue-time-avg", "producer-metrics", "description", Collections.emptyMap())).name());
        Assertions.assertEquals((Object)"org.apache.kafka.producer.record.queue.time.max", (Object)this.metricNamingStrategy.metricKey((Object)new MetricName("record-queue-time-max", "producer-metrics", "description", Collections.emptyMap())).name());
    }

    @Test
    public void testStandardConsumerMetrics() {
        Assertions.assertEquals((Object)"org.apache.kafka.consumer.connection.creation.rate", (Object)this.metricNamingStrategy.metricKey((Object)new MetricName("connection-creation-rate", "consumer-metrics", "description", Collections.emptyMap())).name());
        Assertions.assertEquals((Object)"org.apache.kafka.consumer.connection.creation.total", (Object)this.metricNamingStrategy.metricKey((Object)new MetricName("connection-creation-total", "consumer-metrics", "description", Collections.emptyMap())).name());
        Assertions.assertEquals((Object)"org.apache.kafka.consumer.node.request.latency.avg", (Object)this.metricNamingStrategy.metricKey((Object)new MetricName("request-latency-avg", "consumer-node-metrics", "description", Collections.emptyMap())).name());
        Assertions.assertEquals((Object)"org.apache.kafka.consumer.node.request.latency.max", (Object)this.metricNamingStrategy.metricKey((Object)new MetricName("request-latency-max", "consumer-node-metrics", "description", Collections.emptyMap())).name());
        Assertions.assertEquals((Object)"org.apache.kafka.consumer.poll.idle.ratio.avg", (Object)this.metricNamingStrategy.metricKey((Object)new MetricName("poll-idle-ratio-avg", "consumer-metrics", "description", Collections.emptyMap())).name());
        Assertions.assertEquals((Object)"org.apache.kafka.consumer.coordinator.commit.latency.avg", (Object)this.metricNamingStrategy.metricKey((Object)new MetricName("commit-latency-avg", "consumer-coordinator-metrics", "description", Collections.emptyMap())).name());
        Assertions.assertEquals((Object)"org.apache.kafka.consumer.coordinator.commit.latency.max", (Object)this.metricNamingStrategy.metricKey((Object)new MetricName("commit-latency-max", "consumer-coordinator-metrics", "description", Collections.emptyMap())).name());
        Assertions.assertEquals((Object)"org.apache.kafka.consumer.coordinator.assigned.partitions", (Object)this.metricNamingStrategy.metricKey((Object)new MetricName("assigned-partitions", "consumer-coordinator-metrics", "description", Collections.emptyMap())).name());
        Assertions.assertEquals((Object)"org.apache.kafka.consumer.coordinator.rebalance.latency.avg", (Object)this.metricNamingStrategy.metricKey((Object)new MetricName("rebalance-latency-avg", "consumer-coordinator-metrics", "description", Collections.emptyMap())).name());
        Assertions.assertEquals((Object)"org.apache.kafka.consumer.coordinator.rebalance.latency.max", (Object)this.metricNamingStrategy.metricKey((Object)new MetricName("rebalance-latency-max", "consumer-coordinator-metrics", "description", Collections.emptyMap())).name());
        Assertions.assertEquals((Object)"org.apache.kafka.consumer.coordinator.rebalance.latency.total", (Object)this.metricNamingStrategy.metricKey((Object)new MetricName("rebalance-latency-total", "consumer-coordinator-metrics", "description", Collections.emptyMap())).name());
        Assertions.assertEquals((Object)"org.apache.kafka.consumer.fetch.manager.fetch.latency.avg", (Object)this.metricNamingStrategy.metricKey((Object)new MetricName("fetch-latency-avg", "consumer-fetch-manager-metrics", "description", Collections.emptyMap())).name());
        Assertions.assertEquals((Object)"org.apache.kafka.consumer.fetch.manager.fetch.latency.max", (Object)this.metricNamingStrategy.metricKey((Object)new MetricName("fetch-latency-max", "consumer-fetch-manager-metrics", "description", Collections.emptyMap())).name());
    }
}

