/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.test;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.kafka.clients.consumer.ConsumerInterceptor;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.apache.kafka.clients.consumer.OffsetAndMetadata;
import org.apache.kafka.common.ClusterResource;
import org.apache.kafka.common.ClusterResourceListener;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.header.Headers;
import org.apache.kafka.common.header.internals.RecordHeaders;

public class MockConsumerInterceptor
implements ClusterResourceListener,
ConsumerInterceptor<String, String> {
    public static final AtomicInteger INIT_COUNT = new AtomicInteger(0);
    public static final AtomicInteger CLOSE_COUNT = new AtomicInteger(0);
    public static final AtomicInteger ON_COMMIT_COUNT = new AtomicInteger(0);
    public static final AtomicInteger CONFIG_COUNT = new AtomicInteger(0);
    public static final AtomicInteger THROW_CONFIG_EXCEPTION = new AtomicInteger(0);
    public static final AtomicInteger THROW_ON_CONFIG_EXCEPTION_THRESHOLD = new AtomicInteger(0);
    public static final AtomicReference<ClusterResource> CLUSTER_META = new AtomicReference();
    public static final ClusterResource NO_CLUSTER_ID = new ClusterResource("no_cluster_id");
    public static final AtomicReference<ClusterResource> CLUSTER_ID_BEFORE_ON_CONSUME = new AtomicReference<ClusterResource>(NO_CLUSTER_ID);

    public MockConsumerInterceptor() {
        INIT_COUNT.incrementAndGet();
    }

    public void configure(Map<String, ?> configs) {
        Object clientIdValue = configs.get("client.id");
        if (clientIdValue == null) {
            throw new ConfigException("Mock consumer interceptor expects configuration client.id");
        }
        CONFIG_COUNT.incrementAndGet();
        if (CONFIG_COUNT.get() == THROW_ON_CONFIG_EXCEPTION_THRESHOLD.get()) {
            throw new ConfigException("Failed to instantiate interceptor. Reached configuration exception threshold.");
        }
    }

    public ConsumerRecords<String, String> onConsume(ConsumerRecords<String, String> records) {
        CLUSTER_ID_BEFORE_ON_CONSUME.compareAndSet(NO_CLUSTER_ID, CLUSTER_META.get());
        HashMap recordMap = new HashMap();
        HashMap<TopicPartition, OffsetAndMetadata> nextOffsets = new HashMap<TopicPartition, OffsetAndMetadata>();
        for (TopicPartition tp : records.partitions()) {
            ArrayList<ConsumerRecord> lst = new ArrayList<ConsumerRecord>();
            long nextOffset = 0L;
            for (ConsumerRecord record : records.records(tp)) {
                lst.add(new ConsumerRecord(record.topic(), record.partition(), record.offset(), record.timestamp(), record.timestampType(), record.serializedKeySize(), record.serializedValueSize(), (Object)((String)record.key()), (Object)((String)record.value()).toUpperCase(Locale.ROOT), (Headers)new RecordHeaders(), Optional.empty()));
                nextOffset = record.offset() + 1L;
            }
            if (lst.isEmpty()) {
                recordMap.put(tp, List.of());
                continue;
            }
            recordMap.put(tp, lst);
            nextOffsets.put(tp, new OffsetAndMetadata(nextOffset, Optional.empty(), ""));
        }
        return new ConsumerRecords(recordMap, nextOffsets);
    }

    public void onCommit(Map<TopicPartition, OffsetAndMetadata> offsets) {
        ON_COMMIT_COUNT.incrementAndGet();
    }

    public void close() {
        CLOSE_COUNT.incrementAndGet();
    }

    public static void setThrowOnConfigExceptionThreshold(int value) {
        THROW_ON_CONFIG_EXCEPTION_THRESHOLD.set(value);
    }

    public static void resetCounters() {
        INIT_COUNT.set(0);
        CLOSE_COUNT.set(0);
        ON_COMMIT_COUNT.set(0);
        CONFIG_COUNT.set(0);
        THROW_CONFIG_EXCEPTION.set(0);
        CLUSTER_META.set(null);
        CLUSTER_ID_BEFORE_ON_CONSUME.set(NO_CLUSTER_ID);
    }

    public void onUpdate(ClusterResource clusterResource) {
        CLUSTER_META.set(clusterResource);
    }
}

