/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.admin.internals;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.kafka.clients.admin.ListConsumerGroupOffsetsSpec;
import org.apache.kafka.clients.admin.internals.AdminApiHandler;
import org.apache.kafka.clients.admin.internals.CoordinatorKey;
import org.apache.kafka.clients.admin.internals.CoordinatorStrategy;
import org.apache.kafka.clients.admin.internals.ListConsumerGroupOffsetsHandler;
import org.apache.kafka.clients.consumer.OffsetAndMetadata;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.GroupAuthorizationException;
import org.apache.kafka.common.errors.GroupIdNotFoundException;
import org.apache.kafka.common.errors.InvalidGroupIdException;
import org.apache.kafka.common.message.OffsetFetchRequestData;
import org.apache.kafka.common.message.OffsetFetchResponseData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.AbstractResponse;
import org.apache.kafka.common.requests.OffsetFetchRequest;
import org.apache.kafka.common.requests.OffsetFetchResponse;
import org.apache.kafka.common.utils.LogContext;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ListConsumerGroupOffsetsHandlerTest {
    private final LogContext logContext = new LogContext();
    private final String group0 = "group0";
    private final String group1 = "group1";
    private final String group2 = "group2";
    private final String group3 = "group3";
    private final List<String> groups = List.of("group0", "group1", "group2");
    private final TopicPartition t0p0 = new TopicPartition("t0", 0);
    private final TopicPartition t0p1 = new TopicPartition("t0", 1);
    private final TopicPartition t1p0 = new TopicPartition("t1", 0);
    private final TopicPartition t1p1 = new TopicPartition("t1", 1);
    private final TopicPartition t2p0 = new TopicPartition("t2", 0);
    private final TopicPartition t2p1 = new TopicPartition("t2", 1);
    private final TopicPartition t2p2 = new TopicPartition("t2", 2);
    private final TopicPartition t3p0 = new TopicPartition("t3", 0);
    private final TopicPartition t3p1 = new TopicPartition("t3", 1);
    private final Map<String, ListConsumerGroupOffsetsSpec> singleGroupSpec = Map.of("group0", new ListConsumerGroupOffsetsSpec().topicPartitions(Arrays.asList(this.t0p0, this.t0p1, this.t1p0, this.t1p1)));
    private final Map<String, ListConsumerGroupOffsetsSpec> multiGroupSpecs = Map.of("group0", new ListConsumerGroupOffsetsSpec().topicPartitions(Collections.singletonList(this.t0p0)), "group1", new ListConsumerGroupOffsetsSpec().topicPartitions(Arrays.asList(this.t0p0, this.t1p0, this.t1p1)), "group2", new ListConsumerGroupOffsetsSpec().topicPartitions(Arrays.asList(this.t0p0, this.t1p0, this.t1p1, this.t2p0, this.t2p1, this.t2p2)));

    @Test
    public void testBuildRequest() {
        ListConsumerGroupOffsetsHandler handler = new ListConsumerGroupOffsetsHandler(this.singleGroupSpec, false, this.logContext);
        Assertions.assertEquals((Object)new OffsetFetchRequestData().setGroups(List.of(new OffsetFetchRequestData.OffsetFetchRequestGroup().setGroupId("group0").setTopics(List.of(new OffsetFetchRequestData.OffsetFetchRequestTopics().setName(this.t0p0.topic()).setPartitionIndexes(List.of(Integer.valueOf(this.t0p0.partition()), Integer.valueOf(this.t0p1.partition()))), new OffsetFetchRequestData.OffsetFetchRequestTopics().setName(this.t1p0.topic()).setPartitionIndexes(List.of(Integer.valueOf(this.t1p0.partition()), Integer.valueOf(this.t1p1.partition()))))))), (Object)((OffsetFetchRequest)handler.buildBatchedRequest(this.coordinatorKeys("group0")).build()).data());
    }

    @Test
    public void testBuildRequestWithMultipleGroups() {
        HashMap<String, ListConsumerGroupOffsetsSpec> groupSpecs = new HashMap<String, ListConsumerGroupOffsetsSpec>(this.multiGroupSpecs);
        groupSpecs.put("group3", new ListConsumerGroupOffsetsSpec().topicPartitions(List.of(this.t3p0, this.t3p1)));
        ListConsumerGroupOffsetsHandler handler = new ListConsumerGroupOffsetsHandler(groupSpecs, false, this.logContext);
        OffsetFetchRequest request1 = (OffsetFetchRequest)handler.buildBatchedRequest(this.coordinatorKeys("group0", "group1", "group2")).build();
        Assertions.assertEquals(Set.of(new OffsetFetchRequestData.OffsetFetchRequestGroup().setGroupId("group0").setTopics(List.of(new OffsetFetchRequestData.OffsetFetchRequestTopics().setName(this.t0p0.topic()).setPartitionIndexes(List.of(Integer.valueOf(this.t0p0.partition()))))), new OffsetFetchRequestData.OffsetFetchRequestGroup().setGroupId("group1").setTopics(List.of(new OffsetFetchRequestData.OffsetFetchRequestTopics().setName(this.t0p0.topic()).setPartitionIndexes(List.of(Integer.valueOf(this.t0p0.partition()))), new OffsetFetchRequestData.OffsetFetchRequestTopics().setName(this.t1p0.topic()).setPartitionIndexes(List.of(Integer.valueOf(this.t1p0.partition()), Integer.valueOf(this.t1p1.partition()))))), new OffsetFetchRequestData.OffsetFetchRequestGroup().setGroupId("group2").setTopics(List.of(new OffsetFetchRequestData.OffsetFetchRequestTopics().setName(this.t0p0.topic()).setPartitionIndexes(List.of(Integer.valueOf(this.t0p0.partition()))), new OffsetFetchRequestData.OffsetFetchRequestTopics().setName(this.t1p0.topic()).setPartitionIndexes(List.of(Integer.valueOf(this.t1p0.partition()), Integer.valueOf(this.t1p1.partition()))), new OffsetFetchRequestData.OffsetFetchRequestTopics().setName(this.t2p0.topic()).setPartitionIndexes(List.of(Integer.valueOf(this.t2p0.partition()), Integer.valueOf(this.t2p1.partition()), Integer.valueOf(this.t2p2.partition())))))), Set.copyOf(request1.data().groups()));
        OffsetFetchRequest request2 = (OffsetFetchRequest)handler.buildBatchedRequest(this.coordinatorKeys("group3")).build();
        Assertions.assertEquals(Set.of(new OffsetFetchRequestData.OffsetFetchRequestGroup().setGroupId("group3").setTopics(List.of(new OffsetFetchRequestData.OffsetFetchRequestTopics().setName(this.t3p0.topic()).setPartitionIndexes(List.of(Integer.valueOf(this.t3p0.partition()), Integer.valueOf(this.t3p1.partition())))))), Set.copyOf(request2.data().groups()));
    }

    @Test
    public void testBuildRequestBatchGroups() {
        ListConsumerGroupOffsetsHandler handler = new ListConsumerGroupOffsetsHandler(this.multiGroupSpecs, false, this.logContext);
        Collection requests = handler.buildRequest(1, this.coordinatorKeys("group0", "group1", "group2"));
        Assertions.assertEquals((int)1, (int)requests.size());
        Assertions.assertEquals(Set.of("group0", "group1", "group2"), this.requestGroups((OffsetFetchRequest)((AdminApiHandler.RequestAndKeys)requests.iterator().next()).request.build()));
    }

    @Test
    public void testBuildRequestDoesNotBatchGroup() {
        ListConsumerGroupOffsetsHandler handler = new ListConsumerGroupOffsetsHandler(this.multiGroupSpecs, false, this.logContext);
        ((CoordinatorStrategy)handler.lookupStrategy()).disableBatch();
        Collection requests = handler.buildRequest(1, this.coordinatorKeys("group0", "group1", "group2"));
        Assertions.assertEquals((int)3, (int)requests.size());
        Assertions.assertEquals(Set.of(Set.of("group0"), Set.of("group1"), Set.of("group2")), requests.stream().map(requestAndKey -> this.requestGroups((OffsetFetchRequest)requestAndKey.request.build())).collect(Collectors.toSet()));
    }

    @Test
    public void testSuccessfulHandleResponse() {
        HashMap<TopicPartition, OffsetAndMetadata> expected = new HashMap<TopicPartition, OffsetAndMetadata>();
        this.assertCompleted(this.handleWithError(Errors.NONE), expected);
    }

    @Test
    public void testSuccessfulHandleResponseWithOnePartitionError() {
        Map<TopicPartition, OffsetAndMetadata> expectedResult = Collections.singletonMap(this.t0p0, new OffsetAndMetadata(10L));
        this.assertCompleted(this.handleWithPartitionError(Errors.UNKNOWN_TOPIC_OR_PARTITION), expectedResult);
        this.assertCompleted(this.handleWithPartitionError(Errors.TOPIC_AUTHORIZATION_FAILED), expectedResult);
        this.assertCompleted(this.handleWithPartitionError(Errors.UNSTABLE_OFFSET_COMMIT), expectedResult);
    }

    @Test
    public void testSuccessfulHandleResponseWithOnePartitionErrorWithMultipleGroups() {
        Map<String, Map<TopicPartition, OffsetAndMetadata>> expectedResult = Map.of("group0", Map.of(this.t0p0, new OffsetAndMetadata(10L)), "group1", Map.of(this.t1p1, new OffsetAndMetadata(10L)), "group2", Map.of(this.t2p2, new OffsetAndMetadata(10L)));
        this.assertCompletedForMultipleGroups(this.handleWithPartitionErrorMultipleGroups(Errors.UNKNOWN_TOPIC_OR_PARTITION), expectedResult);
        this.assertCompletedForMultipleGroups(this.handleWithPartitionErrorMultipleGroups(Errors.TOPIC_AUTHORIZATION_FAILED), expectedResult);
        this.assertCompletedForMultipleGroups(this.handleWithPartitionErrorMultipleGroups(Errors.UNSTABLE_OFFSET_COMMIT), expectedResult);
    }

    @Test
    public void testSuccessfulHandleResponseWithMultipleGroups() {
        HashMap<String, Map<TopicPartition, OffsetAndMetadata>> expected = new HashMap<String, Map<TopicPartition, OffsetAndMetadata>>();
        Map<String, Errors> errorMap = this.errorMap(this.groups, Errors.NONE);
        this.assertCompletedForMultipleGroups(this.handleWithErrorWithMultipleGroups(errorMap, this.multiGroupSpecs), expected);
    }

    @Test
    public void testUnmappedHandleResponse() {
        this.assertUnmapped(this.handleWithError(Errors.COORDINATOR_NOT_AVAILABLE));
        this.assertUnmapped(this.handleWithError(Errors.NOT_COORDINATOR));
    }

    @Test
    public void testUnmappedHandleResponseWithMultipleGroups() {
        Map<String, Errors> errorMap = Map.of("group0", Errors.NOT_COORDINATOR, "group1", Errors.COORDINATOR_NOT_AVAILABLE, "group2", Errors.NOT_COORDINATOR);
        this.assertUnmappedWithMultipleGroups(this.handleWithErrorWithMultipleGroups(errorMap, this.multiGroupSpecs));
    }

    @Test
    public void testRetriableHandleResponse() {
        this.assertRetriable(this.handleWithError(Errors.COORDINATOR_LOAD_IN_PROGRESS));
    }

    @Test
    public void testRetriableHandleResponseWithMultipleGroups() {
        Map<String, Errors> errorMap = this.errorMap(this.groups, Errors.COORDINATOR_LOAD_IN_PROGRESS);
        this.assertRetriable(this.handleWithErrorWithMultipleGroups(errorMap, this.multiGroupSpecs));
    }

    @Test
    public void testFailedHandleResponse() {
        this.assertFailed(GroupAuthorizationException.class, this.handleWithError(Errors.GROUP_AUTHORIZATION_FAILED));
        this.assertFailed(GroupIdNotFoundException.class, this.handleWithError(Errors.GROUP_ID_NOT_FOUND));
        this.assertFailed(InvalidGroupIdException.class, this.handleWithError(Errors.INVALID_GROUP_ID));
    }

    @Test
    public void testFailedHandleResponseWithMultipleGroups() {
        Map<String, Errors> errorMap = Map.of("group0", Errors.GROUP_AUTHORIZATION_FAILED, "group1", Errors.GROUP_ID_NOT_FOUND, "group2", Errors.INVALID_GROUP_ID);
        Map<String, Class<? extends Throwable>> groupToExceptionMap = Map.of("group0", GroupAuthorizationException.class, "group1", GroupIdNotFoundException.class, "group2", InvalidGroupIdException.class);
        this.assertFailedForMultipleGroups(groupToExceptionMap, this.handleWithErrorWithMultipleGroups(errorMap, this.multiGroupSpecs));
    }

    private OffsetFetchResponse buildResponse(Errors error) {
        return new OffsetFetchResponse(new OffsetFetchResponseData().setGroups(List.of(new OffsetFetchResponseData.OffsetFetchResponseGroup().setGroupId("group0").setErrorCode(error.code()))), ApiKeys.OFFSET_FETCH.latestVersion());
    }

    private AdminApiHandler.ApiResult<CoordinatorKey, Map<TopicPartition, OffsetAndMetadata>> handleWithErrorWithMultipleGroups(Map<String, Errors> errorMap, Map<String, ListConsumerGroupOffsetsSpec> groupSpecs) {
        ListConsumerGroupOffsetsHandler handler = new ListConsumerGroupOffsetsHandler(groupSpecs, false, this.logContext);
        OffsetFetchResponse response = new OffsetFetchResponse(new OffsetFetchResponseData().setGroups(errorMap.entrySet().stream().map(entry -> new OffsetFetchResponseData.OffsetFetchResponseGroup().setGroupId((String)entry.getKey()).setErrorCode(((Errors)entry.getValue()).code())).collect(Collectors.toList())), ApiKeys.OFFSET_FETCH.latestVersion());
        return handler.handleResponse(new Node(1, "host", 1234), errorMap.keySet().stream().map(CoordinatorKey::byGroupId).collect(Collectors.toSet()), (AbstractResponse)response);
    }

    private OffsetFetchResponse buildResponseWithPartitionError(Errors error) {
        return new OffsetFetchResponse(new OffsetFetchResponseData().setGroups(List.of(new OffsetFetchResponseData.OffsetFetchResponseGroup().setGroupId("group0").setTopics(List.of(new OffsetFetchResponseData.OffsetFetchResponseTopics().setName(this.t0p0.topic()).setPartitions(List.of(new OffsetFetchResponseData.OffsetFetchResponsePartitions().setPartitionIndex(this.t0p0.partition()).setCommittedOffset(10L), new OffsetFetchResponseData.OffsetFetchResponsePartitions().setPartitionIndex(this.t0p1.partition()).setCommittedOffset(10L).setErrorCode(error.code()))))))), ApiKeys.OFFSET_FETCH.latestVersion());
    }

    private OffsetFetchResponse buildResponseWithPartitionErrorWithMultipleGroups(Errors error) {
        OffsetFetchResponseData data = new OffsetFetchResponseData().setGroups(List.of(new OffsetFetchResponseData.OffsetFetchResponseGroup().setGroupId("group0").setTopics(List.of(new OffsetFetchResponseData.OffsetFetchResponseTopics().setName(this.t0p0.topic()).setPartitions(List.of(new OffsetFetchResponseData.OffsetFetchResponsePartitions().setPartitionIndex(this.t0p0.partition()).setCommittedOffset(10L).setCommittedLeaderEpoch(-1).setMetadata("").setErrorCode(Errors.NONE.code()))))), new OffsetFetchResponseData.OffsetFetchResponseGroup().setGroupId("group1").setTopics(List.of(new OffsetFetchResponseData.OffsetFetchResponseTopics().setName(this.t0p0.topic()).setPartitions(List.of(new OffsetFetchResponseData.OffsetFetchResponsePartitions().setPartitionIndex(this.t0p0.partition()).setCommittedOffset(10L).setCommittedLeaderEpoch(-1).setMetadata("").setErrorCode(error.code()))), new OffsetFetchResponseData.OffsetFetchResponseTopics().setName(this.t1p0.topic()).setPartitions(List.of(new OffsetFetchResponseData.OffsetFetchResponsePartitions().setPartitionIndex(this.t1p0.partition()).setCommittedOffset(10L).setCommittedLeaderEpoch(-1).setMetadata("").setErrorCode(error.code()), new OffsetFetchResponseData.OffsetFetchResponsePartitions().setPartitionIndex(this.t1p1.partition()).setCommittedOffset(10L).setCommittedLeaderEpoch(-1).setMetadata("").setErrorCode(Errors.NONE.code()))))), new OffsetFetchResponseData.OffsetFetchResponseGroup().setGroupId("group2").setTopics(List.of(new OffsetFetchResponseData.OffsetFetchResponseTopics().setName(this.t0p0.topic()).setPartitions(List.of(new OffsetFetchResponseData.OffsetFetchResponsePartitions().setPartitionIndex(this.t0p0.partition()).setCommittedOffset(10L).setCommittedLeaderEpoch(-1).setMetadata("").setErrorCode(error.code()))), new OffsetFetchResponseData.OffsetFetchResponseTopics().setName(this.t1p0.topic()).setPartitions(List.of(new OffsetFetchResponseData.OffsetFetchResponsePartitions().setPartitionIndex(this.t1p0.partition()).setCommittedOffset(10L).setCommittedLeaderEpoch(-1).setMetadata("").setErrorCode(error.code()), new OffsetFetchResponseData.OffsetFetchResponsePartitions().setPartitionIndex(this.t1p1.partition()).setCommittedOffset(10L).setCommittedLeaderEpoch(-1).setMetadata("").setErrorCode(error.code()))), new OffsetFetchResponseData.OffsetFetchResponseTopics().setName(this.t2p0.topic()).setPartitions(List.of(new OffsetFetchResponseData.OffsetFetchResponsePartitions().setPartitionIndex(this.t2p0.partition()).setCommittedOffset(10L).setCommittedLeaderEpoch(-1).setMetadata("").setErrorCode(error.code()), new OffsetFetchResponseData.OffsetFetchResponsePartitions().setPartitionIndex(this.t2p1.partition()).setCommittedOffset(10L).setCommittedLeaderEpoch(-1).setMetadata("").setErrorCode(error.code()), new OffsetFetchResponseData.OffsetFetchResponsePartitions().setPartitionIndex(this.t2p2.partition()).setCommittedOffset(10L).setCommittedLeaderEpoch(-1).setMetadata("").setErrorCode(Errors.NONE.code())))))));
        return new OffsetFetchResponse(data, ApiKeys.OFFSET_FETCH.latestVersion());
    }

    private AdminApiHandler.ApiResult<CoordinatorKey, Map<TopicPartition, OffsetAndMetadata>> handleWithPartitionError(Errors error) {
        ListConsumerGroupOffsetsHandler handler = new ListConsumerGroupOffsetsHandler(this.singleGroupSpec, false, this.logContext);
        OffsetFetchResponse response = this.buildResponseWithPartitionError(error);
        return handler.handleResponse(new Node(1, "host", 1234), Collections.singleton(CoordinatorKey.byGroupId((String)"group0")), (AbstractResponse)response);
    }

    private AdminApiHandler.ApiResult<CoordinatorKey, Map<TopicPartition, OffsetAndMetadata>> handleWithPartitionErrorMultipleGroups(Errors error) {
        ListConsumerGroupOffsetsHandler handler = new ListConsumerGroupOffsetsHandler(this.multiGroupSpecs, false, this.logContext);
        OffsetFetchResponse response = this.buildResponseWithPartitionErrorWithMultipleGroups(error);
        return handler.handleResponse(new Node(1, "host", 1234), this.coordinatorKeys("group0", "group1", "group2"), (AbstractResponse)response);
    }

    private AdminApiHandler.ApiResult<CoordinatorKey, Map<TopicPartition, OffsetAndMetadata>> handleWithError(Errors error) {
        ListConsumerGroupOffsetsHandler handler = new ListConsumerGroupOffsetsHandler(this.singleGroupSpec, false, this.logContext);
        OffsetFetchResponse response = this.buildResponse(error);
        return handler.handleResponse(new Node(1, "host", 1234), Collections.singleton(CoordinatorKey.byGroupId((String)"group0")), (AbstractResponse)response);
    }

    private void assertUnmapped(AdminApiHandler.ApiResult<CoordinatorKey, Map<TopicPartition, OffsetAndMetadata>> result) {
        Assertions.assertEquals(Collections.emptySet(), result.completedKeys.keySet());
        Assertions.assertEquals(Collections.emptySet(), result.failedKeys.keySet());
        Assertions.assertEquals(Collections.singletonList(CoordinatorKey.byGroupId((String)"group0")), (Object)result.unmappedKeys);
    }

    private void assertUnmappedWithMultipleGroups(AdminApiHandler.ApiResult<CoordinatorKey, Map<TopicPartition, OffsetAndMetadata>> result) {
        Assertions.assertEquals(Collections.emptySet(), result.completedKeys.keySet());
        Assertions.assertEquals(Collections.emptySet(), result.failedKeys.keySet());
        Assertions.assertEquals(this.coordinatorKeys("group0", "group1", "group2"), new HashSet(result.unmappedKeys));
    }

    private void assertRetriable(AdminApiHandler.ApiResult<CoordinatorKey, Map<TopicPartition, OffsetAndMetadata>> result) {
        Assertions.assertEquals(Collections.emptySet(), result.completedKeys.keySet());
        Assertions.assertEquals(Collections.emptySet(), result.failedKeys.keySet());
        Assertions.assertEquals(Collections.emptyList(), (Object)result.unmappedKeys);
    }

    private void assertCompleted(AdminApiHandler.ApiResult<CoordinatorKey, Map<TopicPartition, OffsetAndMetadata>> result, Map<TopicPartition, OffsetAndMetadata> expected) {
        CoordinatorKey key = CoordinatorKey.byGroupId((String)"group0");
        Assertions.assertEquals(Collections.emptySet(), result.failedKeys.keySet());
        Assertions.assertEquals(Collections.emptyList(), (Object)result.unmappedKeys);
        Assertions.assertEquals(Collections.singleton(key), result.completedKeys.keySet());
        Assertions.assertEquals(expected, result.completedKeys.get(key));
    }

    private void assertCompletedForMultipleGroups(AdminApiHandler.ApiResult<CoordinatorKey, Map<TopicPartition, OffsetAndMetadata>> result, Map<String, Map<TopicPartition, OffsetAndMetadata>> expected) {
        Assertions.assertEquals(Collections.emptySet(), result.failedKeys.keySet());
        Assertions.assertEquals(Collections.emptyList(), (Object)result.unmappedKeys);
        for (String g : expected.keySet()) {
            CoordinatorKey key = CoordinatorKey.byGroupId((String)g);
            Assertions.assertTrue((boolean)result.completedKeys.containsKey(key));
            Assertions.assertEquals(expected.get(g), result.completedKeys.get(key));
        }
    }

    private void assertFailed(Class<? extends Throwable> expectedExceptionType, AdminApiHandler.ApiResult<CoordinatorKey, Map<TopicPartition, OffsetAndMetadata>> result) {
        CoordinatorKey key = CoordinatorKey.byGroupId((String)"group0");
        Assertions.assertEquals(Collections.emptySet(), result.completedKeys.keySet());
        Assertions.assertEquals(Collections.emptyList(), (Object)result.unmappedKeys);
        Assertions.assertEquals(Collections.singleton(key), result.failedKeys.keySet());
        Assertions.assertInstanceOf(expectedExceptionType, result.failedKeys.get(key));
    }

    private void assertFailedForMultipleGroups(Map<String, Class<? extends Throwable>> groupToExceptionMap, AdminApiHandler.ApiResult<CoordinatorKey, Map<TopicPartition, OffsetAndMetadata>> result) {
        Assertions.assertEquals(Collections.emptySet(), result.completedKeys.keySet());
        Assertions.assertEquals(Collections.emptyList(), (Object)result.unmappedKeys);
        for (String g : groupToExceptionMap.keySet()) {
            CoordinatorKey key = CoordinatorKey.byGroupId((String)g);
            Assertions.assertTrue((boolean)result.failedKeys.containsKey(key));
            Assertions.assertInstanceOf(groupToExceptionMap.get(g), result.failedKeys.get(key));
        }
    }

    private Set<CoordinatorKey> coordinatorKeys(String ... groups) {
        return Stream.of(groups).map(CoordinatorKey::byGroupId).collect(Collectors.toSet());
    }

    private Set<String> requestGroups(OffsetFetchRequest request) {
        return request.data().groups().stream().map(OffsetFetchRequestData.OffsetFetchRequestGroup::groupId).collect(Collectors.toSet());
    }

    private Map<String, Errors> errorMap(Collection<String> groups, Errors error) {
        return groups.stream().collect(Collectors.toMap(Function.identity(), unused -> error));
    }
}

