/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.consumer.internals;

import java.time.Duration;
import java.time.Instant;
import java.util.Optional;
import org.apache.kafka.clients.consumer.internals.AutoOffsetResetStrategy;
import org.apache.kafka.common.config.ConfigException;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class AutoOffsetResetStrategyTest {
    @Test
    public void testFromString() {
        Assertions.assertEquals((Object)AutoOffsetResetStrategy.EARLIEST, (Object)AutoOffsetResetStrategy.fromString((String)"earliest"));
        Assertions.assertEquals((Object)AutoOffsetResetStrategy.LATEST, (Object)AutoOffsetResetStrategy.fromString((String)"latest"));
        Assertions.assertEquals((Object)AutoOffsetResetStrategy.NONE, (Object)AutoOffsetResetStrategy.fromString((String)"none"));
        Assertions.assertThrows(IllegalArgumentException.class, () -> AutoOffsetResetStrategy.fromString((String)"invalid"));
        Assertions.assertThrows(IllegalArgumentException.class, () -> AutoOffsetResetStrategy.fromString((String)"by_duration:invalid"));
        Assertions.assertThrows(IllegalArgumentException.class, () -> AutoOffsetResetStrategy.fromString((String)"by_duration:-PT1H"));
        Assertions.assertThrows(IllegalArgumentException.class, () -> AutoOffsetResetStrategy.fromString((String)"by_duration:"));
        Assertions.assertThrows(IllegalArgumentException.class, () -> AutoOffsetResetStrategy.fromString((String)"by_duration"));
        Assertions.assertThrows(IllegalArgumentException.class, () -> AutoOffsetResetStrategy.fromString((String)"LATEST"));
        Assertions.assertThrows(IllegalArgumentException.class, () -> AutoOffsetResetStrategy.fromString((String)"EARLIEST"));
        Assertions.assertThrows(IllegalArgumentException.class, () -> AutoOffsetResetStrategy.fromString((String)"NONE"));
        Assertions.assertThrows(IllegalArgumentException.class, () -> AutoOffsetResetStrategy.fromString((String)""));
        Assertions.assertThrows(IllegalArgumentException.class, () -> AutoOffsetResetStrategy.fromString(null));
        AutoOffsetResetStrategy strategy = AutoOffsetResetStrategy.fromString((String)"by_duration:PT1H");
        Assertions.assertEquals((Object)"by_duration", (Object)strategy.name());
    }

    @Test
    public void testValidator() {
        AutoOffsetResetStrategy.Validator validator = new AutoOffsetResetStrategy.Validator();
        Assertions.assertDoesNotThrow(() -> validator.ensureValid("test", (Object)"earliest"));
        Assertions.assertDoesNotThrow(() -> validator.ensureValid("test", (Object)"latest"));
        Assertions.assertDoesNotThrow(() -> validator.ensureValid("test", (Object)"none"));
        Assertions.assertDoesNotThrow(() -> validator.ensureValid("test", (Object)"by_duration:PT1H"));
        Assertions.assertThrows(ConfigException.class, () -> validator.ensureValid("test", (Object)"invalid"));
        Assertions.assertThrows(ConfigException.class, () -> validator.ensureValid("test", (Object)"by_duration:invalid"));
        Assertions.assertThrows(ConfigException.class, () -> validator.ensureValid("test", (Object)"by_duration:-PT1H"));
        Assertions.assertThrows(ConfigException.class, () -> validator.ensureValid("test", (Object)"by_duration:"));
        Assertions.assertThrows(ConfigException.class, () -> validator.ensureValid("test", (Object)"by_duration"));
        Assertions.assertThrows(ConfigException.class, () -> validator.ensureValid("test", (Object)"LATEST"));
        Assertions.assertThrows(ConfigException.class, () -> validator.ensureValid("test", (Object)"EARLIEST"));
        Assertions.assertThrows(ConfigException.class, () -> validator.ensureValid("test", (Object)"NONE"));
        Assertions.assertThrows(ConfigException.class, () -> validator.ensureValid("test", (Object)""));
        Assertions.assertThrows(ConfigException.class, () -> validator.ensureValid("test", null));
    }

    @Test
    public void testEqualsAndHashCode() {
        AutoOffsetResetStrategy earliest1 = AutoOffsetResetStrategy.fromString((String)"earliest");
        AutoOffsetResetStrategy earliest2 = AutoOffsetResetStrategy.fromString((String)"earliest");
        AutoOffsetResetStrategy latest1 = AutoOffsetResetStrategy.fromString((String)"latest");
        AutoOffsetResetStrategy duration1 = AutoOffsetResetStrategy.fromString((String)"by_duration:P2D");
        AutoOffsetResetStrategy duration2 = AutoOffsetResetStrategy.fromString((String)"by_duration:P2D");
        Assertions.assertEquals((Object)earliest1, (Object)earliest2);
        Assertions.assertNotEquals((Object)earliest1, (Object)latest1);
        Assertions.assertEquals((int)earliest1.hashCode(), (int)earliest2.hashCode());
        Assertions.assertNotEquals((int)earliest1.hashCode(), (int)latest1.hashCode());
        Assertions.assertNotEquals((Object)latest1, (Object)duration2);
        Assertions.assertEquals((Object)duration1, (Object)duration2);
    }

    @Test
    public void testTimestamp() {
        AutoOffsetResetStrategy earliest1 = AutoOffsetResetStrategy.fromString((String)"earliest");
        AutoOffsetResetStrategy earliest2 = AutoOffsetResetStrategy.fromString((String)"earliest");
        Assertions.assertEquals(Optional.of(-2L), (Object)earliest1.timestamp());
        Assertions.assertEquals((Object)earliest1, (Object)earliest2);
        AutoOffsetResetStrategy latest1 = AutoOffsetResetStrategy.fromString((String)"latest");
        AutoOffsetResetStrategy latest2 = AutoOffsetResetStrategy.fromString((String)"latest");
        Assertions.assertEquals(Optional.of(-1L), (Object)latest1.timestamp());
        Assertions.assertEquals((Object)latest1, (Object)latest2);
        AutoOffsetResetStrategy none1 = AutoOffsetResetStrategy.fromString((String)"none");
        AutoOffsetResetStrategy none2 = AutoOffsetResetStrategy.fromString((String)"none");
        Assertions.assertFalse((boolean)none1.timestamp().isPresent());
        Assertions.assertEquals((Object)none1, (Object)none2);
        AutoOffsetResetStrategy byDuration1 = AutoOffsetResetStrategy.fromString((String)"by_duration:PT1H");
        Optional timestamp = byDuration1.timestamp();
        Assertions.assertTrue((boolean)timestamp.isPresent());
        Assertions.assertTrue(((Long)timestamp.get() <= Instant.now().toEpochMilli() - Duration.ofHours(1L).toMillis() ? 1 : 0) != 0);
        AutoOffsetResetStrategy byDuration2 = AutoOffsetResetStrategy.fromString((String)"by_duration:PT1H");
        AutoOffsetResetStrategy byDuration3 = AutoOffsetResetStrategy.fromString((String)"by_duration:PT2H");
        Assertions.assertEquals((Object)byDuration1, (Object)byDuration2);
        Assertions.assertNotEquals((Object)byDuration1, (Object)byDuration3);
    }
}

