/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.consumer.internals;

import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.UUID;
import org.apache.kafka.clients.ApiVersions;
import org.apache.kafka.clients.GroupRebalanceConfig;
import org.apache.kafka.clients.consumer.ConsumerConfig;
import org.apache.kafka.clients.consumer.internals.CommitRequestManager;
import org.apache.kafka.clients.consumer.internals.ConsumerMembershipManager;
import org.apache.kafka.clients.consumer.internals.ConsumerMetadata;
import org.apache.kafka.clients.consumer.internals.FetchBuffer;
import org.apache.kafka.clients.consumer.internals.FetchMetricsManager;
import org.apache.kafka.clients.consumer.internals.MemberStateListener;
import org.apache.kafka.clients.consumer.internals.NetworkClientDelegate;
import org.apache.kafka.clients.consumer.internals.OffsetCommitCallbackInvoker;
import org.apache.kafka.clients.consumer.internals.RequestManagers;
import org.apache.kafka.clients.consumer.internals.StreamsMembershipManager;
import org.apache.kafka.clients.consumer.internals.StreamsRebalanceData;
import org.apache.kafka.clients.consumer.internals.SubscriptionState;
import org.apache.kafka.clients.consumer.internals.events.BackgroundEventHandler;
import org.apache.kafka.common.config.AbstractConfig;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.test.TestUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

public class RequestManagersTest {
    @Test
    public void testMemberStateListenerRegistered() {
        MemberStateListener listener = (memberEpoch, memberId) -> {};
        Properties properties = TestUtils.requiredConsumerConfig();
        properties.setProperty("group.id", "consumerGroup");
        ConsumerConfig config = new ConsumerConfig(properties);
        GroupRebalanceConfig groupRebalanceConfig = new GroupRebalanceConfig((AbstractConfig)config, GroupRebalanceConfig.ProtocolType.CONSUMER);
        RequestManagers requestManagers = (RequestManagers)RequestManagers.supplier((Time)new MockTime(), (LogContext)new LogContext(), (BackgroundEventHandler)((BackgroundEventHandler)Mockito.mock(BackgroundEventHandler.class)), (ConsumerMetadata)((ConsumerMetadata)Mockito.mock(ConsumerMetadata.class)), (SubscriptionState)((SubscriptionState)Mockito.mock(SubscriptionState.class)), (FetchBuffer)((FetchBuffer)Mockito.mock(FetchBuffer.class)), (ConsumerConfig)config, (GroupRebalanceConfig)groupRebalanceConfig, (ApiVersions)((ApiVersions)Mockito.mock(ApiVersions.class)), (FetchMetricsManager)((FetchMetricsManager)Mockito.mock(FetchMetricsManager.class)), () -> (NetworkClientDelegate)Mockito.mock(NetworkClientDelegate.class), Optional.empty(), (Metrics)new Metrics(), (OffsetCommitCallbackInvoker)((OffsetCommitCallbackInvoker)Mockito.mock(OffsetCommitCallbackInvoker.class)), (MemberStateListener)listener, Optional.empty()).get();
        Assertions.assertTrue((boolean)requestManagers.consumerMembershipManager.isPresent());
        Assertions.assertTrue((boolean)requestManagers.streamsMembershipManager.isEmpty());
        Assertions.assertTrue((boolean)requestManagers.streamsGroupHeartbeatRequestManager.isEmpty());
        Assertions.assertEquals((int)2, (int)((ConsumerMembershipManager)requestManagers.consumerMembershipManager.get()).stateListeners().size());
        Assertions.assertTrue((boolean)((ConsumerMembershipManager)requestManagers.consumerMembershipManager.get()).stateListeners().stream().anyMatch(m -> m instanceof CommitRequestManager));
        Assertions.assertTrue((boolean)((ConsumerMembershipManager)requestManagers.consumerMembershipManager.get()).stateListeners().contains(listener));
    }

    @Test
    public void testStreamMemberStateListenerRegistered() {
        MemberStateListener listener = (memberEpoch, memberId) -> {};
        Properties properties = TestUtils.requiredConsumerConfig();
        properties.setProperty("group.id", "consumerGroup");
        ConsumerConfig config = new ConsumerConfig(properties);
        GroupRebalanceConfig groupRebalanceConfig = new GroupRebalanceConfig((AbstractConfig)config, GroupRebalanceConfig.ProtocolType.CONSUMER);
        RequestManagers requestManagers = (RequestManagers)RequestManagers.supplier((Time)new MockTime(), (LogContext)new LogContext(), (BackgroundEventHandler)((BackgroundEventHandler)Mockito.mock(BackgroundEventHandler.class)), (ConsumerMetadata)((ConsumerMetadata)Mockito.mock(ConsumerMetadata.class)), (SubscriptionState)((SubscriptionState)Mockito.mock(SubscriptionState.class)), (FetchBuffer)((FetchBuffer)Mockito.mock(FetchBuffer.class)), (ConsumerConfig)config, (GroupRebalanceConfig)groupRebalanceConfig, (ApiVersions)((ApiVersions)Mockito.mock(ApiVersions.class)), (FetchMetricsManager)((FetchMetricsManager)Mockito.mock(FetchMetricsManager.class)), () -> (NetworkClientDelegate)Mockito.mock(NetworkClientDelegate.class), Optional.empty(), (Metrics)new Metrics(), (OffsetCommitCallbackInvoker)((OffsetCommitCallbackInvoker)Mockito.mock(OffsetCommitCallbackInvoker.class)), (MemberStateListener)listener, Optional.of(new StreamsRebalanceData(UUID.randomUUID(), Optional.empty(), Map.of(), Map.of()))).get();
        Assertions.assertTrue((boolean)requestManagers.streamsMembershipManager.isPresent());
        Assertions.assertTrue((boolean)requestManagers.streamsGroupHeartbeatRequestManager.isPresent());
        Assertions.assertTrue((boolean)requestManagers.consumerMembershipManager.isEmpty());
        Assertions.assertEquals((int)2, (int)((StreamsMembershipManager)requestManagers.streamsMembershipManager.get()).stateListeners().size());
        Assertions.assertTrue((boolean)((StreamsMembershipManager)requestManagers.streamsMembershipManager.get()).stateListeners().stream().anyMatch(m -> m instanceof CommitRequestManager));
        Assertions.assertTrue((boolean)((StreamsMembershipManager)requestManagers.streamsMembershipManager.get()).stateListeners().contains(listener));
    }
}

