/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.consumer.internals;

import java.util.Set;
import org.apache.kafka.clients.consumer.internals.StreamsRebalanceData;
import org.apache.kafka.clients.consumer.internals.StreamsRebalanceListener;
import org.apache.kafka.clients.consumer.internals.StreamsRebalanceListenerInvoker;
import org.apache.kafka.common.errors.InterruptException;
import org.apache.kafka.common.errors.WakeupException;
import org.apache.kafka.common.utils.LogContext;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;
import org.mockito.junit.jupiter.MockitoSettings;
import org.mockito.quality.Strictness;
import org.mockito.verification.VerificationMode;

@ExtendWith(value={MockitoExtension.class})
@MockitoSettings(strictness=Strictness.STRICT_STUBS)
public class StreamsRebalanceListenerInvokerTest {
    @Mock
    private StreamsRebalanceListener mockListener;
    @Mock
    private StreamsRebalanceData streamsRebalanceData;
    private StreamsRebalanceListenerInvoker invoker;
    private final LogContext logContext = new LogContext();

    @BeforeEach
    public void setup() {
        this.invoker = new StreamsRebalanceListenerInvoker(this.logContext, this.streamsRebalanceData);
    }

    @Test
    public void testSetRebalanceListenerWithNull() {
        NullPointerException exception = (NullPointerException)Assertions.assertThrows(NullPointerException.class, () -> this.invoker.setRebalanceListener(null));
        Assertions.assertEquals((Object)"StreamsRebalanceListener cannot be null", (Object)exception.getMessage());
    }

    @Test
    public void testSetRebalanceListenerOverwritesExisting() {
        StreamsRebalanceListener firstListener = (StreamsRebalanceListener)Mockito.mock(StreamsRebalanceListener.class);
        StreamsRebalanceListener secondListener = (StreamsRebalanceListener)Mockito.mock(StreamsRebalanceListener.class);
        StreamsRebalanceData.Assignment mockAssignment = this.createMockAssignment();
        Mockito.when((Object)this.streamsRebalanceData.reconciledAssignment()).thenReturn((Object)mockAssignment);
        this.invoker.setRebalanceListener(firstListener);
        this.invoker.setRebalanceListener(secondListener);
        this.invoker.invokeAllTasksRevoked();
        ((StreamsRebalanceListener)Mockito.verify((Object)firstListener, (VerificationMode)Mockito.never())).onTasksRevoked((Set)ArgumentMatchers.any());
        ((StreamsRebalanceListener)Mockito.verify((Object)secondListener)).onTasksRevoked((Set)ArgumentMatchers.eq((Object)mockAssignment.activeTasks()));
    }

    @Test
    public void testInvokeMethodsWithNoListener() {
        Assertions.assertNull((Object)this.invoker.invokeAllTasksRevoked());
        Assertions.assertNull((Object)this.invoker.invokeTasksAssigned(this.createMockAssignment()));
        Assertions.assertNull((Object)this.invoker.invokeTasksRevoked(this.createMockTasks()));
        Assertions.assertNull((Object)this.invoker.invokeAllTasksLost());
    }

    @Test
    public void testInvokeAllTasksRevokedWithListener() {
        this.invoker.setRebalanceListener(this.mockListener);
        StreamsRebalanceData.Assignment mockAssignment = this.createMockAssignment();
        Mockito.when((Object)this.streamsRebalanceData.reconciledAssignment()).thenReturn((Object)mockAssignment);
        Exception result = this.invoker.invokeAllTasksRevoked();
        Assertions.assertNull((Object)result);
        ((StreamsRebalanceListener)Mockito.verify((Object)this.mockListener)).onTasksRevoked((Set)ArgumentMatchers.eq((Object)mockAssignment.activeTasks()));
    }

    @Test
    public void testInvokeTasksAssignedWithListener() {
        this.invoker.setRebalanceListener(this.mockListener);
        StreamsRebalanceData.Assignment assignment = this.createMockAssignment();
        Exception result = this.invoker.invokeTasksAssigned(assignment);
        Assertions.assertNull((Object)result);
        ((StreamsRebalanceListener)Mockito.verify((Object)this.mockListener)).onTasksAssigned((StreamsRebalanceData.Assignment)ArgumentMatchers.eq((Object)assignment));
    }

    @Test
    public void testInvokeTasksAssignedWithWakeupException() {
        this.invoker.setRebalanceListener(this.mockListener);
        StreamsRebalanceData.Assignment assignment = this.createMockAssignment();
        WakeupException wakeupException = new WakeupException();
        ((StreamsRebalanceListener)Mockito.doThrow((Throwable[])new Throwable[]{wakeupException}).when((Object)this.mockListener)).onTasksAssigned(assignment);
        WakeupException thrownException = (WakeupException)Assertions.assertThrows(WakeupException.class, () -> this.invoker.invokeTasksAssigned(assignment));
        Assertions.assertEquals((Object)((Object)wakeupException), (Object)((Object)thrownException));
        ((StreamsRebalanceListener)Mockito.verify((Object)this.mockListener)).onTasksAssigned((StreamsRebalanceData.Assignment)ArgumentMatchers.eq((Object)assignment));
    }

    @Test
    public void testInvokeTasksAssignedWithInterruptException() {
        this.invoker.setRebalanceListener(this.mockListener);
        StreamsRebalanceData.Assignment assignment = this.createMockAssignment();
        InterruptException interruptException = new InterruptException("Test interrupt");
        ((StreamsRebalanceListener)Mockito.doThrow((Throwable[])new Throwable[]{interruptException}).when((Object)this.mockListener)).onTasksAssigned(assignment);
        InterruptException thrownException = (InterruptException)Assertions.assertThrows(InterruptException.class, () -> this.invoker.invokeTasksAssigned(assignment));
        Assertions.assertEquals((Object)interruptException, (Object)thrownException);
        ((StreamsRebalanceListener)Mockito.verify((Object)this.mockListener)).onTasksAssigned((StreamsRebalanceData.Assignment)ArgumentMatchers.eq((Object)assignment));
    }

    @Test
    public void testInvokeTasksAssignedWithOtherException() {
        this.invoker.setRebalanceListener(this.mockListener);
        StreamsRebalanceData.Assignment assignment = this.createMockAssignment();
        RuntimeException runtimeException = new RuntimeException("Test exception");
        ((StreamsRebalanceListener)Mockito.doThrow((Throwable[])new Throwable[]{runtimeException}).when((Object)this.mockListener)).onTasksAssigned(assignment);
        Exception result = this.invoker.invokeTasksAssigned(assignment);
        Assertions.assertEquals((Object)runtimeException, (Object)result);
        ((StreamsRebalanceListener)Mockito.verify((Object)this.mockListener)).onTasksAssigned((StreamsRebalanceData.Assignment)ArgumentMatchers.eq((Object)assignment));
    }

    @Test
    public void testInvokeTasksRevokedWithListener() {
        this.invoker.setRebalanceListener(this.mockListener);
        Set<StreamsRebalanceData.TaskId> tasks = this.createMockTasks();
        Exception result = this.invoker.invokeTasksRevoked(tasks);
        Assertions.assertNull((Object)result);
        ((StreamsRebalanceListener)Mockito.verify((Object)this.mockListener)).onTasksRevoked((Set)ArgumentMatchers.eq(tasks));
    }

    @Test
    public void testInvokeTasksRevokedWithWakeupException() {
        this.invoker.setRebalanceListener(this.mockListener);
        Set<StreamsRebalanceData.TaskId> tasks = this.createMockTasks();
        WakeupException wakeupException = new WakeupException();
        ((StreamsRebalanceListener)Mockito.doThrow((Throwable[])new Throwable[]{wakeupException}).when((Object)this.mockListener)).onTasksRevoked(tasks);
        WakeupException thrownException = (WakeupException)Assertions.assertThrows(WakeupException.class, () -> this.invoker.invokeTasksRevoked(tasks));
        Assertions.assertEquals((Object)((Object)wakeupException), (Object)((Object)thrownException));
        ((StreamsRebalanceListener)Mockito.verify((Object)this.mockListener)).onTasksRevoked((Set)ArgumentMatchers.eq(tasks));
    }

    @Test
    public void testInvokeTasksRevokedWithInterruptException() {
        this.invoker.setRebalanceListener(this.mockListener);
        Set<StreamsRebalanceData.TaskId> tasks = this.createMockTasks();
        InterruptException interruptException = new InterruptException("Test interrupt");
        ((StreamsRebalanceListener)Mockito.doThrow((Throwable[])new Throwable[]{interruptException}).when((Object)this.mockListener)).onTasksRevoked(tasks);
        InterruptException thrownException = (InterruptException)Assertions.assertThrows(InterruptException.class, () -> this.invoker.invokeTasksRevoked(tasks));
        Assertions.assertEquals((Object)interruptException, (Object)thrownException);
        ((StreamsRebalanceListener)Mockito.verify((Object)this.mockListener)).onTasksRevoked((Set)ArgumentMatchers.eq(tasks));
    }

    @Test
    public void testInvokeTasksRevokedWithOtherException() {
        this.invoker.setRebalanceListener(this.mockListener);
        Set<StreamsRebalanceData.TaskId> tasks = this.createMockTasks();
        RuntimeException runtimeException = new RuntimeException("Test exception");
        ((StreamsRebalanceListener)Mockito.doThrow((Throwable[])new Throwable[]{runtimeException}).when((Object)this.mockListener)).onTasksRevoked(tasks);
        Exception result = this.invoker.invokeTasksRevoked(tasks);
        Assertions.assertEquals((Object)runtimeException, (Object)result);
        ((StreamsRebalanceListener)Mockito.verify((Object)this.mockListener)).onTasksRevoked((Set)ArgumentMatchers.eq(tasks));
    }

    @Test
    public void testInvokeAllTasksLostWithListener() {
        this.invoker.setRebalanceListener(this.mockListener);
        Exception result = this.invoker.invokeAllTasksLost();
        Assertions.assertNull((Object)result);
        ((StreamsRebalanceListener)Mockito.verify((Object)this.mockListener)).onAllTasksLost();
    }

    @Test
    public void testInvokeAllTasksLostWithWakeupException() {
        this.invoker.setRebalanceListener(this.mockListener);
        WakeupException wakeupException = new WakeupException();
        ((StreamsRebalanceListener)Mockito.doThrow((Throwable[])new Throwable[]{wakeupException}).when((Object)this.mockListener)).onAllTasksLost();
        WakeupException thrownException = (WakeupException)Assertions.assertThrows(WakeupException.class, () -> this.invoker.invokeAllTasksLost());
        Assertions.assertEquals((Object)((Object)wakeupException), (Object)((Object)thrownException));
        ((StreamsRebalanceListener)Mockito.verify((Object)this.mockListener)).onAllTasksLost();
    }

    @Test
    public void testInvokeAllTasksLostWithInterruptException() {
        this.invoker.setRebalanceListener(this.mockListener);
        InterruptException interruptException = new InterruptException("Test interrupt");
        ((StreamsRebalanceListener)Mockito.doThrow((Throwable[])new Throwable[]{interruptException}).when((Object)this.mockListener)).onAllTasksLost();
        InterruptException thrownException = (InterruptException)Assertions.assertThrows(InterruptException.class, () -> this.invoker.invokeAllTasksLost());
        Assertions.assertEquals((Object)interruptException, (Object)thrownException);
        ((StreamsRebalanceListener)Mockito.verify((Object)this.mockListener)).onAllTasksLost();
    }

    @Test
    public void testInvokeAllTasksLostWithOtherException() {
        this.invoker.setRebalanceListener(this.mockListener);
        RuntimeException runtimeException = new RuntimeException("Test exception");
        ((StreamsRebalanceListener)Mockito.doThrow((Throwable[])new Throwable[]{runtimeException}).when((Object)this.mockListener)).onAllTasksLost();
        Exception result = this.invoker.invokeAllTasksLost();
        Assertions.assertEquals((Object)runtimeException, (Object)result);
        ((StreamsRebalanceListener)Mockito.verify((Object)this.mockListener)).onAllTasksLost();
    }

    private StreamsRebalanceData.Assignment createMockAssignment() {
        Set<StreamsRebalanceData.TaskId> activeTasks = this.createMockTasks();
        Set standbyTasks = Set.of();
        Set warmupTasks = Set.of();
        return new StreamsRebalanceData.Assignment(activeTasks, standbyTasks, warmupTasks);
    }

    private Set<StreamsRebalanceData.TaskId> createMockTasks() {
        return Set.of(new StreamsRebalanceData.TaskId("subtopology1", 0), new StreamsRebalanceData.TaskId("subtopology1", 1));
    }
}

