/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.compress;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collections;
import org.apache.kafka.common.compress.Compression;
import org.apache.kafka.common.compress.ZstdCompression;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.utils.BufferSupplier;
import org.apache.kafka.common.utils.ByteBufferOutputStream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ZstdCompressionTest {
    @Test
    public void testCompressionDecompression() throws IOException {
        ZstdCompression.Builder builder = Compression.zstd();
        byte[] data = String.join((CharSequence)"", Collections.nCopies(256, "data")).getBytes(StandardCharsets.UTF_8);
        for (byte magic : Arrays.asList((byte)0, (byte)1, (byte)2)) {
            for (int level : Arrays.asList(CompressionType.ZSTD.minLevel(), CompressionType.ZSTD.defaultLevel(), CompressionType.ZSTD.maxLevel())) {
                ZstdCompression compression = builder.level(level).build();
                ByteBufferOutputStream bufferStream = new ByteBufferOutputStream(4);
                try (OutputStream out = compression.wrapForOutput(bufferStream, magic);){
                    out.write(data);
                    out.flush();
                }
                bufferStream.buffer().flip();
                InputStream inputStream = compression.wrapForInput(bufferStream.buffer(), magic, BufferSupplier.create());
                try {
                    byte[] result = new byte[data.length];
                    int read = inputStream.read(result);
                    Assertions.assertEquals((int)data.length, (int)read);
                    Assertions.assertArrayEquals((byte[])data, (byte[])result);
                }
                finally {
                    if (inputStream == null) continue;
                    inputStream.close();
                }
            }
        }
    }

    @Test
    public void testCompressionLevels() {
        ZstdCompression.Builder builder = Compression.zstd();
        Assertions.assertThrows(IllegalArgumentException.class, () -> builder.level(CompressionType.ZSTD.minLevel() - 1));
        Assertions.assertThrows(IllegalArgumentException.class, () -> builder.level(CompressionType.ZSTD.maxLevel() + 1));
        builder.level(CompressionType.ZSTD.minLevel());
        builder.level(CompressionType.ZSTD.maxLevel());
    }
}

