/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.security.oauthbearer;

import java.util.Map;
import org.apache.kafka.common.security.oauthbearer.BrokerJwtValidator;
import org.apache.kafka.common.security.oauthbearer.ClientJwtValidator;
import org.apache.kafka.common.security.oauthbearer.DefaultJwtValidator;
import org.apache.kafka.common.security.oauthbearer.internals.secured.AccessTokenBuilder;
import org.apache.kafka.common.security.oauthbearer.internals.secured.CloseableVerificationKeyResolver;
import org.apache.kafka.common.security.oauthbearer.internals.secured.OAuthBearerTest;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class DefaultJwtValidatorTest
extends OAuthBearerTest {
    @Test
    public void testConfigureWithVerificationKeyResolver() {
        AccessTokenBuilder builder = new AccessTokenBuilder().alg("RS256");
        CloseableVerificationKeyResolver verificationKeyResolver = this.createVerificationKeyResolver(builder);
        Map<String, ?> configs = this.getSaslConfigs();
        DefaultJwtValidator jwtValidator = new DefaultJwtValidator(verificationKeyResolver);
        Assertions.assertDoesNotThrow(() -> jwtValidator.configure(configs, "OAUTHBEARER", this.getJaasConfigEntries()));
        Assertions.assertInstanceOf(BrokerJwtValidator.class, (Object)jwtValidator.delegate());
    }

    @Test
    public void testConfigureWithoutVerificationKeyResolver() {
        Map<String, ?> configs = this.getSaslConfigs();
        DefaultJwtValidator jwtValidator = new DefaultJwtValidator();
        Assertions.assertDoesNotThrow(() -> jwtValidator.configure(configs, "OAUTHBEARER", this.getJaasConfigEntries()));
        Assertions.assertInstanceOf(ClientJwtValidator.class, (Object)jwtValidator.delegate());
    }

    private CloseableVerificationKeyResolver createVerificationKeyResolver(AccessTokenBuilder builder) {
        return (jws, nestingContext) -> builder.jwk().getPublicKey();
    }
}

