/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.security.ssl;

import java.nio.ByteBuffer;
import java.security.KeyPair;
import java.security.KeyStore;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.SignatureException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Date;
import java.util.List;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import org.apache.kafka.common.security.ssl.CommonNameLoggingSslEngineFactory;
import org.apache.kafka.common.security.ssl.CommonNameLoggingTrustManagerFactoryWrapper;
import org.apache.kafka.common.utils.LogCaptureAppender;
import org.apache.kafka.test.TestSslUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInstance;

@TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
public class CommonNameLoggingTrustManagerFactoryWrapperTest {
    private X509Certificate[] chainWithValidEndCertificate;
    private X509Certificate[] chainWithExpiredEndCertificate;
    private X509Certificate[] chainWithInvalidEndCertificate;
    private X509Certificate[] chainWithMultipleEndCertificates;
    private X509Certificate[] chainWithValidAndInvalidEndCertificates;

    @BeforeAll
    public void setUpOnce() throws CertificateException, NoSuchAlgorithmException {
        this.chainWithValidEndCertificate = this.generateKeyChainIncludingCA(false, false, true, false);
        this.chainWithExpiredEndCertificate = this.generateKeyChainIncludingCA(true, false, true, false);
        this.chainWithInvalidEndCertificate = this.generateKeyChainIncludingCA(false, false, false, false);
        this.chainWithMultipleEndCertificates = this.generateKeyChainIncludingCA(false, true, false, true);
        this.chainWithValidAndInvalidEndCertificates = this.generateKeyChainIncludingCA(false, true, true, false);
    }

    @Test
    void testNeverExpiringX509Certificate() throws Exception {
        KeyPair keyPair = TestSslUtils.generateKeyPair("RSA");
        String dn = "CN=Test, L=London, C=GB";
        int nrOfCerts = 5;
        X509Certificate[] testCerts = new X509Certificate[nrOfCerts];
        PublicKey[] signedWith = new PublicKey[nrOfCerts];
        boolean[] expectValidEndCert = new boolean[nrOfCerts];
        boolean days = true;
        testCerts[0] = TestSslUtils.generateCertificate("CN=Test, L=London, C=GB", keyPair, 1, "SHA512withRSA");
        signedWith[0] = testCerts[0].getPublicKey();
        expectValidEndCert[0] = true;
        testCerts[1] = TestSslUtils.generateCertificate("CN=Test, L=London, C=GB", keyPair, -1, "SHA512withRSA");
        signedWith[1] = testCerts[1].getPublicKey();
        expectValidEndCert[1] = true;
        testCerts[2] = this.chainWithValidEndCertificate[0];
        signedWith[2] = this.chainWithValidEndCertificate[1].getPublicKey();
        expectValidEndCert[2] = true;
        testCerts[3] = this.chainWithExpiredEndCertificate[0];
        signedWith[3] = this.chainWithExpiredEndCertificate[1].getPublicKey();
        expectValidEndCert[3] = true;
        testCerts[4] = this.chainWithInvalidEndCertificate[0];
        signedWith[4] = this.chainWithInvalidEndCertificate[1].getPublicKey();
        expectValidEndCert[4] = false;
        for (int i = 0; i < testCerts.length; ++i) {
            X509Certificate cert = testCerts[i];
            CommonNameLoggingTrustManagerFactoryWrapper.NeverExpiringX509Certificate wrappedCert = new CommonNameLoggingTrustManagerFactoryWrapper.NeverExpiringX509Certificate(cert);
            Assertions.assertEquals(cert.getCriticalExtensionOIDs(), (Object)wrappedCert.getCriticalExtensionOIDs());
            String testOid = "2.5.29.14";
            Assertions.assertEquals((Object)cert.getExtensionValue("2.5.29.14"), (Object)wrappedCert.getExtensionValue("2.5.29.14"));
            Assertions.assertEquals(cert.getNonCriticalExtensionOIDs(), (Object)wrappedCert.getNonCriticalExtensionOIDs());
            Assertions.assertEquals((Object)cert.hasUnsupportedCriticalExtension(), (Object)wrappedCert.hasUnsupportedCriticalExtension());
            Assertions.assertEquals((int)cert.getBasicConstraints(), (int)wrappedCert.getBasicConstraints());
            Assertions.assertEquals((Object)cert.getIssuerDN(), (Object)wrappedCert.getIssuerDN());
            Assertions.assertEquals((Object)cert.getIssuerUniqueID(), (Object)wrappedCert.getIssuerUniqueID());
            Assertions.assertEquals((Object)cert.getKeyUsage(), (Object)wrappedCert.getKeyUsage());
            Assertions.assertEquals((Object)cert.getNotAfter(), (Object)wrappedCert.getNotAfter());
            Assertions.assertEquals((Object)cert.getNotBefore(), (Object)wrappedCert.getNotBefore());
            Assertions.assertEquals((Object)cert.getSerialNumber(), (Object)wrappedCert.getSerialNumber());
            Assertions.assertEquals((Object)cert.getSigAlgName(), (Object)wrappedCert.getSigAlgName());
            Assertions.assertEquals((Object)cert.getSigAlgOID(), (Object)wrappedCert.getSigAlgOID());
            Assertions.assertArrayEquals((byte[])cert.getSigAlgParams(), (byte[])wrappedCert.getSigAlgParams());
            Assertions.assertArrayEquals((byte[])cert.getSignature(), (byte[])wrappedCert.getSignature());
            Assertions.assertEquals((Object)cert.getSubjectDN(), (Object)wrappedCert.getSubjectDN());
            Assertions.assertEquals((Object)cert.getSubjectUniqueID(), (Object)wrappedCert.getSubjectUniqueID());
            Assertions.assertArrayEquals((byte[])cert.getTBSCertificate(), (byte[])wrappedCert.getTBSCertificate());
            Assertions.assertEquals((int)cert.getVersion(), (int)wrappedCert.getVersion());
            Assertions.assertArrayEquals((byte[])cert.getEncoded(), (byte[])wrappedCert.getEncoded());
            Assertions.assertEquals((Object)cert.getPublicKey(), (Object)wrappedCert.getPublicKey());
            Assertions.assertEquals((Object)cert.toString(), (Object)wrappedCert.toString());
            PublicKey signingKey = signedWith[i];
            if (expectValidEndCert[i]) {
                Assertions.assertDoesNotThrow(() -> cert.verify(signingKey));
                Assertions.assertDoesNotThrow(() -> wrappedCert.verify(signingKey));
            } else {
                Exception origException = (Exception)Assertions.assertThrows(SignatureException.class, () -> cert.verify(signingKey));
                Exception testException = (Exception)Assertions.assertThrows(SignatureException.class, () -> wrappedCert.verify(signingKey));
                Assertions.assertEquals((Object)origException.getMessage(), (Object)testException.getMessage());
            }
            Date dateNow = new Date();
            if (cert.getNotBefore().before(dateNow) && cert.getNotAfter().after(dateNow)) {
                Assertions.assertDoesNotThrow(() -> cert.checkValidity());
            } else {
                Assertions.assertThrows(CertificateException.class, cert::checkValidity);
            }
            Assertions.assertDoesNotThrow(() -> wrappedCert.checkValidity());
            if (cert.getNotBefore().before(dateNow) && cert.getNotAfter().after(dateNow)) {
                Assertions.assertDoesNotThrow(() -> cert.checkValidity(dateNow));
            } else {
                Assertions.assertThrows(CertificateException.class, () -> cert.checkValidity(dateNow));
            }
            Assertions.assertDoesNotThrow(() -> wrappedCert.checkValidity(dateNow));
            Date dateRecentPast = new Date(System.currentTimeMillis() - 43200000L);
            if (cert.getNotBefore().before(dateRecentPast) && cert.getNotAfter().after(dateRecentPast)) {
                Assertions.assertDoesNotThrow(() -> cert.checkValidity(dateRecentPast));
                Assertions.assertDoesNotThrow(() -> wrappedCert.checkValidity(dateRecentPast));
            } else {
                Assertions.assertThrows(CertificateException.class, () -> cert.checkValidity(dateRecentPast));
                Assertions.assertDoesNotThrow(() -> wrappedCert.checkValidity(dateRecentPast));
            }
            Date datePast = new Date(System.currentTimeMillis() - 259200000L);
            Assertions.assertThrows(CertificateException.class, () -> cert.checkValidity(datePast));
            Assertions.assertDoesNotThrow(() -> wrappedCert.checkValidity(datePast));
            Date dateFuture = new Date(System.currentTimeMillis() + 259200000L);
            Assertions.assertThrows(CertificateException.class, () -> cert.checkValidity(dateFuture));
            Assertions.assertDoesNotThrow(() -> wrappedCert.checkValidity(dateFuture));
        }
    }

    private static X509TrustManager getX509TrustManager(TrustManagerFactory tmf) throws Exception {
        for (TrustManager trustManager : tmf.getTrustManagers()) {
            if (!(trustManager instanceof X509TrustManager)) continue;
            return (X509TrustManager)trustManager;
        }
        throw new Exception("Unable to find X509TrustManager");
    }

    @Test
    public void testCommonNameLoggingTrustManagerFactoryWrapper() throws Exception {
        X509Certificate caCert = this.chainWithValidEndCertificate[2];
        KeyStore trustStore = KeyStore.getInstance(KeyStore.getDefaultType());
        trustStore.load(null, null);
        trustStore.setCertificateEntry("CA", caCert);
        String kmfAlgorithm = TrustManagerFactory.getDefaultAlgorithm();
        TrustManagerFactory origTmFactory = TrustManagerFactory.getInstance(kmfAlgorithm);
        origTmFactory.init(trustStore);
        TrustManager[] origTrustManagers = origTmFactory.getTrustManagers();
        CommonNameLoggingTrustManagerFactoryWrapper testTmFactory = CommonNameLoggingTrustManagerFactoryWrapper.getInstance((String)kmfAlgorithm);
        testTmFactory.init(trustStore);
        TrustManager[] wrappendTrustManagers = testTmFactory.getTrustManagers();
        Assertions.assertEquals((int)origTrustManagers.length, (int)wrappendTrustManagers.length);
        Assertions.assertEquals((Object)origTmFactory.getAlgorithm(), (Object)testTmFactory.getAlgorithm());
        for (int i = 0; i < origTrustManagers.length; ++i) {
            TrustManager origTrustManager = origTrustManagers[i];
            TrustManager testTrustManager = wrappendTrustManagers[i];
            if (origTrustManager instanceof X509TrustManager) {
                Assertions.assertInstanceOf(CommonNameLoggingTrustManagerFactoryWrapper.CommonNameLoggingTrustManager.class, (Object)testTrustManager);
                CommonNameLoggingTrustManagerFactoryWrapper.CommonNameLoggingTrustManager commonNameLoggingTrustManager = (CommonNameLoggingTrustManagerFactoryWrapper.CommonNameLoggingTrustManager)testTrustManager;
                Assertions.assertEquals(origTrustManager.getClass(), commonNameLoggingTrustManager.getOriginalTrustManager().getClass());
                continue;
            }
            Assertions.assertEquals(origTrustManager.getClass(), testTrustManager.getClass());
        }
    }

    @Test
    public void testCommonNameLoggingTrustManagerValidChain() throws Exception {
        X509Certificate endCert = this.chainWithValidEndCertificate[0];
        X509Certificate intermediateCert = this.chainWithValidEndCertificate[1];
        X509Certificate caCert = this.chainWithValidEndCertificate[2];
        X509Certificate[] chainWithoutCa = new X509Certificate[]{endCert, intermediateCert};
        KeyStore trustStore = KeyStore.getInstance(KeyStore.getDefaultType());
        trustStore.load(null, null);
        trustStore.setCertificateEntry("CA", caCert);
        String tmfAlgorithm = TrustManagerFactory.getDefaultAlgorithm();
        TrustManagerFactory tmf = TrustManagerFactory.getInstance(tmfAlgorithm);
        tmf.init(trustStore);
        X509TrustManager origTrustManager = CommonNameLoggingTrustManagerFactoryWrapperTest.getX509TrustManager(tmf);
        try (LogCaptureAppender appender = LogCaptureAppender.createAndRegister(CommonNameLoggingSslEngineFactory.class);){
            int nrOfInitialMessagges = appender.getMessages().size();
            CommonNameLoggingTrustManagerFactoryWrapper.CommonNameLoggingTrustManager testTrustManager = new CommonNameLoggingTrustManagerFactoryWrapper.CommonNameLoggingTrustManager(origTrustManager, 2);
            Assertions.assertEquals((Object)testTrustManager.getOriginalTrustManager(), (Object)origTrustManager);
            Assertions.assertDoesNotThrow(() -> origTrustManager.checkClientTrusted(chainWithoutCa, "RSA"));
            Assertions.assertDoesNotThrow(() -> testTrustManager.checkClientTrusted(chainWithoutCa, "RSA"));
            Assertions.assertEquals((int)nrOfInitialMessagges, (int)appender.getMessages().size());
            Assertions.assertEquals((Object)testTrustManager.getOriginalTrustManager(), (Object)origTrustManager);
            Assertions.assertDoesNotThrow(() -> origTrustManager.checkClientTrusted(chainWithoutCa, "RSA"));
            Assertions.assertDoesNotThrow(() -> testTrustManager.checkClientTrusted(chainWithoutCa, "RSA"));
            Assertions.assertEquals((int)nrOfInitialMessagges, (int)appender.getMessages().size());
            Assertions.assertDoesNotThrow(() -> origTrustManager.checkServerTrusted(chainWithoutCa, "RSA"));
            Assertions.assertDoesNotThrow(() -> testTrustManager.checkServerTrusted(chainWithoutCa, "RSA"));
            Assertions.assertEquals((int)nrOfInitialMessagges, (int)appender.getMessages().size());
            Assertions.assertArrayEquals((Object[])origTrustManager.getAcceptedIssuers(), (Object[])testTrustManager.getAcceptedIssuers());
        }
    }

    @Test
    public void testCommonNameLoggingTrustManagerValidChainWithCA() throws Exception {
        X509Certificate endCert = this.chainWithValidEndCertificate[0];
        X509Certificate intermediateCert = this.chainWithValidEndCertificate[1];
        X509Certificate caCert = this.chainWithValidEndCertificate[2];
        X509Certificate[] chainWitCa = new X509Certificate[]{endCert, intermediateCert, caCert};
        KeyStore trustStore = KeyStore.getInstance(KeyStore.getDefaultType());
        trustStore.load(null, null);
        trustStore.setCertificateEntry("CA", caCert);
        String tmfAlgorithm = TrustManagerFactory.getDefaultAlgorithm();
        TrustManagerFactory tmf = TrustManagerFactory.getInstance(tmfAlgorithm);
        tmf.init(trustStore);
        X509TrustManager origTrustManager = CommonNameLoggingTrustManagerFactoryWrapperTest.getX509TrustManager(tmf);
        try (LogCaptureAppender appender = LogCaptureAppender.createAndRegister(CommonNameLoggingSslEngineFactory.class);){
            int nrOfInitialMessagges = appender.getMessages().size();
            CommonNameLoggingTrustManagerFactoryWrapper.CommonNameLoggingTrustManager testTrustManager = new CommonNameLoggingTrustManagerFactoryWrapper.CommonNameLoggingTrustManager(origTrustManager, 2);
            Assertions.assertEquals((Object)testTrustManager.getOriginalTrustManager(), (Object)origTrustManager);
            Assertions.assertDoesNotThrow(() -> origTrustManager.checkClientTrusted(chainWitCa, "RSA"));
            Assertions.assertDoesNotThrow(() -> testTrustManager.checkClientTrusted(chainWitCa, "RSA"));
            Assertions.assertEquals((int)nrOfInitialMessagges, (int)appender.getMessages().size());
            Assertions.assertDoesNotThrow(() -> origTrustManager.checkServerTrusted(chainWitCa, "RSA"));
            Assertions.assertDoesNotThrow(() -> testTrustManager.checkServerTrusted(chainWitCa, "RSA"));
            Assertions.assertEquals((int)nrOfInitialMessagges, (int)appender.getMessages().size());
            Assertions.assertArrayEquals((Object[])origTrustManager.getAcceptedIssuers(), (Object[])testTrustManager.getAcceptedIssuers());
        }
    }

    @Test
    public void testCommonNameLoggingTrustManagerWithInvalidEndCert() throws Exception {
        X509Certificate endCert = this.chainWithInvalidEndCertificate[0];
        X509Certificate intermediateCert = this.chainWithInvalidEndCertificate[1];
        X509Certificate caCert = this.chainWithInvalidEndCertificate[2];
        X509Certificate[] chainWithoutCa = new X509Certificate[]{endCert, intermediateCert};
        KeyStore trustStore = KeyStore.getInstance(KeyStore.getDefaultType());
        trustStore.load(null, null);
        trustStore.setCertificateEntry("CA", caCert);
        String tmfAlgorithm = TrustManagerFactory.getDefaultAlgorithm();
        TrustManagerFactory tmf = TrustManagerFactory.getInstance(tmfAlgorithm);
        tmf.init(trustStore);
        X509TrustManager origTrustManager = CommonNameLoggingTrustManagerFactoryWrapperTest.getX509TrustManager(tmf);
        try (LogCaptureAppender appender = LogCaptureAppender.createAndRegister(CommonNameLoggingSslEngineFactory.class);){
            int nrOfInitialMessagges = appender.getMessages().size();
            CommonNameLoggingTrustManagerFactoryWrapper.CommonNameLoggingTrustManager testTrustManager = new CommonNameLoggingTrustManagerFactoryWrapper.CommonNameLoggingTrustManager(origTrustManager, 2);
            Assertions.assertEquals((Object)testTrustManager.getOriginalTrustManager(), (Object)origTrustManager);
            Exception origException = (Exception)Assertions.assertThrows(CertificateException.class, () -> origTrustManager.checkClientTrusted(chainWithoutCa, "RSA"));
            Exception testException = (Exception)Assertions.assertThrows(CertificateException.class, () -> testTrustManager.checkClientTrusted(chainWithoutCa, "RSA"));
            Assertions.assertEquals((Object)origException.getMessage(), (Object)testException.getMessage());
            Assertions.assertEquals((int)nrOfInitialMessagges, (int)appender.getMessages().size());
            Assertions.assertEquals((Object)testTrustManager.getOriginalTrustManager(), (Object)origTrustManager);
            origException = (Exception)Assertions.assertThrows(CertificateException.class, () -> origTrustManager.checkClientTrusted(chainWithoutCa, "RSA"));
            testException = (Exception)Assertions.assertThrows(CertificateException.class, () -> testTrustManager.checkClientTrusted(chainWithoutCa, "RSA"));
            Assertions.assertEquals((Object)origException.getMessage(), (Object)testException.getMessage());
            Assertions.assertEquals((int)nrOfInitialMessagges, (int)appender.getMessages().size());
            origException = (Exception)Assertions.assertThrows(CertificateException.class, () -> origTrustManager.checkServerTrusted(chainWithoutCa, "RSA"));
            testException = (Exception)Assertions.assertThrows(CertificateException.class, () -> testTrustManager.checkServerTrusted(chainWithoutCa, "RSA"));
            Assertions.assertEquals((Object)origException.getMessage(), (Object)testException.getMessage());
            Assertions.assertEquals((int)nrOfInitialMessagges, (int)appender.getMessages().size());
            Assertions.assertArrayEquals((Object[])origTrustManager.getAcceptedIssuers(), (Object[])testTrustManager.getAcceptedIssuers());
        }
    }

    @Test
    public void testCommonNameLoggingTrustManagerWithExpiredEndCert() throws Exception {
        X509Certificate endCert = this.chainWithExpiredEndCertificate[0];
        X509Certificate intermediateCert = this.chainWithExpiredEndCertificate[1];
        X509Certificate caCert = this.chainWithExpiredEndCertificate[2];
        X509Certificate[] chainWithoutCa = new X509Certificate[]{endCert, intermediateCert};
        KeyStore trustStore = KeyStore.getInstance(KeyStore.getDefaultType());
        trustStore.load(null, null);
        trustStore.setCertificateEntry("CA", caCert);
        String tmfAlgorithm = TrustManagerFactory.getDefaultAlgorithm();
        TrustManagerFactory tmf = TrustManagerFactory.getInstance(tmfAlgorithm);
        tmf.init(trustStore);
        X509TrustManager origTrustManager = CommonNameLoggingTrustManagerFactoryWrapperTest.getX509TrustManager(tmf);
        try (LogCaptureAppender appender = LogCaptureAppender.createAndRegister(CommonNameLoggingTrustManagerFactoryWrapper.class);){
            int nrOfInitialMessagges = appender.getMessages().size();
            CommonNameLoggingTrustManagerFactoryWrapper.CommonNameLoggingTrustManager testTrustManager = new CommonNameLoggingTrustManagerFactoryWrapper.CommonNameLoggingTrustManager(origTrustManager, 2);
            Assertions.assertEquals((Object)origTrustManager, (Object)testTrustManager.getOriginalTrustManager());
            Exception origException = (Exception)Assertions.assertThrows(CertificateException.class, () -> origTrustManager.checkClientTrusted(chainWithoutCa, "RSA"));
            Exception testException = (Exception)Assertions.assertThrows(CertificateException.class, () -> testTrustManager.checkClientTrusted(chainWithoutCa, "RSA"));
            Assertions.assertEquals((Object)origException.getMessage(), (Object)testException.getMessage());
            List<String> logMessages = appender.getMessages();
            Assertions.assertEquals((int)(nrOfInitialMessagges + 1), (int)logMessages.size());
            Assertions.assertEquals((Object)("Certificate with common name \"" + String.valueOf(endCert.getSubjectX500Principal()) + "\" expired on " + String.valueOf(endCert.getNotAfter())), (Object)logMessages.get(logMessages.size() - 1));
            origException = (Exception)Assertions.assertThrows(CertificateException.class, () -> testTrustManager.checkServerTrusted(chainWithoutCa, "RSA"));
            testException = (Exception)Assertions.assertThrows(CertificateException.class, () -> testTrustManager.checkServerTrusted(chainWithoutCa, "RSA"));
            Assertions.assertEquals((Object)origException.getMessage(), (Object)testException.getMessage());
            Assertions.assertEquals((int)(nrOfInitialMessagges + 1), (int)appender.getMessages().size());
            Assertions.assertArrayEquals((Object[])origTrustManager.getAcceptedIssuers(), (Object[])testTrustManager.getAcceptedIssuers());
        }
    }

    @Test
    public void testCommonNameLoggingTrustManagerWithExpiredEndCertWithCA() throws Exception {
        X509Certificate endCert = this.chainWithExpiredEndCertificate[0];
        X509Certificate intermediateCert = this.chainWithExpiredEndCertificate[1];
        X509Certificate caCert = this.chainWithExpiredEndCertificate[2];
        X509Certificate[] chainWithoutCa = new X509Certificate[]{endCert, intermediateCert, caCert};
        KeyStore trustStore = KeyStore.getInstance(KeyStore.getDefaultType());
        trustStore.load(null, null);
        trustStore.setCertificateEntry("CA", caCert);
        String tmfAlgorithm = TrustManagerFactory.getDefaultAlgorithm();
        TrustManagerFactory tmf = TrustManagerFactory.getInstance(tmfAlgorithm);
        tmf.init(trustStore);
        X509TrustManager origTrustManager = CommonNameLoggingTrustManagerFactoryWrapperTest.getX509TrustManager(tmf);
        try (LogCaptureAppender appender = LogCaptureAppender.createAndRegister(CommonNameLoggingTrustManagerFactoryWrapper.class);){
            int nrOfInitialMessagges = appender.getMessages().size();
            CommonNameLoggingTrustManagerFactoryWrapper.CommonNameLoggingTrustManager testTrustManager = new CommonNameLoggingTrustManagerFactoryWrapper.CommonNameLoggingTrustManager(origTrustManager, 2);
            Assertions.assertEquals((Object)origTrustManager, (Object)testTrustManager.getOriginalTrustManager());
            Exception origException = (Exception)Assertions.assertThrows(CertificateException.class, () -> origTrustManager.checkClientTrusted(chainWithoutCa, "RSA"));
            Exception testException = (Exception)Assertions.assertThrows(CertificateException.class, () -> testTrustManager.checkClientTrusted(chainWithoutCa, "RSA"));
            Assertions.assertEquals((Object)origException.getMessage(), (Object)testException.getMessage());
            List<String> logMessages = appender.getMessages();
            Assertions.assertEquals((int)(nrOfInitialMessagges + 1), (int)logMessages.size());
            Assertions.assertEquals((Object)("Certificate with common name \"" + String.valueOf(endCert.getSubjectX500Principal()) + "\" expired on " + String.valueOf(endCert.getNotAfter())), (Object)logMessages.get(logMessages.size() - 1));
            origException = (Exception)Assertions.assertThrows(CertificateException.class, () -> testTrustManager.checkServerTrusted(chainWithoutCa, "RSA"));
            testException = (Exception)Assertions.assertThrows(CertificateException.class, () -> testTrustManager.checkServerTrusted(chainWithoutCa, "RSA"));
            Assertions.assertEquals((Object)origException.getMessage(), (Object)testException.getMessage());
            Assertions.assertEquals((int)(nrOfInitialMessagges + 1), (int)appender.getMessages().size());
            Assertions.assertArrayEquals((Object[])origTrustManager.getAcceptedIssuers(), (Object[])testTrustManager.getAcceptedIssuers());
        }
    }

    @Test
    public void testCommonNameLoggingTrustManagerMixValidAndInvalidCertificates() throws Exception {
        X509Certificate endCertValid = this.chainWithValidAndInvalidEndCertificates[0];
        X509Certificate endCertInvalid = this.chainWithValidAndInvalidEndCertificates[1];
        X509Certificate intermediateCert = this.chainWithValidAndInvalidEndCertificates[2];
        X509Certificate caCert = this.chainWithValidAndInvalidEndCertificates[3];
        X509Certificate[] validChainWithoutCa = new X509Certificate[]{endCertValid, intermediateCert};
        X509Certificate[] invalidChainWithoutCa = new X509Certificate[]{endCertInvalid, intermediateCert};
        KeyStore trustStore = KeyStore.getInstance(KeyStore.getDefaultType());
        trustStore.load(null, null);
        trustStore.setCertificateEntry("CA", caCert);
        String tmfAlgorithm = TrustManagerFactory.getDefaultAlgorithm();
        TrustManagerFactory tmf = TrustManagerFactory.getInstance(tmfAlgorithm);
        tmf.init(trustStore);
        X509TrustManager origTrustManager = CommonNameLoggingTrustManagerFactoryWrapperTest.getX509TrustManager(tmf);
        try (LogCaptureAppender appender = LogCaptureAppender.createAndRegister(CommonNameLoggingSslEngineFactory.class);){
            CommonNameLoggingTrustManagerFactoryWrapper.CommonNameLoggingTrustManager testTrustManager = new CommonNameLoggingTrustManagerFactoryWrapper.CommonNameLoggingTrustManager(origTrustManager, 2);
            Assertions.assertDoesNotThrow(() -> testTrustManager.checkClientTrusted(validChainWithoutCa, "RSA"));
            Assertions.assertThrows(CertificateException.class, () -> testTrustManager.checkClientTrusted(invalidChainWithoutCa, "RSA"));
            Assertions.assertDoesNotThrow(() -> testTrustManager.checkClientTrusted(validChainWithoutCa, "RSA"));
            Assertions.assertThrows(CertificateException.class, () -> testTrustManager.checkClientTrusted(invalidChainWithoutCa, "RSA"));
            Assertions.assertDoesNotThrow(() -> testTrustManager.checkClientTrusted(validChainWithoutCa, "RSA"));
        }
    }

    @Test
    public void testSortChainAnWrapEndCertificate() {
        Assertions.assertThrows(CertificateException.class, () -> CommonNameLoggingTrustManagerFactoryWrapper.CommonNameLoggingTrustManager.sortChainAnWrapEndCertificate(null));
        Assertions.assertThrows(CertificateException.class, () -> CommonNameLoggingTrustManagerFactoryWrapper.CommonNameLoggingTrustManager.sortChainAnWrapEndCertificate((X509Certificate[])new X509Certificate[0]));
        X509Certificate endCert = this.chainWithExpiredEndCertificate[0];
        X509Certificate intermediateCert = this.chainWithExpiredEndCertificate[1];
        X509Certificate caCert = this.chainWithExpiredEndCertificate[2];
        X509Certificate[] chainWithEndCert = new X509Certificate[]{endCert};
        X509Certificate[] sortedChain = (X509Certificate[])Assertions.assertDoesNotThrow(() -> CommonNameLoggingTrustManagerFactoryWrapper.CommonNameLoggingTrustManager.sortChainAnWrapEndCertificate((X509Certificate[])chainWithEndCert));
        Assertions.assertEquals((Object)endCert.getSubjectX500Principal(), (Object)sortedChain[0].getSubjectX500Principal());
        X509Certificate[] chainWithoutCaInOrder = new X509Certificate[]{endCert, intermediateCert};
        sortedChain = (X509Certificate[])Assertions.assertDoesNotThrow(() -> CommonNameLoggingTrustManagerFactoryWrapper.CommonNameLoggingTrustManager.sortChainAnWrapEndCertificate((X509Certificate[])chainWithoutCaInOrder));
        Assertions.assertEquals((Object)endCert.getSubjectX500Principal(), (Object)sortedChain[0].getSubjectX500Principal());
        Assertions.assertEquals((Object)intermediateCert.getSubjectX500Principal(), (Object)sortedChain[1].getSubjectX500Principal());
        X509Certificate[] chainWithoutCaOutOfOrder = new X509Certificate[]{intermediateCert, endCert};
        sortedChain = (X509Certificate[])Assertions.assertDoesNotThrow(() -> CommonNameLoggingTrustManagerFactoryWrapper.CommonNameLoggingTrustManager.sortChainAnWrapEndCertificate((X509Certificate[])chainWithoutCaOutOfOrder));
        Assertions.assertEquals((Object)endCert.getSubjectX500Principal(), (Object)sortedChain[0].getSubjectX500Principal());
        Assertions.assertEquals((Object)intermediateCert.getSubjectX500Principal(), (Object)sortedChain[1].getSubjectX500Principal());
        X509Certificate[] chainWithCaOutOfOrder = new X509Certificate[]{caCert, intermediateCert, endCert};
        sortedChain = (X509Certificate[])Assertions.assertDoesNotThrow(() -> CommonNameLoggingTrustManagerFactoryWrapper.CommonNameLoggingTrustManager.sortChainAnWrapEndCertificate((X509Certificate[])chainWithCaOutOfOrder));
        Assertions.assertEquals((Object)endCert.getSubjectX500Principal(), (Object)sortedChain[0].getSubjectX500Principal());
        Assertions.assertEquals((Object)intermediateCert.getSubjectX500Principal(), (Object)sortedChain[1].getSubjectX500Principal());
        Assertions.assertEquals((Object)caCert.getSubjectX500Principal(), (Object)sortedChain[2].getSubjectX500Principal());
    }

    @Test
    public void testSortChainWithMultipleEndCertificate() {
        Assertions.assertThrows(CertificateException.class, () -> CommonNameLoggingTrustManagerFactoryWrapper.CommonNameLoggingTrustManager.sortChainAnWrapEndCertificate((X509Certificate[])this.chainWithMultipleEndCertificates));
    }

    @Test
    public void testCalcDigestForCertificateChain() {
        ByteBuffer digestForValidChain = (ByteBuffer)Assertions.assertDoesNotThrow(() -> CommonNameLoggingTrustManagerFactoryWrapper.CommonNameLoggingTrustManager.calcDigestForCertificateChain((X509Certificate[])this.chainWithValidEndCertificate));
        ByteBuffer digestForValidChainAgain = (ByteBuffer)Assertions.assertDoesNotThrow(() -> CommonNameLoggingTrustManagerFactoryWrapper.CommonNameLoggingTrustManager.calcDigestForCertificateChain((X509Certificate[])this.chainWithValidEndCertificate));
        Assertions.assertEquals((Object)digestForValidChain, (Object)digestForValidChainAgain);
        ByteBuffer digestForInvalidChain = (ByteBuffer)Assertions.assertDoesNotThrow(() -> CommonNameLoggingTrustManagerFactoryWrapper.CommonNameLoggingTrustManager.calcDigestForCertificateChain((X509Certificate[])this.chainWithInvalidEndCertificate));
        Assertions.assertNotEquals((Object)digestForValidChain, (Object)digestForInvalidChain);
        ByteBuffer digestForExpiredChain = (ByteBuffer)Assertions.assertDoesNotThrow(() -> CommonNameLoggingTrustManagerFactoryWrapper.CommonNameLoggingTrustManager.calcDigestForCertificateChain((X509Certificate[])this.chainWithExpiredEndCertificate));
        Assertions.assertNotEquals((Object)digestForValidChain, (Object)digestForExpiredChain);
        Assertions.assertNotEquals((Object)digestForInvalidChain, (Object)digestForExpiredChain);
    }

    private X509Certificate[] generateKeyChainIncludingCA(boolean expired, boolean multipleEndCert, boolean endCert0Valid, boolean endCert1Valid) throws CertificateException, NoSuchAlgorithmException {
        int nrOfCerts = multipleEndCert ? 4 : 3;
        KeyPair[] keyPairs = new KeyPair[nrOfCerts];
        for (int i = 0; i < nrOfCerts; ++i) {
            keyPairs[i] = TestSslUtils.generateKeyPair("RSA");
        }
        X509Certificate[] certs = new X509Certificate[nrOfCerts];
        int endCertDaysValidBeforeNow = 1;
        int endCertDaysValidAfterNow = expired ? 0 : 1;
        int caIndex = nrOfCerts - 1;
        certs[caIndex] = TestSslUtils.generateSignedCertificate("CN=CA", keyPairs[caIndex], 365, 365, null, null, "SHA512withRSA", true, false, false);
        int intermediateCertIndex = caIndex - 1;
        certs[intermediateCertIndex] = TestSslUtils.generateSignedCertificate("CN=Intermediate CA", keyPairs[intermediateCertIndex], 365, 365, certs[caIndex].getSubjectX500Principal().getName(), keyPairs[caIndex], "SHA512withRSA", true, false, false);
        for (int currIndex = intermediateCertIndex - 1; currIndex >= 0; --currIndex) {
            boolean endCertValid = currIndex == 0 ? endCert0Valid : endCert1Valid;
            certs[currIndex] = endCertValid ? TestSslUtils.generateSignedCertificate("CN=kafka", keyPairs[currIndex], endCertDaysValidBeforeNow, endCertDaysValidAfterNow, certs[intermediateCertIndex].getSubjectX500Principal().getName(), keyPairs[intermediateCertIndex], "SHA512withRSA", false, true, true) : TestSslUtils.generateSignedCertificate("C=GB, L=London, CN=kafka", keyPairs[currIndex], endCertDaysValidBeforeNow, endCertDaysValidAfterNow, null, null, "SHA512withRSA", false, true, true);
        }
        return certs;
    }
}

