/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.log4jappender;

import java.nio.charset.StandardCharsets;
import java.util.Date;
import java.util.Properties;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.Producer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.common.config.ConfigException;
import org.apache.log4j.AppenderSkeleton;
import org.apache.log4j.helpers.LogLog;
import org.apache.log4j.spi.LoggingEvent;

public class KafkaLog4jAppender
extends AppenderSkeleton {
    private static final String BOOTSTRAP_SERVERS_CONFIG = "bootstrap.servers";
    private static final String COMPRESSION_TYPE_CONFIG = "compression.type";
    private static final String ACKS_CONFIG = "acks";
    private static final String RETRIES_CONFIG = "retries";
    private static final String KEY_SERIALIZER_CLASS_CONFIG = "key.serializer";
    private static final String VALUE_SERIALIZER_CLASS_CONFIG = "value.serializer";
    private static final String SECURITY_PROTOCOL = "security.protocol";
    private static final String SSL_TRUSTSTORE_LOCATION = "ssl.truststore.location";
    private static final String SSL_TRUSTSTORE_PASSWORD = "ssl.truststore.password";
    private static final String SSL_KEYSTORE_TYPE = "ssl.keystore.type";
    private static final String SSL_KEYSTORE_LOCATION = "ssl.keystore.location";
    private static final String SSL_KEYSTORE_PASSWORD = "ssl.keystore.password";
    private static final String SASL_KERBEROS_SERVICE_NAME = "sasl.kerberos.service.name";
    private String brokerList = null;
    private String topic = null;
    private String compressionType = null;
    private String securityProtocol = null;
    private String sslTruststoreLocation = null;
    private String sslTruststorePassword = null;
    private String sslKeystoreType = null;
    private String sslKeystoreLocation = null;
    private String sslKeystorePassword = null;
    private String saslKerberosServiceName = null;
    private String clientJaasConfPath = null;
    private String kerb5ConfPath = null;
    private int retries = 0;
    private int requiredNumAcks = Integer.MAX_VALUE;
    private boolean syncSend = false;
    private Producer<byte[], byte[]> producer = null;

    public Producer<byte[], byte[]> getProducer() {
        return this.producer;
    }

    public String getBrokerList() {
        return this.brokerList;
    }

    public void setBrokerList(String brokerList) {
        this.brokerList = brokerList;
    }

    public int getRequiredNumAcks() {
        return this.requiredNumAcks;
    }

    public void setRequiredNumAcks(int requiredNumAcks) {
        this.requiredNumAcks = requiredNumAcks;
    }

    public int getRetries() {
        return this.retries;
    }

    public void setRetries(int retries) {
        this.retries = retries;
    }

    public String getCompressionType() {
        return this.compressionType;
    }

    public void setCompressionType(String compressionType) {
        this.compressionType = compressionType;
    }

    public String getTopic() {
        return this.topic;
    }

    public void setTopic(String topic) {
        this.topic = topic;
    }

    public boolean getSyncSend() {
        return this.syncSend;
    }

    public void setSyncSend(boolean syncSend) {
        this.syncSend = syncSend;
    }

    public String getSslTruststorePassword() {
        return this.sslTruststorePassword;
    }

    public String getSslTruststoreLocation() {
        return this.sslTruststoreLocation;
    }

    public String getSecurityProtocol() {
        return this.securityProtocol;
    }

    public void setSecurityProtocol(String securityProtocol) {
        this.securityProtocol = securityProtocol;
    }

    public void setSslTruststoreLocation(String sslTruststoreLocation) {
        this.sslTruststoreLocation = sslTruststoreLocation;
    }

    public void setSslTruststorePassword(String sslTruststorePassword) {
        this.sslTruststorePassword = sslTruststorePassword;
    }

    public void setSslKeystorePassword(String sslKeystorePassword) {
        this.sslKeystorePassword = sslKeystorePassword;
    }

    public void setSslKeystoreType(String sslKeystoreType) {
        this.sslKeystoreType = sslKeystoreType;
    }

    public void setSslKeystoreLocation(String sslKeystoreLocation) {
        this.sslKeystoreLocation = sslKeystoreLocation;
    }

    public void setSaslKerberosServiceName(String saslKerberosServiceName) {
        this.saslKerberosServiceName = saslKerberosServiceName;
    }

    public void setClientJaasConfPath(String clientJaasConfPath) {
        this.clientJaasConfPath = clientJaasConfPath;
    }

    public void setKerb5ConfPath(String kerb5ConfPath) {
        this.kerb5ConfPath = kerb5ConfPath;
    }

    public String getSslKeystoreLocation() {
        return this.sslKeystoreLocation;
    }

    public String getSslKeystoreType() {
        return this.sslKeystoreType;
    }

    public String getSslKeystorePassword() {
        return this.sslKeystorePassword;
    }

    public String getSaslKerberosServiceName() {
        return this.saslKerberosServiceName;
    }

    public String getClientJaasConfPath() {
        return this.clientJaasConfPath;
    }

    public String getKerb5ConfPath() {
        return this.kerb5ConfPath;
    }

    public void activateOptions() {
        Properties props = new Properties();
        if (this.brokerList != null) {
            props.put(BOOTSTRAP_SERVERS_CONFIG, this.brokerList);
        }
        if (props.isEmpty()) {
            throw new ConfigException("The bootstrap servers property should be specified");
        }
        if (this.topic == null) {
            throw new ConfigException("Topic must be specified by the Kafka log4j appender");
        }
        if (this.compressionType != null) {
            props.put(COMPRESSION_TYPE_CONFIG, this.compressionType);
        }
        if (this.requiredNumAcks != Integer.MAX_VALUE) {
            props.put(ACKS_CONFIG, Integer.toString(this.requiredNumAcks));
        }
        if (this.retries > 0) {
            props.put(RETRIES_CONFIG, (Object)this.retries);
        }
        if (this.securityProtocol != null) {
            props.put(SECURITY_PROTOCOL, this.securityProtocol);
        }
        if (this.securityProtocol != null && this.securityProtocol.contains("SSL") && this.sslTruststoreLocation != null && this.sslTruststorePassword != null) {
            props.put(SSL_TRUSTSTORE_LOCATION, this.sslTruststoreLocation);
            props.put(SSL_TRUSTSTORE_PASSWORD, this.sslTruststorePassword);
            if (this.sslKeystoreType != null && this.sslKeystoreLocation != null && this.sslKeystorePassword != null) {
                props.put(SSL_KEYSTORE_TYPE, this.sslKeystoreType);
                props.put(SSL_KEYSTORE_LOCATION, this.sslKeystoreLocation);
                props.put(SSL_KEYSTORE_PASSWORD, this.sslKeystorePassword);
            }
        }
        if (this.securityProtocol != null && this.securityProtocol.contains("SASL") && this.saslKerberosServiceName != null && this.clientJaasConfPath != null) {
            props.put(SASL_KERBEROS_SERVICE_NAME, this.saslKerberosServiceName);
            System.setProperty("java.security.auth.login.config", this.clientJaasConfPath);
            if (this.kerb5ConfPath != null) {
                System.setProperty("java.security.krb5.conf", this.kerb5ConfPath);
            }
        }
        props.put(KEY_SERIALIZER_CLASS_CONFIG, "org.apache.kafka.common.serialization.ByteArraySerializer");
        props.put(VALUE_SERIALIZER_CLASS_CONFIG, "org.apache.kafka.common.serialization.ByteArraySerializer");
        this.producer = this.getKafkaProducer(props);
        LogLog.debug((String)("Kafka producer connected to " + this.brokerList));
        LogLog.debug((String)("Logging for topic: " + this.topic));
    }

    protected Producer<byte[], byte[]> getKafkaProducer(Properties props) {
        return new KafkaProducer(props);
    }

    protected void append(LoggingEvent event) {
        String message = this.subAppend(event);
        LogLog.debug((String)("[" + new Date(event.getTimeStamp()) + "]" + message));
        Future response = this.producer.send(new ProducerRecord(this.topic, (Object)message.getBytes(StandardCharsets.UTF_8)));
        if (this.syncSend) {
            try {
                response.get();
            }
            catch (InterruptedException | ExecutionException ex) {
                throw new RuntimeException(ex);
            }
        }
    }

    private String subAppend(LoggingEvent event) {
        return this.layout == null ? event.getRenderedMessage() : this.layout.format(event);
    }

    public void close() {
        if (!this.closed) {
            this.closed = true;
            this.producer.close();
        }
    }

    public boolean requiresLayout() {
        return true;
    }
}

