/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.image;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.apache.kafka.common.metadata.ConfigRecord;
import org.apache.kafka.image.ConfigurationImage;

public final class ConfigurationDelta {
    private final ConfigurationImage image;
    private final Map<String, Optional<String>> changes = new HashMap<String, Optional<String>>();

    public ConfigurationDelta(ConfigurationImage image) {
        this.image = image;
    }

    public void finishSnapshot() {
        for (String key : this.image.data().keySet()) {
            if (this.changes.containsKey(key)) continue;
            this.changes.put(key, Optional.empty());
        }
    }

    public void replay(ConfigRecord record) {
        this.changes.put(record.name(), Optional.ofNullable(record.value()));
    }

    public void deleteAll() {
        this.changes.clear();
        for (String key : this.image.data().keySet()) {
            this.changes.put(key, Optional.empty());
        }
    }

    public ConfigurationImage apply() {
        HashMap<String, String> newData = new HashMap<String, String>(this.image.data().size());
        for (Map.Entry<String, String> entry : this.image.data().entrySet()) {
            Optional<String> change = this.changes.get(entry.getKey());
            if (change == null) {
                newData.put(entry.getKey(), entry.getValue());
                continue;
            }
            if (!change.isPresent()) continue;
            newData.put(entry.getKey(), change.get());
        }
        for (Map.Entry<String, Object> entry : this.changes.entrySet()) {
            if (newData.containsKey(entry.getKey()) || !((Optional)entry.getValue()).isPresent()) continue;
            newData.put(entry.getKey(), (String)((Optional)entry.getValue()).get());
        }
        return new ConfigurationImage(newData);
    }
}

