/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.image;

import java.util.Iterator;
import java.util.List;
import org.apache.kafka.common.metadata.BrokerRegistrationChangeRecord;
import org.apache.kafka.common.metadata.ClientQuotaRecord;
import org.apache.kafka.common.metadata.ConfigRecord;
import org.apache.kafka.common.metadata.FeatureLevelRecord;
import org.apache.kafka.common.metadata.FenceBrokerRecord;
import org.apache.kafka.common.metadata.MetadataRecordType;
import org.apache.kafka.common.metadata.PartitionChangeRecord;
import org.apache.kafka.common.metadata.PartitionRecord;
import org.apache.kafka.common.metadata.RegisterBrokerRecord;
import org.apache.kafka.common.metadata.RemoveFeatureLevelRecord;
import org.apache.kafka.common.metadata.RemoveTopicRecord;
import org.apache.kafka.common.metadata.TopicRecord;
import org.apache.kafka.common.metadata.UnfenceBrokerRecord;
import org.apache.kafka.common.metadata.UnregisterBrokerRecord;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.image.ClientQuotasDelta;
import org.apache.kafka.image.ClientQuotasImage;
import org.apache.kafka.image.ClusterDelta;
import org.apache.kafka.image.ClusterImage;
import org.apache.kafka.image.ConfigurationsDelta;
import org.apache.kafka.image.ConfigurationsImage;
import org.apache.kafka.image.FeaturesDelta;
import org.apache.kafka.image.FeaturesImage;
import org.apache.kafka.image.MetadataImage;
import org.apache.kafka.image.TopicsDelta;
import org.apache.kafka.image.TopicsImage;
import org.apache.kafka.raft.OffsetAndEpoch;
import org.apache.kafka.server.common.ApiMessageAndVersion;

public final class MetadataDelta {
    private final MetadataImage image;
    private long highestOffset;
    private int highestEpoch;
    private FeaturesDelta featuresDelta = null;
    private ClusterDelta clusterDelta = null;
    private TopicsDelta topicsDelta = null;
    private ConfigurationsDelta configsDelta = null;
    private ClientQuotasDelta clientQuotasDelta = null;

    public MetadataDelta(MetadataImage image) {
        this.image = image;
        this.highestOffset = image.highestOffsetAndEpoch().offset;
        this.highestEpoch = image.highestOffsetAndEpoch().epoch;
    }

    public MetadataImage image() {
        return this.image;
    }

    public FeaturesDelta featuresDelta() {
        return this.featuresDelta;
    }

    public ClusterDelta clusterDelta() {
        return this.clusterDelta;
    }

    public TopicsDelta topicsDelta() {
        return this.topicsDelta;
    }

    public ConfigurationsDelta configsDelta() {
        return this.configsDelta;
    }

    public ClientQuotasDelta clientQuotasDelta() {
        return this.clientQuotasDelta;
    }

    public void read(long highestOffset, int highestEpoch, Iterator<List<ApiMessageAndVersion>> reader) {
        while (reader.hasNext()) {
            List<ApiMessageAndVersion> batch = reader.next();
            for (ApiMessageAndVersion messageAndVersion : batch) {
                this.replay(highestOffset, highestEpoch, messageAndVersion.message());
            }
        }
    }

    public void replay(long offset, int epoch, ApiMessage record) {
        this.highestOffset = offset;
        this.highestEpoch = epoch;
        MetadataRecordType type = MetadataRecordType.fromId(record.apiKey());
        switch (type) {
            case REGISTER_BROKER_RECORD: {
                this.replay((RegisterBrokerRecord)record);
                break;
            }
            case UNREGISTER_BROKER_RECORD: {
                this.replay((UnregisterBrokerRecord)record);
                break;
            }
            case TOPIC_RECORD: {
                this.replay((TopicRecord)record);
                break;
            }
            case PARTITION_RECORD: {
                this.replay((PartitionRecord)record);
                break;
            }
            case CONFIG_RECORD: {
                this.replay((ConfigRecord)record);
                break;
            }
            case PARTITION_CHANGE_RECORD: {
                this.replay((PartitionChangeRecord)record);
                break;
            }
            case FENCE_BROKER_RECORD: {
                this.replay((FenceBrokerRecord)record);
                break;
            }
            case UNFENCE_BROKER_RECORD: {
                this.replay((UnfenceBrokerRecord)record);
                break;
            }
            case REMOVE_TOPIC_RECORD: {
                this.replay((RemoveTopicRecord)record);
                break;
            }
            case FEATURE_LEVEL_RECORD: {
                this.replay((FeatureLevelRecord)record);
                break;
            }
            case CLIENT_QUOTA_RECORD: {
                this.replay((ClientQuotaRecord)record);
                break;
            }
            case PRODUCER_IDS_RECORD: {
                break;
            }
            case REMOVE_FEATURE_LEVEL_RECORD: {
                this.replay((RemoveFeatureLevelRecord)record);
                break;
            }
            case BROKER_REGISTRATION_CHANGE_RECORD: {
                this.replay((BrokerRegistrationChangeRecord)record);
                break;
            }
            default: {
                throw new RuntimeException("Unknown metadata record type " + (Object)((Object)type));
            }
        }
    }

    public void replay(RegisterBrokerRecord record) {
        if (this.clusterDelta == null) {
            this.clusterDelta = new ClusterDelta(this.image.cluster());
        }
        this.clusterDelta.replay(record);
    }

    public void replay(UnregisterBrokerRecord record) {
        if (this.clusterDelta == null) {
            this.clusterDelta = new ClusterDelta(this.image.cluster());
        }
        this.clusterDelta.replay(record);
    }

    public void replay(TopicRecord record) {
        if (this.topicsDelta == null) {
            this.topicsDelta = new TopicsDelta(this.image.topics());
        }
        this.topicsDelta.replay(record);
    }

    public void replay(PartitionRecord record) {
        if (this.topicsDelta == null) {
            this.topicsDelta = new TopicsDelta(this.image.topics());
        }
        this.topicsDelta.replay(record);
    }

    public void replay(ConfigRecord record) {
        if (this.configsDelta == null) {
            this.configsDelta = new ConfigurationsDelta(this.image.configs());
        }
        this.configsDelta.replay(record);
    }

    public void replay(PartitionChangeRecord record) {
        if (this.topicsDelta == null) {
            this.topicsDelta = new TopicsDelta(this.image.topics());
        }
        this.topicsDelta.replay(record);
    }

    public void replay(FenceBrokerRecord record) {
        if (this.clusterDelta == null) {
            this.clusterDelta = new ClusterDelta(this.image.cluster());
        }
        this.clusterDelta.replay(record);
    }

    public void replay(UnfenceBrokerRecord record) {
        if (this.clusterDelta == null) {
            this.clusterDelta = new ClusterDelta(this.image.cluster());
        }
        this.clusterDelta.replay(record);
    }

    public void replay(RemoveTopicRecord record) {
        if (this.topicsDelta == null) {
            this.topicsDelta = new TopicsDelta(this.image.topics());
        }
        String topicName = this.topicsDelta.replay(record);
        if (this.configsDelta == null) {
            this.configsDelta = new ConfigurationsDelta(this.image.configs());
        }
        this.configsDelta.replay(record, topicName);
    }

    public void replay(FeatureLevelRecord record) {
        if (this.featuresDelta == null) {
            this.featuresDelta = new FeaturesDelta(this.image.features());
        }
        this.featuresDelta.replay(record);
    }

    public void replay(BrokerRegistrationChangeRecord record) {
        if (this.clusterDelta == null) {
            this.clusterDelta = new ClusterDelta(this.image.cluster());
        }
        this.clusterDelta.replay(record);
    }

    public void replay(ClientQuotaRecord record) {
        if (this.clientQuotasDelta == null) {
            this.clientQuotasDelta = new ClientQuotasDelta(this.image.clientQuotas());
        }
        this.clientQuotasDelta.replay(record);
    }

    public void replay(RemoveFeatureLevelRecord record) {
        if (this.featuresDelta == null) {
            this.featuresDelta = new FeaturesDelta(this.image.features());
        }
        this.featuresDelta.replay(record);
    }

    public void finishSnapshot() {
        if (this.featuresDelta != null) {
            this.featuresDelta.finishSnapshot();
        }
        if (this.clusterDelta != null) {
            this.clusterDelta.finishSnapshot();
        }
        if (this.topicsDelta != null) {
            this.topicsDelta.finishSnapshot();
        }
        if (this.configsDelta != null) {
            this.configsDelta.finishSnapshot();
        }
        if (this.clientQuotasDelta != null) {
            this.clientQuotasDelta.finishSnapshot();
        }
    }

    public MetadataImage apply() {
        FeaturesImage newFeatures = this.featuresDelta == null ? this.image.features() : this.featuresDelta.apply();
        ClusterImage newCluster = this.clusterDelta == null ? this.image.cluster() : this.clusterDelta.apply();
        TopicsImage newTopics = this.topicsDelta == null ? this.image.topics() : this.topicsDelta.apply();
        ConfigurationsImage newConfigs = this.configsDelta == null ? this.image.configs() : this.configsDelta.apply();
        ClientQuotasImage newClientQuotas = this.clientQuotasDelta == null ? this.image.clientQuotas() : this.clientQuotasDelta.apply();
        return new MetadataImage(new OffsetAndEpoch(this.highestOffset, this.highestEpoch), newFeatures, newCluster, newTopics, newConfigs, newClientQuotas);
    }

    public String toString() {
        return "MetadataDelta(highestOffset=" + this.highestOffset + ", highestEpoch=" + this.highestEpoch + ", featuresDelta=" + this.featuresDelta + ", clusterDelta=" + this.clusterDelta + ", topicsDelta=" + this.topicsDelta + ", configsDelta=" + this.configsDelta + ", clientQuotasDelta=" + this.clientQuotasDelta + ')';
    }
}

