/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.controller;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.TreeMap;
import org.apache.kafka.common.metadata.FeatureLevelRecord;
import org.apache.kafka.common.metadata.MetadataRecordType;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.ApiError;
import org.apache.kafka.controller.ControllerResult;
import org.apache.kafka.metadata.FeatureMap;
import org.apache.kafka.metadata.FeatureMapAndEpoch;
import org.apache.kafka.metadata.VersionRange;
import org.apache.kafka.server.common.ApiMessageAndVersion;
import org.apache.kafka.timeline.SnapshotRegistry;
import org.apache.kafka.timeline.TimelineHashMap;

public class FeatureControlManager {
    private final Map<String, VersionRange> supportedFeatures;
    private final TimelineHashMap<String, VersionRange> finalizedVersions;

    FeatureControlManager(Map<String, VersionRange> supportedFeatures, SnapshotRegistry snapshotRegistry) {
        this.supportedFeatures = supportedFeatures;
        this.finalizedVersions = new TimelineHashMap(snapshotRegistry, 0);
    }

    ControllerResult<Map<String, ApiError>> updateFeatures(Map<String, VersionRange> updates, Set<String> downgradeables, Map<Integer, Map<String, VersionRange>> brokerFeatures) {
        TreeMap<String, ApiError> results = new TreeMap<String, ApiError>();
        ArrayList<ApiMessageAndVersion> records = new ArrayList<ApiMessageAndVersion>();
        for (Map.Entry<String, VersionRange> entry : updates.entrySet()) {
            results.put(entry.getKey(), this.updateFeature(entry.getKey(), entry.getValue(), downgradeables.contains(entry.getKey()), brokerFeatures, records));
        }
        return ControllerResult.atomicOf(records, results);
    }

    private ApiError updateFeature(String featureName, VersionRange newRange, boolean downgradeable, Map<Integer, Map<String, VersionRange>> brokerFeatures, List<ApiMessageAndVersion> records) {
        if (newRange.min() <= 0) {
            return new ApiError(Errors.INVALID_UPDATE_VERSION, "The lower value for the new range cannot be less than 1.");
        }
        if (newRange.max() <= 0) {
            return new ApiError(Errors.INVALID_UPDATE_VERSION, "The upper value for the new range cannot be less than 1.");
        }
        VersionRange localRange = this.supportedFeatures.get(featureName);
        if (localRange == null || !localRange.contains(newRange)) {
            return new ApiError(Errors.INVALID_UPDATE_VERSION, "The controller does not support the given feature range.");
        }
        for (Map.Entry<Integer, Map<String, VersionRange>> brokerEntry : brokerFeatures.entrySet()) {
            VersionRange brokerRange = brokerEntry.getValue().get(featureName);
            if (brokerRange != null && brokerRange.contains(newRange)) continue;
            return new ApiError(Errors.INVALID_UPDATE_VERSION, "Broker " + brokerEntry.getKey() + " does not support the given feature range.");
        }
        VersionRange currentRange = this.finalizedVersions.get(featureName);
        if (currentRange != null && currentRange.max() > newRange.max() && !downgradeable) {
            return new ApiError(Errors.INVALID_UPDATE_VERSION, "Can't downgrade the maximum version of this feature without setting downgradable to true.");
        }
        records.add(new ApiMessageAndVersion((ApiMessage)new FeatureLevelRecord().setName(featureName).setMinFeatureLevel(newRange.min()).setMaxFeatureLevel(newRange.max()), MetadataRecordType.FEATURE_LEVEL_RECORD.highestSupportedVersion()));
        return ApiError.NONE;
    }

    FeatureMapAndEpoch finalizedFeatures(long lastCommittedOffset) {
        HashMap<String, VersionRange> features = new HashMap<String, VersionRange>();
        for (Map.Entry<String, VersionRange> entry : this.finalizedVersions.entrySet(lastCommittedOffset)) {
            features.put(entry.getKey(), entry.getValue());
        }
        return new FeatureMapAndEpoch(new FeatureMap(features), lastCommittedOffset);
    }

    public void replay(FeatureLevelRecord record) {
        this.finalizedVersions.put(record.name(), new VersionRange(record.minFeatureLevel(), record.maxFeatureLevel()));
    }

    FeatureControlIterator iterator(long epoch) {
        return new FeatureControlIterator(epoch);
    }

    class FeatureControlIterator
    implements Iterator<List<ApiMessageAndVersion>> {
        private final Iterator<Map.Entry<String, VersionRange>> iterator;

        FeatureControlIterator(long epoch) {
            this.iterator = FeatureControlManager.this.finalizedVersions.entrySet(epoch).iterator();
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public List<ApiMessageAndVersion> next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            Map.Entry<String, VersionRange> entry = this.iterator.next();
            VersionRange versions = entry.getValue();
            return Collections.singletonList(new ApiMessageAndVersion((ApiMessage)new FeatureLevelRecord().setName(entry.getKey()).setMinFeatureLevel(versions.min()).setMaxFeatureLevel(versions.max()), MetadataRecordType.FEATURE_LEVEL_RECORD.highestSupportedVersion()));
        }
    }
}

