/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.image.loader;

import java.util.Objects;
import org.apache.kafka.image.MetadataProvenance;
import org.apache.kafka.raft.LeaderAndEpoch;

public class LogDeltaManifest {
    private final MetadataProvenance provenance;
    private final LeaderAndEpoch leaderAndEpoch;
    private final int numBatches;
    private final long elapsedNs;
    private final long numBytes;

    public LogDeltaManifest(MetadataProvenance provenance, LeaderAndEpoch leaderAndEpoch, int numBatches, long elapsedNs, long numBytes) {
        this.provenance = provenance;
        this.leaderAndEpoch = leaderAndEpoch;
        this.numBatches = numBatches;
        this.elapsedNs = elapsedNs;
        this.numBytes = numBytes;
    }

    public MetadataProvenance provenance() {
        return this.provenance;
    }

    public LeaderAndEpoch leaderAndEpoch() {
        return this.leaderAndEpoch;
    }

    public int numBatches() {
        return this.numBatches;
    }

    public long elapsedNs() {
        return this.elapsedNs;
    }

    public long numBytes() {
        return this.numBytes;
    }

    public int hashCode() {
        return Objects.hash(this.provenance, this.leaderAndEpoch, this.numBatches, this.elapsedNs, this.numBytes);
    }

    public boolean equals(Object o) {
        if (o == null || !o.getClass().equals(this.getClass())) {
            return false;
        }
        LogDeltaManifest other = (LogDeltaManifest)o;
        return this.provenance.equals(other.provenance) && this.leaderAndEpoch == other.leaderAndEpoch && this.numBatches == other.numBatches && this.elapsedNs == other.elapsedNs && this.numBytes == other.numBytes;
    }

    public String toString() {
        return "LogDeltaManifest(provenance=" + this.provenance + ", leaderAndEpoch=" + this.leaderAndEpoch + ", numBatches=" + this.numBatches + ", elapsedNs=" + this.elapsedNs + ", numBytes=" + this.numBytes + ")";
    }
}

