/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.image;

import java.util.Collections;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.kafka.image.writer.ImageWriter;
import org.apache.kafka.image.writer.ImageWriterOptions;
import org.apache.kafka.metadata.BrokerRegistration;

public final class ClusterImage {
    public static final ClusterImage EMPTY = new ClusterImage(Collections.emptyMap());
    private final Map<Integer, BrokerRegistration> brokers;
    private final Map<Integer, BrokerRegistration> zkBrokers;

    public ClusterImage(Map<Integer, BrokerRegistration> brokers) {
        this.brokers = Collections.unmodifiableMap(brokers);
        this.zkBrokers = Collections.unmodifiableMap(brokers.entrySet().stream().filter(entry -> ((BrokerRegistration)entry.getValue()).isMigratingZkBroker()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue)));
    }

    public boolean isEmpty() {
        return this.brokers.isEmpty();
    }

    public Map<Integer, BrokerRegistration> brokers() {
        return this.brokers;
    }

    public Map<Integer, BrokerRegistration> zkBrokers() {
        return Collections.unmodifiableMap(this.brokers.entrySet().stream().filter(x -> ((BrokerRegistration)x.getValue()).isMigratingZkBroker() && !((BrokerRegistration)x.getValue()).fenced()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue)));
    }

    public BrokerRegistration broker(int nodeId) {
        return this.brokers.get(nodeId);
    }

    public boolean containsBroker(int brokerId) {
        return this.brokers.containsKey(brokerId);
    }

    public void write(ImageWriter writer, ImageWriterOptions options) {
        for (BrokerRegistration broker : this.brokers.values()) {
            writer.write(broker.toRecord(options));
        }
    }

    public int hashCode() {
        return this.brokers.hashCode();
    }

    public boolean equals(Object o) {
        if (!(o instanceof ClusterImage)) {
            return false;
        }
        ClusterImage other = (ClusterImage)o;
        return this.brokers.equals(other.brokers);
    }

    public String toString() {
        return this.brokers.entrySet().stream().map(e -> e.getKey() + ":" + e.getValue()).collect(Collectors.joining(", "));
    }
}

