/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.metadata;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.IntNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.ShortNode;
import com.fasterxml.jackson.databind.node.TextNode;
import java.util.ArrayList;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.kafka.common.metadata.PartitionChangeRecord;
import org.apache.kafka.common.protocol.MessageUtil;

public class PartitionChangeRecordJsonConverter {
    public static PartitionChangeRecord read(JsonNode _node, short _version) {
        PartitionChangeRecord _object = new PartitionChangeRecord();
        JsonNode _partitionIdNode = _node.get("partitionId");
        if (_partitionIdNode == null) {
            throw new RuntimeException("PartitionChangeRecord: unable to locate field 'partitionId', which is mandatory in version " + _version);
        }
        _object.partitionId = MessageUtil.jsonNodeToInt((JsonNode)_partitionIdNode, (String)"PartitionChangeRecord");
        JsonNode _topicIdNode = _node.get("topicId");
        if (_topicIdNode == null) {
            throw new RuntimeException("PartitionChangeRecord: unable to locate field 'topicId', which is mandatory in version " + _version);
        }
        if (!_topicIdNode.isTextual()) {
            throw new RuntimeException("PartitionChangeRecord expected a JSON string type, but got " + _node.getNodeType());
        }
        _object.topicId = Uuid.fromString((String)_topicIdNode.asText());
        JsonNode _isrNode = _node.get("isr");
        if (_isrNode == null) {
            _object.isr = null;
        } else if (_isrNode.isNull()) {
            _object.isr = null;
        } else {
            if (!_isrNode.isArray()) {
                throw new RuntimeException("PartitionChangeRecord expected a JSON array, but got " + _node.getNodeType());
            }
            ArrayList<Integer> _collection = new ArrayList<Integer>(_isrNode.size());
            _object.isr = _collection;
            for (JsonNode _element : _isrNode) {
                _collection.add(MessageUtil.jsonNodeToInt((JsonNode)_element, (String)"PartitionChangeRecord element"));
            }
        }
        JsonNode _leaderNode = _node.get("leader");
        _object.leader = _leaderNode == null ? -2 : MessageUtil.jsonNodeToInt((JsonNode)_leaderNode, (String)"PartitionChangeRecord");
        JsonNode _replicasNode = _node.get("replicas");
        if (_replicasNode == null) {
            _object.replicas = null;
        } else if (_replicasNode.isNull()) {
            _object.replicas = null;
        } else {
            if (!_replicasNode.isArray()) {
                throw new RuntimeException("PartitionChangeRecord expected a JSON array, but got " + _node.getNodeType());
            }
            ArrayList<Integer> _collection = new ArrayList<Integer>(_replicasNode.size());
            _object.replicas = _collection;
            for (Object _element : _replicasNode) {
                _collection.add(MessageUtil.jsonNodeToInt((JsonNode)_element, (String)"PartitionChangeRecord element"));
            }
        }
        JsonNode _removingReplicasNode = _node.get("removingReplicas");
        if (_removingReplicasNode == null) {
            _object.removingReplicas = null;
        } else if (_removingReplicasNode.isNull()) {
            _object.removingReplicas = null;
        } else {
            if (!_removingReplicasNode.isArray()) {
                throw new RuntimeException("PartitionChangeRecord expected a JSON array, but got " + _node.getNodeType());
            }
            ArrayList<Integer> _collection = new ArrayList<Integer>(_removingReplicasNode.size());
            _object.removingReplicas = _collection;
            for (Object _element : _removingReplicasNode) {
                _collection.add(MessageUtil.jsonNodeToInt((JsonNode)_element, (String)"PartitionChangeRecord element"));
            }
        }
        JsonNode _addingReplicasNode = _node.get("addingReplicas");
        if (_addingReplicasNode == null) {
            _object.addingReplicas = null;
        } else if (_addingReplicasNode.isNull()) {
            _object.addingReplicas = null;
        } else {
            if (!_addingReplicasNode.isArray()) {
                throw new RuntimeException("PartitionChangeRecord expected a JSON array, but got " + _node.getNodeType());
            }
            ArrayList<Integer> _collection = new ArrayList<Integer>(_addingReplicasNode.size());
            _object.addingReplicas = _collection;
            for (JsonNode _element : _addingReplicasNode) {
                _collection.add(MessageUtil.jsonNodeToInt((JsonNode)_element, (String)"PartitionChangeRecord element"));
            }
        }
        JsonNode _leaderRecoveryStateNode = _node.get("leaderRecoveryState");
        _object.leaderRecoveryState = _leaderRecoveryStateNode == null ? (byte)-1 : MessageUtil.jsonNodeToByte((JsonNode)_leaderRecoveryStateNode, (String)"PartitionChangeRecord");
        JsonNode _directoriesNode = _node.get("directories");
        if (_directoriesNode == null) {
            _object.directories = null;
        } else if (_directoriesNode.isNull()) {
            _object.directories = null;
        } else {
            if (!_directoriesNode.isArray()) {
                throw new RuntimeException("PartitionChangeRecord expected a JSON array, but got " + _node.getNodeType());
            }
            ArrayList<Uuid> _collection = new ArrayList<Uuid>(_directoriesNode.size());
            _object.directories = _collection;
            for (Object _element : _directoriesNode) {
                if (!_element.isTextual()) {
                    throw new RuntimeException("PartitionChangeRecord element expected a JSON string type, but got " + _node.getNodeType());
                }
                _collection.add(Uuid.fromString((String)_element.asText()));
            }
        }
        JsonNode _eligibleLeaderReplicasNode = _node.get("eligibleLeaderReplicas");
        if (_eligibleLeaderReplicasNode == null) {
            _object.eligibleLeaderReplicas = null;
        } else if (_eligibleLeaderReplicasNode.isNull()) {
            _object.eligibleLeaderReplicas = null;
        } else {
            if (!_eligibleLeaderReplicasNode.isArray()) {
                throw new RuntimeException("PartitionChangeRecord expected a JSON array, but got " + _node.getNodeType());
            }
            ArrayList<Integer> _collection = new ArrayList<Integer>(_eligibleLeaderReplicasNode.size());
            _object.eligibleLeaderReplicas = _collection;
            for (JsonNode _element : _eligibleLeaderReplicasNode) {
                _collection.add(MessageUtil.jsonNodeToInt((JsonNode)_element, (String)"PartitionChangeRecord element"));
            }
        }
        JsonNode _lastKnownELRNode = _node.get("lastKnownELR");
        if (_lastKnownELRNode == null) {
            _object.lastKnownELR = null;
        } else if (_lastKnownELRNode.isNull()) {
            _object.lastKnownELR = null;
        } else {
            if (!_lastKnownELRNode.isArray()) {
                throw new RuntimeException("PartitionChangeRecord expected a JSON array, but got " + _node.getNodeType());
            }
            ArrayList<Integer> _collection = new ArrayList<Integer>(_lastKnownELRNode.size());
            _object.lastKnownELR = _collection;
            for (JsonNode _element : _lastKnownELRNode) {
                _collection.add(MessageUtil.jsonNodeToInt((JsonNode)_element, (String)"PartitionChangeRecord element"));
            }
        }
        return _object;
    }

    public static JsonNode write(PartitionChangeRecord _object, short _version, boolean _serializeRecords) {
        ObjectNode _node = new ObjectNode(JsonNodeFactory.instance);
        _node.set("partitionId", (JsonNode)new IntNode(_object.partitionId));
        _node.set("topicId", (JsonNode)new TextNode(_object.topicId.toString()));
        if (_object.isr != null) {
            ArrayNode _isrArray = new ArrayNode(JsonNodeFactory.instance);
            for (Integer n : _object.isr) {
                _isrArray.add((JsonNode)new IntNode(n.intValue()));
            }
            _node.set("isr", (JsonNode)_isrArray);
        }
        if (_object.leader != -2) {
            _node.set("leader", (JsonNode)new IntNode(_object.leader));
        }
        if (_object.replicas != null) {
            ArrayNode _replicasArray = new ArrayNode(JsonNodeFactory.instance);
            for (Integer n : _object.replicas) {
                _replicasArray.add((JsonNode)new IntNode(n.intValue()));
            }
            _node.set("replicas", (JsonNode)_replicasArray);
        }
        if (_object.removingReplicas != null) {
            ArrayNode _removingReplicasArray = new ArrayNode(JsonNodeFactory.instance);
            for (Integer n : _object.removingReplicas) {
                _removingReplicasArray.add((JsonNode)new IntNode(n.intValue()));
            }
            _node.set("removingReplicas", (JsonNode)_removingReplicasArray);
        }
        if (_object.addingReplicas != null) {
            ArrayNode _addingReplicasArray = new ArrayNode(JsonNodeFactory.instance);
            for (Integer n : _object.addingReplicas) {
                _addingReplicasArray.add((JsonNode)new IntNode(n.intValue()));
            }
            _node.set("addingReplicas", (JsonNode)_addingReplicasArray);
        }
        if (_object.leaderRecoveryState != -1) {
            _node.set("leaderRecoveryState", (JsonNode)new ShortNode((short)_object.leaderRecoveryState));
        }
        if (_version >= 1) {
            if (_object.directories != null) {
                ArrayNode _directoriesArray = new ArrayNode(JsonNodeFactory.instance);
                for (Uuid uuid : _object.directories) {
                    _directoriesArray.add((JsonNode)new TextNode(uuid.toString()));
                }
                _node.set("directories", (JsonNode)_directoriesArray);
            }
        } else if (_object.directories != null) {
            throw new UnsupportedVersionException("Attempted to write a non-default directories at version " + _version);
        }
        if (_version >= 2) {
            if (_object.eligibleLeaderReplicas != null) {
                ArrayNode _eligibleLeaderReplicasArray = new ArrayNode(JsonNodeFactory.instance);
                for (Integer n : _object.eligibleLeaderReplicas) {
                    _eligibleLeaderReplicasArray.add((JsonNode)new IntNode(n.intValue()));
                }
                _node.set("eligibleLeaderReplicas", (JsonNode)_eligibleLeaderReplicasArray);
            }
        } else if (_object.eligibleLeaderReplicas != null) {
            throw new UnsupportedVersionException("Attempted to write a non-default eligibleLeaderReplicas at version " + _version);
        }
        if (_version >= 2) {
            if (_object.lastKnownELR != null) {
                ArrayNode _lastKnownELRArray = new ArrayNode(JsonNodeFactory.instance);
                for (Integer n : _object.lastKnownELR) {
                    _lastKnownELRArray.add((JsonNode)new IntNode(n.intValue()));
                }
                _node.set("lastKnownELR", (JsonNode)_lastKnownELRArray);
            }
        } else if (_object.lastKnownELR != null) {
            throw new UnsupportedVersionException("Attempted to write a non-default lastKnownELR at version " + _version);
        }
        return _node;
    }

    public static JsonNode write(PartitionChangeRecord _object, short _version) {
        return PartitionChangeRecordJsonConverter.write(_object, _version, true);
    }
}

