/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.image.loader;

import java.util.Objects;
import org.apache.kafka.image.MetadataProvenance;
import org.apache.kafka.image.loader.LoaderManifest;
import org.apache.kafka.image.loader.LoaderManifestType;

public class SnapshotManifest
implements LoaderManifest {
    private final MetadataProvenance provenance;
    private final long elapsedNs;

    public SnapshotManifest(MetadataProvenance provenance, long elapsedNs) {
        this.provenance = provenance;
        this.elapsedNs = elapsedNs;
    }

    @Override
    public LoaderManifestType type() {
        return LoaderManifestType.SNAPSHOT;
    }

    @Override
    public MetadataProvenance provenance() {
        return this.provenance;
    }

    public long elapsedNs() {
        return this.elapsedNs;
    }

    public int hashCode() {
        return Objects.hash(this.provenance, this.elapsedNs);
    }

    public boolean equals(Object o) {
        if (o == null || !o.getClass().equals(this.getClass())) {
            return false;
        }
        SnapshotManifest other = (SnapshotManifest)o;
        return this.provenance.equals(other.provenance) && this.elapsedNs == other.elapsedNs;
    }

    public String toString() {
        return "SnapshotManifest(provenance=" + this.provenance + ", elapsedNs=" + this.elapsedNs + ")";
    }
}

