/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.controller;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.apache.kafka.metadata.VersionRange;
import org.apache.kafka.server.common.Feature;
import org.apache.kafka.server.common.MetadataVersion;

public final class QuorumFeatures {
    public static final VersionRange DISABLED = VersionRange.of(0, 0);
    private final int nodeId;
    private final Map<String, VersionRange> localSupportedFeatures;
    private final List<Integer> quorumNodeIds;

    public static Optional<String> reasonNotSupported(short newVersion, String what, VersionRange range) {
        if (!range.contains(newVersion)) {
            if (range.max() == 0) {
                return Optional.of(what + " does not support this feature.");
            }
            return Optional.of(what + " only supports versions " + String.valueOf(range));
        }
        return Optional.empty();
    }

    public static Map<String, VersionRange> defaultSupportedFeatureMap(boolean enableUnstable) {
        HashMap<String, VersionRange> features = new HashMap<String, VersionRange>(1);
        features.put("metadata.version", VersionRange.of(MetadataVersion.MINIMUM_VERSION.featureLevel(), enableUnstable ? MetadataVersion.latestTesting().featureLevel() : MetadataVersion.latestProduction().featureLevel()));
        for (Feature feature : Feature.PRODUCTION_FEATURES) {
            short maxVersion = enableUnstable ? feature.latestTesting() : feature.latestProduction();
            if (maxVersion <= 0) continue;
            features.put(feature.featureName(), VersionRange.of(feature.minimumProduction(), maxVersion));
        }
        return features;
    }

    public QuorumFeatures(int nodeId, Map<String, VersionRange> localSupportedFeatures, List<Integer> quorumNodeIds) {
        this.nodeId = nodeId;
        this.localSupportedFeatures = Collections.unmodifiableMap(localSupportedFeatures);
        this.quorumNodeIds = Collections.unmodifiableList(quorumNodeIds);
    }

    public int nodeId() {
        return this.nodeId;
    }

    public Map<String, VersionRange> localSupportedFeatures() {
        return this.localSupportedFeatures;
    }

    public List<Integer> quorumNodeIds() {
        return this.quorumNodeIds;
    }

    public VersionRange localSupportedFeature(String name) {
        return this.localSupportedFeatures.getOrDefault(name, DISABLED);
    }

    public boolean isControllerId(int nodeId) {
        return this.quorumNodeIds.contains(nodeId);
    }

    public Optional<String> reasonNotLocallySupported(String featureName, short newVersion) {
        return QuorumFeatures.reasonNotSupported(newVersion, "Local controller " + this.nodeId, this.localSupportedFeature(featureName));
    }

    public int hashCode() {
        return Objects.hash(this.nodeId, this.localSupportedFeatures, this.quorumNodeIds);
    }

    public boolean equals(Object o) {
        if (o == null || !o.getClass().equals(QuorumFeatures.class)) {
            return false;
        }
        QuorumFeatures other = (QuorumFeatures)o;
        return this.nodeId == other.nodeId && this.localSupportedFeatures.equals(other.localSupportedFeatures) && this.quorumNodeIds.equals(other.quorumNodeIds);
    }

    public String toString() {
        ArrayList features = new ArrayList();
        this.localSupportedFeatures.forEach((key, value) -> features.add(key + ": " + String.valueOf(value)));
        features.sort(String::compareTo);
        ArrayList nodeIds = new ArrayList();
        this.quorumNodeIds.forEach(id -> nodeIds.add("" + id));
        nodeIds.sort(String::compareTo);
        return "QuorumFeatures(nodeId=" + this.nodeId + ", localSupportedFeatures={" + String.valueOf(features) + "}, quorumNodeIds=[" + String.valueOf(nodeIds) + "])";
    }
}

