/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.raft;

import java.util.Optional;
import java.util.OptionalInt;
import java.util.Set;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Timer;
import org.apache.kafka.raft.ElectionState;
import org.apache.kafka.raft.EpochState;
import org.apache.kafka.raft.LogOffsetMetadata;

public class VotedState
implements EpochState {
    private final int epoch;
    private final int votedId;
    private final Set<Integer> voters;
    private final int electionTimeoutMs;
    private final Timer electionTimer;
    private final Optional<LogOffsetMetadata> highWatermark;

    public VotedState(Time time, int epoch, int votedId, Set<Integer> voters, Optional<LogOffsetMetadata> highWatermark, int electionTimeoutMs) {
        this.epoch = epoch;
        this.votedId = votedId;
        this.voters = voters;
        this.highWatermark = highWatermark;
        this.electionTimeoutMs = electionTimeoutMs;
        this.electionTimer = time.timer((long)electionTimeoutMs);
    }

    @Override
    public ElectionState election() {
        return new ElectionState(this.epoch, OptionalInt.empty(), OptionalInt.of(this.votedId), this.voters);
    }

    public int votedId() {
        return this.votedId;
    }

    @Override
    public int epoch() {
        return this.epoch;
    }

    @Override
    public String name() {
        return "Voted";
    }

    public long remainingElectionTimeMs(long currentTimeMs) {
        this.electionTimer.update(currentTimeMs);
        return this.electionTimer.remainingMs();
    }

    public boolean hasElectionTimeoutExpired(long currentTimeMs) {
        this.electionTimer.update(currentTimeMs);
        return this.electionTimer.isExpired();
    }

    public void overrideElectionTimeout(long currentTimeMs, long timeoutMs) {
        this.electionTimer.update(currentTimeMs);
        this.electionTimer.reset(timeoutMs);
    }

    @Override
    public Optional<LogOffsetMetadata> highWatermark() {
        return this.highWatermark;
    }

    public String toString() {
        return "Voted(epoch=" + this.epoch + ", votedId=" + this.votedId + ", voters=" + this.voters + ", electionTimeoutMs=" + this.electionTimeoutMs + ')';
    }

    @Override
    public void close() {
    }
}

