/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.snapshot;

import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.OptionalLong;
import org.apache.kafka.common.utils.BufferSupplier;
import org.apache.kafka.raft.Batch;
import org.apache.kafka.raft.OffsetAndEpoch;
import org.apache.kafka.raft.internals.RecordsIterator;
import org.apache.kafka.server.common.serialization.RecordSerde;
import org.apache.kafka.snapshot.RawSnapshotReader;
import org.apache.kafka.snapshot.SnapshotReader;

public final class RecordsSnapshotReader<T>
implements SnapshotReader<T> {
    private final OffsetAndEpoch snapshotId;
    private final RecordsIterator<T> iterator;
    private Optional<Batch<T>> nextBatch = Optional.empty();
    private OptionalLong lastContainedLogTimestamp = OptionalLong.empty();

    private RecordsSnapshotReader(OffsetAndEpoch snapshotId, RecordsIterator<T> iterator) {
        this.snapshotId = snapshotId;
        this.iterator = iterator;
    }

    @Override
    public OffsetAndEpoch snapshotId() {
        return this.snapshotId;
    }

    @Override
    public long lastContainedLogOffset() {
        return this.snapshotId.offset - 1L;
    }

    @Override
    public int lastContainedLogEpoch() {
        return this.snapshotId.epoch;
    }

    @Override
    public long lastContainedLogTimestamp() {
        if (!this.lastContainedLogTimestamp.isPresent()) {
            this.nextBatch.ifPresent(batch -> {
                throw new IllegalStateException(String.format("nextBatch was present when last contained log timestamp was not present", batch));
            });
            this.nextBatch = this.nextBatch();
        }
        return this.lastContainedLogTimestamp.getAsLong();
    }

    @Override
    public boolean hasNext() {
        if (!this.nextBatch.isPresent()) {
            this.nextBatch = this.nextBatch();
        }
        return this.nextBatch.isPresent();
    }

    @Override
    public Batch<T> next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException("Snapshot reader doesn't have any more elements");
        }
        Batch<T> batch = this.nextBatch.get();
        this.nextBatch = Optional.empty();
        return batch;
    }

    @Override
    public void close() {
        this.iterator.close();
    }

    public static <T> RecordsSnapshotReader<T> of(RawSnapshotReader snapshot, RecordSerde<T> serde, BufferSupplier bufferSupplier, int maxBatchSize) {
        return new RecordsSnapshotReader<T>(snapshot.snapshotId(), new RecordsIterator<T>(snapshot.records(), serde, bufferSupplier, maxBatchSize));
    }

    private Optional<Batch<T>> nextBatch() {
        while (this.iterator.hasNext()) {
            Object batch = this.iterator.next();
            if (!this.lastContainedLogTimestamp.isPresent()) {
                this.lastContainedLogTimestamp = OptionalLong.of(((Batch)batch).appendTimestamp());
            }
            if (((Batch)batch).records().isEmpty()) continue;
            return Optional.of(batch);
        }
        return Optional.empty();
    }
}

