/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.raft;

import java.util.OptionalInt;
import java.util.Set;

public class ElectionState {
    public final int epoch;
    public final OptionalInt leaderIdOpt;
    public final OptionalInt votedIdOpt;
    private final Set<Integer> voters;

    ElectionState(int epoch, OptionalInt leaderIdOpt, OptionalInt votedIdOpt, Set<Integer> voters) {
        this.epoch = epoch;
        this.leaderIdOpt = leaderIdOpt;
        this.votedIdOpt = votedIdOpt;
        this.voters = voters;
    }

    public static ElectionState withVotedCandidate(int epoch, int votedId, Set<Integer> voters) {
        if (votedId < 0) {
            throw new IllegalArgumentException("Illegal voted Id " + votedId + ": must be non-negative");
        }
        if (!voters.contains(votedId)) {
            throw new IllegalArgumentException("Voted candidate with id " + votedId + " is not among the valid voters");
        }
        return new ElectionState(epoch, OptionalInt.empty(), OptionalInt.of(votedId), voters);
    }

    public static ElectionState withElectedLeader(int epoch, int leaderId, Set<Integer> voters) {
        if (leaderId < 0) {
            throw new IllegalArgumentException("Illegal leader Id " + leaderId + ": must be non-negative");
        }
        if (!voters.contains(leaderId)) {
            throw new IllegalArgumentException("Leader with id " + leaderId + " is not among the valid voters");
        }
        return new ElectionState(epoch, OptionalInt.of(leaderId), OptionalInt.empty(), voters);
    }

    public static ElectionState withUnknownLeader(int epoch, Set<Integer> voters) {
        return new ElectionState(epoch, OptionalInt.empty(), OptionalInt.empty(), voters);
    }

    public boolean isLeader(int nodeId) {
        if (nodeId < 0) {
            throw new IllegalArgumentException("Invalid negative nodeId: " + nodeId);
        }
        return this.leaderIdOpt.orElse(-1) == nodeId;
    }

    public boolean isVotedCandidate(int nodeId) {
        if (nodeId < 0) {
            throw new IllegalArgumentException("Invalid negative nodeId: " + nodeId);
        }
        return this.votedIdOpt.orElse(-1) == nodeId;
    }

    public int leaderId() {
        if (!this.leaderIdOpt.isPresent()) {
            throw new IllegalStateException("Attempt to access nil leaderId");
        }
        return this.leaderIdOpt.getAsInt();
    }

    public int votedId() {
        if (!this.votedIdOpt.isPresent()) {
            throw new IllegalStateException("Attempt to access nil votedId");
        }
        return this.votedIdOpt.getAsInt();
    }

    public Set<Integer> voters() {
        return this.voters;
    }

    public boolean hasLeader() {
        return this.leaderIdOpt.isPresent();
    }

    public boolean hasVoted() {
        return this.votedIdOpt.isPresent();
    }

    public String toString() {
        return "Election(epoch=" + this.epoch + ", leaderIdOpt=" + this.leaderIdOpt + ", votedIdOpt=" + this.votedIdOpt + ')';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ElectionState that = (ElectionState)o;
        if (this.epoch != that.epoch) {
            return false;
        }
        if (!this.leaderIdOpt.equals(that.leaderIdOpt)) {
            return false;
        }
        return this.votedIdOpt.equals(that.votedIdOpt);
    }

    public int hashCode() {
        int result = this.epoch;
        result = 31 * result + this.leaderIdOpt.hashCode();
        result = 31 * result + this.votedIdOpt.hashCode();
        return result;
    }
}

