/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.server.util;

import java.io.PrintStream;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.apache.kafka.common.Metric;
import org.apache.kafka.common.MetricName;

public class ToolsUtils {
    public static void printMetrics(Map<MetricName, ? extends Metric> metrics) {
        if (metrics != null && !metrics.isEmpty()) {
            int maxLengthOfDisplayName = 0;
            TreeMap<String, Object> sortedMetrics = new TreeMap<String, Object>();
            for (Metric metric : metrics.values()) {
                MetricName mName = metric.metricName();
                String mergedName = mName.group() + ":" + mName.name() + ":" + mName.tags();
                maxLengthOfDisplayName = maxLengthOfDisplayName < mergedName.length() ? mergedName.length() : maxLengthOfDisplayName;
                sortedMetrics.put(mergedName, metric.metricValue());
            }
            String doubleOutputFormat = "%-" + maxLengthOfDisplayName + "s : %.3f";
            String string = "%-" + maxLengthOfDisplayName + "s : %s";
            System.out.println(String.format("\n%-" + maxLengthOfDisplayName + "s   %s", "Metric Name", "Value"));
            for (Map.Entry entry : sortedMetrics.entrySet()) {
                String outputFormat = entry.getValue() instanceof Double ? doubleOutputFormat : string;
                System.out.println(String.format(outputFormat, entry.getKey(), entry.getValue()));
            }
        }
    }

    private static void appendColumnValue(StringBuilder rowBuilder, String value, int length) {
        int padLength = length - value.length();
        rowBuilder.append(value);
        for (int i = 0; i < padLength; ++i) {
            rowBuilder.append(' ');
        }
    }

    private static void printRow(List<Integer> columnLengths, String[] row, PrintStream out) {
        StringBuilder rowBuilder = new StringBuilder();
        for (int i = 0; i < row.length; ++i) {
            Integer columnLength = columnLengths.get(i);
            String columnValue = row[i];
            ToolsUtils.appendColumnValue(rowBuilder, columnValue, columnLength);
            rowBuilder.append('\t');
        }
        out.println(rowBuilder);
    }

    public static void prettyPrintTable(String[] headers, List<String[]> rows, PrintStream out) {
        List<Integer> columnLengths = Arrays.stream(headers).map(String::length).collect(Collectors.toList());
        for (String[] row2 : rows) {
            for (int i = 0; i < headers.length; ++i) {
                columnLengths.set(i, Math.max(columnLengths.get(i), row2[i].length()));
            }
        }
        ToolsUtils.printRow(columnLengths, headers, out);
        rows.forEach(row -> ToolsUtils.printRow(columnLengths, row, out));
    }
}

