/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.timeline;

import java.util.HashSet;
import java.util.Random;
import org.apache.kafka.timeline.BaseHashTable;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;

@Timeout(value=40L)
public class BaseHashTableTest {
    @Test
    public void testEmptyTable() {
        BaseHashTable table = new BaseHashTable(0);
        Assertions.assertEquals((int)0, (int)table.baseSize());
        Assertions.assertNull((Object)table.baseGet((Object)1));
    }

    @Test
    public void testFindSlot() {
        Random random = new Random(123L);
        for (int i = 1; i <= 5; ++i) {
            int numSlots = 2 << i;
            HashSet<Integer> slotsReturned = new HashSet<Integer>();
            while (slotsReturned.size() < numSlots) {
                int slot = BaseHashTable.findSlot((Object)random.nextInt(), (int)numSlots);
                Assertions.assertTrue((slot >= 0 ? 1 : 0) != 0);
                Assertions.assertTrue((slot < numSlots ? 1 : 0) != 0);
                slotsReturned.add(slot);
            }
        }
    }

    @Test
    public void testInsertAndRemove() {
        BaseHashTable table = new BaseHashTable(20);
        Integer one = 1;
        Integer two = 2;
        Integer three = 3;
        Integer four = 4;
        Assertions.assertNull((Object)table.baseAddOrReplace((Object)one));
        Assertions.assertNull((Object)table.baseAddOrReplace((Object)two));
        Assertions.assertNull((Object)table.baseAddOrReplace((Object)three));
        Assertions.assertEquals((int)3, (int)table.baseSize());
        Assertions.assertEquals((Integer)one, (Integer)((Integer)table.baseGet((Object)one)));
        Assertions.assertEquals((Integer)two, (Integer)((Integer)table.baseGet((Object)two)));
        Assertions.assertEquals((Integer)three, (Integer)((Integer)table.baseGet((Object)three)));
        Assertions.assertNull((Object)table.baseGet((Object)four));
        Assertions.assertEquals((Integer)one, (Integer)((Integer)table.baseRemove((Object)one)));
        Assertions.assertEquals((int)2, (int)table.baseSize());
        Assertions.assertNull((Object)table.baseGet((Object)one));
        Assertions.assertEquals((int)2, (int)table.baseSize());
    }

    @Test
    public void testHashCollisons() {
        Foo one = new Foo();
        Foo two = new Foo();
        Foo three = new Foo();
        Foo four = new Foo();
        BaseHashTable table = new BaseHashTable(20);
        Assertions.assertNull((Object)table.baseAddOrReplace((Object)one));
        Assertions.assertNull((Object)table.baseAddOrReplace((Object)two));
        Assertions.assertNull((Object)table.baseAddOrReplace((Object)three));
        Assertions.assertEquals((int)3, (int)table.baseSize());
        Assertions.assertEquals((Object)one, (Object)table.baseGet((Object)one));
        Assertions.assertEquals((Object)two, (Object)table.baseGet((Object)two));
        Assertions.assertEquals((Object)three, (Object)table.baseGet((Object)three));
        Assertions.assertNull((Object)table.baseGet((Object)four));
        Assertions.assertEquals((Object)one, (Object)table.baseRemove((Object)one));
        Assertions.assertEquals((Object)three, (Object)table.baseRemove((Object)three));
        Assertions.assertEquals((int)1, (int)table.baseSize());
        Assertions.assertNull((Object)table.baseGet((Object)four));
        Assertions.assertEquals((Object)two, (Object)table.baseGet((Object)two));
        Assertions.assertEquals((Object)two, (Object)table.baseRemove((Object)two));
        Assertions.assertEquals((int)0, (int)table.baseSize());
    }

    @Test
    public void testExpansion() {
        int i;
        BaseHashTable table = new BaseHashTable(0);
        for (i = 0; i < 4096; ++i) {
            Assertions.assertEquals((int)i, (int)table.baseSize());
            Assertions.assertNull((Object)table.baseAddOrReplace((Object)i));
        }
        for (i = 0; i < 4096; ++i) {
            Assertions.assertEquals((int)(4096 - i), (int)table.baseSize());
            Assertions.assertEquals((Integer)i, (Integer)((Integer)table.baseRemove((Object)i)));
        }
    }

    @Test
    public void testExpectedSizeToCapacity() {
        Assertions.assertEquals((int)2, (int)BaseHashTable.expectedSizeToCapacity((int)Integer.MIN_VALUE));
        Assertions.assertEquals((int)2, (int)BaseHashTable.expectedSizeToCapacity((int)-123));
        Assertions.assertEquals((int)2, (int)BaseHashTable.expectedSizeToCapacity((int)0));
        Assertions.assertEquals((int)2, (int)BaseHashTable.expectedSizeToCapacity((int)1));
        Assertions.assertEquals((int)4, (int)BaseHashTable.expectedSizeToCapacity((int)2));
        Assertions.assertEquals((int)4, (int)BaseHashTable.expectedSizeToCapacity((int)3));
        Assertions.assertEquals((int)8, (int)BaseHashTable.expectedSizeToCapacity((int)4));
        Assertions.assertEquals((int)16, (int)BaseHashTable.expectedSizeToCapacity((int)12));
        Assertions.assertEquals((int)32, (int)BaseHashTable.expectedSizeToCapacity((int)13));
        Assertions.assertEquals((int)0x2000000, (int)BaseHashTable.expectedSizeToCapacity((int)0x1010400));
        Assertions.assertEquals((int)0x4000000, (int)BaseHashTable.expectedSizeToCapacity((int)0x2000000));
        Assertions.assertEquals((int)0x4000000, (int)BaseHashTable.expectedSizeToCapacity((int)0x2000001));
        Assertions.assertEquals((int)0x40000000, (int)BaseHashTable.expectedSizeToCapacity((int)0x40000000));
        Assertions.assertEquals((int)0x40000000, (int)BaseHashTable.expectedSizeToCapacity((int)0x40000001));
        Assertions.assertEquals((int)0x40000000, (int)BaseHashTable.expectedSizeToCapacity((int)0x7FFFFFFE));
        Assertions.assertEquals((int)0x40000000, (int)BaseHashTable.expectedSizeToCapacity((int)Integer.MAX_VALUE));
    }

    static class Foo {
        Foo() {
        }

        public boolean equals(Object o) {
            return this == o;
        }

        public int hashCode() {
            return 42;
        }
    }
}

