/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.timeline;

import java.util.Collections;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.timeline.SnapshotRegistry;
import org.apache.kafka.timeline.TimelineObject;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;

@Timeout(value=40L)
public class TimelineObjectTest {
    @Test
    public void testModifyValue() {
        SnapshotRegistry registry = new SnapshotRegistry(new LogContext());
        TimelineObject object = new TimelineObject(registry, (Object)"default");
        Assertions.assertEquals((Object)"default", (Object)object.get());
        Assertions.assertEquals((Object)"default", (Object)object.get(Long.MAX_VALUE));
        object.set((Object)"1");
        object.set((Object)"2");
        Assertions.assertEquals((Object)"2", (Object)object.get());
        Assertions.assertEquals((Object)"2", (Object)object.get(Long.MAX_VALUE));
    }

    @Test
    public void testToStringAndEquals() {
        SnapshotRegistry registry = new SnapshotRegistry(new LogContext());
        TimelineObject object = new TimelineObject(registry, (Object)"");
        Assertions.assertEquals((Object)"", (Object)object.toString());
        object.set((Object)"a");
        TimelineObject object2 = new TimelineObject(registry, (Object)"");
        object2.set((Object)"a");
        Assertions.assertEquals((Object)"a", (Object)object2.toString());
        Assertions.assertEquals((Object)object, (Object)object2);
    }

    @Test
    public void testSnapshot() {
        SnapshotRegistry registry = new SnapshotRegistry(new LogContext());
        TimelineObject object = new TimelineObject(registry, (Object)"1000");
        registry.getOrCreateSnapshot(2L);
        object.set((Object)"1001");
        registry.getOrCreateSnapshot(3L);
        object.set((Object)"1002");
        object.set((Object)"1003");
        object.set((Object)"1002");
        registry.getOrCreateSnapshot(4L);
        Assertions.assertEquals((Object)"1000", (Object)object.get(2L));
        Assertions.assertEquals((Object)"1001", (Object)object.get(3L));
        Assertions.assertEquals((Object)"1002", (Object)object.get(4L));
        registry.revertToSnapshot(3L);
        Assertions.assertEquals((Object)"1001", (Object)object.get());
        registry.revertToSnapshot(2L);
        Assertions.assertEquals((Object)"1000", (Object)object.get());
    }

    @Test
    public void testReset() {
        SnapshotRegistry registry = new SnapshotRegistry(new LogContext());
        TimelineObject value = new TimelineObject(registry, (Object)"<default>");
        registry.getOrCreateSnapshot(2L);
        value.set((Object)"first value");
        registry.getOrCreateSnapshot(3L);
        value.set((Object)"second value");
        registry.reset();
        Assertions.assertEquals(Collections.emptyList(), (Object)registry.epochsList());
        Assertions.assertEquals((Object)"<default>", (Object)value.get());
    }
}

