/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.server.group.share;

import java.util.stream.Collectors;
import org.apache.kafka.common.message.InitializeShareGroupStateRequestData;
import org.apache.kafka.server.group.share.GroupTopicPartitionData;
import org.apache.kafka.server.group.share.PartitionFactory;
import org.apache.kafka.server.group.share.PartitionStateData;
import org.apache.kafka.server.group.share.PersisterParameters;
import org.apache.kafka.server.group.share.TopicData;

public class InitializeShareGroupStateParameters
implements PersisterParameters {
    private final GroupTopicPartitionData<PartitionStateData> groupTopicPartitionData;

    private InitializeShareGroupStateParameters(GroupTopicPartitionData<PartitionStateData> groupTopicPartitionData) {
        this.groupTopicPartitionData = groupTopicPartitionData;
    }

    public GroupTopicPartitionData<PartitionStateData> groupTopicPartitionData() {
        return this.groupTopicPartitionData;
    }

    public static InitializeShareGroupStateParameters from(InitializeShareGroupStateRequestData data) {
        return new Builder().setGroupTopicPartitionData(new GroupTopicPartitionData<PartitionStateData>(data.groupId(), data.topics().stream().map(readStateData -> new TopicData(readStateData.topicId(), readStateData.partitions().stream().map(partitionData -> PartitionFactory.newPartitionStateData(partitionData.partition(), partitionData.stateEpoch(), partitionData.startOffset())).collect(Collectors.toList()))).collect(Collectors.toList()))).build();
    }

    public static class Builder {
        private GroupTopicPartitionData<PartitionStateData> groupTopicPartitionData;

        public Builder setGroupTopicPartitionData(GroupTopicPartitionData<PartitionStateData> groupTopicPartitionData) {
            this.groupTopicPartitionData = groupTopicPartitionData;
            return this;
        }

        public InitializeShareGroupStateParameters build() {
            return new InitializeShareGroupStateParameters(this.groupTopicPartitionData);
        }
    }
}

