/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.server.network;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import org.apache.kafka.common.ClusterResource;
import org.apache.kafka.common.Endpoint;
import org.apache.kafka.server.authorizer.AuthorizerServerInfo;

public final class KafkaAuthorizerServerInfo
implements AuthorizerServerInfo {
    private final ClusterResource clusterResource;
    private final int brokerId;
    private final Collection<Endpoint> endpoints;
    private final Endpoint interbrokerEndpoint;
    private final Collection<String> earlyStartListeners;

    public KafkaAuthorizerServerInfo(ClusterResource clusterResource, int brokerId, Collection<Endpoint> endpoints, Endpoint interbrokerEndpoint, Collection<String> earlyStartListeners) {
        this.clusterResource = clusterResource;
        this.brokerId = brokerId;
        this.endpoints = Collections.unmodifiableCollection(new ArrayList<Endpoint>(endpoints));
        this.interbrokerEndpoint = interbrokerEndpoint;
        this.earlyStartListeners = Collections.unmodifiableCollection(new ArrayList<String>(earlyStartListeners));
    }

    public ClusterResource clusterResource() {
        return this.clusterResource;
    }

    public int brokerId() {
        return this.brokerId;
    }

    public Collection<Endpoint> endpoints() {
        return this.endpoints;
    }

    public Endpoint interBrokerEndpoint() {
        return this.interbrokerEndpoint;
    }

    public Collection<String> earlyStartListeners() {
        return this.earlyStartListeners;
    }

    public boolean equals(Object o) {
        if (o == null || !o.getClass().equals(KafkaAuthorizerServerInfo.class)) {
            return false;
        }
        KafkaAuthorizerServerInfo other = (KafkaAuthorizerServerInfo)o;
        return this.clusterResource.equals((Object)other.clusterResource) && this.brokerId == other.brokerId && this.endpoints.equals(other.endpoints) && this.interbrokerEndpoint.equals((Object)other.interbrokerEndpoint) && this.earlyStartListeners.equals(other.earlyStartListeners);
    }

    public int hashCode() {
        return Objects.hash(this.clusterResource, this.brokerId, this.endpoints, this.interbrokerEndpoint, this.earlyStartListeners);
    }

    public String toString() {
        return "KafkaAuthorizerServerInfo(clusterResource=" + this.clusterResource + ", brokerId=" + this.brokerId + ", endpoints=" + this.endpoints + ", earlyStartListeners=" + this.earlyStartListeners + ")";
    }
}

