/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.timeline;

import java.util.Iterator;
import org.apache.kafka.timeline.Delta;
import org.apache.kafka.timeline.Revertable;
import org.apache.kafka.timeline.Snapshot;
import org.apache.kafka.timeline.SnapshotRegistry;

public class TimelineInteger
implements Revertable {
    public static final int INIT = 0;
    private final SnapshotRegistry snapshotRegistry;
    private int value;

    public TimelineInteger(SnapshotRegistry snapshotRegistry) {
        this.snapshotRegistry = snapshotRegistry;
        this.value = 0;
        snapshotRegistry.register(this);
    }

    public int get() {
        return this.value;
    }

    public int get(long epoch) {
        if (epoch == Long.MAX_VALUE) {
            return this.value;
        }
        Iterator<Snapshot> iterator = this.snapshotRegistry.iterator(epoch);
        while (iterator.hasNext()) {
            Snapshot snapshot = iterator.next();
            IntegerContainer container = (IntegerContainer)snapshot.getDelta(this);
            if (container == null) continue;
            return container.value();
        }
        return this.value;
    }

    public void set(int newValue) {
        Snapshot snapshot;
        IntegerContainer container;
        Iterator<Snapshot> iterator = this.snapshotRegistry.reverseIterator();
        if (iterator.hasNext() && (container = (IntegerContainer)(snapshot = iterator.next()).getDelta(this)) == null) {
            container = new IntegerContainer();
            snapshot.setDelta(this, container);
            container.setValue(this.value);
        }
        this.value = newValue;
    }

    public void increment() {
        this.set(this.get() + 1);
    }

    public void decrement() {
        this.set(this.get() - 1);
    }

    @Override
    public void executeRevert(long targetEpoch, Delta delta) {
        IntegerContainer container = (IntegerContainer)delta;
        this.value = container.value;
    }

    @Override
    public void reset() {
        this.set(0);
    }

    public int hashCode() {
        return this.value;
    }

    public boolean equals(Object o) {
        if (!(o instanceof TimelineInteger)) {
            return false;
        }
        TimelineInteger other = (TimelineInteger)o;
        return this.value == other.value;
    }

    public String toString() {
        return Integer.toString(this.value);
    }

    static class IntegerContainer
    implements Delta {
        private int value = 0;

        IntegerContainer() {
        }

        int value() {
            return this.value;
        }

        void setValue(int value) {
            this.value = value;
        }

        @Override
        public void mergeFrom(long destinationEpoch, Delta delta) {
        }
    }
}

