/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.server.network;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import org.apache.kafka.common.ClusterResource;
import org.apache.kafka.common.Endpoint;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.server.authorizer.AuthorizerServerInfo;
import org.apache.kafka.server.network.EndpointReadyFutures;
import org.apache.kafka.server.network.KafkaAuthorizerServerInfo;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public final class EndpointReadyFuturesTest {
    private static final Endpoint EXTERNAL = new Endpoint("EXTERNAL", SecurityProtocol.SSL, "127.0.0.1", 9092);
    private static final Endpoint INTERNAL = new Endpoint("INTERNAL", SecurityProtocol.PLAINTEXT, "127.0.0.1", 9093);
    private static final KafkaAuthorizerServerInfo INFO = new KafkaAuthorizerServerInfo(new ClusterResource("S6-01LPiQOCBhhFIunQUcQ"), 1, Arrays.asList(EXTERNAL, INTERNAL), INTERNAL, Arrays.asList("INTERNAL"));

    static void assertComplete(EndpointReadyFutures readyFutures, Endpoint ... endpoints) {
        for (Endpoint endpoint : endpoints) {
            String name = (String)endpoint.listenerName().get();
            CompletableFuture future = (CompletableFuture)readyFutures.futures().get(endpoint);
            Assertions.assertNotNull((Object)future, (String)("Unable to find future for " + name));
            Assertions.assertTrue((boolean)future.isDone(), (String)("Future for " + name + " is not done."));
            Assertions.assertFalse((boolean)future.isCompletedExceptionally(), (String)("Future for " + name + " is completed exceptionally."));
        }
    }

    static void assertIncomplete(EndpointReadyFutures readyFutures, Endpoint ... endpoints) {
        for (Endpoint endpoint : endpoints) {
            CompletableFuture future = (CompletableFuture)readyFutures.futures().get(endpoint);
            Assertions.assertNotNull((Object)future, (String)("Unable to find future for " + String.valueOf(endpoint)));
            Assertions.assertFalse((boolean)future.isDone(), (String)("Future for " + String.valueOf(endpoint) + " is done."));
        }
    }

    static void assertException(EndpointReadyFutures readyFutures, Throwable throwable, Endpoint ... endpoints) {
        for (Endpoint endpoint : endpoints) {
            CompletableFuture future = (CompletableFuture)readyFutures.futures().get(endpoint);
            Assertions.assertNotNull((Object)future, (String)("Unable to find future for " + String.valueOf(endpoint)));
            Assertions.assertTrue((boolean)future.isCompletedExceptionally(), (String)("Future for " + String.valueOf(endpoint) + " is not completed exceptionally."));
            Throwable cause = ((CompletionException)Assertions.assertThrows(CompletionException.class, () -> future.getNow(null))).getCause();
            Assertions.assertNotNull((Object)cause, (String)("Unable to find CompletionException cause for " + String.valueOf(endpoint)));
            Assertions.assertEquals(throwable.getClass(), cause.getClass());
            Assertions.assertEquals((Object)throwable.getMessage(), (Object)cause.getMessage());
        }
    }

    @Test
    public void testImmediateCompletion() {
        EndpointReadyFutures readyFutures = new EndpointReadyFutures.Builder().build(Optional.empty(), (AuthorizerServerInfo)INFO);
        Assertions.assertEquals(new HashSet<Endpoint>(Arrays.asList(EXTERNAL, INTERNAL)), readyFutures.futures().keySet());
        EndpointReadyFuturesTest.assertComplete(readyFutures, EXTERNAL, INTERNAL);
    }

    @Test
    public void testAddReadinessFuture() {
        CompletableFuture<Object> foo = new CompletableFuture<Object>();
        EndpointReadyFutures readyFutures = new EndpointReadyFutures.Builder().addReadinessFuture("foo", foo).build(Optional.empty(), (AuthorizerServerInfo)INFO);
        Assertions.assertEquals(new HashSet<Endpoint>(Arrays.asList(EXTERNAL, INTERNAL)), readyFutures.futures().keySet());
        EndpointReadyFuturesTest.assertIncomplete(readyFutures, EXTERNAL, INTERNAL);
        foo.complete(null);
        EndpointReadyFuturesTest.assertComplete(readyFutures, EXTERNAL, INTERNAL);
    }

    @Test
    public void testAddMultipleReadinessFutures() {
        CompletableFuture<Object> foo = new CompletableFuture<Object>();
        CompletableFuture<Object> bar = new CompletableFuture<Object>();
        EndpointReadyFutures readyFutures = new EndpointReadyFutures.Builder().addReadinessFuture("foo", foo).addReadinessFuture("bar", bar).build(Optional.empty(), (AuthorizerServerInfo)INFO);
        Assertions.assertEquals(new HashSet<Endpoint>(Arrays.asList(EXTERNAL, INTERNAL)), readyFutures.futures().keySet());
        EndpointReadyFuturesTest.assertIncomplete(readyFutures, EXTERNAL, INTERNAL);
        foo.complete(null);
        EndpointReadyFuturesTest.assertIncomplete(readyFutures, EXTERNAL, INTERNAL);
        bar.complete(null);
        EndpointReadyFuturesTest.assertComplete(readyFutures, EXTERNAL, INTERNAL);
    }

    @Test
    public void testAddReadinessFutures() {
        HashMap bazFutures = new HashMap();
        bazFutures.put(EXTERNAL, new CompletableFuture());
        bazFutures.put(INTERNAL, new CompletableFuture());
        EndpointReadyFutures readyFutures = new EndpointReadyFutures.Builder().addReadinessFutures("baz", bazFutures).build(Optional.empty(), (AuthorizerServerInfo)INFO);
        Assertions.assertEquals(new HashSet<Endpoint>(Arrays.asList(EXTERNAL, INTERNAL)), readyFutures.futures().keySet());
        EndpointReadyFuturesTest.assertIncomplete(readyFutures, EXTERNAL, INTERNAL);
        ((CompletableFuture)bazFutures.get(EXTERNAL)).complete(null);
        EndpointReadyFuturesTest.assertComplete(readyFutures, EXTERNAL);
        EndpointReadyFuturesTest.assertIncomplete(readyFutures, INTERNAL);
        ((CompletableFuture)bazFutures.get(INTERNAL)).complete(null);
        EndpointReadyFuturesTest.assertComplete(readyFutures, EXTERNAL, INTERNAL);
    }

    @Test
    public void testFailedReadinessFuture() {
        CompletableFuture<Object> foo = new CompletableFuture<Object>();
        CompletableFuture bar = new CompletableFuture();
        EndpointReadyFutures readyFutures = new EndpointReadyFutures.Builder().addReadinessFuture("foo", foo).addReadinessFuture("bar", bar).build(Optional.empty(), (AuthorizerServerInfo)INFO);
        Assertions.assertEquals(new HashSet<Endpoint>(Arrays.asList(EXTERNAL, INTERNAL)), readyFutures.futures().keySet());
        EndpointReadyFuturesTest.assertIncomplete(readyFutures, EXTERNAL, INTERNAL);
        foo.complete(null);
        EndpointReadyFuturesTest.assertIncomplete(readyFutures, EXTERNAL, INTERNAL);
        bar.completeExceptionally(new RuntimeException("Failed."));
        EndpointReadyFuturesTest.assertException(readyFutures, new RuntimeException("Failed."), EXTERNAL, INTERNAL);
    }
}

