/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.server.purgatory;

import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import org.apache.kafka.common.utils.KafkaThread;
import org.apache.kafka.server.purgatory.DelayedFuture;
import org.apache.kafka.server.purgatory.DelayedOperationKey;
import org.apache.kafka.server.purgatory.DelayedOperationPurgatory;

public class DelayedFuturePurgatory {
    private final DelayedOperationPurgatory<DelayedFuture<?>> purgatory;
    private final ThreadPoolExecutor executor;
    private final DelayedOperationKey purgatoryKey;

    public DelayedFuturePurgatory(String purgatoryName, int brokerId) {
        this.purgatory = new DelayedOperationPurgatory(purgatoryName, brokerId);
        this.executor = new ThreadPoolExecutor(1, 1, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), r -> new KafkaThread("DelayedExecutor-" + purgatoryName, r, true));
        this.purgatoryKey = () -> "delayed-future-key";
    }

    public <T> DelayedFuture<T> tryCompleteElseWatch(long timeoutMs, List<CompletableFuture<T>> futures, Runnable responseCallback) {
        DelayedFuture delayedFuture = new DelayedFuture(timeoutMs, futures, responseCallback);
        boolean done = this.purgatory.tryCompleteElseWatch(delayedFuture, List.of(this.purgatoryKey));
        if (!done) {
            BiConsumer<Void, Throwable> callbackAction = (result, exception) -> delayedFuture.forceComplete();
            CompletableFuture.allOf(futures.toArray(new CompletableFuture[0])).whenCompleteAsync((BiConsumer)callbackAction, (Executor)this.executor);
        }
        return delayedFuture;
    }

    public void shutdown() throws Exception {
        this.executor.shutdownNow();
        this.executor.awaitTermination(60L, TimeUnit.SECONDS);
        this.purgatory.shutdown();
    }

    public boolean isShutdown() {
        return this.executor.isShutdown();
    }
}

